<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Clinic Tev Protocol']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Risk Factors']), ['controller' => 'RiskFactors', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Risk Factor']), ['controller' => 'RiskFactors', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="clinicTevProtocols index col-md-10 columns content">
    <h3>Clinic Tev Protocols</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('is_active') ?></th>
                <th><?= $this->Paginator->sort('hospitalization_id') ?></th>
                <th><?= $this->Paginator->sort('indicacao_profilaxia_data') ?></th>
                <th><?= $this->Paginator->sort('indicacao_profilaxia_hora') ?></th>
                <th><?= $this->Paginator->sort('sangramento_ativo') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($clinicTevProtocols as $clinicTevProtocol): ?>
            <tr>
                <td><?= $this->Number->format($clinicTevProtocol->id) ?></td>
                <td><?= h($clinicTevProtocol->created) ?></td>
                <td><?= h($clinicTevProtocol->is_active) ?></td>
                <td><?= $clinicTevProtocol->has('hospitalization') ? $this->Html->link($clinicTevProtocol->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $clinicTevProtocol->hospitalization->id]) : '' ?></td>
                <td><?= h($clinicTevProtocol->indicacao_profilaxia_data) ?></td>
                <td><?= h($clinicTevProtocol->indicacao_profilaxia_hora) ?></td>
                <td><?= h($clinicTevProtocol->sangramento_ativo) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $clinicTevProtocol->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $clinicTevProtocol->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $clinicTevProtocol->id], ['confirm' => __('Are you sure you want to delete # {0}?', $clinicTevProtocol->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>