 <?php
$classificacao_risco = ['azul' => 'Azul', 'verde' => 'Verde', 'amarelo' => 'Amarelo', 'vermelho' => 'Vermelho'];

$pain_intensity = [
    'Leve'     => [
        0, 1, 2,
    ],
    'Moderada' => [
        3, 4, 5, 6, 7,
    ],
    'Intensa'  => [
        8, 9, 10,
    ],
];

$fraquesa_muscular     = ['Generalizada' => 'Generalizada', 'Membros' => 'Membros', 'Face' => 'Face'];

$alteracao_consciencia = ['Inquieto' => 'Inquieto', 'Agitado' => 'Agitado', 'Agressivo' => 'Agressivo', 'Obnubilado' => 'Obnubilado', 'Torporoso' => 'Torporoso', 'Comatoso' => 'Comatoso'];

$fraquesa_muscular_tipo = ['aguda_menor_48h' => 'Aguda < 48h', 'cronica' => 'Crônica'];

$queixa_principal       = ['alteracao_estado_mental' => 'Alteração de estado mental', 'dispneia' => 'Dispneia', 'hiperglicemia' => 'Hiperglicemia', 'alt_sinais_vitais' => 'Alt. sinais vitais isolados', 'tosse' => 'Tosse', 'lesoes_de_pele' => 'Lesões de pele', 'dor' => 'Dor', 'febre' => 'Febre', 'hipoglicemia' => 'Hipoglicemia', 'diarreia' => 'Diarreia', 'casos_especiais' => 'Casos especiais', 'procura_da_unidade' => 'Procura da unidade p/ procedimentos', 'hemorragia' => 'Hemorragia', 'alteracao_de_pressao' => 'Alteração de pressão', 'parada_cardiorrespiratoria' => 'Parada cardiorrespiratória', 'hemorragia_digestiva' => 'Hemorragia digestiva', 'queixas_cronicas' => 'Queixas crônicas'];

$localizacao_da_dor = ['abdominal' => 'Abdominal', 'cefaleia' => 'Cefaleia', 'ceruical' => 'Ceruical', 'lombar' => 'Lombar', 'toracia' => 'Torácica', 'outras' => 'Outras'];

$intensidade_da_dor  = ['Forte' => 'Forte', 'Moderada' => 'Moderada', 'Leve' => 'Leve'];

$aparecimento_da_dor = ['Nas últimas horas' => 'Nas últimas horas', 'Inferior a 48h' => 'Inferior a 48h', 'Superior a 48h' => 'Superior a 48h'];
?>
<div class="screenings form col-md-10 columns content">
    <?=$this->Form->create($screening)?>
    <fieldset>
        <div class="tabbable-panel">
            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active">
                        <a href="#tab_default_1" data-toggle="tab">
                        Triagem
                        </a>
                    </li>
                    <li >
                        <a id="menu_2" href="#tab_default_2" data-toggle="tab">
                        Classificação de Risco
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="tab_default_1">
                        <?php
                        //Sinais alt_sinais_vitais
                        echo $this->Form->input('ocular', ['id'=>'ocular', 'class' => 'hide-element', 'label' =>false]);
                        echo $this->Form->input('verbal', ['id'=>'verbal', 'class' => 'hide-element', 'label' =>false]);
                        echo $this->Form->input('motora', ['id'=>'motora', 'class' => 'hide-element', 'label' =>false]);


                        echo "<br><br><div class='row div-pading'>";
                        echo "<legend class='big-title'>Sinais Vitais</legend>";
                        echo "<div class='col-md-3'>";
                        echo $this->Form->input('pas', ['class' => 'int-limit-3 calc-screening', 'label' => ['text' => 'PAS (mmHg):', 'class' => 'form-input']]);
                        echo "</div>";

                        echo "<div class='col-md-3'>";
                        echo $this->Form->input('d', ['class' => 'int-limit-3 calc-screening', 'label' => ['text' => 'PAD (mmHg):', 'class' => 'form-input']]);
                        echo "</div>";

                        echo "<div class='col-md-3'>";
                        echo $this->Form->input('temp', ['class' => 'temp calc-screening', 'label' => ['text' => 'Temp (ºC):', 'class' => 'form-input']]);
                        echo "</div>";

                        echo "<div class='col-md-3'>";
                        echo $this->Form->input('sato2', ['type' => 'text calc-screening', 'class' => 'int-limit-3',  'label' => ['text' => 'Sato2 (%):', 'class' => 'form-input']]);
                        echo "</div>";
                        echo "</div>";

                        echo "<div class='row div-pading'>";
                        echo "<div class='col-md-4'>";
                        echo $this->Form->input('fc', ['class' => 'int-limit-3 calc-screening', 'type' => 'number', 'label' => ['text' => 'FC (bpm):', 'class' => 'form-input']]);
                        echo "</div>";

                        echo "<div class='col-md-4'>";
                        echo $this->Form->input('fr', ['type' => 'text', 'class calc-screening' => 'int-limit-3', 'label' => ['text' => 'FR (irm):', 'class' => 'form-input']]);
                        echo "</div>";

echo "<div class='col-md-4'>";
echo $this->Form->input('glicemia', ['type' => 'text', 'class' => '', 'label' => ['text' => 'Glicemia (mg/dl):', 'class' => 'form-input']]);
echo "</div>";
echo "</div>";

echo '<div class="funkyradio">';
    echo '<div class="funkyradio-primary">';
    echo $this->Form->checkbox('portador_necessidas_especiais', ['id' => 'portador_necessidas_especiais']);
    echo '<label for="portador_necessidas_especiais">Portador de necessidades especiais</label>';
    echo "</div>";

    echo '<div class="funkyradio-primary">';
    echo $this->Form->checkbox('esta_gestente_ou_suspeita', ['id' => 'esta_gestente_ou_suspeita']);
    echo '<label for="esta_gestente_ou_suspeita">Esta gestante ou há suspeita</label>';
    echo "</div>";

    echo '<div class="funkyradio-primary">';
    echo $this->Form->checkbox('parada_cardiaca_ou_suspeita', ['id' => 'parada_cardiaca_ou_suspeita']);
    echo '<label for="parada_cardiaca_ou_suspeita">Parada cardiorrespiratória ou suspeita</label>';
    echo "</div>";

    echo '<div class="funkyradio-primary parada_cardiaca_ou_suspeita" style="display:none">';
    echo $this->Form->checkbox('classificacao_obstetrica', ['id' => 'classificacao_obstetrica']);
    echo '<label for="classificacao_obstetrica">Deseja realizar a Classificação de Risco de Obstetrícia?</label>';
    echo "</div>";
echo "</div><br>";

//Nível de consciência e déficit motor-sensorial
echo "<br><br><div class='row div-pading'>";
echo "<legend class='big-title'>Nível de consciência e déficit motor-sensorial</legend>";
echo $this->Form->input('fraquesa_muscular', ['empty' => true, 'options' => $fraquesa_muscular, 'label' => ['text' => 'Fraquesa Muscular:', 'class' => 'form-input']]);

echo $this->Form->input('fraquesa_muscular_tipo', ['empty' => true, 'options' => $fraquesa_muscular_tipo, 'label' => ['text' => 'Tipo de Fraquesa:', 'class' => 'form-input']]);

echo $this->Form->input('perda_sensorial', ['empty' => true, 'options' => $fraquesa_muscular, 'label' => ['text' => 'Perda Sensorial:', 'class' => 'form-input']]);

echo $this->Form->input('perda_sensorial_tipo', ['empty' => true, 'options' => $fraquesa_muscular_tipo, 'label' => ['text' => 'Tipo de perda:', 'class' => 'form-input']]);

echo $this->Form->input('alteracao_consciencia', ['empty' => true, 'options' => $alteracao_consciencia, 'label' => ['text' => 'Alteração de Consciência:', 'class' => 'form-input']]);
echo "</div><br>";

?>
<br><br>
  <!-- Glasgow -->
  <table class="table table-striped table-striped-gray table-hover">
      <?='<legend class="big-title">Escala de coma de glasgow (selecionar)</legend>';?>
    <thead>
      <tr>
        <th>#</th>
        <th>1</th>
        <th>2</th>
        <th>3</th>
        <th>4</th>
        <th>5</th>
        <th>6</th>
        <th></th>
      </tr>
    </thead>
    <tbody id="glasgow_tbody">
      <tr id='tr-ocular' >
        <th scope="row">Ocular</th>
        <td id="nao_abre_os_olhos" onclick="selectGlasgow('ocular', this, 'nao_abre_os_olhos')">Não abre os olhos</td>
        <td id="abre_os_olhos_a_dor" onclick="selectGlasgow('ocular', this, 'abre_os_olhos_a_dor')">Abre os olhos em resposta da dor</td>
        <td id="abre_os_olhos_a_resposta" onclick="selectGlasgow('ocular', this, 'abre_os_olhos_a_resposta')">Abre os olhos a resposta a um chamado</td>
        <td id="abre_os_olhos_espontaneamente" onclick="selectGlasgow('ocular', this, 'abre_os_olhos_espontaneamente')">Abre os olhos espontaneamente</td>
        <td>&nbsp;</td>
        <td>&nbsp;</td>
        <!-- <td>&nbsp;</td> -->
      </tr>
      <tr id ='tr-verbal'>
        <th  scope="row">Verbal</th>
        <td id="sem_resposta" onclick="selectGlasgow('verbal', this, 'sem_resposta')">Sem resposta</td>
        <td id='emite_sons' onclick="selectGlasgow('verbal', this, 'emite_sons')">Emite sons incompreensíveis</td>
        <td id="pronuncia_palavras" onclick="selectGlasgow('verbal', this, 'pronuncia_palavras')">pronuncia palavras inapropriadas</td>
        <td id="confuso_desorientado" onclick="selectGlasgow('verbal', this, 'confuso_desorientado')">confuso/desorientado</td>
        <td id="orientado" onclick="selectGlasgow('verbal', this, 'orientado')">Orientado</td>
        <td>&nbsp;</td>
        <!-- <td>&nbsp;</td> -->
      </tr>
      <tr id ='tr-motora'>
        <th  scope="row">Motora</th>
        <td id="nao_se_movimenta" onclick="selectGlasgow('motora', this, 'nao_se_movimenta')">Não se movimenta</td>
        <td id="extensao_a_estimulos" onclick="selectGlasgow('motora', this, 'extensao_a_estimulos')">extensão a estímulos dolorosos</td>
        <td id="flexao_ao_estimulo" onclick="selectGlasgow('motora', this, 'flexao_ao_estimulo')">flexão ao estimulo doloroso</td>
        <td id="retirada_ao_estimulo" onclick="selectGlasgow('motora', this, 'retirada_ao_estimulo')">retirada ao estimulo doloroso</td>
        <td id="localiza_a_dor" onclick="selectGlasgow('motora', this, 'localiza_a_dor')">localiza a dor(retirada ao toque)</td>
        <td id="movimentacao_espontanea" onclick="selectGlasgow('motora', this, 'movimentacao_espontanea')">movimentação espontânea</td>
        <!-- <td>&nbsp;</td> -->
      </tr>
    </tbody>
  </table>

  <h3 id="glasgow-pontuation">Pontuação glasgow: 0</h3>

<?php
//Queixa
echo "<br><br><div class='row div-pading'>";
echo "<legend class='big-title'>Queixa </legend>";
echo $this->Form->input('queixa_principal', ['empty' => true, 'options' => $queixa_principal, 'label' => ['text' => 'Queixa principal:', 'class' => 'form-input']]);

echo '<div class="funkyradio">';
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tem_alergiatem_alergia', ['id' => 'tem_alergia']);
echo '<label for="tem_alergia">Possui alergia</label>';
echo "</div>";
echo "</div><br>";

echo "<div class='tem_alergia' style='display:none'>";
echo $this->Form->input('alergias', ['type' => 'textarea', 'label' => ['text' => 'Alergias:', 'class' => 'form-input']]);
echo "</div>";

echo '<div class="funkyradio">';
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('uso_medicacao_regular', ['id' => 'uso_medicacao_regular']);
echo '<label for="uso_medicacao_regular">Uso de medicação regular</label>';
echo "</div>";
echo "</div><br>";

echo "<div class='uso_medicacao_regular' style='display:none'>";
echo $this->Form->input('medicacao_regular', ['type' => 'textarea', 'label' => ['text' => 'Medicação regular:', 'class' => 'form-input']]);
echo "</div>";

echo $this->Form->input('resumo_da_queixa', ['type' => 'textarea', 'label' => ['text' => 'Resumo da queixa do paciente:', 'class' => 'form-input']]);
echo "</div>";


echo '<br><button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>&nbsp;&nbsp;';
echo "<button disabled class='btn btn-success' type='button' id='proximo'>Próximo</button>";
?>

                    </div>
                    <div class="tab-pane" id="tab_default_2">
                       <?php
echo "<br><br><div class='row div-pading'>";
echo "<div class='dor tipo-de-dor-queixa hide-element'>";
echo "<legend class='big-title'>Dor</legend>";
echo $this->Form->input('localizacao_da_dor', ['class'=>'calc-screening', 'empty' => true, 'options' => $localizacao_da_dor, 'label' => ['text' => 'Localização:', 'class' => 'form-input']]);

echo $this->Form->input('intensidade_da_dor', ['class'=>'calc-screening', 'empty' => true, 'options' => $intensidade_da_dor, 'label' => ['text' => 'Intensidade:', 'class' => 'form-input']]);

echo $this->Form->input('aparecimento_da_dor', ['class'=>'calc-screening', 'empty' => true, 'options' => $aparecimento_da_dor, 'label' => ['text' => 'Aparecimento:', 'class' => 'form-input ']]);

echo $this->Form->input('pain_characteristics._ids', ['class'=>'calc-screening', 'options' => $pain_characteristics, 'empty' => true, 'label' => ['text' => 'Característica da dor:', 'class' => 'form-input']]);

echo "<div class='cefaleia tipo-de-dor hide-element'>";
echo '<div class="funkyradio">';

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('cefaleia_episodio_de_crise_convulsiva', ['id' => 'cefaleia_episodio_de_crise_convulsiva', 'class'=>'calc-screening']);
echo '<label for="cefaleia_episodio_de_crise_convulsiva">Episodio de crise convulsiva</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('cefaleia_rigidez_da_nuca', ['id' => 'cefaleia_rigidez_da_nuca', 'class'=>'calc-screening']);
echo '<label for="cefaleia_rigidez_da_nuca">Rigidez da nuca</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('cefaleia_vomitos', ['id' => 'cefaleia_vomitos', 'class'=>'calc-screening']);
echo '<label for="cefaleia_vomitos">Vomitos</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";
echo "</div>";

echo "<div class='abdominal tipo-de-dor hide-element'>";
echo '<div class="funkyradio">';

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_abdominal_historico_de_trauma', ['onclick' => 'addClassificacao("Vermelho")', 'id' => 'dor_abdominal_historico_de_trauma']);
echo '<label for="dor_abdominal_historico_de_trauma">Histórico abdominal</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_abdominal_diarreia', ['id' => 'dor_abdominal_diarreia']);
echo '<label for="dor_abdominal_diarreia">Diarreia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_abdominal_nausea', ['id' => 'dor_abdominal_nausea']);
echo '<label for="dor_abdominal_nausea">Nausea</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_abdominal_vomitos', ['id' => 'dor_abdominal_vomitos']);
echo '<label for="dor_abdominal_vomitos">Vomito</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='ceruical tipo-de-dor hide-element'>";
echo '<div class="funkyradio">';

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('ceruicalgia_historico_progresso_calculo_renal', ['id' => 'ceruicalgia_historico_progresso_calculo_renal']);
echo '<label for="ceruicalgia_historico_progresso_calculo_renal">Histórico de progressão do cálculo renal, hu, omose, hepatia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('ceruicalgia_transplatandos_e_em_quimioterapia', ['id' => 'ceruicalgia_transplatandos_e_em_quimioterapia']);
echo '<label for="ceruicalgia_transplatandos_e_em_quimioterapia">Transplantados e em quimioterapia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('ceruicalgia_alteracao_de_esfincter', ['id' => 'ceruicalgia_alteracao_de_esfincter']);
echo '<label for="ceruicalgia_alteracao_de_esfincter">Alteração de esfincter</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='toracica tipo-de-dor' style='display:none'>";
echo '<div class="funkyradio">';

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_toracica_dispineia', ['id' => 'dor_toracica_dispineia']);
echo '<label for="dor_toracica_dispineia">Dispneia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_toracica_assimetria_dos_pulsos', ['id' => 'dor_toracica_assimetria_dos_pulsos']);
echo '<label for="dor_toracica_assimetria_dos_pulsos">Assimetria dos pulsos</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_toracica_historico_de_coronariopatia', ['id' => 'dor_toracica_historico_de_coronariopatia']);
echo '<label for="dor_toracica_historico_de_coronariopatia">Histórico de coronariopatia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_toracica_historico_de_coronariopatia', ['id' => 'dor_toracica_historico_de_coronariopatia']);
echo '<label for="dor_toracica_historico_de_coronariopatia">Histórico de coronariopatia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_toracica_historico_de_avc', ['id' => 'dor_toracica_historico_de_avc']);
echo '<label for="dor_toracica_historico_de_avc">Histórico de familar com AVC ou TAI</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_toracica_trauma_toracico_antecedente', ['id' => 'dor_toracica_trauma_toracico_antecedente']);
echo '<label for="dor_toracica_trauma_toracico_antecedente">Antecedente de trauma torácico</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='dispneia tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';
echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Dispneia</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dispneia_desconforto', ['onclick' => 'addClassificacao("Vermelho")', 'id' => 'dispneia_desconforto']);
echo '<label for="dispneia_desconforto">Desconforto respiratório moderado a intenso</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dispneia_cianose', ['onclick' => 'addClassificacao("Vermelho")', 'id' => 'dispneia_cianose']);
echo '<label for="dispneia_cianose">Cianose</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dispneia_utilizacao_da_musculatura', ['onclick' => 'addClassificacao("Vermelho")', 'id' => 'dispneia_utilizacao_da_musculatura']);
echo '<label for="dispneia_utilizacao_da_musculatura">Utilização de musculatura acessora</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dispneia_dificuldade_para_falar', ['onclick' => 'addClassificacao("Vermelho")', 'id' => 'dispneia_dificuldade_para_falar']);
echo '<label for="dispneia_dificuldade_para_falar">Dificuldade para falar</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dispneia_historico_de_asma', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'dispneia_historico_de_asma']);
echo '<label for="dispneia_historico_de_asma">Histórico de asma ou DPOC"</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dispneia_alteracao_na_ausculta', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'dispneia_alteracao_na_ausculta']);
echo '<label for="dispneia_alteracao_na_ausculta">Alteração na ausulta pulmonar</label>';
echo "</div>";
echo "</div><br>";
echo "</div>";

echo "<div class='diarreia tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Diarreia</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('diarreia_sinais_de_desidratacao', ['id' => 'diarreia_sinais_de_desidratacao']);
echo '<label for="diarreia_sinais_de_desidratacao">Sinais de desidratação</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('diarreia_dor_abdominal', ['id' => 'diarreia_dor_abdominal']);
echo '<label for="diarreia_dor_abdominal">Dor abdominal leve e monerada</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('diarreia_nausea_e_vomito', ['id' => 'diarreia_nausea_e_vomito']);
echo '<label for="diarreia_nausea_e_vomito">Nausea e vomito</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('diarreia_sinais_vitais_normais', ['id' => 'diarreia_sinais_vitais_normais']);
echo '<label for="diarreia_sinais_vitais_normais">Sinais vitais dentro da normalidade</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='tosse tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Tosse</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_dispneia', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'tosse_dispneia']);
echo '<label for="tosse_dispneia">Dispneia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_historico_de_hemoptise', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'tosse_historico_de_hemoptise']);
echo '<label for="tosse_historico_de_hemoptise">Histórico de hemoptise</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_dor_toracica_ausente', ['id' => 'tosse_dor_toracica_ausente']);
echo '<label for="tosse_dor_toracica_ausente">Dor torácica ausente ou leve</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='casos_especiais tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Casos especiais</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_dispneia_yo', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'tosse_dispneia_yo']);
echo '<label for="tosse_dispneia_yo">Idade >60 anos</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_historico_de_hemoptise_yo', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'tosse_historico_de_hemoptise_yo']);
echo '<label for="tosse_historico_de_hemoptise_yo">Pacientes portadores de necessidades especiais</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_dor_toracica_ausente_yo', ['id' => 'tosse_dor_toracica_ausente_yo']);
echo '<label for="tosse_dor_toracica_ausente_yo">Gestantes</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='alteracao_de_pressao tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Alteração de pressão</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_dispneia_hh', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'tosse_dispneia_hh']);
echo '<label for="tosse_dispneia_hh">PA >150/100mmHg ou PA <100/60mmHg </label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_historico_de_hemoptise_hhh', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'tosse_historico_de_hemoptise_hhh']);
echo '<label for="tosse_historico_de_hemoptise_hhh">FC >100bpm ou FC <60bpm</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_dor_toracica_ausente_ggg', ['id' => 'tosse_dor_toracica_ausente_ggg']);
echo '<label for="tosse_dor_toracica_ausente_ggg">FR >20rpm</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_dor_toracica_ausente_gggh', ['id' => 'tosse_dor_toracica_ausente_gggh']);
echo '<label for="tosse_dor_toracica_ausente_gggh">Tº >37,8oC no momento da consulta</label>';
echo "</div>";
echo "</div><br>";
echo "</div>";

echo "<div class='parada_cardiorrespiratoria tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Parada cardiorrespiratória</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('parada_ausecia_pulso', [ 'id' => 'parada_ausecia_pulso']);
echo '<label for="parada_ausecia_pulso">Ausência de pulso carotídeo (5 a 10 segundos)</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('parada_ausecia_movimentos', [ 'id' => 'parada_ausecia_movimentos']);
echo '<label for="parada_ausecia_movimentos">Ausência de movimentos respiratórios</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('parada_inconsciencia', ['id' => 'parada_inconsciencia']);
echo '<label for="parada_inconsciencia">Inconsciência</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='hemorragia_digestiva tipo-de-queixa  hide-element'>";
    echo '<div class="funkyradio">';

        echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Hemorragia</legend>";
        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('hemorragia_historico_de_enterorragia', ['id' => 'hemorragia_historico_de_enterorragia']);
        echo '<label for="hemorragia_historico_de_enterorragia">História de enterorragia, melena ou hematêmese</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('hemorragia_antecedente_de_cirrose', ['id' => 'hemorragia_antecedente_de_cirrose']);
        echo '<label for="hemorragia_antecedente_de_cirrose">Antecedente de cirrose ou neoplasia hepática ou de cólon, uso de anti-inflamatório não esteroidal</label>';
        echo "</div>";

    echo "</div><br>";
echo "</div>";

echo "<div class='queixa_cronica tipo-de-queixa  hide-element'>";
echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Queixa crônica</legend>";
    echo '<div class="funkyradio-primary">';
    echo $this->Form->checkbox('queixa_cronica_nao_agudizada', ['id' => 'queixa_cronica_nao_agudizada']);
    echo '<label for="queixa_cronica_nao_agudizada">Queixa crõnica não agudizadas</label>';
    echo "</div>";

echo "</div>";

echo "<div class='demaio_mal_estar tipo-de-queixa hide-element'>";
    echo '<div class="funkyradio">';        
        echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Demaio / mal estar geral</legend>";

         // echo "<div id='desmaio_vermelho'> ";
        $desmaio_saturacao=['Saturação ≤ 89% em ar ambiente', 'Saturação de O² ≥ 90% e ≤ 94% (ar ambiente)', 'Saturação ≥ 95% (ar ambiente)'];
        $desmaio_pas=["PAS ≥ 160 e/ou PAD ≥ 110 mmHg", "PAS de 140-159 e/ou PAD 90-109 mmHg, sem sintomas", 'PAS ≤ 139 e PAD ≤ 89 mmHg'];

        $abdominal_dor=["Dor intensa ≥ 7-10", 'Dor lombar moderada 4-6/10', 'Dor leve intensidade (&lt;3/10)'];

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('desmaio_nao_responsivo', ['id' => 'desmaio_nao_responsivo', 'class'=>'red', 'onclick' => 'addClassificacao("Vermelho")']);
        echo '<label for="desmaio_nao_responsivo">Não responsiva</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('desmaio_choque', ['id' => 'desmaio_choque', 'class'=>'red' , 'onclick' => 'addClassificacao("Vermelho")']);
        echo '<label for="desmaio_choque">Choque</label>';
        echo "</div><br>";

        echo $this->Form->input('desmaio_saturacao', ['empty'=>true, 'options'=>$desmaio_saturacao, 'label'=>['text'=>'Saturação:', 'class'=>'form-input ']]);     

        echo $this->Form->input('desmaio_pas', ['empty'=>true, 'options'=>$desmaio_pas, 'label'=>['text'=>'PAS:', 'class'=>'form-input ']]);     


        //     echo '<div class="funkyradio-primary">';
        //     echo $this->Form->checkbox('desmaio_nao_vermelho', ['id' => 'desmaio_nao_vermelho']);
        //     echo '<label for="desmaio_nao_vermelho">Não</label>';
        //     echo "</div>";
        // echo "</div>";

        // echo "<div id='desmaio_laranja' style='display:none'> ";
            echo '<div class="funkyradio-primary">';
                echo $this->Form->checkbox('desmaio_alteracao_consciencia', ['id' => 'desmaio_alteracao_consciencia', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
                echo '<label for="desmaio_alteracao_consciencia">Alteração de consciência ou estado mental</label>';
            echo "</div>";

            echo '<div class="funkyradio-primary">';
                echo $this->Form->checkbox('desmaio_padrao_respiratorio', ['id' => 'desmaio_padrao_respiratorio', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
                echo '<label for="desmaio_padrao_respiratorio">Padrão respiratório ineficaz*²</label>';
            echo "</div>";

            //echo '<div class="funkyradio-primary">';
            // echo $this->Form->checkbox('desmaio_saturacao_o2', ['id' => 'desmaio_saturacao_o2', 'class'=>'laranja']);
            // echo '<label for="desmaio_saturacao_o2">Saturação de O² ≥ 90% e ≤ 94% (ar ambiente)</label>';

            //echo '<div class="funkyradio-primary">';
            // echo $this->Form->checkbox('desmaio_pas', ['id' => 'desmaio_pas', 'class'=>'laranja']);
            // echo '<label for="desmaio_pas">PAS ≥ 160 e/ou PAD ≥ 110 mmHg</label>';

            echo '<div class="funkyradio-primary">';
                echo $this->Form->checkbox('desmaio_pa', ['id' => 'desmaio_pa', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
                echo '<label for="desmaio_pa">PA ≥ 140/90 mmHg com dor de cabeça, de estômago ou alterações visuais</label>';
            echo "</div>";

            echo '<div class="funkyradio-primary">';
                echo $this->Form->checkbox('desmaio_relatorio_diabetes', ['id' => 'desmaio_relatorio_diabetes', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
                echo '<label for="desmaio_relatorio_diabetes">Relato de Diabetes (glicemia ≤ 50 mg/dl)</label>';
            echo "</div>";

            echo '<div class="funkyradio-primary">';
                echo $this->Form->checkbox('desmaio_hipertermia', ['id' => 'desmaio_hipertermia', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
                echo '<label for="desmaio_hipertermia">Hipertermia ≥ 40ºC</label>';
            echo "</div>";

            echo '<div class="funkyradio-primary">';
                echo $this->Form->checkbox('desmaio_febre', ['id' => 'desmaio_febre', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
                echo '<label for="desmaio_febre">Febre: TAx 38,0oC a 39,9oC</label>';
            echo "</div>";

            echo '<div class="funkyradio-primary">';
                echo $this->Form->checkbox('desmaio_pacientes_imunodeprimidas', ['id' => 'desmaio_pacientes_imunodeprimidas', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
                echo '<label for="desmaio_pacientes_imunodeprimidas">Pacientes imunodeprimidas (HIV)</label>';
            echo "</div>";  

            echo '<div class="funkyradio-primary">';
                echo $this->Form->checkbox('desmaio_encaminhamento_centro', ['id' => 'desmaio_encaminhamento_centro', 'class'=>'verde', 'onclick' => 'addClassificacao("Verde")']);
                echo '<label for="desmaio_encaminhamento_centro">Encaminhamento do Centro de Saúde não enquadradas nas situações de urgência</label>';
            echo "</div>";  

            echo '<div class="funkyradio-primary">';
                echo $this->Form->checkbox('desmaio_atendimento_nao_prioritario', ['id' => 'desmaio_atendimento_nao_prioritario', 'class'=>'verde', 'onclick' => 'addClassificacao("Azul")']);
                echo '<label for="desmaio_atendimento_nao_prioritario">Atendimento não prioritário ou encaminhamento ao Centro de Saúde</label>';
            echo "</div>";  

            // echo '<div class="funkyradio-primary">';
            // echo $this->Form->checkbox('desmaio_nao_laranja', ['id' => 'desmaio_nao_laranja']);
            // echo '<label for="desmaio_nao_laranja">Não</label>';
            // echo "</div>";            
        //echo "</div>";

    echo "</div><br>";
echo "</div>";



echo "<div class='dor_abdominal_lombar tipo-de-queixa hide-element'>";
    echo '<div class="funkyradio">';
        echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Dor abdominal/lombar/contrações uterinas</legend>";
        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_periodo_expulsivo', ['id' => 'abdominal_periodo_expulsivo', 'class'=>'red' , 'onclick' => 'addClassificacao("Vermelho")']);
        echo '<label for="abdominal_periodo_expulsivo">Período expulsivo</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_prolapso', ['id' => 'abdominal_prolapso', 'class'=>'red' , 'onclick' => 'addClassificacao("Vermelho")']);
        echo '<label for="abdominal_prolapso">Prolapso de cordão umbilical</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_exteriorizacao', ['id' => 'abdominal_exteriorizacao', 'class'=>'red' , 'onclick' => 'addClassificacao("Vermelho")']);
        echo '<label for="abdominal_exteriorizacao">Exteriorização de partes fetais</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_sinais_choque', ['id' => 'abdominal_sinais_choque', 'class'=>'red' , 'onclick' => 'addClassificacao("Vermelho")']);
        echo '<label for="abdominal_sinais_choque">Sinais de choque</label>';
        echo "</div><br>";

        echo $this->Form->input('abdominal_dor', ['empty'=>true, 'options'=>$abdominal_dor, 'label'=>['text'=>'Dor:', 'class'=>'form-input ']]);     


        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_contracoes', ['id' => 'abdominal_contracoes', 'class'=>'laranja' , 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="abdominal_contracoes">Contrações intensas a cada 2 minutos</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_hipertonia', ['id' => 'abdominal_hipertonia', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="abdominal_hipertonia">Hipertonia uterina / Sangramento genital intenso**</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_pa', ['id' => 'abdominal_pa', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="abdominal_pa">PA ≥ 140/90 mmHg com dor de cabeça, de estômago ou alterações visuais</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_perda_liquido', ['id' => 'abdominal_perda_liquido', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="abdominal_perda_liquido">Perda de líquido espesso esverdeado</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_portadora', ['id' => 'abdominal_portadora', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="abdominal_portadora">Portadora de doença falciforme</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_portadora_hiv', ['id' => 'abdominal_portadora_hiv', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="abdominal_portadora_hiv">Portadora de HIV em TP (qualquer frequência ou dor)</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_pos_parto', ['id' => 'abdominal_pos_parto', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="abdominal_pos_parto">Pós-parto imediato</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_dor_lombar', ['id' => 'abdominal_dor_lombar', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
        echo '<label for="abdominal_dor_lombar">Dor lombar moderada 4-6/10</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_sangramento_moderado', ['id' => 'abdominal_sangramento_moderado', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
        echo '<label for="abdominal_sangramento_moderado">Sangramento moderado**</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_ausencia', ['id' => 'abdominal_ausencia', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
        echo '<label for="abdominal_ausencia">Ausência de MF em gravidez ≥ 22 semanas</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_vitima', ['id' => 'abdominal_vitima', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
        echo '<label for="abdominal_vitima">Vítimas de Violência física e sexual</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_febril', ['id' => 'abdominal_febril', 'class'=>'verde', 'onclick' => 'addClassificacao("Verde")']);
        echo '<label for="abdominal_febril">Febril ≤ 37,9oC</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_perda_liquido_pequena', ['id' => 'abdominal_perda_liquido_pequena', 'class'=>'verde', 'onclick' => 'addClassificacao("Verde")']);
        echo '<label for="abdominal_perda_liquido_pequena">Perda de liquido em pequena quantidade</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_encaminhamento', ['id' => 'abdominal_encaminhamento', 'class'=>'verde', 'onclick' => 'addClassificacao("Verde")']);
        echo '<label for="desmaio_nao">Encaminhamento de outras unidades de saúde não enquadradas nas situações de urgência</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('abdominal_atendimento_prioritario', ['id' => 'abdominal_atendimento_prioritario', 'class'=>'red', 'onclick' => 'addClassificacao("Azul")']);
        echo '<label for="abdominal_atendimento_prioritario">Atendimento não prioritário ou Encaminhamento ao Centro de Saúde</label>';
        echo "</div>";

    echo "</div><br>";
echo "</div>";

echo "<div class='new dor_de_cabeca tipo-de-queixa hide-element'>";
    echo '<div class="funkyradio">';
        echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Dor de cabeça, tontura, vertigem</legend>";
        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_apneia', ['id' => 'dor_cabeca_apneia', 'class'=>'red' , 'onclick' => 'addClassificacao("Vermelho")']);
        echo '<label for="dor_cabeca_apneia">Apnéia ou Padrão Respiratório ineficaz*²</label>';
        echo "</div>";



        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_choque', ['id' => 'dor_cabeca_choque', 'class'=>'red' , 'onclick' => 'addClassificacao("Vermelho")']);
        echo '<label for="dor_cabeca_choque">Sinais de Choque</label>';
        echo "</div><br>";

        echo '<div class="funkyradio-primary">';
            echo $this->Form->checkbox('dor_cabeca_alteracao_consciencia', ['id' => 'dor_cabeca_alteracao_consciencia', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
            echo '<label for="dor_cabeca_alteracao_consciencia">Alteração de consciência ou estado mental</label>';
        echo "</div><br>";

        echo $this->Form->input('dor_cabeca_pas', ['empty'=>true, 'options'=>$desmaio_pas, 'label'=>['text'=>'PAS:', 'class'=>'form-input ']]);     

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_pa_maior_140', ['id' => 'dor_cabeca_pa_maior_140', 'class'=>'red', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="dor_cabeca_pa_maior_140">PA ≥ 140/90 mmHg com dor de cabeça, de estômago ou alterações visuais</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_dor_intensa', ['id' => 'dor_cabeca_dor_intensa', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="dor_cabeca_dor_intensa">Dor intensa (7-10/10) de início abrupto ou progressiva</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_disturbios', ['id' => 'dor_cabeca_disturbios', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="dor_cabeca_disturbios">Distúrbios de equilíbrio, zumbidos, perda da visão, Sinais de meningismo*6</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_hipertermia', ['id' => 'dor_cabeca_hipertermia', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="dor_cabeca_hipertermia">Hipertermia: &gt; 40ºC</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_dor_forte', ['id' => 'dor_cabeca_dor_forte', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
        echo '<label for="dor_cabeca_dor_forte">Dor forte moderada (5-7/10) </label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_nausea', ['id' => 'dor_cabeca_nausea', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
        echo '<label for="dor_cabeca_nausea">Náuseas e vômitos de início agudo ou persistentes</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_febre', ['id' => 'dor_cabeca_febre', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
        echo '<label for="dor_cabeca_febre">Febre: TAx 38,0oC a 39,9oC</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_dor_leve', ['id' => 'dor_cabeca_dor_leve', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Verde")']);
        echo '<label for="dor_cabeca_dor_leve">Dor leve 1-4/10</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_dor_relato', ['id' => 'dor_cabeca_dor_relato', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Verde")']);
        echo '<label for="dor_cabeca_dor_relato">Relato de náuseas e vômitos</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_febril', ['id' => 'dor_cabeca_febril', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Verde")']);
        echo '<label for="dor_cabeca_febril">Febril: 37,5oC a 37,9oC</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_atendimento', ['id' => 'dor_cabeca_atendimento', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Azul")']);
        echo '<label for="dor_cabeca_atendimento">Atendimento não prioritário ou Encaminhamento ao Centro de Saúde</label>';
        echo "</div>";

    echo "</div><br>";
echo "</div>";


echo "<div class='new falta_de_ar tipo-de-queixa hide-element'>";
    echo '<div class="funkyradio">';
        echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Falta de ar/sintomas respiratórios</legend>";

        echo $this->Form->input('falta_ar_saturacao', ['empty'=>true, 'options'=>$desmaio_saturacao, 'label'=>['text'=>'Saturação:', 'class'=>'form-input ']]);  

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('falta_ar_estridor', ['id' => 'falta_ar_estridor', 'class'=>'red' , 'onclick' => 'addClassificacao("Vermelho")']);
        echo '<label for="falta_ar_estridor">Estridor</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('falta_ar_choque', ['id' => 'falta_ar_choque', 'class'=>'red' , 'onclick' => 'addClassificacao("Vermelho")']);
        echo '<label for="falta_ar_choque">Sinais de Choque</label>';
        echo "</div><br>";

        echo '<div class="funkyradio-primary">';
            echo $this->Form->checkbox('falta_ar_padrao', ['id' => 'falta_ar_padrao', 'class'=>'laranja', 'onclick' => 'addClassificacao("Laranja")']);
            echo '<label for="falta_ar_padrao">Padrão respiratório ineficaz*²</label>';
        echo "</div><br>";

        echo $this->Form->input('falta_ar_pas', ['empty'=>true, 'options'=>$desmaio_pas, 'label'=>['text'=>'PAS:', 'class'=>'form-input ']]);     

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_pa_maior_140', ['id' => 'dor_cabeca_pa_maior_140', 'class'=>'red', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="dor_cabeca_pa_maior_140">PA ≥ 140/90 mmHg com dor de cabeça, de estômago ou alterações visuais</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_dor_intensa', ['id' => 'dor_cabeca_dor_intensa', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="dor_cabeca_dor_intensa">Dor intensa (7-10/10) de início abrupto ou progressiva</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_disturbios', ['id' => 'dor_cabeca_disturbios', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="dor_cabeca_disturbios">Distúrbios de equilíbrio, zumbidos, perda da visão, Sinais de meningismo*6</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_hipertermia', ['id' => 'dor_cabeca_hipertermia', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Laranja")']);
        echo '<label for="dor_cabeca_hipertermia">Hipertermia: &gt; 40ºC</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_dor_forte', ['id' => 'dor_cabeca_dor_forte', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
        echo '<label for="dor_cabeca_dor_forte">Dor forte moderada (5-7/10) </label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_nausea', ['id' => 'dor_cabeca_nausea', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
        echo '<label for="dor_cabeca_nausea">Náuseas e vômitos de início agudo ou persistentes</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_febre', ['id' => 'dor_cabeca_febre', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Amarelo")']);
        echo '<label for="dor_cabeca_febre">Febre: TAx 38,0oC a 39,9oC</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_dor_leve', ['id' => 'dor_cabeca_dor_leve', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Verde")']);
        echo '<label for="dor_cabeca_dor_leve">Dor leve 1-4/10</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_dor_relato', ['id' => 'dor_cabeca_dor_relato', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Verde")']);
        echo '<label for="dor_cabeca_dor_relato">Relato de náuseas e vômitos</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_febril', ['id' => 'dor_cabeca_febril', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Verde")']);
        echo '<label for="dor_cabeca_febril">Febril: 37,5oC a 37,9oC</label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('dor_cabeca_atendimento', ['id' => 'dor_cabeca_atendimento', 'class'=>'amarelo', 'onclick' => 'addClassificacao("Azul")']);
        echo '<label for="dor_cabeca_atendimento">Atendimento não prioritário ou Encaminhamento ao Centro de Saúde</label>';
        echo "</div>";

    echo "</div><br>";
echo "</div>";
echo "<div class='lesoes_de_pele tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Lesões de pele</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('lesoes_de_pele_escabiose', ['id' => 'lesoes_de_pele_escabiose']);
echo '<label for="lesoes_de_pele_escabiose">Escabiose</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('lesoes_de_pele_eczema', ['id' => 'lesoes_de_pele_eczema']);
echo '<label for="lesoes_de_pele_eczema">Eczema</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('lesoes_de_pele_outras_lesoes', ['id' => 'lesoes_de_pele_outras_lesoes']);
echo '<label for="lesoes_de_pele_outras_lesoes">Outras lesões de pele</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='alteracao_estado_mental tipo-de-queixa  hide-element'>";
    echo '<div class="funkyradio">';

        echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Alteração do estado mental</legend>";
        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('alt_estado_mental_ausencia_de_resposta', ['onclick' => 'addClassificacao("Vermelho")', 'id' => 'alt_estado_mental_ausencia_de_resposta', 'class'=>'calc-screening']);
        echo '<label for="alt_estado_mental_ausencia_de_resposta">Ausência de resposta a estímulos (verbal, doloroso, tátil) </label>';
        echo "</div>";

        echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('alt_estado_mental_alteracao_consciencia', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'alt_estado_mental_alteracao_consciencia', 'class'=>'calc-screening']);
        echo '<label for="alt_estado_mental_alteracao_consciencia">Alteração do nível de consciência</label>';
        echo "</div>";

    echo "</div><br>";
echo "</div>";

echo "<div class='deficit_motor tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Déficit Motor</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('deficit_motor_inicio_subito', ['id' => 'deficit_motor_inicio_subito']);
echo '<label for="deficit_motor_inicio_subito">Início súbito (<48h)</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='febre tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Febre</legend>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('febre_alteracao_nivel_consciencia', ['id' => 'febre_alteracao_nivel_consciencia']);
echo '<label for="febre_alteracao_nivel_consciencia">Alteração do nível de consciência</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('febre_dispneia', ['id' => 'febre_dispneia']);
echo '<label for="febre_dispneia">Dispneia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('febre_imunossupressao', ['id' => 'febre_imunossupressao']);
echo '<label for="febre_imunossupressao">Imunossupressão</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='hiperglicemia tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Hiperglicemia</legend>";

echo "</div><br>";
echo "</div>";

echo "<div class='alt_sinais_vitais tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Alt. Sinais Vitais</legend>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('hip', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'hip']);
echo '<label for="hip">FC >100bpm ou FC <60bpm</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('hipp', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'hipp']);
echo '<label for="hipp">FR >20rpm</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('hipap', ['onclick' => 'addClassificacao("Amarelo")', 'id' => 'hipap']);
echo '<label for="hipap">Tº >37,8oC no momento da consulta</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='hipoglicemia tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Hipoglicemia</legend>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('hipoglicemia_glicemia_capilar', ['id' => 'hipoglicemia_glicemia_capilar']);
echo '<label for="hipoglicemia_glicemia_capilar">Glicemia capilar < ou = 60mg/dl</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<br><br><br>";
echo "<p id='classificacao-sugerida'>Classificação sugerida: Verde</p>";
echo "<figure class='circle classficiacao_sugerida'></figure>";

echo "<div class='hide-element' style='display:none'>";
echo "<input name='classificacao_sugerida' value='Verde'>";
echo "</div>";

// echo $this->Form->input('classificacao_sugerida', ['empty'=>true, 'options'=>$classificacao_risco, 'label'=>['text'=>'Classificação sugerida:', 'class'=>'form-input']]);

echo '<div class="funkyradio">';

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('sel', ['id' => 'sel']);
echo '<label for="sel">Deseja alterar a seleção?</label>';
echo "</div>";
echo "</div>";

echo "<br>";
echo "<div class='alterar-sel' style='display:none'>";
echo $this->Form->input('classificacao_selecionada', ['empty' => true, 'options' => $classificacao_risco, 'label' => ['text' => 'Classificação corrigida:', 'class' => 'form-input classificacao_selecionada_l']]);
//echo "";
echo "<br>";
echo "</div>";
?>
    <button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>&nbsp;&nbsp;
    <?=  $this->Form->button(__('Salvar')); ?>
</div>
</div>

                    </div>
                </div>
        </div>
            <div class="hide-element">
                <input type="text" value="" name="glasgow"  id="glasgow-ocular">
                <input type="text" value="" name="glasgow"  id="glasgow-verbal">
                <input type="text" value="" name="glasgow"  id="glasgow-motora">
            </div>
            <br><br>
                <?= $this->Form->hidden('patient_id', ['value' => $pacient_id]); ?>
                <?=  $this->Form->hidden('unit_id', ['value' => $unit_id]); ?>
             <?=$this->Form->end()?>
        </div>

    </fieldset>
</div>

<script >
var verbal =0; 
var ocular = 0;
var motora = 0;
var classificacao = null;

var select_opt_1 = '<option value=""></option><option value="alteracao_estado_mental">Alteração de estado mental</option><option value="dispneia">Dispneia</option><option value="hiperglicemia">Hiperglicemia</option><option value="alt_sinais_vitais">Alt. sinais vitais isolados</option><option value="tosse">Tosse</option><option value="lesoes_de_pele">Lesões de pele</option><option value="dor">Dor</option><option value="febre">Febre</option><option value="hipoglicemia">Hipoglicemia</option><option value="diarreia">Diarreia</option><option value="casos_especiais">Casos especiais</option><option value="procura_da_unidade">Procura da unidade p/ procedimentos</option><option value="hemorragia">Hemorragia</option><option value="alteracao_de_pressao">Alteração de pressão</option><option value="parada_cardiorrespiratoria">Parada cardiorrespiratória</option><option value="hemorragia_digestiva">Hemorragia digestiva</option><option value="queixas_cronicas">Queixas crônicas</option>';

var select_opt_2 = '<option value=""></option>';
    select_opt_2 += '<option value="demaio_mal_estar">Desmaio / mal estar geral</option>';
    select_opt_2 += '<option value="dor_abdominal_lombar">Dor abdominal / lombar / contrações uterinas</option>';
    select_opt_2 += '<option value="dor_de_cabeca">Dor de cabeça, tontura, vertigem</option>';
    select_opt_2 += '<option value="falta_de_ar">Falta de ar</option>';
    select_opt_2 += '<option value="febre_sinais_infeccao">Febre / sinais de infecção</option>';
    select_opt_2 += '<option value="nausea_e_vomito">Náuseas e vômitos</option>';
    select_opt_2 += '<option value="perda_liquido_vaginal">Perda de líquido vaginal / secreções</option>';
    select_opt_2 += '<option value="perda_de_sangue_vaginal">Perda de sangue via vaginal</option>';
    select_opt_2 += '<option value="queixas_urinarias">Queixas urinárias</option>';
    select_opt_2 += '<option value="parada_reducao_movimentos">Parada / redução de movimentos fetais</option>';
    select_opt_2 += '<option value="relato_convulsao">Relato de convulsão</option>';
    select_opt_2 += '<option value="outras_queixaas_pacientes">Outras queixas / pacientes encaminhadas de outras unidades sem referenciamento</option>';

    $(".calc-screening").change(function() {

        ajustar_classificacao("verde");

        //$(".calc-screening").each(function(index, value) {

            switch( $("#queixa-principal").val() ) {

                case "alteracao_estado_mental":
                    if ($("#alt_estado_mental_ausencia_de_resposta").is(":checked")) {
                        ajustar_classificacao("vermelho");
                    }

                    if ($("#alt_estado_mental_alteracao_consciencia").val().length > 1) {
                        ajustar_classificacao("amarelo");
                    }                        
                break;

                case "hiperglicemia":
                    if ($("#alt_estado_mental_alteracao_consciencia").val().length > 1) {
                        ajustar_classificacao("vermelho");
                    }                      
                break;

                case "hipoglicemia":
                    if ($("#alt_estado_mental_alteracao_consciencia").val().length > 1) {
                        ajustar_classificacao("vermelho");
                    }           

                    if ( $("#glicemia").val() <= 60 ) {
                        ajustar_classificacao("amarelo");
                    }           
                break;

                case "parada_cardiorrespiratoria":
                    if ($("#parada_ausecia_pulso").is(":checked")) {
                        ajustar_classificacao("vermelho");
                    }           

                    if ($("#parada_ausecia_movimentos").is(":checked")) {
                        ajustar_classificacao("vermelho");
                    }   

                    if ($("#parada_inconsciencia").is(":checked")) {
                        ajustar_classificacao("vermelho");
                    }   
                          
                break;


                case "diarreia":
                    //resolver corrigir pa
                    if ($("#diarreia_sinais_de_desidratacao").is(":checked")) {
                        ajustar_classificacao("amarelo");
                    }           

                    if ( $("#fc").val() > 100 ) {
                        ajustar_classificacao("amarelo");
                    }    

                    if ( $("#temp").val() > 37.8 ) {
                        ajustar_classificacao("amarelo");
                    }
                          
                break;

                case "hemorragia_digestiva":
                    //resolver corrigir pa
                    if ($("#hemorragia_historico_de_enterorragia").is(":checked")) {
                        ajustar_classificacao("amarelo");
                    }           

                    if ( $("#fc").val() > 100 ) {
                        ajustar_classificacao("amarelo");
                    }    

                    if ($("#alt_estado_mental_alteracao_consciencia").val().length > 1) {
                        ajustar_classificacao("amarelo");
                    }

                    if ($("#hemorragia_antecedente_de_cirrose").is(":checked")) {
                        ajustar_classificacao("amarelo");
                    }
                          
                break;

                case "tosse":
                    //resolver corrigir pa
                    if ($("#tosse_dispneia").is(":checked")) {
                        ajustar_classificacao("amarelo");
                    }

                    if ($("#tosse_historico_de_hemoptise").is(":checked")) {
                        ajustar_classificacao("amarelo");
                    }            

                    if ( $("#fr").val() > 20 ) {
                        ajustar_classificacao("amarelo");
                    }    

                    if ( $("#temp").val() > 37.8 ) {
                        ajustar_classificacao("amarelo");
                    }

                    if ( $("#sato2").val() > 95 ) {
                        ajustar_classificacao("amarelo");
                    }

                    
                          
                break;

                case "febre":
                    //resolver corrigir pa

                    if ($("#alt_estado_mental_ausencia_de_resposta").is(":checked")) {
                        ajustar_classificacao("vermelho");
                    }

                    if ($("#febre_dispneia").is(":checked")) {
                        ajustar_classificacao("vermelho");
                    }

                    if ($("#febre_imunossupressao").is(":checked")) {
                        ajustar_classificacao("vermelho");
                    }

                    if ( $("#fc").val() > 100 ) {
                        ajustar_classificacao("vermelho");
                    }       

                    if ( $("#fr").val() > 25 ) {
                        ajustar_classificacao("vermelho");
                    }                 
                break;

                case "dispneia":
                    if ( $("#dispneia_desconforto").is(":checked") ) {
                        ajustar_classificacao("vermelho");
                    }

                    if ( $("#dispneia_cianose").is(":checked") ) {
                        ajustar_classificacao("vermelho");
                    }

                    if ( $("#dispneia_utilizacao_da_musculatura").is(":checked") ) {
                        ajustar_classificacao("vermelho");
                    }

                    if ( $("#fr").val() > 20 ) {
                        ajustar_classificacao("vermelho");
                    }

                    if ( $("#dispneia_dificuldade_para_falar").is(":checked") ) {
                        ajustar_classificacao("vermelho");
                    }

                    if ( $("#temp").val() > 37.8 || $("#temp").val() < 35 ) {
                        ajustar_classificacao("vermelho");
                    }

                    if ( $("#alteracao-consciencia").val().length > 1 ) {
                        ajustar_classificacao("vermelho");
                    }

                    if ( $("#fr").val() < 95 ) {
                        ajustar_classificacao("vermelho");
                    }

                    if ( $("#fc").val() > 100 ) {
                        ajustar_classificacao("vermelho");
                    }

                    if ( $("#dispneia_historico_de_asma").is(":checked") ) {
                        ajustar_classificacao("amarelo");
                    }

                    if ( $("#dispneia_alteracao_na_ausculta").is(":checked") ) {
                        ajustar_classificacao("amarelo");
                    }
                break;

                case "dor":
                    if ( $('#localizacao-da-dor').val().length > 1 ) {
                        switch( $("#localizacao-da-dor option:selected").val() ) {
                            case "cefaleia" :
                                if ( $("#cefaleia_inicio_subito").is(":checked") ) {
                                    console.log("cefaleia_inicio_subito");
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#cefaleia_episodio_de_crise_convulsiva").is(":checked") ) {
                                    console.log("cefaleia_episodio_de_crise_convulsiva");
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#cefaleia_deficit_motor_agudo").is(":checked") ) {
                                    console.log("cefaleia_deficit_motor_agudo");
                                    ajustar_classificacao("vermelho");
                                }



                                if ( $("#alteracao-consciencia").val().length > 0 ) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#pas").val() > 140 ) {
                                    console.log("cefaleia pas > 140 ");
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#fc").val() < 60 ) {
                                    console.log("cefaleia fc < 60");
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#cefaleia_rigidez_da_nuca").is(":checked") ) {
                                    ajustar_classificacao("vermelho");
                                    console.log("cefaleia_rigidez_da_nuca");
                                }

                                if ( $("#cefaleia_vomitos").is(":checked") ) {
                                    ajustar_classificacao("vermelho");
                                    console.log("cefaleia_vomitos");

                                }
                                
                                if ( $("#intensidade-da-dor").val() == "Forte" ) {                                    
                                    ajustar_classificacao("amarelo");
                                    console.log("intensidade-da-dor");
                                }
                                // else if ( $("#intensidade-da-dor").val() == "Moderada" || $("#intensidade-da-dor").val() == "Leve" ) {
                                //     ajustar_classificacao("verde");
                                // }
                                
                            break;

                            case "abdominal":
                                //resolver corrigir pa
                                if ( $("#fc").val() > 100 ) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#temp").val() > 37.8) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#dor_abdominal_historico_de_trauma").is(":checked") ) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#intensidade-da-dor").val() == "Moderada" ) {
                                    ajustar_classificacao("amarelo");
                                }
                            break;

                            case "toracia":
                                //resolver corrigir pa
                                if ( $("#dor_toracica_dor_precordial").is(":checked") ) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#dor_toracica_dispineia").is(":checked") ) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#dor_toracica_assimetria_dos_pulsos").is(":checked") ) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#dor_toracica_historico_de_coronariopatia").is(":checked") ) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#dor_toracica_irradiacao").is(":checked") ) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#fc").val() > 90 || $("#fc").val() < 60 ) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#fr").val() > 20 ) {
                                    ajustar_classificacao("vermelho");
                                }

                                if ( $("#dor_toracica_historico_de_avc").is(":checked") ) {
                                    ajustar_classificacao("amarelo");
                                }
                                
                            break;
                        }                        
                    }                                            
                break;

                default:
                    classificacao = "verde";
                break;
            }

            if ( $(this).is("#pas") ) {
                 //console.log("queixa-principal = " + $("#queixa-principal").val() );
                // console.log("value = " + $(value).val());
                //if ( $(value).val() > 140)
            }
        // });
    });

    function ajustar_classificacao(cor) {
        console.log("ajustar_classificacao");
        $("#classificacao-sugerida").text("Classificação sugerida: "+cor);

        switch(cor) {
            case 'amarelo':
                $(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #fff700, #676767)');
                break;
            case 'azul':
                $(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #00a1ff, #676767)');
                break;
            case 'vermelho':
                $(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #ff0000, #676767)');
                break;
            default:
                $(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #1BFF00, #676767)');
        }
    }

    $("#esta_gestente_ou_suspeita").change(function() {
        $("#queixa-principal option").remove();

        if ($(this).is(":checked")) {            
            $("#queixa-principal").append(select_opt_2);
        }
        else {
            $("#queixa-principal").append(select_opt_1);
        }
    });

    $("#desmaio_nao_vermelho").change(function() {
        $("#desmaio_vermelho").hide();

        if ($(this).is(":checked")) {            
            $("#desmaio_laranja").fadeIn();
        }
        else {
            $("#desmaio_laranja").fadeOut();
        }
    });

$("#localizacao-da-dor").change(function(){
   var localizacao = $(this).val();

   $('.tipo-de-dor select').val('');
   $('.tipo-de-dor').hide();

   $('.'+localizacao).toggle();
   console.log($(this).val());
});


$("#queixa-principal").change(function(){

   var localizacao = $(this).val();
   console.log(localizacao);

   if (localizacao.length > 2){
      $("#proximo").removeAttr("disabled");
      // $("#menu_2").attr("href", "#tab_default_2");
      // $("#menu_2").attr("data-toggle", "#tab");

    }
   else
   {
      $("#proximo").attr("disabled");
      //$("#proximo").removeAttr("href");
      //$("#proximo").removeAttr("data-toggle");
   }

   $('.tipo-de-dor-queixa select').val('');
   $('.tipo-de-queixa select').val('');
   $('.tipo-de-dor select').val('');

   $('.tipo-de-dor').hide();
   $('.tipo-de-dor-queixa').hide();
   $('.tipo-de-queixa').hide();

   $('.'+localizacao).toggle();
   console.log($(this).val());
});

$("#proximo").click(function(){
    $("#menu_2").click();
});

// $("#parada_cardiaca_ou_suspeita").change(function() {
//     if ($(this).is(":checked")) {
//         $(".parada_cardiaca_ou_suspeita").slideDown();
//     } 
//     else {
//         $(".parada_cardiaca_ou_suspeita").slideUp();
//     }
// });

$("#tem_alergia").change(function() {
    console.log("yo");
    console.log(this.checked );

    if (this.checked ) {
        $(".tem_alergia").show();
    }
    else {
        $(".tem_alergia").hide();
    }
});

$("#uso_medicacao_regular").change(function() {

    console.log(this.checked);

    if (this.checked ) {
        $(".uso_medicacao_regular").show();
    }
    else {
        $(".uso_medicacao_regular").hide();
    }
});

$("#classificacao-selecionada").change(function(){
    console.log($(this).val());
    if(!$( ".classificacao_selecionada_l figure" ).hasClass( "circle_selecionada" )){
        $(".classificacao_selecionada_l").append("<figure class='circle circle_selecionada'></figure>");
    }

    color = $(this).val();
    switch(color) {
        case 'amarelo':
            $(".circle_selecionada").css('background','radial-gradient(circle at 13px 14px, #fff700, #676767)');
            break;
        case 'azul':
            $(".circle_selecionada").css('background','radial-gradient(circle at 13px 14px, #00a1ff, #676767)');
            break;
        case 'vermelho':
            $(".circle_selecionada").css('background','radial-gradient(circle at 13px 14px, #ff0000, #676767)');
            break;
        default:
            $(".circle_selecionada").css('background','radial-gradient(circle at 13px 14px, #1BFF00, #676767)');
    }
});

(function() {
   // your page initialization code here
   // the DOM will be available here
   var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>',
    array('controller' => 'Users', 'action' => 'login'), array('class' => 'btn btn-default ', 'escape' => false))?> ';

   var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';
   var link3 =' <?=$this->Html->link('Triagens', ['controller' => 'Screenings', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= link3;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Novo</a>';
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();

var glasgow = {
    'nao_abre_os_olhos':1,
    'abre_os_olhos_a_dor':2,
    'abre_os_olhos_a_resposta':3,
    'abre_os_olhos_espontaneamente':4,
    'sem_resposta':1,
    'emite_sons':2,
    'pronuncia_palavras':3,
    'confuso_desorientado':4,
    'orientado':5,
    'nao_se_movimenta':1,
    'extensao_a_estimulos':2,
    'flexao_ao_estimulo':3,
    'retirada_ao_estimulo':4,
    'localiza_a_dor':5,
    'movimentacao_espontanea':6
};

// function calculateGlasgow () {
//     var total = 0;
//     $(".selected").each(function (elem) {
//         var param = elem. 
//         total += elem
//     });
// }

function selectGlasgow(type, elem,  param, val) {
    console.log("param = " + param);
    console.log('type = '+type);
    console.log($(elem).html());


    if (type == 'ocular') {
       ocular = glasgow[param];
       console.log("entro no ocular");
       $("#tr-ocular td").removeClass("selected");
       // $("#tr-ocular td").css("color", "#000");
       // $("#tr-ocular td").css("background-color", "");

       $("#glasgow-ocular").val($(elem).html());
    } 
    else if (type == 'verbal') {
      verbal = glasgow[param];
      $("#tr-verbal td").removeClass("selected");
      // $("#tr-verbal td").css("color", "#000");
      // $("#tr-verbal td").css("background-color", "");

      $("#glasgow-verbal").val($(elem).html());

    } 
    else if (type == 'motora') {
      motora = glasgow[param];
      $("#tr-motora td").removeClass("selected");
      // $("#tr-motora td").css("color", "#000");
      // $("#tr-motora td").css("background-color", "");

      $("#glasgow-motora").val($(elem).html());
    }
    console.log(glasgow[param]);
    
    $("#glasgow-pontuation").text("Pontuação glasgow: "+ (ocular + verbal + motora));
    // $(elem).css( "background-color", "#4A4A4A;" );
    // $(elem).css( "color", "#FFF;" );
    $(elem).addClass("selected");
}

function addClassificacao(param, yo) {
    if (!yo) {
        return;    
    }
    
    console.log("addClassificacao");
    $("#classificacao-sugerida").text("Classificação sugerida: "+param);

    switch(param) {
        case 'Amarelo':
            $(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #fff700, #676767)');
            break;
        case 'Azul':
            $(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #00a1ff, #676767)');
            break;
        case 'Vermelho':
            $(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #ff0000, #676767)');
            break;
        default:
            $(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #1BFF00, #676767)');
    }
}

$("#sel").change(function() {
       if (this.checked ) {
        $(".alterar-sel").show();
    }
    else {
        $(".alterar-sel").hide();
    }
});

</script>