<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * BarthelIndexes Controller
 *
 * @property \App\Model\Table\BarthelIndexesTable $BarthelIndexes
 */
class BarthelIndexesController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Barthel');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'ApacheIiScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index($barthel_id = null)
    {
        $hospitalizations_id = $this->request->session()->read('selected-hospitalization');

        $this->paginate = [
            //'contain'    => ['Barthels'],
            'conditions' => ['BarthelIndexes.barthel_id =' => $barthel_id],
        ];
        $barthelIndexes = $this->paginate($this->BarthelIndexes);

        $this->set(compact('barthelIndexes'));
        $this->set('_serialize', ['barthelIndexes']);
    }

    /**
     * View method
     *
     * @param string|null $id Barthel Index id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $barthelIndex = $this->BarthelIndexes->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('barthelIndex', $barthelIndex);
        $this->set('_serialize', ['barthelIndex']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        //$barthel_table = TableRegistry::get('Barthels');

        // if ($barthel_id == null) {
        //     $barthel = $barthel_table->newEntity();
        //     $barthel_table->save($barthel);
        // }

        $barthelIndex = $this->BarthelIndexes->newEntity();

        if ($this->request->is('post')) {

            $barthelIndex = $this->BarthelIndexes->patchEntity($barthelIndex, $this->request->data);

            if ($this->BarthelIndexes->save($barthelIndex)) {
                $this->Flash->success(__('The barthel index has been saved.'));
                //return $this->redirect(['action' => 'index']);
                return $this->redirect(['controller' => 'StrengthAssessmentScales', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The barthel index could not be saved. Please, try again.'));
            }
        }
        //$hospitalizations = $this->BarthelIndexes->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('barthelIndex'));
        $this->set('_serialize', ['barthelIndex']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Barthel Index id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $barthelIndex = $this->BarthelIndexes->get($id, [
            'contain' => [],
        ]);

        if ($barthelIndex['total_pontos_admissao'] != 0) {
            $tipo = "Admissão";
        } else if ($barthelIndex['total_pontos_exturbacao'] != 0) {
            $tipo = "24h após a extubação";
        } else {
            $tipo = "Alta";
        }

        if ($this->request->is(['patch', 'post', 'put'])) {
            $barthelIndex = $this->BarthelIndexes->patchEntity($barthelIndex, $this->request->data);
            if ($this->BarthelIndexes->save($barthelIndex)) {
                $this->Flash->success(__('The barthel index has been saved.'));
                return $this->redirect(['controller' => 'strength-assessment-scales', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The barthel index could not be saved. Please, try again.'));
            }
        }
        //$hospitalizations = $this->BarthelIndexes->Hospitalizations->find('list', ['limit' => 200]);
        $this->set("tipo", $tipo);
        $this->set(compact('barthelIndex'));
        $this->set('_serialize', ['barthelIndex']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Barthel Index id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $barthelIndex = $this->BarthelIndexes->get($id);
        if ($this->BarthelIndexes->delete($barthelIndex)) {
            $this->Flash->success(__('The barthel index has been deleted.'));
        } else {
            $this->Flash->error(__('The barthel index could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
