<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * PavDiaryChecklists Controller
 *
 * @property \App\Model\Table\PavDiaryChecklistsTable $PavDiaryChecklists
 */
class PavDiaryChecklistsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Bundle Diário');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $bundle_id = $session->read('bundle_id');
        $this->set('bundle_id', $bundle_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'PavPreventionBundles', $action);

        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index($bundle_id)
    {
        $session = $this->request->session();
        $session->write('bundle_id', $bundle_id);

        $this->paginate = [
            'contain' => ['PavPreventionBundles'],
            'conditions' => ['PavDiaryChecklists.pav_prevention_bundle_id' => $bundle_id],
            'order'   => ['PavDiaryChecklists.created' => 'DESC'],
        ];

        $pavDiaryChecklists = $this->paginate($this->PavDiaryChecklists);

        $this->set(compact('pavDiaryChecklists', 'bundle_id'));
        $this->set('_serialize', ['pavDiaryChecklists']);
    }


    /**
     * View method
     *
     * @param string|null $id Pav Diary Checklist id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $pavDiaryChecklist = $this->PavDiaryChecklists->get($id, [
            'contain' => ['PavPreventionBundles'],
        ]);

        $this->set('pavDiaryChecklist', $pavDiaryChecklist);
        $this->set('_serialize', ['pavDiaryChecklist']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add($id)
    {
        $pavDiaryChecklist = $this->PavDiaryChecklists->newEntity();
        if ($this->request->is('post')) {
            $pavDiaryChecklist = $this->PavDiaryChecklists->patchEntity($pavDiaryChecklist, $this->request->data);
            if ($this->PavDiaryChecklists->save($pavDiaryChecklist)) {
                $this->Flash->success(__('The pav diary checklist has been saved.'));
                return $this->redirect(['action' => 'index', $id]);
            } else {
                $this->Flash->error(__('The pav diary checklist could not be saved. Please, try again.'));
            }
        }
        $pavPreventionBundles = $this->PavDiaryChecklists->PavPreventionBundles->find('list', ['limit' => 200]);
        $this->set(compact('pavDiaryChecklist', 'pavPreventionBundles'));
        $this->set('_serialize', ['pavDiaryChecklist']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Pav Diary Checklist id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $pavDiaryChecklist = $this->PavDiaryChecklists->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $pavDiaryChecklist = $this->PavDiaryChecklists->patchEntity($pavDiaryChecklist, $this->request->data);
            if ($this->PavDiaryChecklists->save($pavDiaryChecklist)) {
                $this->Flash->success(__('The pav diary checklist has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The pav diary checklist could not be saved. Please, try again.'));
            }
        }
        $pavPreventionBundles = $this->PavDiaryChecklists->PavPreventionBundles->find('list', ['limit' => 200]);
        $this->set(compact('pavDiaryChecklist', 'pavPreventionBundles'));
        $this->set('_serialize', ['pavDiaryChecklist']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Pav Diary Checklist id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $pavDiaryChecklist = $this->PavDiaryChecklists->get($id);
        if ($this->PavDiaryChecklists->delete($pavDiaryChecklist)) {
            $this->Flash->success(__('The pav diary checklist has been deleted.'));
        } else {
            $this->Flash->error(__('The pav diary checklist could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
