<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * SapsIiiScores Controller
 *
 * @property \App\Model\Table\SapsIiiScoresTable $SapsIiiScores
 */
class SapsIiiScoresController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Escores');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $sapsIiiScores = $this->paginate($this->SapsIiiScores);

        $this->set(compact('sapsIiiScores'));
        $this->set('_serialize', ['sapsIiiScores']);
    }

    /**
     * View method
     *
     * @param string|null $id Saps Iii Score id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $sapsIiiScore = $this->SapsIiiScores->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('sapsIiiScore', $sapsIiiScore);
        $this->set('_serialize', ['sapsIiiScore']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $session            = $this->request->session();
        $patients_table     = TableRegistry::get('Patients');
        $pacient_id         = $session->read('selected-pacient');
        $hospitalization_id = $session->read('selected-hospitalization');

        $patient = $patients_table->get($pacient_id);

        $hospitalizationTable = TableRegistry::get('Hospitalizations');
        $hospitalization      = $hospitalizationTable->get($hospitalization_id)->toArray();

        $sapsIiiScore = $this->SapsIiiScores->newEntity();
        if ($this->request->is('post')) {
            $sapsIiiScore = $this->SapsIiiScores->patchEntity($sapsIiiScore, $this->request->data);
            if ($this->SapsIiiScores->save($sapsIiiScore)) {
                $this->Flash->success(__('The saps iii score has been saved.'));
                return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The saps iii score could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('sapsIiiScore', 'patient', 'hospitalization'));
        $this->set('_serialize', ['sapsIiiScore']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Saps Iii Score id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $session            = $this->request->session();
        $patients_table     = TableRegistry::get('Patients');
        $pacient_id         = $session->read('selected-pacient');
        $hospitalization_id = $session->read('selected-hospitalization');

        $patient = $patients_table->get($pacient_id);

        $hospitalizationTable = TableRegistry::get('Hospitalizations');
        $hospitalization      = $hospitalizationTable->get($hospitalization_id)->toArray();

        $sapsIiiScore = $this->SapsIiiScores->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $sapsIiiScore = $this->SapsIiiScores->patchEntity($sapsIiiScore, $this->request->data);
            if ($this->SapsIiiScores->save($sapsIiiScore)) {
                $this->Flash->success(__('The saps iii score has been saved.'));
                return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The saps iii score could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('sapsIiiScore', 'hospitalization', 'patient'));
        $this->set('_serialize', ['sapsIiiScore']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Saps Iii Score id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $sapsIiiScore = $this->SapsIiiScores->get($id);
        if ($this->SapsIiiScores->delete($sapsIiiScore)) {
            $this->Flash->success(__('The saps iii score has been deleted.'));
        } else {
            $this->Flash->error(__('The saps iii score could not be deleted. Please, try again.'));
        }
        return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
    }

    public function printView($id = null)
    {
        $session            = $this->request->session();
        $patients_table     = TableRegistry::get('Patients');
        $pacient_id         = $session->read('selected-pacient');
        $hospitalization_id = $session->read('selected-hospitalization');

        $patient = $patients_table->get($pacient_id);

        $is_print_view = true;
        $units_table   = TableRegistry::get('Units');
        $unit_id       = $session->read('selected-unit');
        $unit          = $units_table->get($unit_id);

        $hospitalizationTable = TableRegistry::get('Hospitalizations');
        $hospitalization      = $hospitalizationTable->get($hospitalization_id);

        $sapsIiiScore = $this->SapsIiiScores->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put']))
        {
            $sapsIiiScore = $this->SapsIiiScores->patchEntity($sapsIiiScore, $this->request->data);
            if ($this->SapsIiiScores->save($sapsIiiScore))
            {
                $this->Flash->success(__('The saps iii score has been saved.'));
                return $this->redirect(['controller' => 'ApacheIiScores', 'action' => 'index']);
            }
            else
            {
                $this->Flash->error(__('The saps iii score could not be saved. Please, try again.'));
            }
        }
        $this->set(compact('is_print_view','unit','sapsIiiScore', 'hospitalization', 'patient'));
        $this->set('_serialize', ['sapsIiiScore']);
    }
}