<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * IndicatorsSector Entity.
 *
 * @property int $id
 * @property float $taxa_de_ocupacao
 * @property float $indice_de_giro_de_leito
 * @property float $intervalo_de_substituicao
 * @property float $faixa_de_internacao_menor_que_24h
 * @property float $faixa_de_internacao_ate_7_dias
 * @property float $faixa_de_internacao_ate_21_dias
 * @property float $faixa_de_internacao_superior_28_dias
 * @property float $taxa_de_reinternacao
 * @property \Cake\I18n\Time $tempo_medio_decisao_de_alta_e_alta_efetiva
 * @property \Cake\I18n\Time $tempo_medio_permanencia_paciente_em_obito
 * @property int $total_de_pacientes_no_mes
 * @property float $percentual_de_altas
 * @property \Cake\I18n\Time $tempo_de_permanencia_minimo
 * @property \Cake\I18n\Time $tempo_de_permanencia_medio
 * @property \Cake\I18n\Time $tempo_de_permanencia_maximo
 * @property int $sector_id
 * @property \App\Model\Entity\Sector $sector
 */
class IndicatorsSector extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
