<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SepseProtocol Entity.
 *
 * @property int $id
 * @property bool $is_active
 * @property \Cake\I18n\Time $created
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property int $screening_id
 * @property \App\Model\Entity\Screening $screening
 * @property bool $hipotensao
 * @property bool $taquipneia
 * @property bool $alteracao_estado_mental
 * @property bool $pneumonia
 * @property bool $infeccao_urinaria
 * @property bool $infeccao_abdominal
 * @property bool $meningite
 * @property bool $endocardite
 * @property bool $pele_partes_moles
 * @property bool $infeccao_protese
 * @property bool $infeccao_ossea
 * @property bool $infeccao_ferida_operatoria
 * @property bool $infeccao_corrente_sanguinea
 * @property string $outras_infeccoes
 * @property bool $sem_foco_definido
 * @property bool $infeccao_nao_complicada
 * @property bool $sepse
 * @property bool $choque_septico
 * @property bool $afastado_sepse
 * @property bool $sepse_choque_septico
 * @property bool $coletar_exame
 * @property \Cake\I18n\Time $coletar_exame_data
 * @property \Cake\I18n\Time $coletar_exame_hora
 * @property bool $preservar_antibio
 * @property \Cake\I18n\Time $preservar_antibio_hora
 * @property \Cake\I18n\Time $preservar_anti_data
 * @property bool $encerrar_atendimento
 * @property \Cake\I18n\Time $encerrar_atendimento_data
 * @property \Cake\I18n\Time $encerrar_atendimento_hora
 * @property bool $paciente_nao_tem_disfuncao
 * @property bool $pas_menor_que_90
 * @property bool $relacao_pao
 * @property bool $rebaixamento_do_nivel
 * @property bool $creatina
 * @property bool $bilirrubina
 * @property bool $contagem_de_plaquetas
 * @property bool $lactato_acima_do_valor
 * @property bool $coagulopatia
 * @property \Cake\I18n\Time $data_primeira_disfuncao
 * @property \Cake\I18n\Time $hora_primeira_disfuncao
 * @property string $caso_confirmado_como
 * @property \Cake\I18n\Time $destino_data
 * @property \Cake\I18n\Time $destino_hora
 * @property bool $destino_liberacao_para_tratamento
 * @property bool $destino_internacao
 * @property \Cake\I18n\Time $reconhecimento_sepse_hora
 * @property \Cake\I18n\Time $reconhecimento_sepse_data
 * @property \Cake\I18n\Time $antibioticoterapia_hora
 * @property \Cake\I18n\Time $antibioticoterapia_data
 * @property string $classificacao
 * @property string $delta_de_cultura
 * @property string $pontuacao_sofa_d1_score
 * @property string $pontuacao_maxima_sofa
 * @property string $desfecho
 * @property \Cake\I18n\Time $hemocultura_data
 * @property \Cake\I18n\Time $hemocultura_hora
 * @property \Cake\I18n\Time $qsofa_data
 * @property \Cake\I18n\Time $qsofa_hora
 * @property string $lactato
 * @property \Cake\I18n\Time $lactato_hora
 * @property string $delta_de_antibiotico
 * @property string $taxa_clareamento_lactato
 * @property int $sofa_escore_id
 */
class SepseProtocol extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
