<?php
namespace App\Model\Table;

use App\Model\Entity\DailyBundle;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * DailyBundles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Bundles
 */
class DailyBundlesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('daily_bundles');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Bundles', [
            'foreignKey' => 'bundle_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('higienizacao_diaria_com_solucao_dergermante_da_genitalia')
            ->allowEmpty('higienizacao_diaria_com_solucao_dergermante_da_genitalia');

        $validator
            ->boolean('manter_bolsa_coletora_abaixo_do_nivel_da_bexiga')
            ->allowEmpty('manter_bolsa_coletora_abaixo_do_nivel_da_bexiga');

        $validator
            ->boolean('manter_bolsa_coletora_com_capacidade_maxima_de_2_3')
            ->allowEmpty('manter_bolsa_coletora_com_capacidade_maxima_de_2_3');

        $validator
            ->boolean('fixacao_do_cateter_seguro_para_evitar_qualquer_movimento')
            ->allowEmpty('fixacao_do_cateter_seguro_para_evitar_qualquer_movimento');

        $validator
            ->boolean('revisao_diaria_da_indicacao_de_permanencia_do_cateter')
            ->allowEmpty('revisao_diaria_da_indicacao_de_permanencia_do_cateter');

        $validator
            ->boolean('sinal_de_uretrite')
            ->allowEmpty('sinal_de_uretrite');

        $validator
            ->boolean('transporte_realizado_com_clampeamento_do_sistema_coletor')
            ->allowEmpty('transporte_realizado_com_clampeamento_do_sistema_coletor');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after)
    {
        $calc_obj = new MedidasDispersao();
        $data =
            [
            'periodos' => [],
            'total_de_registros' => 0,
            //Julio
            'total_de_bundles_nao_preenchido' => 0,
            //Julio
            'total_de_dias_no_periodo_ate_hoje' => 0,

            'total_dias_no_periodo' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / DIAS NO PERÍODO
            'tot_bundles_por_dias' => 0,
            'percen_bundles_por_dias' => 0,

            //total de procedimentos do tipo cateter vesical cadastrados
            'tot_dispositivos_inseridos' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / TOTAL DE PACIENTES COM INSTALAÇÃO DE DISPOSITIVO
            'percen_bundles_por_procedimentos' => 0,
            'tot_bundles_por_procedimentos' => 0,

            //TOTAL DE TOTOS OS DIAS SOMADOS POR TODOS OS PACIENTES COM ESTE DISPOSITIVO INSTALADO NO PERÍODO
            'tot_tempo_uso_do_bundle' => 0,
            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / TOTAL DE PACIENTES-DIA
            'tot_bundles_por_tempo_de_uso' => 0,
            'percen_bundles_por_tempo_de_uso' => 0,

            //Julio
            //VALOR TOTAL DE BUNDLES DIÁRIOS NÂO PREENCHIDOS / DIAS NO PERÍODO
            'percen_bundles_por_dias_nao_preenchido' => 0,
            'tot_bundles_por_dias_nao_preenchido' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS NÃo PREENCHIDOS / TOTAL DE PACIENTES COM INSTALAÇÃO DE DISPOSITIVO
            'percen_bundles_por_procedimentos_nao_preenchido' => 0,
            'tot_bundles_por_procedimentos_nao_preenchido' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS NÃO PREENCHIDOS / TOTAL DE PACIENTES-DIA
            'tot_bundles_por_tempo_de_uso_nao_preenchido' => 0,
            'percen_bundles_por_tempo_de_uso_nao_preenchido' => 0,
        ];

        $data['total_dias_no_periodo'] = $date_before->diff($date_after)->days;

        $columns = $this->schema()->columns();
        foreach ($columns as $key => $column) 
        {
            $data[$column]['total'] = 0;
            $data[$column]['percentual'] = 0;
            $data[$column]['media'] = 0;
            $data[$column]['mediana'] = 0;
            $data[$column]['desvio_padrao'] = 0;
            $data[$column]['soma'] = 0;
        }

        foreach ($hospitalizations as $hospitalization)
        {
            if (isset($hospitalization["supportive_measures"]))
            {
                foreach ($hospitalization["supportive_measures"] as $key_1 => $supportive_measure)
                {
                    if ($supportive_measure['data_inicio'] >= $date_before &&
                        $supportive_measure['data_termino'] <= $date_after
                    )
                    {
                        $itens = ['Cateter venoso central curta permanência', 'Cateter venoso central de inserção periférica', 'Cateter venoso central longa permanência', 'Cateter venoso central por dissecção venosa', 'Cateter de artéria pulmonar', 'Cateter de átrio esquerdo', 'Cateter umbilical', 'Cateter venoso periférico', 'Cateter arterial', 'Cateter venoso para diálise', 'Marcapasso transvenoso', 'Balão intra-aórtico '];

                        foreach ($itens as $item)
                        {
                            if (stripos($supportive_measure['type'], $item) !== false)
                            {
                                $data['tot_dispositivos_inseridos']++;

                                // if (in_array($hospitalization->id, $data['arr_internacao_procedimento_vesical']) == false)
                                // {
                                //     array_push($data['arr_internacao_procedimento_vesical'], $hospitalization->id);
                                //     $data['tot_internacao_procedimento_vesical']++;
                                // }
                                break;
                            }
                        }
                    }
                }
            }
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization['bundles'] as $key_1 => $bundle)
            {
                //deve ser criado um campo de data no bundle diario para ser usada no lugar do bundle principal
                if ($bundle['date_instalation'] >= $date_before &&
                    $bundle['date_instalation'] <= $date_after)
                {
                    foreach ($bundle["daily_bundles"] as $daily_bundle)
                    {
                        $bundle_arr = (array) $daily_bundle;
                        $i = 0;

                        $data['total_de_registros']++;

                        foreach ($bundle_arr as $key_2 => $value_2)
                        {
                            $i++;
                            if ($i == 2) //acessa as propriades do obj
                            {
                                foreach ($value_2 as $key_3 => $value_3)
                                {
                                    formatArr($value_3, $data, $key_3);
                                }
                            }
                        }
                    }

                    if (isset($bundle['date_instalation']) && isset($bundle['date_of_withdrawal']))
                    {
                        $bundle_period = null;
                        $now = new \Datetime();

                        if ($bundle['date_of_withdrawal'] > $now)
                        {
                            $bundle['date_of_withdrawal'] = $now;
                        }

                        if ($bundle['date_instalation'] < $date_before)
                        {
                            $bundle['date_instalation'] = $date_before;
                        }

                        $bundle_period = $bundle['date_instalation']->diff($bundle['date_of_withdrawal'])->days;

                        $periodo = [
                            'date_instalation' => $bundle['date_instalation']->format('Y-m-d'),
                            'date_of_withdrawal' => $bundle['date_of_withdrawal']->format('Y-m-d'),
                            'now' => $now->format('Y-m-d'),
                        ];

                        array_push($data['periodos'], $periodo);
                        $data['total_de_dias_no_periodo_ate_hoje'] += $bundle_period;
                    }

                    if (isset($bundle['date_instalation']) &&
                        isset($bundle['date_of_withdrawal']))
                    {
                        $data['tot_tempo_uso_do_bundle'] += $bundle['date_instalation']->diff($bundle['date_of_withdrawal'])->d;
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            if (isset($data[$key]['percentual']) && isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                //if (isset($data[$key]['percentual']))
                //{
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
                //}

                //calcula o total
                /*if (count($data[$key]['arr']) > 0)
            {
            foreach ($data[$key]['arr'] as $attr)
            {
            if (is_numeric($attr))
            {
            $data[$key]['soma'] += $attr;
            }
            }
            }*/
            }
        }

        if ($data['total_de_registros'] > 0 &&
            $data['total_dias_no_periodo'] > 0
        )
        {
            $data['percen_bundles_por_dias'] = ($data['total_de_registros'] * 100) / $data['total_dias_no_periodo'];
            $data['percen_bundles_por_dias'] = round($data['percen_bundles_por_dias'], 2);

            $data['tot_bundles_por_dias'] = $data['total_de_registros'] / $data['total_dias_no_periodo'];
            $data['tot_bundles_por_dias'] = round($data['tot_bundles_por_dias'], 2);
        }

        //calc
        if ($data['total_de_registros'] > 0 &&
            $data['tot_dispositivos_inseridos'] > 0
        )
        {
            $data['percen_bundles_por_procedimentos'] = ($data['total_de_registros'] * 100) / $data['tot_dispositivos_inseridos'];
            $data['percen_bundles_por_procedimentos'] = round($data['percen_bundles_por_procedimentos'], 2);

            $data['tot_bundles_por_procedimentos'] = $data['total_de_registros']  / $data['tot_dispositivos_inseridos'];
            $data['tot_bundles_por_procedimentos'] = round($data['tot_bundles_por_procedimentos'], 2);
        }

        //calc
        if ($data['total_de_registros'] > 0 &&
            $data['tot_tempo_uso_do_bundle'] > 0
        )
        {
            $data['percen_bundles_por_tempo_de_uso'] = ($data['total_de_registros'] * 100) / $data['tot_tempo_uso_do_bundle'];
            $data['percen_bundles_por_tempo_de_uso'] = round($data['percen_bundles_por_tempo_de_uso'], 2);

            $data['tot_bundles_por_tempo_de_uso'] = $data['total_de_registros']  / $data['tot_tempo_uso_do_bundle'];
            $data['tot_bundles_por_tempo_de_uso'] = round($data['tot_bundles_por_tempo_de_uso'], 2);
        }

        //Julio
        if ($data['total_de_registros'] > 0 &&
            $data['total_de_dias_no_periodo_ate_hoje'] > 0
        )
        {
            $data['total_de_bundles_nao_preenchido'] = $data['total_de_dias_no_periodo_ate_hoje'] - $data['total_de_registros'];
            
            if ($data['total_de_bundles_nao_preenchido'] < 0)
            {
                $data['total_de_bundles_nao_preenchido'] = 0;
            }
        }

        if ($data['total_de_bundles_nao_preenchido'] > 0 &&
            $data['total_dias_no_periodo'] > 0
        )
        {
            $data['percen_bundles_por_dias_nao_preenchido'] = ($data['total_de_bundles_nao_preenchido'] * 100) / $data['total_dias_no_periodo'];
            $data['percen_bundles_por_dias_nao_preenchido'] = round($data['percen_bundles_por_dias_nao_preenchido'], 2);

            $data['tot_bundles_por_dias_nao_preenchido'] = $data['total_de_bundles_nao_preenchido']  / $data['total_dias_no_periodo'];
            $data['tot_bundles_por_dias_nao_preenchido'] = round($data['tot_bundles_por_dias_nao_preenchido'], 2);        
        }

        if ($data['total_de_bundles_nao_preenchido'] > 0 &&
            $data['tot_dispositivos_inseridos'] > 0
        )
        {
            $data['percen_bundles_por_procedimentos_nao_preenchido'] = ($data['total_de_bundles_nao_preenchido'] * 100) / $data['tot_dispositivos_inseridos'];
            $data['percen_bundles_por_procedimentos_nao_preenchido'] = round($data['percen_bundles_por_procedimentos_nao_preenchido'], 2);

            $data['tot_bundles_por_procedimentos_nao_preenchido'] = $data['total_de_bundles_nao_preenchido'] / $data['tot_dispositivos_inseridos'];
            $data['tot_bundles_por_procedimentos_nao_preenchido'] = round($data['tot_bundles_por_procedimentos_nao_preenchido'], 2);
        }

        if ($data['total_de_bundles_nao_preenchido'] > 0 &&
            $data['tot_tempo_uso_do_bundle'] > 0
        )
        {
            $data['tot_bundles_por_tempo_de_uso_nao_preenchido'] = $data['total_de_bundles_nao_preenchido']  / $data['tot_tempo_uso_do_bundle'];
            $data['tot_bundles_por_tempo_de_uso_nao_preenchido'] = round($data['tot_bundles_por_tempo_de_uso_nao_preenchido'], 2);

            $data['percen_bundles_por_tempo_de_uso_nao_preenchido'] = ($data['total_de_bundles_nao_preenchido'] * 100) / $data['tot_tempo_uso_do_bundle'];
            $data['percen_bundles_por_tempo_de_uso_nao_preenchido'] = round($data['percen_bundles_por_tempo_de_uso_nao_preenchido'], 2);

            
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['bundle_id'], 'Bundles'));
        return $rules;
    }
}
