<?php
namespace App\Model\Table;

use App\Model\Entity\FugulinBradenScale;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * FugulinBradenScales Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class FugulinBradenScalesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('fugulin_braden_scales');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);

        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('estado_mental');

        $validator
            ->allowEmpty('oxigenacao');

        $validator
            ->allowEmpty('sinais_vitais');

        $validator
            ->allowEmpty('deambulacao');

        $validator
            ->allowEmpty('mobilidade');

        $validator
        //->boolean('alimentacao')
        ->allowEmpty('alimentacao');

        $validator
            ->allowEmpty('fugulin_score');

        $validator
            ->allowEmpty('braden_score');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after)
    {
        $calc_obj = new MedidasDispersao();

        $data = [
            'tot_de_pacientes' => 0,

            'arr_de_pacientes_fugulin_intensivo' => [],
            'tot_de_pacientes_fugulin_intensivo' => 0, //fugulin > 31
            'percen_de_pacientes_fugulin_intensivo' => 0,

            'arr_de_pacientes_fugulin_semi_intensivo' => [],
            'tot_de_pacientes_fugulin_semi_intensivo' => 0, //fugulin 27 a 31
            'percen_de_pacientes_fugulin_semi_intensivo' => 0,

            'arr_de_pacientes_fugulin_21_a_26' => [],
            'tot_de_pacientes_fugulin_21_a_26' => 0,
            'percen_de_pacientes_fugulin_21_a_26' => 0,

            'arr_de_pacientes_fugulin_15_a_20' => [],
            'tot_de_pacientes_fugulin_15_a_20' => 0,
            'percen_de_pacientes_fugulin_15_a_20' => 0,

            'arr_de_pacientes_fugulin_9_a_11' => [],
            'tot_de_pacientes_fugulin_9_a_11' => 0,
            'percen_de_pacientes_fugulin_9_a_11' => 0,

            'setores_uti' => [
                'tot_de_pacientes' => 0,

                'arr_de_pacientes_fugulin_intensivo' => [],
                'tot_de_pacientes_fugulin_intensivo' => 0, //fugulin > 31
                'percen_de_pacientes_fugulin_intensivo' => 0,

                'arr_de_pacientes_fugulin_semi_intensivo' => [],
                'tot_de_pacientes_fugulin_semi_intensivo' => 0, //fugulin 27 a 31
                'percen_de_pacientes_fugulin_semi_intensivo' => 0,

                'arr_de_pacientes_fugulin_21_a_26' => [],
                'tot_de_pacientes_fugulin_21_a_26' => 0,
                'percen_de_pacientes_fugulin_21_a_26' => 0,

                'arr_de_pacientes_fugulin_15_a_20' => [],
                'tot_de_pacientes_fugulin_15_a_20' => 0,
                'percen_de_pacientes_fugulin_15_a_20' => 0,

                'arr_de_pacientes_fugulin_9_a_11' => [],
                'tot_de_pacientes_fugulin_9_a_11' => 0,
                'percen_de_pacientes_fugulin_9_a_11' => 0,
            ],

            'setores_uti_alta' => [
                'tot_de_pacientes' => 0,

                'arr_de_pacientes_fugulin_intensivo' => [],
                'tot_de_pacientes_fugulin_intensivo' => 0, //fugulin > 31
                'percen_de_pacientes_fugulin_intensivo' => 0,

                'arr_de_pacientes_fugulin_semi_intensivo' => [],
                'tot_de_pacientes_fugulin_semi_intensivo' => 0, //fugulin 27 a 31
                'percen_de_pacientes_fugulin_semi_intensivo' => 0,

                'arr_de_pacientes_fugulin_21_a_26' => [],
                'tot_de_pacientes_fugulin_21_a_26' => 0,
                'percen_de_pacientes_fugulin_21_a_26' => 0,

                'arr_de_pacientes_fugulin_15_a_20' => [],
                'tot_de_pacientes_fugulin_15_a_20' => 0,
                'percen_de_pacientes_fugulin_15_a_20' => 0,

                'arr_de_pacientes_fugulin_9_a_11' => [],
                'tot_de_pacientes_fugulin_9_a_11' => 0,
                'percen_de_pacientes_fugulin_9_a_11' => 0,
            ],

            'setores_uti_reinternacao' => [
                'tot_de_pacientes' => 0,

                'arr_de_pacientes_fugulin_intensivo' => [],
                'tot_de_pacientes_fugulin_intensivo' => 0, //fugulin > 31
                'percen_de_pacientes_fugulin_intensivo' => 0,

                'arr_de_pacientes_fugulin_semi_intensivo' => [],
                'tot_de_pacientes_fugulin_semi_intensivo' => 0, //fugulin 27 a 31
                'percen_de_pacientes_fugulin_semi_intensivo' => 0,

                'arr_de_pacientes_fugulin_21_a_26' => [],
                'tot_de_pacientes_fugulin_21_a_26' => 0,
                'percen_de_pacientes_fugulin_21_a_26' => 0,

                'arr_de_pacientes_fugulin_15_a_20' => [],
                'tot_de_pacientes_fugulin_15_a_20' => 0,
                'percen_de_pacientes_fugulin_15_a_20' => 0,

                'arr_de_pacientes_fugulin_9_a_11' => [],
                'tot_de_pacientes_fugulin_9_a_11' => 0,
                'percen_de_pacientes_fugulin_9_a_11' => 0,
            ],

            'setores_ui' => [
                'tot_de_pacientes' => 0,
                'arr_de_pacientes_fugulin_intensivo' => [],
                'tot_de_pacientes_fugulin_intensivo' => 0, //fugulin > 31
                'percen_de_pacientes_fugulin_intensivo' => 0,

                'arr_de_pacientes_fugulin_semi_intensivo' => [],
                'tot_de_pacientes_fugulin_semi_intensivo' => 0, //fugulin 27 a 31
                'percen_de_pacientes_fugulin_semi_intensivo' => 0,

                'arr_de_pacientes_fugulin_21_a_26' => [],
                'tot_de_pacientes_fugulin_21_a_26' => 0,
                'percen_de_pacientes_fugulin_21_a_26' => 0,

                'arr_de_pacientes_fugulin_15_a_20' => [],
                'tot_de_pacientes_fugulin_15_a_20' => 0,
                'percen_de_pacientes_fugulin_15_a_20' => 0,

                'arr_de_pacientes_fugulin_9_a_11' => [],
                'tot_de_pacientes_fugulin_9_a_11' => 0,
                'percen_de_pacientes_fugulin_9_a_11' => 0,
            ],
        ];
        $arr_id_uti = [12, 13, 14];
        $arr_id_ui = [];

        foreach ($hospitalizations as $hospitalization)
        {
            $status_internacao = null;
            $reinternacao = false;

            if ($hospitalization['rehospitalization_up_24'] || $hospitalization['readmission_to_hospital_until_30_days'])
            {
                $reinternacao = true;
            }

            if ($hospitalization['status'] == 'alta')
            {
                $status_internacao = 'alta';
            }

            $data['tot_de_pacientes']++;

            if (count($hospitalization["fugulin_braden_scales"]) == 0)
            {
                $columns = $this->schema()->columns();
                foreach ($columns as $key => $column)
                {
                    $data[$column]['total'] = 0;
                    $data[$column]['percentual'] = 0;
                    $data[$column]['media'] = 0;
                    $data[$column]['mediana'] = 0;
                    $data[$column]['desvio_padrao'] = 0;
                    $data[$column]['soma'] = 0;
                }
            }

            foreach ($hospitalization["fugulin_braden_scales"] as $fugulin)
            {
                $tipo_de_setor = null;
                if ($fugulin['sector']['type'])
                {
                    if (in_array($fugulin['sector']['type'], $arr_id_uti))
                    {
                        $tipo_de_setor = 'setores_uti';

                        if (in_array($fugulin['hospitalization_id'], $data[$tipo_de_setor]['tot_de_pacientes']) == false)
                        {
                            array_push($data[$tipo_de_setor]['tot_de_pacientes'], $fugulin['hospitalization_id']);
                        }
                    }
                }

                if ($fugulin['fugulin_score'] > 31)
                {
                    if (in_array($fugulin['hospitalization_id'], $data['arr_de_pacientes_fugulin_intensivo']) == false)
                    {
                        array_push($data['arr_de_pacientes_fugulin_intensivo'], $fugulin['hospitalization_id']);

                        if ($tipo_de_setor)
                        {
                            $data[$tipo_de_setor]['tot_de_pacientes_fugulin_intensivo']++;

                            if ($status_internacao)
                            {
                                $data[$tipo_de_setor . '_alta']['tot_de_pacientes_fugulin_intensivo']++;
                            }

                            if ($reinternacao)
                            {
                                $data[$tipo_de_setor . '_reinternacao']['tot_de_pacientes_fugulin_intensivo']++;
                            }
                        }
                    }
                }
                else if ($fugulin['fugulin_score'] >= 27 && $fugulin['fugulin_score'] <= 31)
                {
                    if (in_array($fugulin['hospitalization_id'], $data['arr_de_pacientes_fugulin_semi_intensivo']) == false)
                    {
                        array_push($data['arr_de_pacientes_fugulin_semi_intensivo'], $fugulin['hospitalization_id']);
                        $data['tot_de_pacientes_fugulin_semi_intensivo']++;

                        if ($tipo_de_setor)
                        {
                            $data[$tipo_de_setor]['tot_de_pacientes_fugulin_semi_intensivo']++;

                            if ($status_internacao)
                            {
                                $data[$tipo_de_setor . '_alta']['tot_de_pacientes_fugulin_semi_intensivo']++;
                            }

                            if ($reinternacao)
                            {
                                $data[$tipo_de_setor . '_reinternacao']['tot_de_pacientes_fugulin_semi_intensivo']++;
                            }
                        }
                    }
                }
                else if ($fugulin['fugulin_score'] >= 21 && $fugulin['fugulin_score'] <= 26)
                {
                    if (in_array($fugulin['hospitalization_id'], $data['arr_de_pacientes_fugulin_21_a_26']) == false)
                    {
                        array_push($data['arr_de_pacientes_fugulin_21_a_26'], $fugulin['hospitalization_id']);
                        $data['tot_de_pacientes_fugulin_21_a_26']++;

                        if ($tipo_de_setor)
                        {
                            $data[$tipo_de_setor]['tot_de_pacientes_fugulin_21_a_26']++;
                            if ($status_internacao)
                            {
                                $data[$tipo_de_setor . '_alta']['tot_de_pacientes_fugulin_21_a_26']++;
                            }

                            if ($reinternacao)
                            {
                                $data[$tipo_de_setor . '_reinternacao']['tot_de_pacientes_fugulin_21_a_26']++;
                            }
                        }
                    }
                }
                else if ($fugulin['fugulin_score'] >= 15 && $fugulin['fugulin_score'] <= 20)
                {
                    if (in_array($fugulin['hospitalization_id'], $data['arr_de_pacientes_fugulin_15_a_20']) == false)
                    {
                        array_push($data['arr_de_pacientes_fugulin_15_a_20'], $fugulin['hospitalization_id']);
                        $data['tot_de_pacientes_fugulin_15_a_20']++;

                        if ($tipo_de_setor)
                        {
                            $data[$tipo_de_setor]['tot_de_pacientes_fugulin_15_a_20']++;

                            if ($status_internacao)
                            {
                                $data[$tipo_de_setor . '_alta']['tot_de_pacientes_fugulin_15_a_20']++;
                            }

                            if ($reinternacao)
                            {
                                $data[$tipo_de_setor . '_reinternacao']['tot_de_pacientes_fugulin_15_a_20']++;
                            }
                        }
                    }
                }
                else if ($fugulin['fugulin_score'] >= 9 && $fugulin['fugulin_score'] <= 11)
                {
                    if (in_array($fugulin['hospitalization_id'], $data['arr_de_pacientes_fugulin_9_a_11']) == false)
                    {
                        array_push($data['arr_de_pacientes_fugulin_9_a_11'], $fugulin['hospitalization_id']);
                        $data['tot_de_pacientes_fugulin_9_a_11']++;

                        if ($tipo_de_setor)
                        {
                            $data[$tipo_de_setor]['tot_de_pacientes_fugulin_9_a_11']++;

                            if ($status_internacao)
                            {
                                $data[$tipo_de_setor . '_alta']['tot_de_pacientes_fugulin_9_a_11']++;
                            }

                            if ($reinternacao)
                            {
                                $data[$tipo_de_setor . '_reinternacao']['tot_de_pacientes_fugulin_9_a_11']++;
                            }
                        }
                    }
                }
            }
        }

        if ($data['tot_de_pacientes_fugulin_intensivo'] > 0)
        {
            $data['percen_de_pacientes_fugulin_intensivo'] = ($data['tot_de_pacientes_fugulin_intensivo'] * 100) / $data['tot_de_pacientes'];
            $data['percen_de_pacientes_fugulin_intensivo'] = round($data['percen_de_pacientes_fugulin_intensivo'], 2);
        }

        if ($data['tot_de_pacientes_fugulin_semi_intensivo'] > 0)
        {
            $data['percen_de_pacientes_fugulin_semi_intensivo'] = ($data['tot_de_pacientes_fugulin_semi_intensivo'] * 100) / $data['tot_de_pacientes'];
            $data['percen_de_pacientes_fugulin_semi_intensivo'] = round($data['percen_de_pacientes_fugulin_semi_intensivo'], 2);
        }

        if ($data['tot_de_pacientes_fugulin_21_a_26'] > 0)
        {
            $data['percen_de_pacientes_fugulin_21_a_26'] = ($data['tot_de_pacientes_fugulin_21_a_26'] * 100) / $data['tot_de_pacientes'];
            $data['percen_de_pacientes_fugulin_21_a_26'] = round($data['percen_de_pacientes_fugulin_21_a_26'], 2);
        }

        if ($data['tot_de_pacientes_fugulin_15_a_20'] > 0)
        {
            $data['percen_de_pacientes_fugulin_15_a_20'] = ($data['tot_de_pacientes_fugulin_15_a_20'] * 100) / $data['tot_de_pacientes'];
            $data['percen_de_pacientes_fugulin_15_a_20'] = round($data['percen_de_pacientes_fugulin_15_a_20'], 2);
        }

        if ($data['tot_de_pacientes_fugulin_9_a_11'] > 0)
        {
            $data['percen_de_pacientes_fugulin_9_a_11'] = ($data['tot_de_pacientes_fugulin_9_a_11'] * 100) / $data[$tipo_setor]['tot_de_pacientes'];
            $data['percen_de_pacientes_fugulin_9_a_11'] = round($data['percen_de_pacientes_fugulin_9_a_11'], 2);
        }

        foreach (['setores_ui', 'setores_uti', 'setores_uti_alta', 'setores_uti_reinternacao'] as $key => $tipo_setor)
        {
            if ($data[$tipo_setor]['tot_de_pacientes_fugulin_intensivo'] > 0)
            {
                $data[$tipo_setor]['percen_de_pacientes_fugulin_intensivo'] = ($data[$tipo_setor]['tot_de_pacientes_fugulin_intensivo'] * 100) / $data[$tipo_setor]['tot_de_pacientes'];
                $data[$tipo_setor]['percen_de_pacientes_fugulin_intensivo'] = round($data[$tipo_setor]['percen_de_pacientes_fugulin_intensivo'], 2);
            }

            if ($data[$tipo_setor]['tot_de_pacientes_fugulin_semi_intensivo'] > 0)
            {
                $data[$tipo_setor]['percen_de_pacientes_fugulin_semi_intensivo'] = ($data[$tipo_setor]['tot_de_pacientes_fugulin_semi_intensivo'] * 100) / $data[$tipo_setor]['tot_de_pacientes'];
                $data[$tipo_setor]['percen_de_pacientes_fugulin_semi_intensivo'] = round($data[$tipo_setor]['percen_de_pacientes_fugulin_semi_intensivo'], 2);
            }

            if ($data[$tipo_setor]['tot_de_pacientes_fugulin_21_a_26'] > 0)
            {
                $data[$tipo_setor]['percen_de_pacientes_fugulin_21_a_26'] = ($data[$tipo_setor]['tot_de_pacientes_fugulin_21_a_26'] * 100) / $data[$tipo_setor]['tot_de_pacientes'];
                $data[$tipo_setor]['percen_de_pacientes_fugulin_21_a_26'] = round($data[$tipo_setor]['percen_de_pacientes_fugulin_21_a_26'], 2);
            }

            if ($data[$tipo_setor]['tot_de_pacientes_fugulin_15_a_20'] > 0)
            {
                $data[$tipo_setor]['percen_de_pacientes_fugulin_15_a_20'] = ($data[$tipo_setor]['tot_de_pacientes_fugulin_15_a_20'] * 100) / $data[$tipo_setor]['tot_de_pacientes'];
                $data[$tipo_setor]['percen_de_pacientes_fugulin_15_a_20'] = round($data[$tipo_setor]['percen_de_pacientes_fugulin_15_a_20'], 2);
            }

            if ($data[$tipo_setor]['tot_de_pacientes_fugulin_9_a_11'] > 0)
            {
                $data[$tipo_setor]['percen_de_pacientes_fugulin_9_a_11'] = ($data[$tipo_setor]['tot_de_pacientes_fugulin_9_a_11'] * 100) / $data[$tipo_setor]['tot_de_pacientes'];
                $data[$tipo_setor]['percen_de_pacientes_fugulin_9_a_11'] = round($data[$tipo_setor]['percen_de_pacientes_fugulin_9_a_11'], 2);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
