<?php
namespace App\Model\Table;

use App\Model\Entity\IdentificationOfRisk;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * IdentificationOfRisks Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class IdentificationOfRisksTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('identification_of_risks');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);

        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('alergia');

        $validator
            ->boolean('ignorancia')
            ->allowEmpty('ignorancia');

        $validator
            ->boolean('administracao')
            ->allowEmpty('administracao');

        $validator
            ->boolean('reconcializacao')
            ->allowEmpty('reconcializacao');

        $validator
            ->boolean('transporte_inseguro')
            ->allowEmpty('transporte_inseguro');

        $validator
            ->boolean('identificacao_errada_do_paciente')
            ->allowEmpty('identificacao_errada_do_paciente');

        $validator
            ->boolean('controle_inadequado')
            ->allowEmpty('controle_inadequado');

        $validator
            ->boolean('perda_da_passagem')
            ->allowEmpty('perda_da_passagem');

        $validator
            ->boolean('que_do_leito')
            ->allowEmpty('que_do_leito');

        $validator
            ->boolean('turnover')
            ->allowEmpty('turnover');

        $validator
            ->boolean('absenteismo')
            ->allowEmpty('absenteismo');

        $validator
            ->boolean('nao_parametrizacao_da_monitorizacao')
            ->allowEmpty('nao_parametrizacao_da_monitorizacao');

        $validator
            ->boolean('contaminacao_de_culturas')
            ->allowEmpty('contaminacao_de_culturas');

        $validator
            ->boolean('coleta_inadequada_de_culturas')
            ->allowEmpty('coleta_inadequada_de_culturas');

        $validator
            ->boolean('broncoaspiracao')
            ->allowEmpty('broncoaspiracao');

        $validator
            ->boolean('infeccao_de_corrente')
            ->allowEmpty('infeccao_de_corrente');

        $validator
            ->boolean('pneumonia')
            ->allowEmpty('pneumonia');

        $validator
            ->boolean('infeccao_de_trato')
            ->allowEmpty('infeccao_de_trato');

        $validator
            ->boolean('reacao_transfusional')
            ->allowEmpty('reacao_transfusional');

        $validator
            ->boolean('nao_acompanhamento')
            ->allowEmpty('nao_acompanhamento');

        $validator
            ->boolean('reinteracao')
            ->allowEmpty('reinteracao');

        $validator
            ->boolean('extubacao_acidental')
            ->allowEmpty('extubacao_acidental');

        $validator
            ->boolean('feblite')
            ->allowEmpty('feblite');

        $validator
            ->boolean('dor')
            ->allowEmpty('dor');

        $validator
            ->boolean('troca_de_pacientes')
            ->allowEmpty('troca_de_pacientes');

        $validator
            ->boolean('fornecimento_de_medicamentos_incorretos')
            ->allowEmpty('fornecimento_de_medicamentos_incorretos');

        $validator
            ->boolean('nao_administracao_de_dietas')
            ->allowEmpty('nao_administracao_de_dietas');

        $validator
            ->boolean('administracao_inadequada_de_dieta')
            ->allowEmpty('administracao_inadequada_de_dieta');

        $validator
            ->boolean('diarreia')
            ->allowEmpty('diarreia');

        $validator
            ->boolean('nao_fornecimento_de_materiais')
            ->allowEmpty('nao_fornecimento_de_materiais');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after, $sectors)
    {
        $calc_obj = new MedidasDispersao();

        $data = [
            'total_de_registros' => 0,

            'tot_pacientes' => 0,

            'arr_pacientes_com_risco' => [],
            'tot_pacientes_com_risco' => 0,

            'tot_paciente_com_risco' => 0,
            'percen_paciente_com_risco' => 0,

            'tot_risco_por_paciente' => 0,
            'media_risco_por_paciente' => 0,
            'percen_risco_por_paciente' => 0,
            'setores' => [],

            'principais_riscos' => [],
            'principais_riscos_clinico' => [],
            'principais_riscos_cirurgico' => [],

            'riscos' => [
                'impossibilidade_de_reconciliacao' => [
                    'name' => 'Impossibilidade de reconciliação medicamentosa',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_broncoaspiracao' => [
                    'name' => 'Risco de broncoaspiração',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_desnutricao' => [
                    'name' => 'Risco de desnutrição',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_diarreia' => [
                    'name' => 'Risco de diarreia',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_dor' => [
                    'name' => 'Risco de dor',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_extubacao_acidental' => [
                    'name' => 'Risco de extubação acidental',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_falencia_renal' => [
                    'name' => 'Risco de falência renal',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_feblite' => [
                    'name' => 'Risco de feblite',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_hipoglicemia' => [
                    'name' => 'Risco de hipoglicemia',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_infeccao_corrente' => [
                    'name' => 'Risco de infecção por corrente sanguínea por cateter',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_infeccao_urinaria' => [
                    'name' => 'Risco de infecção urinária por cateter vesical',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_pneumonia' => [
                    'name' => 'Risco de pneumonia associada a ventilação mecânica',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'riscco_queda_leito' => [
                    'name' => 'Risco de queda do leito',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_reacao_transfusional' => [
                    'name' => 'Risco de reação transfusional',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_retirada_acidental_cateter' => [
                    'name' => 'Risco de retirada acidental de cateteres e dispositivos invasivos',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_sangramento' => [
                    'name' => 'Risco de sangramento',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_tromboembolia' => [
                    'name' => 'Risco de tromboembolia',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_ulcera' => [
                    'name' => 'Risco de úlcera de pressão',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

                'risco_iminente' => [
                    'name' => 'Risco iminente de óbito',
                    'tot' => 0,
                    'percen' => 0,

                    'tot_clinico' => 0,
                    'percen_clinico' => 0,

                    'tot_cirurgico' => 0,
                    'percen_cirurgico' => 0,
                ],

            ],
        ];

        //falta eventos
        $riscos = ['impossibilidade_de_reconciliacao', 'risco_broncoaspiracao', 'risco_desnutricao',
            'risco_diarreia', 'risco_dor', 'risco_extubacao_acidental', 'risco_falencia_renal', 'risco_feblite', 'risco_hipoglicemia',
            'risco_infeccao_corrente', 'risco_infeccao_urinaria', 'risco_pneumonia', 'riscco_queda_leito', 'risco_reacao_transfusional',
            'risco_retirada_acidental_cateter', 'risco_sangramento', 'risco_tromboembolia', 'risco_ulcera', 'risco_iminente'];

        $columns = $this->schema()->columns();

        foreach ($columns as $key => $column)
        {
            $data[$column]['total'] = 0;
            $data[$column]['percentual'] = 0;
            $data[$column]['media'] = 0;
            $data[$column]['mediana'] = 0;
            $data[$column]['desvio_padrao'] = 0;
            $data[$column]['soma'] = 0;
        }

        foreach ($sectors as $sector)
        {
            $sector_name = $sector['name'];
            $data['setores'][$sector_name] = [
                'media' => 0,
                'total_de_riscos' => 0,

                'arr_total_pacientes' => [],
                'total_pacientes' => 0,

                'cirurgico' => ['total_de_riscos' => 0, 'total_pacientes' => 0, 'media' => 0],
                'clinico' => ['total_de_riscos' => 0, 'total_pacientes' => 0, 'media' => 0],
            ];
        }

        foreach ($hospitalizations as $hospitalization)
        {
            $data['tot_pacientes']++;

            foreach ($hospitalization["identification_of_risks"] as $key_1 => $risk)
            {
                $risk_arr = (array) $risk;
                $i = 0;
                $i_2 = 0;

                foreach ($riscos as $risco_key => $risco)
                {
                    if ($risk[$risco])
                    {
                        $data['tot_risco_por_paciente']++;

                        if (!in_array($hospitalization->id, $data['arr_pacientes_com_risco']))
                        {
                            array_push($data['arr_pacientes_com_risco'], $hospitalization->id);
                            $data['tot_pacientes_com_risco']++;
                        }

                        $data['riscos'][$risco]['tot']++;

                        if (strpos($hospitalization['type'], 'clínic') !== false)
                        {
                            $data['riscos'][$risco]['tot_clinico']++;
                        }
                        elseif (strpos($hospitalization['type'], 'cirúr') !== false)
                        {
                            $data['riscos'][$risco]['tot_cirurgico']++;
                        }
                    }
                }

                $data['total_de_registros']++;

                if (isset($risk['sector']['name']))
                {
                    $sector_name = $risk['sector']['name'];

                    foreach ($riscos as $risco_key => $risco)
                    {
                        if ($risk[$risco])
                        {
                            $data['setores'][$sector_name]['total_de_riscos']++;

                            if (strpos($hospitalization['type'], 'clínic') !== false)
                            {
                                $data['setores'][$sector_name]['clinico']['total_de_riscos']++;
                            }
                            elseif (strpos($hospitalization['type'], 'cirúr') !== false)
                            {
                                $data['setores'][$sector_name]['cirurgico']['total_de_riscos']++;
                            }
                        }

                        if (!in_array($hospitalization->id, $data['setores'][$sector_name]['arr_total_pacientes']))
                        {
                            array_push($data['setores'][$sector_name]['arr_total_pacientes'], $hospitalization->id);
                            $data['setores'][$sector_name]['total_pacientes']++;

                            if (strpos($hospitalization['type'], 'clínic') !== false)
                            {
                                $data['setores'][$sector_name]['clinico']['total_pacientes']++;
                            }
                            elseif (strpos($hospitalization['type'], 'cirúr') !== false)
                            {
                                $data['setores'][$sector_name]['cirurgico']['total_pacientes']++;
                            }
                        }
                    }

                    foreach ($risk_arr as $key_2 => $value_2)
                    {
                        $i++;

                        if ($i == 2) //acessa as propriades do obj
                        {
                            foreach ($value_2 as $key_3 => $value_3)
                            {
                                if (
                                    (gettype($value_2) == 'tinyint' ||
                                        gettype($value_2) == 'boolean') &&
                                    $value_2
                                )
                                {
                                    //$data['tot_risco_por_paciente']++;
                                }

                                //formatArr($value_3, $data['setores'][$sector_name], $key_3);

                                if (strpos($hospitalization['type'], 'clínic') !== false)
                                {
                                    //formatArr($value_3, $data['setores'][$sector_name]['clinico_total'], $key_3);
                                }
                                elseif (strpos($hospitalization['type'], 'cirúr') !== false)
                                {
                                    //formatArr($value_3, $data['setores'][$sector_name]['cirurgico_total_total'], $key_3);
                                }
                            }
                        }
                    }
                }

                foreach ($risk_arr as $key_2 => $value_2)
                {
                    $i_2++;

                    if ($i_2 == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            if (isset($data[$key]['percentual']) &&
                isset($data[$key]['arr']))
            {
                $marcados = 0;

                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

//calc média de risco por paciente
        if ($data['tot_risco_por_paciente'] > 0 && $data['tot_paciente_com_risco'] > 0)
        {
            $data['percen_risco_por_paciente'] = $data['tot_risco_por_paciente'] / $data['tot_paciente_com_risco'];
            $data['percen_risco_por_paciente'] = round($data['percen_risco_por_paciente'], 2);
        }

        if ($data['tot_pacientes'] > 0 && $data['tot_risco_por_paciente'])
        {
            $data['media_risco_por_paciente'] = round($data['tot_risco_por_paciente'] / $data['tot_pacientes'], 2);
        }

        if ($data['tot_pacientes'] > 0 && $data['tot_pacientes_com_risco'] > 0)
        {
            $data['percen_paciente_com_risco'] = ($data['tot_pacientes_com_risco'] * 100) / $data['tot_pacientes'];
            $data['percen_paciente_com_risco'] = round($data['percen_paciente_com_risco'], 2);
        }

        foreach ($data['setores'] as $key => $setor)
        {
            if ($setor['total_de_riscos'] > 0 && $setor['total_pacientes'] > 0)
            {
                $data['setores'][$key]['media'] = round($setor['total_de_riscos'] / $setor['total_pacientes'], 2);
            }

            if ($setor['cirurgico']['total_de_riscos'] > 0 && $setor['cirurgico']['total_pacientes'] > 0)
            {
                $data['setores'][$key]['cirurgico']['media'] = round($setor['cirurgico']['total_de_riscos'] / $setor['cirurgico']['total_pacientes'], 2);
            }

            if ($setor['clinico']['total_de_riscos'] > 0 && $setor['clinico']['total_pacientes'] > 0)
            {
                $data['setores'][$key]['clinico']['media'] = round($setor['clinico']['total_de_riscos'] / $setor['clinico']['total_pacientes'], 2);
            }
        }

        foreach ($data['riscos'] as $key => $risco)
        {
            if ($risco['tot'] > 0)
            {
                $data['riscos'][$key]['percen'] = ($risco['tot'] * 100) / $data['tot_risco_por_paciente'];
                $data['riscos'][$key]['percen'] = round($data['riscos'][$key]['percen'], 2);
            }

            if ($risco['tot_cirurgico'] > 0)
            {
                $data['riscos'][$key]['percen_cirurgico'] = ($risco['tot_cirurgico'] * 100) / $data['tot_risco_por_paciente'];
                $data['riscos'][$key]['percen_cirurgico'] = round($data['riscos'][$key]['percen_cirurgico'], 2);
            }

            if ($risco['tot_clinico'] > 0)
            {
                $data['riscos'][$key]['percen_clinico'] = ($risco['tot_clinico'] * 100) / $data['tot_risco_por_paciente'];
                $data['riscos'][$key]['percen_clinico'] = round($data['riscos'][$key]['percen_clinico'], 2);
            }
        }

        $data['principais_riscos'] = $data['riscos'];
        $data['principais_riscos_clinico'] = $data['riscos'];
        $data['principais_riscos_cirurgico'] = $data['riscos'];
        $count_riscos = 0;
        usort($data['principais_riscos'], function ($a, $b)
        {
            return $a['tot'] < $b['tot'];
        });

        usort($data['principais_riscos_clinico'], function ($a, $b)
        {
            return $a['tot'] < $b['tot'];
        });

        usort($data['principais_riscos_cirurgico'], function ($a, $b)
        {
            return $a['tot'] < $b['tot'];
        });

        foreach ($data['principais_riscos'] as $key => $risco)
        {
            $count_riscos++;
            if ($count_riscos > 10)
            {
                unset($data['principais_riscos'][$key]);
                unset($data['principais_riscos_cirurgico'][$key]);
                unset($data['principais_riscos_clinico'][$key]);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
