<?php
namespace App\Model\Table;

use App\Model\Entity\Inspection;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Inspections Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $NeonatalChecklists
 */
class InspectionsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('inspections');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->belongsToMany('NeonatalChecklists', [            
            'targetForeignKey' => 'neonatal_checklist_id',
            'foreignKey' => 'inspection_id',
            'joinTable' => 'inspections_neonatal_checklists'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('name', 'create')
            ->notEmpty('name');

        return $validator;
    }
}
