<?php
namespace App\Model\Table;

use App\Model\Entity\NasScore;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * NasScores Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class NasScoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('nas_scores');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('monitoramento_e_controles');

        $validator
            ->allowEmpty('investigacoes_laboratoriais');

        $validator
            ->allowEmpty('medicacao');

        $validator
            ->allowEmpty('procedimentos_de_higiene');

        $validator
            ->allowEmpty('cuidados_com_drenos');

        $validator
            ->allowEmpty('mobilizacao_e_posicionamento');

        $validator
            ->allowEmpty('suporte_e_cuidados_aos_familiares');

        $validator
            ->allowEmpty('tarefas_administrativas');

        $validator
            ->allowEmpty('suporte_ventilatorio');

        $validator
            ->allowEmpty('cuidado_com_vias_aereas');

        $validator
            ->allowEmpty('tratamento_para_funcao_pulmonar');

        $validator
            ->allowEmpty('medicacao_vasoativa');

        $validator
            ->allowEmpty('reposicao_iv_de_grandes_perdas_de_fluidos');

        $validator
            ->allowEmpty('monitoracao_com_cateter_de_swan_ganz');

        $validator
            ->allowEmpty('rcp_nas_ultimas_24h');

        $validator
            ->allowEmpty('tecnicas_de_suporte_renal');

        $validator
            ->allowEmpty('medida_do_debito_urinario');

        $validator
            ->allowEmpty('medida_da_pic');

        $validator
            ->allowEmpty('tratamento_da_acidose');

        $validator
            ->allowEmpty('nutricao_parenteral_total');

        $validator
            ->allowEmpty('nutricao_enteral');

        $validator
            ->allowEmpty('intervencoes_especificas_na_uti');

        $validator
            ->allowEmpty('intervencoes_especificas_fora_da_uti');

        $validator
        //->date('data_de_realizacao')
        ->requirePresence('data_de_realizacao', 'create')
            ->notEmpty('data_de_realizacao');

        $validator
            ->allowEmpty('doenca_do_paciente');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('pontuacao');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after, $sectors)
    {
        $calc_obj = new MedidasDispersao();

        $tot_dias_no_periodo = $date_before->diff($date_after)->days;

        $data = [
            'total_de_registros' => 0,

            'tot_pacientes' => 0,

            'arr_pacientes_com_nas' => [],
            'tot_pacientes_com_nas' => 0,
            'percen_pacientes_com_nas' => 0,

            'arr_pontuacao_nas' => [],
            'media_pontuacao_nas' => 0,

            'tot_realocacao' => 0,
            'percen_realocacao_por_paciente' => 0,
            'media_realocacao_nas_por_dia' => 0,
        ];

        $columns = $this->schema()->columns();

        foreach ($columns as $key => $column)
        {
            $data[$column]['total'] = 0;
            $data[$column]['percentual'] = 0;
            $data[$column]['media'] = 0;
            $data[$column]['mediana'] = 0;
            $data[$column]['desvio_padrao'] = 0;
            $data[$column]['soma'] = 0;
        }

        foreach ($sectors as $sector)
        {
            $sector_name = $sector['name'];
            $sector_id = $sector['id'];
            $data['setores'][$sector_id] = [
                'name' => $sector_name,

                'tot_realocacao' => 0,
                //'percen_realocacao_por_paciente' => 0,
                'percen' => 0,

                'arr_total_pacientes' => [],
                'total_pacientes' => 0,

// 'cirurgico' => ['tot_realocacao' => 0, 'total_pacientes' => 0, 'media' => 0],
                // 'clinico' => ['tot_realocacao' => 0, 'total_pacientes' => 0, 'media' => 0],
            ];
        }

        foreach ($hospitalizations as $hospitalization)
        {
            $data['tot_pacientes']++;

            if ($hospitalization['date_of_hospitalization'])
            {
            //yolo

            // $data_begin = $date_before;

            // $data_end = $date_after;

            // if ($hospitalization['date_of_hospitalization'] > $date_before)

            // {

            //     $data_begin = new \Datetime($hospitalization['date_of_hospitalization']->format('Y-m-d'));

            // }

            // $days = $data_begin->diff($data_end)->days;

            // if ($days > 0)

            // {

            //     $data['tot_paciente_dia'] += $days;
                // }
            }

            foreach ($hospitalization["nas_scores"] as $key_1 => $nas)
            {
                if (!in_array($hospitalization->id, $data['arr_pacientes_com_nas']))
                {
                    array_push($data['arr_pacientes_com_nas'], $hospitalization->id);
                    $data['tot_pacientes_com_nas']++;
                }

                if ($nas['pontuation'])
                {
                    array_push($data['arr_pontuacao_nas'], $nas['pontuation']);
                }

                if ($nas['sector_id'])
                {
                    $sector_id = $nas['sector_id'];

                    if ($nas['houve_mudanca_da_relacao'])
                    {
                        $data['setores'][$sector_id]['tot_realocacao']++;
                    }
                }

                if ($nas['houve_mudanca_da_relacao'])
                {
                    $data['tot_realocacao']++;
                }
            }
        }

        if ($data['tot_pacientes_com_nas'] > 0)
        {
            $data['percen_pacientes_com_nas'] = ($data['tot_pacientes_com_nas'] * 100) / $data['tot_pacientes'];
            $data['percen_pacientes_com_nas'] = round($data['percen_pacientes_com_nas'], 2);
        }

        if (count($data['arr_pontuacao_nas']) > 0)
        {
            $data['media_pontuacao_nas'] = $calc_obj->calc_average($data['arr_pontuacao_nas']);
        }

        if ($data['tot_realocacao'] > 0 && $data['tot_pacientes'] > 0)
        {
            $media_realocacao_dia = $data['tot_realocacao'] / $tot_dias_no_periodo;
            $media_paciente_dia = $data['tot_pacientes'] / $tot_dias_no_periodo;

            $data['media_realocacao_nas_por_dia'] = round($media_realocacao_dia / $media_paciente_dia, 2);
        }

        foreach ($data['setores'] as $key => $setor)
        {
            if ($setor['tot_realocacao'] > 0)
            {
                $data['setores'][$key]['percen'] = ($setor['tot_realocacao'] / $data['tot_realocacao']) * 100;
                $data['setores'][$key]['percen'] = round($data['setores'][$key]['percen'], 2);
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
