<?php
namespace App\Model\Table;

use App\Model\Entity\ObtainedOrgansFromCorpsesSuspectedMeProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ObtainedOrgansFromCorpsesSuspectedMeProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SuspectedMeProtocols
 * @property \Cake\ORM\Association\BelongsTo $ObtainedOrgansFromCorpses
 */
class ObtainedOrgansFromCorpsesSuspectedMeProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('obtained_organs_from_corpses_suspected_me_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('SuspectedMeProtocols', [
            'foreignKey' => 'suspected_me_protocol_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('ObtainedOrgansFromCorpses', [
            'foreignKey' => 'obtained_organs_from_corpse_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['suspected_me_protocol_id'], 'SuspectedMeProtocols'));
        $rules->add($rules->existsIn(['obtained_organs_from_corpse_id'], 'ObtainedOrgansFromCorpses'));
        return $rules;
    }
}
