<?php
namespace App\Model\Table;

use App\Model\Entity\Patient;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Patients Model
 *
 * @property \Cake\ORM\Association\HasMany $Allergies
 * @property \Cake\ORM\Association\HasMany $Diagnostics
 * @property \Cake\ORM\Association\HasMany $GlasgowComaScales
 * @property \Cake\ORM\Association\HasMany $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $Responsibles
 * @property \Cake\ORM\Association\HasMany $Screenings
 * @property \Cake\ORM\Association\BelongsToMany $Telephones
 * @property \Cake\ORM\Association\BelongsToMany $Units
 */
class PatientsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('patients');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->hasMany('Allergies', [
            'foreignKey' => 'patient_id',
        ]);
        $this->hasMany('Diagnostics', [
            'foreignKey' => 'patient_id',
        ]);
        $this->hasMany('GlasgowComaScales', [
            'foreignKey' => 'patient_id',
        ]);
        $this->hasMany('Hospitalizations', [
            'foreignKey' => 'patient_id',
        ]);
        $this->hasMany('Responsibles', [
            'foreignKey' => 'patient_id',
        ]);
        $this->hasMany('Screenings', [
            'foreignKey' => 'patient_id',
        ]);

        $this->belongsTo('HealthInsurancePlans', [
            'foreignKey' => 'health_insurance_plan_id',
            'joinType' => 'LEFT'
        ]);
        // $this->belongsToMany('Telephones', [
        //     'foreignKey'       => 'patient_id',
        //     'targetForeignKey' => 'telephone_id',
        //     'joinTable'        => 'patients_telephones',
        // ]);
        $this->belongsToMany('Units', [
            'foreignKey'       => 'patient_id',
            'targetForeignKey' => 'unit_id',
            'joinTable'        => 'patients_units',
        ]);

    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        $validator
            ->email('email')
            ->allowEmpty('email');

        $validator
            ->requirePresence('document_number', 'create')
            ->notEmpty('document_number');

        $validator
        //->date('birthday')
        //->allowEmpty('birthday');
        ->notEmpty('birthday');

        $validator
            ->notEmpty('sexo');

        $validator
            ->allowEmpty('nationality');

        $validator
            ->allowEmpty('profession');

        $validator
            ->allowEmpty('civil_status');

        $validator
            ->allowEmpty('race');

        $validator
            ->allowEmpty('medical_record_number');

        $validator
            ->allowEmpty('street');

        $validator
            ->allowEmpty('district');

        $validator
            ->requirePresence('cep', 'create')
            ->notEmpty('cep');

        $validator
            ->requirePresence('city', 'create')
            ->notEmpty('city');

        $validator

            ->requirePresence('country', 'create')
            ->notEmpty('country');

        $validator
            ->allowEmpty('mother_name');

        $validator
            ->allowEmpty('father_name');

        $validator
            ->allowEmpty('responsible_name');

        $validator
            ->notEmpty('religion');

        $validator
            ->allowEmpty('medical_care');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->isUnique(['email']));
        return $rules;
    }
}
