<?php
namespace App\Model\Table;

use App\Model\Entity\PavDiaryChecklist;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * PavDiaryChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $PavPreventionBundles
 */
class PavDiaryChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('pav_diary_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('PavPreventionBundles', [
            'foreignKey' => 'pav_prevention_bundle_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('elevacao_cabeceira')
            ->allowEmpty('elevacao_cabeceira');

        $validator
            ->boolean('avaliacao_ventilatoria_diaria')
            ->allowEmpty('avaliacao_ventilatoria_diaria');

        $validator
            ->boolean('manutencao_da_pressao_balonete')
            ->allowEmpty('manutencao_da_pressao_balonete');

        $validator
            ->boolean('higiene_bucal')
            ->allowEmpty('higiene_bucal');

        $validator
            ->boolean('inicio_da_nutricao')
            ->allowEmpty('inicio_da_nutricao');

        $validator
            ->boolean('posicao_tubo_checado')
            ->allowEmpty('posicao_tubo_checado');

        $validator
            ->boolean('pro_cinetico')
            ->allowEmpty('pro_cinetico');

        $validator
            ->boolean('presencao_de_nausea')
            ->allowEmpty('presencao_de_nausea');

        $validator
            ->boolean('gastroparesia')
            ->allowEmpty('gastroparesia');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    //relatorio diario
    public function getRelatorioData($hospitalizations, $date_before, $date_after)
    {
        $calc_obj = new MedidasDispersao();

        $data = [
            'total_de_bundles' => 0,
            'periodos' => [],

            //arr com id dos pacientes (hospitalization_id) com dispositvo
            'arr_paciente_com_dispositivo' => [],
            'tot_paciente_com_dispositivo' => 0,

            //Julio
            'total_de_bundles_nao_preenchido' => 0,

            //Julio
            'total_de_dias_no_periodo_ate_hoje' => 0,

            'total_dias_no_periodo' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / DIAS NO PERÍODO
            'percen_bundles_por_dias' => 0,
            'tot_bundles_por_dias' => 0,

            //total de procedimentos do tipo cateter vesical cadastrados
            'tot_dispositivos_inseridos' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / TOTAL DE PACIENTES COM INSTALAÇÃO DE DISPOSITIVO
            'percen_bundles_por_procedimentos' => 0,

            //TOTAL DE TOTOS OS DIAS SOMADOS POR TODOS OS PACIENTES COM ESTE DISPOSITIVO INSTALADO NO PERÍODO
            'tot_tempo_uso_do_bundle' => 0,
            //VALOR TOTAL DE BUNDLES DIÁRIOS PREENCHIDOS / TOTAL DE PACIENTES-DIA
            'tot_bundles_por_tempo_de_uso' => 0,
            'percen_bundles_por_tempo_de_uso' => 0,

            //Julio
            //VALOR TOTAL DE BUNDLES DIÁRIOS NÂO PREENCHIDOS / DIAS NO PERÍODO
            'percen_bundles_por_dias_nao_preenchido' => 0,
            'tot_bundles_por_dias_nao_preenchido' => 0,


            //VALOR TOTAL DE BUNDLES DIÁRIOS NÃo PREENCHIDOS / TOTAL DE PACIENTES COM INSTALAÇÃO DE DISPOSITIVO
            'percen_bundles_por_procedimentos_nao_preenchido' => 0,
            'tot_bundles_por_procedimentos_nao_preenchido' => 0,

            //VALOR TOTAL DE BUNDLES DIÁRIOS NÃO PREENCHIDOS / TOTAL DE PACIENTES-DIA
            'tot_bundles_por_tempo_de_uso_nao_preenchido' => 0,
            'percen_bundles_por_tempo_de_uso_nao_preenchido' => 0,

            //Bundles diários preenchidos por pacientes com instalação de dispositivo
            'tot_bundle_dia_por_paciente_com_disp' => 0,
            'percen_bundle_dia_por_paciente_com_disp' => 0,
            
        ];

        $data['total_dias_no_periodo'] = $date_before->diff($date_after)->days;

        $columns = $this->schema()->columns();
        foreach ($columns as $key => $column) 
        {
            $data[$column]['total'] = 0;
            $data[$column]['percentual'] = 0;
            $data[$column]['media'] = 0;
            $data[$column]['mediana'] = 0;
            $data[$column]['desvio_padrao'] = 0;
            $data[$column]['soma'] = 0;
        }

        

        foreach ($hospitalizations as $hospitalization)
        {
            foreach ($hospitalization["supportive_measures"] as $key_1 => $supportive_measure)
            {
                if ($supportive_measure['data_inicio'] >= $date_before)
                {
                    $data["tot_dispositivos_inseridos"]++;
                }
            }

            if (in_array($hospitalization->id, $data['arr_paciente_com_dispositivo']) == false)
            {
                array_push($data['arr_paciente_com_dispositivo'], $hospitalization->id);
                $data['tot_paciente_com_dispositivo']++;
            }

            foreach ($hospitalization["pav_prevention_bundles"] as $bundle)
            {
                //deve ser criado um campo de data no bundle diario para ser usada no lugar do bundle principal
                if ($bundle['data_da_instalacao'] >= $date_before &&
                    $bundle['data_da_instalacao'] <= $date_after)
                {
                    //calcula o tot de bundles preenchidos por pacientes que tiveram a instalacao do dispositvo
                    if (in_array($hospitalization->id, $data['arr_paciente_com_dispositivo']) == false)
                    {
                     $data['tot_bundle_dia_por_paciente_com_disp']++;   
                    }

                    if (isset($bundle['data_da_instalacao']) && isset($bundle['data_da_retirada']))
                    {
                        $date_now = new \DateTime('today');
                        
                        $data['total_de_dias_no_periodo_ate_hoje'] += ($bundle['data_da_instalacao']->diff($bundle['data_da_retirada'])->days);
                    }

                    if (isset($bundle['data_da_instalacao']) &&
                        isset($bundle['data_da_retirada']))
                    {                        
                        //$data['tot_tempo_uso_do_bundle'] += $bundle['data_da_instalacao']->diff($bundle['data_da_retirada'])->days;

                        $bundle_period = null;
                        $now = new \Datetime();

                        if ($bundle['data_da_retirada'] > $now)
                        {
                            $bundle['data_da_retirada'] = $now;
                        }

                        if ($bundle['data_da_instalacao'] < $date_before)
                        {
                            $bundle['data_da_instalacao'] = $date_before;
                        }

                        $bundle_period = $bundle['data_da_instalacao']->diff($bundle['data_da_retirada'])->days;

                        $periodo = [
                            'data_da_instalacao' => $bundle['data_da_instalacao']->format('Y-m-d'),
                            'data_da_retirada' => $bundle['data_da_retirada']->format('Y-m-d'),
                            'now' => $now->format('Y-m-d'),
                        ];
                        array_push($data['periodos'], $periodo);

                        $data['tot_tempo_uso_do_bundle'] += $bundle_period;
                    }

                    foreach ($bundle["pav_diary_checklists"] as $daily_bundle)
                    {
                        $bundle_arr = (array) $daily_bundle;
                        $i = 0;

                        $data['total_de_bundles']++;

                        foreach ($bundle_arr as $key_2 => $value_2)
                        {
                            $i++;
                            if ($i == 2) //acessa as propriades do obj
                            {
                                foreach ($value_2 as $key_3 => $value_3)
                                {
                                    //$data[$key_3] = $value_3;
                                    formatArr($value_3, $data, $key_3);
                                }
                            }
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            if (isset($data[$key]['percentual']) && isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['soma'] = 0;
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_bundles']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);

                //calcula o total
                if (count($data[$key]['arr']) > 0)
                {
                    foreach ($data[$key]['arr'] as $attr)
                    {
                        if (is_numeric($attr))
                        {
                            $data[$key]['soma'] += $attr;
                        }
                    }
                }
            }
        }

        //calc
        if ($data['total_de_bundles'] > 0 &&
            $data['total_dias_no_periodo'] > 0
        )
        {
            $data['percen_bundles_por_dias'] = ($data['total_de_bundles'] * 100) / $data['total_dias_no_periodo'];
            $data['percen_bundles_por_dias'] = round($data['percen_bundles_por_dias'], 2);

            $data['tot_bundles_por_dias'] = $data['total_de_bundles']  / $data['total_dias_no_periodo'];
            $data['tot_bundles_por_dias'] = round($data['tot_bundles_por_dias'], 2);
        }

        //calc
        if ($data['total_de_bundles'] > 0 &&
            $data['tot_dispositivos_inseridos'] > 0
        )
        {
            $data['percen_bundles_por_procedimentos'] = ($data['total_de_bundles'] * 100) / $data['tot_dispositivos_inseridos'];
            $data['percen_bundles_por_procedimentos'] = round($data['percen_bundles_por_procedimentos'], 2);
        }

        //calc
        if ($data['total_de_bundles'] > 0 &&
            $data['tot_tempo_uso_do_bundle'] > 0
        )
        {
            $data['tot_bundles_por_tempo_de_uso'] = $data['total_de_bundles']  / $data['tot_tempo_uso_do_bundle'];
            $data['tot_bundles_por_tempo_de_uso'] = round($data['tot_bundles_por_tempo_de_uso'], 2);

            $data['percen_bundles_por_tempo_de_uso'] = ($data['total_de_bundles'] * 100) / $data['tot_tempo_uso_do_bundle'];
            $data['percen_bundles_por_tempo_de_uso'] = round($data['percen_bundles_por_tempo_de_uso'], 2);
        }     

        //Julio
        if ($data['total_de_bundles'] > 0 &&
          //  $data['total_de_dias_no_periodo_ate_hoje'] > 0
            $data['tot_tempo_uso_do_bundle'] > 0
        )
        {
            //$data['total_de_bundles_nao_preenchido'] = $data['total_de_dias_no_periodo_ate_hoje'] - $data['total_de_bundles'];
            $data['total_de_bundles_nao_preenchido'] = $data['tot_tempo_uso_do_bundle'] - $data['total_de_bundles'];
        }

        if ($data['total_de_bundles_nao_preenchido'] > 0 &&
            $data['total_dias_no_periodo'] > 0
        )
        {
            $data['percen_bundles_por_dias_nao_preenchido'] = ($data['total_de_bundles_nao_preenchido'] * 100) / $data['total_dias_no_periodo'];
            $data['percen_bundles_por_dias_nao_preenchido'] = round($data['percen_bundles_por_dias_nao_preenchido'], 2);

            $data['tot_bundles_por_dias_nao_preenchido'] = $data['total_de_bundles_nao_preenchido']  / $data['total_dias_no_periodo'];
            $data['tot_bundles_por_dias_nao_preenchido'] = round($data['tot_bundles_por_dias_nao_preenchido'], 2);

            
        }

        if ($data['total_de_bundles_nao_preenchido'] > 0 &&
            $data['tot_dispositivos_inseridos'] > 0
        )
        {
            $data['percen_bundles_por_procedimentos_nao_preenchido'] = ($data['total_de_bundles_nao_preenchido'] * 100) / $data['tot_dispositivos_inseridos'];
            $data['percen_bundles_por_procedimentos_nao_preenchido'] = round($data['percen_bundles_por_procedimentos_nao_preenchido'], 2);

            $data['tot_bundles_por_procedimentos_nao_preenchido'] = $data['total_de_bundles_nao_preenchido']  / $data['tot_dispositivos_inseridos'];
            $data['tot_bundles_por_procedimentos_nao_preenchido'] = round($data['tot_bundles_por_procedimentos_nao_preenchido'], 2);
        }

        if ($data['total_de_bundles_nao_preenchido'] > 0 &&
            $data['tot_tempo_uso_do_bundle'] > 0
        )
        {
            $data['tot_bundles_por_tempo_de_uso_nao_preenchido'] = $data['total_de_bundles_nao_preenchido']  / $data['tot_tempo_uso_do_bundle'];
            $data['tot_bundles_por_tempo_de_uso_nao_preenchido'] = round($data['tot_bundles_por_tempo_de_uso_nao_preenchido'], 2);

            $data['percen_bundles_por_tempo_de_uso_nao_preenchido'] = ($data['total_de_bundles_nao_preenchido'] * 100) / $data['tot_tempo_uso_do_bundle'];
            $data['percen_bundles_por_tempo_de_uso_nao_preenchido'] = round($data['percen_bundles_por_tempo_de_uso_nao_preenchido'], 2);
        }

        if ($data['tot_paciente_com_dispositivo'] > 0 &&
            $data['total_de_bundles'])
        {
            $data['tot_bundle_dia_por_paciente_com_disp'] = $data['total_de_bundles']  / $data['tot_paciente_com_dispositivo'];
            $data['tot_bundle_dia_por_paciente_com_disp'] = round($data['tot_bundle_dia_por_paciente_com_disp'], 2);

            $data['percen_bundle_dia_por_paciente_com_disp'] = ($data['total_de_bundles'] * 100) / $data['tot_paciente_com_dispositivo'];
            $data['percen_bundle_dia_por_paciente_com_disp'] = round($data['percen_bundle_dia_por_paciente_com_disp'], 2);
        }

        return $data;
    }

/**
 * Returns a rules checker object that will be used for validating
 * application integrity.
 *
 * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
 * @return \Cake\ORM\RulesChecker
 */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['pav_prevention_bundle_id'], 'PavPreventionBundles'));
        return $rules;
    }
}
