<?php
namespace App\Model\Table;

use App\Model\Entity\SepseProtocol;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * SepseProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 * @property \Cake\ORM\Association\BelongsTo $SofaEscores
 */
class SepseProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('sepse_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
        ]);
        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
        ]);
        $this->belongsTo('SofaEscores', [
            'foreignKey' => 'sofa_escore_id',
        ]);

        $this->belongsTo('Sectors', [
            'foreignKey' => 'sector_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->boolean('hipotensao')
            ->allowEmpty('hipotensao');

        $validator
            ->boolean('taquipneia')
            ->allowEmpty('taquipneia');

        $validator
            ->boolean('alteracao_estado_mental')
            ->allowEmpty('alteracao_estado_mental');

        $validator
            ->boolean('pneumonia')
            ->allowEmpty('pneumonia');

        $validator
            ->boolean('infeccao_urinaria')
            ->allowEmpty('infeccao_urinaria');

        $validator
            ->boolean('infeccao_abdominal')
            ->allowEmpty('infeccao_abdominal');

        $validator
            ->boolean('meningite')
            ->allowEmpty('meningite');

        $validator
            ->boolean('endocardite')
            ->allowEmpty('endocardite');

        $validator
            ->boolean('pele_partes_moles')
            ->allowEmpty('pele_partes_moles');

        $validator
            ->boolean('infeccao_protese')
            ->allowEmpty('infeccao_protese');

        $validator
            ->boolean('infeccao_ossea')
            ->allowEmpty('infeccao_ossea');

        $validator
            ->boolean('infeccao_ferida_operatoria')
            ->allowEmpty('infeccao_ferida_operatoria');

        $validator
            ->boolean('infeccao_corrente_sanguinea')
            ->allowEmpty('infeccao_corrente_sanguinea');

        $validator
            ->allowEmpty('outras_infeccoes');

        $validator
            ->boolean('sem_foco_definido')
            ->allowEmpty('sem_foco_definido');

        $validator
            ->boolean('infeccao_nao_complicada')
            ->allowEmpty('infeccao_nao_complicada');

        $validator
            ->boolean('sepse')
            ->allowEmpty('sepse');

        $validator
            ->boolean('choque_septico')
            ->allowEmpty('choque_septico');

        $validator
            ->boolean('afastado_sepse')
            ->allowEmpty('afastado_sepse');

        $validator
            ->boolean('sepse_choque_septico')
            ->allowEmpty('sepse_choque_septico');

        $validator
            ->boolean('coletar_exame')
            ->allowEmpty('coletar_exame');

        $validator
        // ->date('coletar_exame_data')
        ->allowEmpty('coletar_exame_data');

        $validator
            ->time('coletar_exame_hora')
            ->allowEmpty('coletar_exame_hora');

        $validator
            ->boolean('preservar_antibio')
            ->allowEmpty('preservar_antibio');

        $validator
            ->time('preservar_antibio_hora')
            ->allowEmpty('preservar_antibio_hora');

        $validator
        // ->date('preservar_anti_data')
        ->allowEmpty('preservar_anti_data');

        $validator
            ->boolean('encerrar_atendimento')
            ->allowEmpty('encerrar_atendimento');

        $validator
        // ->date('encerrar_atendimento_data')
        ->allowEmpty('encerrar_atendimento_data');

        $validator
            ->time('encerrar_atendimento_hora')
            ->allowEmpty('encerrar_atendimento_hora');

        $validator
            ->boolean('paciente_nao_tem_disfuncao')
            ->allowEmpty('paciente_nao_tem_disfuncao');

        $validator
            ->boolean('pas_menor_que_90')
            ->allowEmpty('pas_menor_que_90');

        $validator
            ->boolean('relacao_pao')
            ->allowEmpty('relacao_pao');

        $validator
            ->boolean('rebaixamento_do_nivel')
            ->allowEmpty('rebaixamento_do_nivel');

        $validator
            ->boolean('creatina')
            ->allowEmpty('creatina');

        $validator
            ->boolean('bilirrubina')
            ->allowEmpty('bilirrubina');

        $validator
            ->boolean('contagem_de_plaquetas')
            ->allowEmpty('contagem_de_plaquetas');

        $validator
            ->boolean('lactato_acima_do_valor')
            ->allowEmpty('lactato_acima_do_valor');

        $validator
            ->boolean('coagulopatia')
            ->allowEmpty('coagulopatia');

        $validator
        // ->date('data_primeira_disfuncao')
        ->allowEmpty('data_primeira_disfuncao');

        $validator
            ->time('hora_primeira_disfuncao')
            ->allowEmpty('hora_primeira_disfuncao');

        $validator
            ->allowEmpty('caso_confirmado_como');

        $validator
        // ->date('destino_data')
        ->allowEmpty('destino_data');

        $validator
            ->time('destino_hora')
            ->allowEmpty('destino_hora');

        $validator
            ->boolean('destino_liberacao_para_tratamento')
            ->allowEmpty('destino_liberacao_para_tratamento');

        $validator
            ->boolean('destino_internacao')
            ->allowEmpty('destino_internacao');

        $validator
           // ->time('reconhecimento_sepse_hora')
            ->allowEmpty('reconhecimento_sepse_hora');

        $validator
        // ->date('reconhecimento_sepse_data')
        ->allowEmpty('reconhecimento_sepse_data');

        $validator
            ->time('antibioticoterapia_hora')
            ->allowEmpty('antibioticoterapia_hora');

        $validator
        // ->date('antibioticoterapia_data')
        ->allowEmpty('antibioticoterapia_data');

        $validator
            ->allowEmpty('classificacao');

        $validator
            ->allowEmpty('delta_de_cultura');

        $validator
            ->allowEmpty('pontuacao_sofa_d1_score');

        $validator
            ->allowEmpty('pontuacao_maxima_sofa');

        $validator
            ->allowEmpty('desfecho');

        $validator
        // ->date('hemocultura_data')
        ->allowEmpty('hemocultura_data');

        $validator
            ->time('hemocultura_hora')
            ->allowEmpty('hemocultura_hora');

        $validator
        // ->date('qsofa_data')
        ->allowEmpty('qsofa_data');

        $validator
            ->time('qsofa_hora')
            ->allowEmpty('qsofa_hora');

        $validator
            ->allowEmpty('lactato');

        $validator
            ->time('lactato_hora')
            ->allowEmpty('lactato_hora');

        $validator
            ->allowEmpty('delta_de_antibiotico');

        $validator
            ->allowEmpty('taxa_clareamento_lactato');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,

            'arr_pacientes'  => [],
            'tot_pacientes' =>0,

            'arr_pacientes_prot_aberto'  => [], //total de pacientes com sepse que nao receberam alta ou obito
            'tot_pacientes_prot_aberto' =>0,

            'arr_paci_com_sepse' => [],
            'tot_paci_com_sepse'=>0,

            'indice_paciente_sepse' => 0,
            'indice_paciente_sepse_percentual' => 0,

            'distribuicao_lactato' =>[
                'menor_20'=>['tot'=>0, 'percen'=>0],
                '21_a_40'=>['tot'=>0, 'percen'=>0],
                '41_a_60'=>['tot'=>0, 'percen'=>0],
                'maior_60'=>['tot'=>0, 'percen'=>0],
            ],
            'sofa' => [
                'minimo' => 0,
                'maximo' => 0,
                'medio' => 0,
                'total' => 0,
                'count' => 0,
            ],

            'taxa_adesao_prot_sepse' => 0,
            'paciente_aumento_sofa' => [
                'count' => 0,
                'valor' => 0,
                'paciente_aumento' => 0,
                'percentual' => 0,
            ],
            'paciente_permanencia_sepse' => [
                'media' => 0,
                'total' => 0,
                'count' => 0,
            ],
            'mortalidade' => [
                'total' => 0,
                'percentual' => 0,
                'tipo' => [
                    'Sepse' => [
                        'count' => 0,
                        'percentual' => 0,
                    ],
                    // 'Sepse severo' => [
                    //     'count' => 0,
                    //     'percentual' => 0,
                    // ],
                    'Choque séptico' => [
                        'count' => 0,
                        'percentual' => 0,
                    ],
                ]
            ],
            'taxa_efetividade' => [
                'total' => 0,
                'percentual' => 0
            ],
            'distribuicao_sepse' => [
                'tipo' => [
                    'Sepse' => [
                        'count' => 0,
                        'percentual' => 0,
                    ],
                    // 'Sepse severo' => [
                    //     'count' => 0,
                    //     'percentual' => 0,
                    // ],
                    'Choque séptico' => [
                        'count' => 0,
                        'percentual' => 0,
                    ],
                ]
            ],
            'tempo_medio' => [
                'tipo' => [
                    'Sepse' => [
                        'count' => 0,
                        'total_dia' => 0,
                        'media' => 0,
                    ],
                    // 'Sepse severo' => [
                    //     'count' => 0,
                    //     'total_dia' => 0,
                    //     'media' => 0,
                    // ],
                    'Choque séptico' => [
                        'count' => 0,
                        'total_dia' => 0,
                        'media' => 0,
                    ],
                ]
            ],
            'reinternacao_uti' => [
                'tipo' => [
                    'Sepse' => [
                        'count' => 0,
                    ],
                    // 'Sepse severo' => [
                    //     'count' => 0,
                    // ],
                    'Choque séptico' => [
                        'count' => 0,
                    ],
                ]
            ],
            'tempo_medio_uti' => [
                'tipo' => [
                    'Sepse' => [
                        'count' => 0,
                        'total_dia' => 0,
                        'media' => 0,
                    ],
                    // 'Sepse severo' => [
                    //     'count' => 0,
                    //     'total_dia' => 0,
                    //     'media' => 0,
                    // ],
                    'Choque séptico' => [
                        'count' => 0,
                        'total_dia' => 0,
                        'media' => 0,
                    ],
                ]
            ],
        ];
        $columns = $this->schema()->columns();
        foreach ($columns as $key => $column)
        {
            $data[$column]['total'] = 0;
            $data[$column]['percentual'] = 0;
            $data[$column]['media'] = 0;
            $data[$column]['mediana'] = 0;
            $data[$column]['desvio_padrao'] = 0;
            $data[$column]['soma'] = 0;
            $data[$column]['variacao'] = 0;

        }

        foreach ($hospitalizations as $hospitalization)
        {

            if (in_array($hospitalization->id, $data['arr_pacientes']) == false)
            {
                array_push($data['arr_pacientes'], $hospitalization->id);
                $data['tot_pacientes']++;
            }

            //echo '<pre>';
            //print_r($hospitalization);
            foreach ($hospitalization["sepse_protocols"] as $key_1 => $neonatal)
            {
                if ($neonatal['created'] >= $date_before && $neonatal['created'] <= $date_after)
                {
                    //echo '<pre>';
                    //print_r($neonatal);
                    //print_r($data['arr_pacientes']) . "<br>";
                    //pega todos os pacientes com sepse
                    if (in_array($hospitalization->id, $data['arr_paci_com_sepse']) == false)
                    {
                        array_push($data['arr_paci_com_sepse'], $hospitalization->id);
                        $data['tot_paci_com_sepse']++;
                    }

                    //pega todos os pacientes com sepsee que ainda estao internados
                    if ($hospitalization->status == 'internado')
                    {
                        if (in_array($hospitalization->id, $data['arr_pacientes_prot_aberto']) == false)
                        {
                            array_push($data['arr_pacientes_prot_aberto'], $hospitalization->id);
                            $data['tot_pacientes_prot_aberto']++;
                            if($neonatal['caso_confirmado_como'] != 2){
                                $data['taxa_efetividade']['total']++;
                            }

                            if($neonatal['caso_confirmado_como'] == 1){
                                $data['distribuicao_sepse']['tipo']['Sepse']['count']++;
                            }
                            else if($neonatal['caso_confirmado_como'] == 2){
                                $data['distribuicao_sepse']['tipo']['Choque séptico']['count']++;
                            }
                        }
                    }


                    if ($hospitalization->status == 'alta' || $hospitalization->status == 'obito')
                    {
                        //$data['paciente_permanencia_sepse']['total']
                        //$data['paciente_permanencia_sepse']['count']++;
                        if(isset($hospitalization->date_of_hospitalization) && isset($neonatal['avaliacao_3_data'])){
                            $data_entrada = new \Datetime($hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                            $data_saida = new \Datetime($neonatal['avaliacao_3_data']->i18nFormat('dd-MM-yyyy'));

                            $data_intervalo = $data_saida->diff($data_entrada);
                            //echo "<pre>";
                            //print_r($data_intervalo);
                            $data['paciente_permanencia_sepse']['total'] += $data_intervalo->days;
                            $data['paciente_permanencia_sepse']['count']++;
                        }
                    }
                    else{
                        $data['mortalidade']['total']++;
                        if($neonatal['caso_confirmado_como'] == 1){
                            $data['mortalidade']['tipo']['Sepse']['count']++;
                        }
                        else if($neonatal['caso_confirmado_como'] == 2){
                            $data['mortalidade']['tipo']['Choque séptico']['count']++;
                        }

                    }


                    //VALIDAR DATA AQUI


                   if ($neonatal['taxa_clareamento_lactato'] <= 20)
                   {
                    $data['distribuicao_lactato']['menor_20']['tot']++;
                   }
                   else if ($neonatal['taxa_clareamento_lactato'] <= 40)
                   {
                        $data['distribuicao_lactato']['21_a_40']['tot']++;
                   }
                   else if ($neonatal['taxa_clareamento_lactato'] <= 60)
                   {
                        $data['distribuicao_lactato']['41_a_60']['tot']++;
                   }
                   else if ($neonatal['taxa_clareamento_lactato'] > 60)
                   {
                        $data['distribuicao_lactato']['maior_60']['tot']++;
                   }

                    // switch ($neonatal['classificacao_do_cranio'])
                    // {
                    //     case 'Microcefalia':
                    //         $data['classificacao_do_cranio']['Microcefalia']++;
                    //         break;

                    //     case 'Macrocefalia':
                    //         $data['classificacao_do_cranio']['Macrocefalia']++;
                    //         break;

                    //     case 'Hidrocefalia':
                    //         $data['classificacao_do_cranio']['Hidrocefalia']++;
                    //         break;

                    //     case 'Hidranencefalia':
                    //         $data['classificacao_do_cranio']['Hidranencefalia']++;
                    //         break;
                    // }


                    $neonatal_arr = (array) $neonatal;
                    $i = 0;

                    $data['total_de_registros']++;

                    foreach ($neonatal_arr as $key_2 => $value_2)
                    {
                        $i++;
                        if ($i == 2) //acessa as propriades do obj
                        {
                            foreach ($value_2 as $key_3 => $value_3)
                            {
                                //$data[$key_3] = $value_3;
                                formatArr($value_3, $data, $key_3);
                            }
                        }
                    }
                    //tempo de permanencia sepse por setor
                    if(isset($hospitalization->date_of_hospitalization) && isset($neonatal['avaliacao_3_data'])){
                        $data_entrada = new \Datetime($hospitalization->date_of_hospitalization->i18nFormat('dd-MM-yyyy'));
                        $data_saida = new \Datetime($neonatal['avaliacao_3_data']->i18nFormat('dd-MM-yyyy'));

                        $data_intervalo = $data_saida->diff($data_entrada);
                        //echo "<pre>";
                        //print_r($data_intervalo);
                        if($neonatal['caso_confirmado_como'] == 1){
                            $data['tempo_medio']['tipo']['Sepse']['total_dia'] += $data_intervalo->days;
                            $data['tempo_medio']['tipo']['Sepse']['count']++;
                        }
                        else if($neonatal['caso_confirmado_como'] == 2){
                            $data['tempo_medio']['tipo']['Choque séptico']['total_dia'] += $data_intervalo->days;
                            $data['tempo_medio']['tipo']['Choque séptico']['count']++;
                        }
                    }

                    //reinternação de uti por tipo de sepse
                    if(($hospitalization['readmission_to_hospital_until_30_days'] || $hospitalization['rehospitalization_up_24']) && ($neonatal['sector']['type_id'] == '12' || $neonatal['sector']['type_id'] == '13' || $neonatal['sector']['type_id'] == '14')){
                        if($neonatal['caso_confirmado_como'] == 1){
                            $data['reinternacao_uti']['tipo']['Sepse']['count']++;
                        }
                        else if($neonatal['caso_confirmado_como'] == 2){
                            $data['reinternacao_uti']['tipo']['Choque séptico']['count']++;
                        }
                    }

                    if ($neonatal['sector']['type_id'] == '12' || $neonatal['sector']['type_id'] == '13' || $neonatal['sector']['type_id'] == '14'){
                        if($neonatal['caso_confirmado_como'] == 1){
                            $data['tempo_medio_uti']['tipo']['Sepse']['total_dia'] += $data_intervalo->days;
                            $data['tempo_medio_uti']['tipo']['Sepse']['count']++;
                        }
                        else if($neonatal['caso_confirmado_como'] == 2){
                            $data['tempo_medio_uti']['tipo']['Choque séptico']['total_dia'] += $data_intervalo->days;
                            $data['tempo_medio_uti']['tipo']['Choque séptico']['count']++;
                        }
                    }
                }
            }

            //echo "<pre>";
            //print_r($hospitalization);
            $data['paciente_aumento_sofa']['count'] = 0;
            $data['paciente_aumento_sofa']['valor'] = 0;
            if(isset($hospitalization['sofa_escores'])){
               foreach ($hospitalization['sofa_escores'] as $key => $sofa) {
                    $data_admissao = $hospitalization['date_of_hospitalization']->format('Y-m-d');
                    $data_24h = date('Y-m-d', strtotime("+1 days",strtotime($data_admissao)));
                    //echo "<pre>";
                    //print_r($sofa);
                    //paciente 24h
                    if(isset($sofa['data_de_realizacao'])){
                        $data_de_realizacao = $sofa['data_de_realizacao']->format('Y-m-d') . "<br>";
                        //echo $data_de_realizacao;
                        //Sofa nas primeiras 24h:
                        if($data_de_realizacao >= $data_admissao && $data_de_realizacao <= $data_24h){
                            $data = $this->dadosPontuacao($data, $sofa['pontuation']);
                        }
                    }
                    //pacientes com aumento de sofa
                    if($sofa['pontuation'] > 0){
                        if($data['paciente_aumento_sofa']['count'] == 0){
                            $data['paciente_aumento_sofa']['count']++;
                            $data['paciente_aumento_sofa']['valor'] = $sofa['pontuation'];
                        }
                        else if($data['paciente_aumento_sofa']['count'] == 1){

                            if($sofa['pontuation'] > $data['paciente_aumento_sofa']['valor']){
                                //echo "pontuacao = " . $sofa['pontuation'] . "<br>";
                                //echo "valor = " . $data['paciente_aumento_sofa']['valor']. "<br>";
                              $data['paciente_aumento_sofa']['paciente_aumento']++;
                              $data['paciente_aumento_sofa']['count'] = 2;
                            }
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;
            if (isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);
                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }
            }


            if (isset($data[$key]['percentual']))
            {
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
            }

            if (isset($data[$key]['arr']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
                $data[$key]['variacao'] = $calc_obj->calc_variance($data[$key]['arr']);
            }
        }
        if ($data['tot_paci_com_sepse'] > 0 &&
            $data['tot_pacientes_prot_aberto'] > 0)
        {
            $data['taxa_adesao_prot_sepse'] = ($data['tot_pacientes_prot_aberto'] * 100) / $data['tot_paci_com_sepse'];
            $data['taxa_adesao_prot_sepse'] = round($data['taxa_adesao_prot_sepse'], 2);

            $data['taxa_efetividade']['percentual'] = $data['taxa_efetividade']['total'] / $data['tot_pacientes_prot_aberto'];
            $data['taxa_efetividade']['percentual'] = round($data['taxa_efetividade']['percentual']*100, 2);

            foreach ($data['distribuicao_sepse']['tipo'] as $key => $value) {
                $distribuicao_sepse = ($data['distribuicao_sepse']['tipo'][$key]['count'] *100) / $data['tot_pacientes_prot_aberto'];
                $data['distribuicao_sepse']['tipo'][$key]['percentual'] = round($distribuicao_sepse, 2);
            }
        }
        if($data['tot_pacientes'] > 0 ){
            $data['indice_paciente_sepse'] = round(($data['tot_paci_com_sepse'] / $data['tot_pacientes']), 2);
            $data['indice_paciente_sepse_percentual'] = round(($data['indice_paciente_sepse'] * 100), 2);
            $data['paciente_aumento_sofa']['percentual'] = round((($data['paciente_aumento_sofa']['paciente_aumento'] * 100) / $data['tot_pacientes']), 2);
        }

        if($data['sofa']['count'] > 0){
            $data['sofa']['medio'] = round(($data['sofa']['total'] / $data['sofa']['count']), 2);
        }

        if($data['paciente_permanencia_sepse']['count'] > 0){
             $data['paciente_permanencia_sepse']['media'] = round($data['paciente_permanencia_sepse']['total'] / $data['paciente_permanencia_sepse']['count'], 2);
        }

        if($data['mortalidade']['total'] > 0){
            $mortalidade_percentual = ($data['mortalidade']['total'] *100) / $data['tot_paci_com_sepse'];
            $data['mortalidade']['percentual'] = round($mortalidade_percentual, 2);

            foreach ($data['mortalidade']['tipo'] as $key => $value) {
                $mortalidade_tipo = ($data['mortalidade']['tipo'][$key]['count'] *100) / $data['tot_paci_com_sepse'];
                $data['mortalidade']['tipo'][$key]['percentual'] = round($mortalidade_tipo, 2);
            }
        }

        foreach ($data['tempo_medio']['tipo'] as $key => $tempo_medio) {
            if($data['tempo_medio']['tipo'][$key]['count'] > 0){
                $data['tempo_medio']['tipo'][$key]['media'] = $data['tempo_medio']['tipo'][$key]['total_dia'] / $data['tempo_medio']['tipo'][$key]['count'];
            }
        }

        foreach ($data['tempo_medio_uti']['tipo'] as $key => $tempo_medio_uti) {
            if($data['tempo_medio_uti']['tipo'][$key]['count'] > 0){
                $data['tempo_medio_uti']['tipo'][$key]['media'] = $data['tempo_medio_uti']['tipo'][$key]['total_dia'] / $data['tempo_medio_uti']['tipo'][$key]['count'];
            }
        }

        return $data;
    }

    public function dadosPontuacao($data, $pontuacao){
        //minimo
        if($data['sofa']['minimo'] == 0){
            $data['sofa']['minimo'] = $pontuacao;
        }
        else{
            if($pontuacao < $data['sofa']['minimo']){
                $data['sofa']['minimo'] = $pontuacao;
            }
        }
        //maximo
        if($pontuacao > $data['sofa']['maximo']){
            $data['sofa']['maximo'] = $pontuacao;
        }
        //somanto pontos
        $data['sofa']['total'] += $pontuacao;

        $data['sofa']['count']++;

        return $data;
    }
    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        $rules->add($rules->existsIn(['sofa_escore_id'], 'SofaEscores'));
        return $rules;
    }
}
