<?php
namespace App\Model\Table;

use App\Model\Entity\SupportiveMeasure;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;
use Cake\ORM\TableRegistry;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * SupportiveMeasures Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class SupportiveMeasuresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('supportive_measures');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->hasMany('Measures', [
            'foreignKey' => 'supportive_measure_id',
        ]);

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
        //->date('data_inicio')
        ->requirePresence('data_inicio', 'create')
            ->allowEmpty('data_inicio');

        $validator
        //->date('data_termino')
        ->requirePresence('data_termino', 'create')
            ->allowEmpty('data_termino');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->requirePresence('type', 'create')
            ->notEmpty('type');

        return $validator;
    }

    public function getRelatorioPav($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,
            'type' => [
                'arr' => [],
            ],
        ];
        $percentual = [];

        foreach ($hospitalizations as $hospitalization)
        {
            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["supportive_measures"] as $key_1 => $neonatal)
            {
                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;

            $len = count($data[$key]['arr']);

            for ($i = 0; $i < $len; $i++)
            {
                if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                {
                    $marcados++;
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        foreach ($data['type']['arr'] as $key => $value)
        {
            $cont_orotraqueal = 0;
            if ($value == 'Tubo orotraqueal')
            {
            }
        }

        return $data;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after, $unit_id){
        //array suporte 1
        $suporte_procedimento_1 = ['Aminas hipertensoras', 'Balão intra-aórtico', 'Bioimpedância', 'Cateter arterial', 'Cateter de artéria pulmonar', 'Cateter de átrio esquerda', 'Cateter de mensuração da SjVO2', 'Cateter de microdiálise', 'Cateter de monitorização da pressão intracraniana', 'Cateter de PtiO2', 'Cateter venoso central curta permanência', 'Cateter venoso central longa permanência', 'Cateter venoso para diálise', 'Cateter venoso periférico', 'Cateter vesical', 'Derivação ventricular externa', 'Drogas hipotensoras em BI', 'Drogas inotrópicas em BI', 'ECMO', 'Macronebulização', 'Marcapasso transcutâneo', 'Marcapasso transvenoso', 'Monitoração hemodinâmica minimamente invasiva', 'Traqueostomia', 'Ventilação mecânica invasiva', 'Ventilação não-invasiva'];
        //array suporte 2
        $suporte_procedimento_2 = ['Abciximab', 'Albumina', 'Alteplase', 'Complemento', 'Complexo protrombínico', 'Concentrado de Fibrinogênio liofilizado', 'Concentrado de Hemácias', 'Concentrado de Plaquetas', 'Criopreciptado', 'Eptifibatide', 'Estreptoquinase', 'Fator IX', 'Fator VIIa', 'Fator VIII', 'Imunoglobulina', 'Plasma fresco', 'Tenecteplase', 'Tirofiban', 'Outros hemocomponentes'];

        $arr2 = [];

        foreach ($suporte_procedimento_1 as $key => $value) {
             $arr2['suporte_procedimento_1'][$value] = [
                'total' => 0,
                'totalVezesUtilizou' => 0,
                'minimo' => 0,
                'maximo' => 0,
                'mediana' => 0,
                'totalMedia' => 0,
                'percentual' => 0,
                'total_paciente' => 0,
                'calcularMediana' => [],
                'nome' => '',
                'ids' => [],
            ];
        }
        foreach ($suporte_procedimento_2 as $key => $value) {
             $arr2['suporte_procedimento_2'][$value] = [
                'total' => 0,
                'totalVezesUtilizou' => 0,
                'minimo' => 0,
                'maximo' => 0,
                'mediana' => 0,
                'totalMedia' => 0,
                'percentual' => 0,
                'total_paciente' => 0,
                'calcularMediana' => [],
                'nome' => '',
                'ids' => [],
            ];
        }

        //cria o array, com o nome do procedimento e total de usuario de usaram o serviço
        $c = 0;
        $count_pacient = 0;
        foreach ($hospitalizations as $key => $hospitalization) {
            //echo "<pre>";
            //print_r($hospitalization['supportive_measures']);
            foreach ($hospitalization['supportive_measures'] as $key => $supportive_mesasure_patient) {
                //echo "<pre>";
                //print_r($supportive_mesasure_patient);
               // verifica se pertence ao array de suporte 1 ou 2
               //echo $key . "<br>";
                if (in_array($supportive_mesasure_patient['type'], $suporte_procedimento_1))
                {
                    if (isset($supportive_mesasure_patient['data_inicio']) && isset($supportive_mesasure_patient['data_termino']))
                    {
                        //echo "d1 = " . $d1 . " d2 = " . $d2 . "<br>";
                        $d1 = explode("/", $supportive_mesasure_patient['data_inicio']->i18nFormat('dd/MM/yyyy'));
                        $d2 = explode("/", $supportive_mesasure_patient['data_termino']->i18nFormat('dd/MM/yyyy'));

                        $data1 = new \DateTime($d1['2'] . '-' . $d1['1'] . '-' . $d1['0']);
                        $data2 = new \DateTime($d2['2'] . '-' . $d2['1'] . '-' . $d2['0']);

                        $intervalo = $data1->diff($data2);
                        //print_r($intervalo);
                        //echo "dias = " .$intervalo->d;

                        //total de dias e total de vezes que foi usado
                        if ($supportive_mesasure_patient['type'])
                        {
                            $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['total'] = $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['total'] + $intervalo->days;
                            $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] = $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] + 1;
                        }

                        //calculando minimo
                        if ($arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['minimo'] == 0)
                        {
                            $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['minimo'] = $intervalo->days;
                        }
                        else
                        {
                            if ($arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['minimo'] > $intervalo->days)
                            {
                                $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['minimo'] = $intervalo->days;
                            }
                        }

                        //calculando maximo
                        if ($arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['maximo'] < $intervalo->days)
                        {
                            $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['maximo'] = $intervalo->days;
                        }

                        //inserindo elementos no array para calcular a mediana
                        $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['calcularMediana'][] = $intervalo->days;
                    }

                    $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['nome'] = $supportive_mesasure_patient['type'];
                    //echo "ids = " . $supportive_mesasure_patient['hospitalization']['id'] . "<br>";
                    if (!in_array($supportive_mesasure_patient['hospitalization_id'], $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['ids']))
                    {
                        array_push($arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['ids'], $supportive_mesasure_patient['hospitalization_id']);
                        $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['total_paciente'] = $arr2['suporte_procedimento_1'][$supportive_mesasure_patient['type']]['total_paciente'] + 1;
                    }
                }

                if (in_array($supportive_mesasure_patient['type'], $suporte_procedimento_2))
                {
                    if (isset($supportive_mesasure_patient['quantidade_administrada']) )
                    {
                        $quantidade_administrada = $supportive_mesasure_patient['quantidade_administrada'];
                        //total de dias e total de vezes que foi usado
                        if ($supportive_mesasure_patient['type'])
                        {

                            $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['total'] = $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['total'] + $quantidade_administrada;
                            $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] = $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['totalVezesUtilizou'] + 1;
                        }

                        //calculando minimo
                        if ($arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['minimo'] == 0)
                        {
                            $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['minimo'] = $quantidade_administrada;
                        }
                        else
                        {
                            if ($arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['minimo'] > $quantidade_administrada)
                            {
                                $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['minimo'] = $quantidade_administrada;
                            }
                        }

                        //calculando maximo
                        if ($arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['maximo'] < $quantidade_administrada)
                        {
                            $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['maximo'] = $quantidade_administrada;
                        }

                        //inserindo elementos no array para calcular a mediana
                        $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['calcularMediana'][] = $quantidade_administrada;
                    }

                    $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['nome'] = $supportive_mesasure_patient['type'];
                    //echo "ids = " . $supportive_mesasure_patient['hospitalization']['id'] . "<br>";
                    if (!in_array($supportive_mesasure_patient['hospitalization_id'], $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['ids']))
                    {
                        array_push($arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['ids'], $supportive_mesasure_patient['hospitalization_id']);
                        $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['total_paciente'] = $arr2['suporte_procedimento_2'][$supportive_mesasure_patient['type']]['total_paciente'] + 1;
                    }
                }
                $count_pacient++;
            }
        }

        $relatorios_table = TableRegistry::get('Relatorios');

        foreach ($arr2 as $key => $suporte_procedimento)
        {
            //echo "<pre>";
            //print_r($suporte_procedimento);
            foreach ($suporte_procedimento as $key_2 => $value) {
                if($value['total_paciente'] != 0 ){
                    $percentual = ($value['total_paciente'] * 100) / $count_pacient;
                    //total de parcientes em percentual
                    $arr2[$key][$key_2]['percentual'] = number_format($percentual, 2, '.', '');
                }

                if($key_2 == "suporte_procedimento_1"){
                    if($arr2[$key]['totalVezesUtilizou'] != 0 ){
                        $diasI = $arr2[$key][$key_2]['totalDia'] / $arr2[$key]['totalVezesUtilizou'];
                        $cs = $diasI - (int) $diasI;

                        if ($cs != 0)
                        {
                            $cs = $cs * 24;
                            $arr2[$key][$key_2]['totalMedia'] = floor($diasI) . " dias e " . $cs . "h";
                        }
                        else
                        {
                            if ($diasI == 1)
                            {
                                //$arr2[$key][$key2]['totalMedia'] = floor($diasI) . " dia";
                                $arr2[$key][$key_2]['totalMedia'] = floor($diasI) . ' dia';
                            }
                            else
                            {
                                //$arr2[$key][$key2]['totalMedia'] = floor($diasI) . " dias ";
                                $arr2[$key][$key_2]['totalMedia'] = floor($diasI) . ' dias ';
                            }
                        }
                    }
                }
                else{
                    if($arr2[$key][$key_2]['totalVezesUtilizou'] != 0 ){
                        $arr2[$key][$key_2]['totalMedia'] = $arr2[$key][$key_2]['total'] / $arr2[$key][$key_2]['totalVezesUtilizou'];
                    }
                }

                if(isset($arr2[$key][$key_2]['calcularMediana'])){
                    $arr2[$key][$key_2]['mediana'] = $relatorios_table->mediana($arr2[$key][$key_2]['calcularMediana']);
                }
            }
        }
        //echo $count_pacient;
        //echo "<pre>";
        //print_r($arr2);
        return $arr2;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
