<?php
namespace App\Model\Table;

use App\Model\Entity\SuspectedMeProtocol;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * SuspectedMeProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $LaboratoryExaminations
 * @property \Cake\ORM\Association\HasMany $ObtainedOrgansFromCorpses
 * @property \Cake\ORM\Association\HasMany $SedativeDrugs
 * @property \Cake\ORM\Association\HasMany $SupplementaryExaminations
 * @property \Cake\ORM\Association\BelongsToMany $Organs
 * @property \Cake\ORM\Association\BelongsToMany $SedativeDrugs
 */
class SuspectedMeProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('suspected_me_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
        $this->hasMany('LaboratoryExaminations', [
            'foreignKey' => 'suspected_me_protocol_id',
        ]);
        $this->hasMany('ObtainedOrgansFromCorpses', [
            'foreignKey' => 'suspected_me_protocol_id',
        ]);
        $this->hasMany('SedativeDrugs', [
            'foreignKey' => 'suspected_me_protocol_id',
        ]);
        $this->hasMany('SupplementaryExaminations', [
            'foreignKey' => 'suspected_me_protocol_id',
        ]);

        $this->belongsToMany('Organs', [
            'foreignKey' => 'suspected_me_protocol_id',
            'targetForeignKey' => 'organ_id',
            'joinTable' => 'organs_suspected_me_protocols',
        ]);

        $this->belongsToMany('PotentialOrgans', [
            'foreignKey' => 'suspected_me_protocol_id',
            'targetForeignKey' => 'organ_id',
            'joinTable' => 'potential_organs_suspected_me_protocols',
        ]);

// $this->belongsToMany('SedativeDrugs', [

//     'foreignKey' => 'suspected_me_protocol_id',

//     'targetForeignKey' => 'sedative_drug_id',

//     'joinTable' => 'sedative_drugs_suspected_me_protocols'
        // ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('causa_do_coma');

        $validator
            ->boolean('uso_de_drogas_depressoras')
            ->allowEmpty('uso_de_drogas_depressoras');

        $validator
            ->boolean('hiportemia')
            ->allowEmpty('hiportemia');

        $validator
            ->allowEmpty('1_exame_data');

        $validator
        //->time('1_exame_hora')
        ->allowEmpty('1_exame_hora');

        $validator
            ->allowEmpty('1_exame_nome_medico');

        $validator
            ->allowEmpty('1_exame_endereco');

        $validator
            ->allowEmpty('1_exame_numero_conselho');

        $validator
            ->boolean('1_exame_coma_aperceptivo')
            ->allowEmpty('1_exame_coma_aperceptivo');

        $validator
            ->boolean('1_exame_ausencia_de_reflexo_corneo')
            ->allowEmpty('1_exame_ausencia_de_reflexo_corneo');

        $validator
            ->boolean('1_exame_ausencia_de_reflexos_oculocefalicos')
            ->allowEmpty('1_exame_ausencia_de_reflexos_oculocefalicos');

        $validator
            ->boolean('1_exame_ausencia_de_respostas_as_provas')
            ->allowEmpty('1_exame_ausencia_de_respostas_as_provas');

        $validator
            ->allowEmpty('2_exame_data');

        $validator
        //->time('2_exame_hora')
        ->allowEmpty('2_exame_hora');

        $validator
            ->allowEmpty('2_exame_nome_medico');

        $validator
            ->allowEmpty('2_exame_endereco');

        $validator
            ->allowEmpty('2_exame_numero_conselho');

        $validator
            ->allowEmpty('2_exame_coma_aperceptivo');

        $validator
            ->allowEmpty('2_exame_ausencia_de_reflexo_corneo');

        $validator
            ->allowEmpty('2_exame_ausencia_de_reflexos_oculocefalicos');

        $validator
            ->allowEmpty('2_exame_ausencia_de_respostas_as_provas');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->boolean('ausencia_reflexo_pupilar')
            ->allowEmpty('ausencia_reflexo_pupilar');

        $validator
            ->boolean('ausencia_reflexo_oculovestibular')
            ->allowEmpty('ausencia_reflexo_oculovestibular');

        $validator
            ->boolean('ausencia_reflexo_tosse')
            ->allowEmpty('ausencia_reflexo_tosse');

        $validator
            ->boolean('ausencia_drive')
            ->allowEmpty('ausencia_drive');

        $validator
            ->boolean('1_acolhimento_realizacao')
            ->allowEmpty('1_acolhimento_realizacao');

        $validator
            ->boolean('1_acolhimento_aceitam')
            ->allowEmpty('1_acolhimento_aceitam');

        $validator
            ->allowEmpty('1_acolhimento_motivo');

        $validator
            ->boolean('2_acolhimento_realizacao')
            ->allowEmpty('2_acolhimento_realizacao');

        $validator
            ->boolean('2_acolhimento_aceitam')
            ->allowEmpty('2_acolhimento_aceitam');

        $validator
            ->allowEmpty('2_acolhimento_motivo');

        $validator
            ->boolean('fechamento_exame_colhido')
            ->allowEmpty('fechamento_exame_colhido');

        $validator
        //->date('2_acolhimento_data')
        ->allowEmpty('2_acolhimento_data');

        $validator
        //->time('2_acolhimento_hora')
        ->allowEmpty('2_acolhimento_hora');

        $validator
        //->date('1_acolhimento_data')
        ->allowEmpty('1_acolhimento_data');

        $validator
        //->time('1_acolhimento_hora')
        ->allowEmpty('1_acolhimento_hora');

        $validator
        //->time('fechamento_exame_colhido_hora')
        ->allowEmpty('fechamento_exame_colhido_hora');

        $validator
        //->date('fechamento_exame_colhido_data')
        ->allowEmpty('fechamento_exame_colhido_data');

        $validator
            ->boolean('fechamento_encaminhado_exame')
            ->allowEmpty('fechamento_encaminhado_exame');

        $validator
        //->date('fechamento_encaminhado_exame_data')
        ->allowEmpty('fechamento_encaminhado_exame_data');

        $validator
        //->time('fechamento_encaminhado_exame_hora')
        ->allowEmpty('fechamento_encaminhado_exame_hora');

        $validator
            ->boolean('fechamento_solicitado_agendamento')
            ->allowEmpty('fechamento_solicitado_agendamento');

        $validator
        //->date('fechamento_solicitado_agendamento_data')
        ->allowEmpty('fechamento_solicitado_agendamento_data');

        $validator
        //->time('fechamento_solicitado_agendamento_hora')
        ->allowEmpty('fechamento_solicitado_agendamento_hora');

        $validator
            ->boolean('orgaos_doar_cornea')
            ->allowEmpty('orgaos_doar_cornea');

        $validator
            ->boolean('orgaos_doar_coracao')
            ->allowEmpty('orgaos_doar_coracao');

        $validator
            ->boolean('orgaos_doar_pulmoes')
            ->allowEmpty('orgaos_doar_pulmoes');

        $validator
            ->boolean('orgaos_doar_rins')
            ->allowEmpty('orgaos_doar_rins');

        $validator
            ->boolean('orgaos_doar_figado')
            ->allowEmpty('orgaos_doar_figado');

        $validator
            ->boolean('orgaos_doar_pancreas')
            ->allowEmpty('orgaos_doar_pancreas');

        $validator
            ->boolean('orgaos_doar_ossos')
            ->allowEmpty('orgaos_doar_ossos');

        $validator
            ->boolean('orgaos_doar_cadaver_cornea')
            ->allowEmpty('orgaos_doar_cadaver_cornea');

        $validator
            ->boolean('orgaos_doar_cadaver_rin')
            ->allowEmpty('orgaos_doar_cadaver_rin');

        $validator
            ->boolean('orgaos_doar_cadaver_ossos')
            ->allowEmpty('orgaos_doar_cadaver_ossos');

        $validator
        //->date('data_captcao_orgaos')
        ->allowEmpty('data_captcao_orgaos');

        $validator
        //->time('hora_captcao_orgaos')
        ->allowEmpty('hora_captcao_orgaos');

        $validator
        //->date('data_liberacao_corpo')
        ->allowEmpty('data_liberacao_corpo');

        $validator
        //->time('hora_liberacao_corpo')
        ->allowEmpty('hora_liberacao_corpo');

        $validator
            ->boolean('paciente_fez_uso_droga_sedativo')
            ->allowEmpty('paciente_fez_uso_droga_sedativo');

        $validator
            ->boolean('captacao_de_orgaos_cadaver')
            ->allowEmpty('captacao_de_orgaos_cadaver');

        $validator
            ->boolean('potencial_orgao_cornea')
            ->allowEmpty('potencial_orgao_cornea');

        $validator
            ->boolean('potencial_orgao_pulmao')
            ->allowEmpty('potencial_orgao_pulmao');

        $validator
            ->boolean('potencial_orgao_coracao')
            ->allowEmpty('potencial_orgao_coracao');

        $validator
            ->boolean('potencial_orgao_rin')
            ->allowEmpty('potencial_orgao_rin');

        $validator
            ->boolean('potencial_orgao_figado')
            ->allowEmpty('potencial_orgao_figado');

        $validator
            ->boolean('potencial_orgao_pancreas')
            ->allowEmpty('potencial_orgao_pancreas');

        $validator
            ->boolean('potencial_orgao_ossos')
            ->allowEmpty('potencial_orgao_ossos');

        $validator
            ->allowEmpty('1_pas');

        $validator
            ->allowEmpty('1_pad');

        $validator
            ->allowEmpty('1_temp');

        $validator
            ->allowEmpty('1_sato2');

        $validator
            ->allowEmpty('1_fc');

        $validator
            ->allowEmpty('1_fr');

        $validator
            ->allowEmpty('1_glicemia');

        $validator
            ->allowEmpty('1_pam');

        $validator
            ->boolean('1_ausencia_reflexo_pupilar')
            ->allowEmpty('1_ausencia_reflexo_pupilar');

        $validator
            ->boolean('1_ausencia_reflexo_oculovestibular')
            ->allowEmpty('1_ausencia_reflexo_oculovestibular');

        $validator
            ->boolean('1_ausencia_reflexo_tosse')
            ->allowEmpty('1_ausencia_reflexo_tosse');

        $validator
            ->boolean('1_ausencia_drive')
            ->allowEmpty('1_ausencia_drive');

        $validator
            ->allowEmpty('2_pas');

        $validator
            ->allowEmpty('2_pad');

        $validator
            ->allowEmpty('2_temp');

        $validator
            ->allowEmpty('2_sato2');

        $validator
            ->allowEmpty('2_fc');

        $validator
            ->allowEmpty('2_fr');

        $validator
            ->allowEmpty('2_glicemia');

        $validator
            ->allowEmpty('2_pam');

        $validator
            ->boolean('2_ausencia_reflexo_pupilar')
            ->allowEmpty('2_ausencia_reflexo_pupilar');

        $validator
            ->boolean('2_ausencia_reflexo_oculovestibular')
            ->allowEmpty('2_ausencia_reflexo_oculovestibular');

        $validator
            ->boolean('2_ausencia_reflexo_tosse')
            ->allowEmpty('2_ausencia_reflexo_tosse');

        $validator
            ->boolean('2_ausencia_drive')
            ->allowEmpty('2_ausencia_drive');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,

            'tot_pacientes' => 0, //total de pacientes

            'arr_paciente_proto_fechado_nao_doaram' => [], //total de pacientes que fecharam o protocolo e nao doarao orgaos
            'tot_paciente_proto_fechado_nao_doaram' => 0,

            'taxa_de_nao_captacao' => 0, //Taxa de não captação (valor absoluto e percentual de pacientes com fechamento de protocolo que não doaram orgãos/ frente a pacientes com confirmação de me)

            'arr_pacientes_com_protocolo_aberto' => [],
            'tot_pacientes_com_protocolo_aberto' => 0,
            'percen_pacientes_com_protocolo_aberto' => 0,

            'arr_pacientes_com_protocolo_fechado' => [],
            'tot_pacientes_com_protocolo_fechado' => 0,
            'percen_pacientes_com_protocolo_fechado' => 0,

            'percen_pacientes_iniciaram_protocolo' => 0,

            'arr_pacientes_suspeita_me' => [], //pacientes com suspeita de ME
            'tot_pacientes_suspeita_me' => 0,
            'percen_pacientes_suspeita_me' => 0,

            'media_pacientes_doaroes_pac_prot_fechado' => 0,
            'percen_pacientes_doaroes_pac_prot_fechado' => 0,

            'arr_pacientes_doadores' => [], //pacientes que doraram orgãos
            'tot_pacientes_doadores' => 0,
            'percen_pacientes_doadores' => 0,

            'media_pacientes_doaroes_pac_suspeita' => 0,
            'percen_pacientes_doaroes_pac_suspeita' => 0,

            'total_de_orgaos_captdados' => 0,

            'percen_orgaos_por_todos_pacientes' => 0,

            'percen_orgaos_por_pacientes_doadores' => 0,

            'orgaos' => [
                'cornea' => [
                    'name' => 'Córnea',
                    'tot' => 0,
                    'percen' => 0,
                ],
                'coracao' => [
                    'name' => 'Coração',
                    'tot' => 0,
                    'percen' => 0,
                ],
                'pulmao' => ['name' => 'Pulmão', 'tot' => 0, 'percen' => 0],
                'figado' => ['name' => 'Fígado', 'tot' => 0, 'percen' => 0],
                'rim' => ['name' => 'Rim', 'tot' => 0, 'percen' => 0],
                'pancreas' => ['name' => 'Pãncreas', 'tot' => 0, 'percen' => 0],
                'osso' => ['name' => 'Osso', 'tot' => 0, 'percen' => 0],
            ],

            'arr_tempo_fechamento_protocolo' => [],
            'tempo_min_fechamento_protocolo' => 0,
            'tempo_medio_fechamento_protocolo' => 0,
            'tempo_maximo_fechamento_protocolo' => 0,

            'arr_tempo_entre_exame_clinico' => [],
            'tempo_min_entre_exame_clinico' => 0,
            'tempo_medio_entre_exame_clinico' => 0,
            'tempo_maximo_entre_exame_clinico' => 0,

            'arr_tempo_entre_exa_medico_clinico' => [], //Tempo entre o 1º exame médico e o 1º exame complementar
            'tempo_min_entre_exa_medico_clinico' => 0,
            'tempo_medio_entre_exa_medico_clinico' => 0,
            'tempo_maximo_entre_exa_medico_clinico' => 0,

            'tot_exames_complementares' => 0,
            'exame_complementar' => [
                'eletroencefalograma' => ['tot' => 0, 'percen' => 0],
                'doppler' => ['tot' => 0, 'percen' => 0],
                'arteriografia' => ['tot' => 0, 'percen' => 0],
                'cintilografia' => ['tot' => 0, 'percen' => 0],
                'spect' => ['tot' => 0, 'percen' => 0],
                'potenciais' => ['tot' => 0, 'percen' => 0],
            ],

            'arr_pacientes_usaram_exam_comple' => [], //arr de pacientes que utilizaram exame complementar
            'tot_pacientes_usaram_exam_comple' => 0,

            'arr_pacientes_usaram_unico_exam_comple' => [], //arr de pacientes que utilizaram um unico exame complementar
            'tot_pacientes_usaram_unico_exam_comple' => 0,
            'percen_pacientes_usaram_unico_exam_comple' => 0,

            'tot_causa_do_coma' => 0,
            'causa_do_coma' => [
                'traumatismo' => [
                    'tot' => 0,
                    'percen' => 0,

                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,

                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],
                'hipoxemia' => [
                    'tot' => 0,
                    'percen' => 0,
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,

                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],
                'parada' => [
                    'tot' => 0,
                    'percen' => 0,
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,

                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],
                'ave_isquemico' => [
                    'tot' => 0,
                    'percen' => 0,
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,

                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],
                'ave_hemo' => [
                    'tot' => 0,
                    'percen' => 0,
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,

                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],
                'edema' => [
                    'tot' => 0,
                    'percen' => 0,
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,

                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],
                'hipertensao' => [
                    'tot' => 0,
                    'percen' => 0,
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,

                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],
                'tumores' => [
                    'tot' => 0,
                    'percen' => 0,
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,

                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],
                'overdose' => [
                    'tot' => 0,
                    'percen' => 0,
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,

                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],
                'hipoglicemia' => [
                    'tot' => 0,
                    'percen' => 0,
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,

                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],

            ],

            'idade_por_tempo_captacao' => [
                '0_10' => [
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,
                ],

                '11_20' => [
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,
                ],

                '21_30' => [
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,
                ],

                '31_40' => [
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,
                ],

                '41_50' => [
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,
                ],

                '51_60' => [
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,
                ],

                '61_70' => [
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,
                ],

                '71_80' => [
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,
                ],

                '81_90' => [
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,
                ],

                'maior_que_91' => [
                    'arr_tempo_fechamento_protocolo' => [],
                    'tempo_medio_fechamento_protocolo' => 0,
                ],
            ],

            'idade_orgaos_doados' => [
                '0_10' => [
                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],

                '11_20' => [
                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],

                '21_30' => [
                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],

                '31_40' => [
                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],

                '41_50' => [
                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],

                '51_60' => [
                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],

                '61_70' => [
                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],

                '71_80' => [
                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],

                '81_90' => [
                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],

                'maior_que_91' => [
                    'arr_qtd_orgaos_doados' => [],
                    'media_orgaos_doados' => 0,
                ],
            ],

            'arr_tempo_fechamento_protocolo_e_captacao' => [],
            'min_tempo_fechamento_protocolo_e_captacao' => 0,
            'medio_tempo_fechamento_protocolo_e_captacao' => 0,
            'max_tempo_fechamento_protocolo_e_captacao' => 0,

            'arr_tempo_de_confirmacao_da_me' => [],

            'tempo_confirmacao' => [
                'tempo_confirmacao_ate_12h' => [
                    'arr_paciente_sem_captacao' => [], 
                    'tot_paciente_sem_captacao' => 0,
                ],
                'tempo_confirmacao_12_a_24h' => [
                    'arr_paciente_sem_captacao' => [], 
                    'tot_paciente_sem_captacao' => 0,
                ],
                'tempo_confirmacao_24_a_36h' => [
                    'arr_paciente_sem_captacao' => [], 
                    'tot_paciente_sem_captacao' => 0,
                ],
                'tempo_confirmacao_36_a_48h' => [
                    'arr_paciente_sem_captacao' => [], 
                    'tot_paciente_sem_captacao' => 0,
                ],
                'tempo_confirmacao_48_a_60h' => [
                    'arr_paciente_sem_captacao' => [], 
                    'tot_paciente_sem_captacao' => 0,
                ],
                'tempo_confirmacao_60_a_72h' => [
                    'arr_paciente_sem_captacao' => [], 
                    'tot_paciente_sem_captacao' => 0,
                ],
                'tempo_confirmacao_maior_72h' => [
                    'arr_paciente_sem_captacao' => [], 
                    'tot_paciente_sem_captacao' => 0,
                ],
            ],

            'saps' => [
                'tempo_confirmacao_ate_12h' => [
                    '0_10' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],

                'tempo_confirmacao_12_a_24h' => [
                    '0_10' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_confirmacao_24_a_36h' => [
                    '0_10' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_confirmacao_36_a_48h' => [
                    '0_10' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_confirmacao_48_a_60h' => [

                    '0_10' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_confirmacao_60_a_72h' => [
                    '0_10' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_confirmacao_maior_72h' => [

                    '0_10' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                
                'tempo_captacao_ate_12h' => [
                    '0_10' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => 'Até 12h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_captacao_12_a_24h' => [
                    '0_10' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => '12h a 24h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_captacao_24_a_36h' => [
                    '0_10' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => '24h a 36h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_captacao_36_a_48h' => [
                    '0_10' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => '36h a 48h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_captacao_48_a_60h' => [

                    '0_10' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => '48h a 60h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_captacao_60_a_72h' => [

                    '0_10' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => '60h a 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],
                'tempo_captacao_maior_72h' => [

                    '0_10' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '11_20' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '21_30' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '31_40' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                    '41_50' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '51_60' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '61_70' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '71_80' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],

                    '81_90' => [
                        'name' => 'Maior que 72h',
                        'arr_pacientes' => [],
                        'tot' => 0,
                        'percen' => 0,
                    ],
                ],

            ],

            'curb' => [
                'tempo_confirmacao_ate_12h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_confirmacao_12_a_24h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_confirmacao_24_a_36h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_confirmacao_36_a_48h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_confirmacao_48_a_60h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],

                'tempo_confirmacao_60_a_72h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],

                'tempo_confirmacao_maior_72h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],


                'tempo_captacao_ate_12h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_captacao_12_a_24h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_captacao_24_a_36h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_captacao_36_a_48h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_captacao_48_a_60h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],

                'tempo_captacao_60_a_72h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],

                'tempo_captacao_maior_72h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '1' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '2' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '3' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '5' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                
                
            ],
            'sofa' => [
                'tempo_confirmacao_ate_12h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_confirmacao_12_a_24h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_confirmacao_24_a_36h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_confirmacao_36_a_48h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_confirmacao_48_a_60h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],

                'tempo_confirmacao_60_a_72h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],

                'tempo_confirmacao_maior_72h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_captacao_ate_12h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_captacao_12_a_24h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_captacao_24_a_36h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_captacao_36_a_48h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],
                'tempo_captacao_48_a_60h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],

                'tempo_captacao_60_a_72h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],

                'tempo_captacao_maior_72h' => [
                    '0' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '4' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '8' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '12' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '16' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                    '20' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],

                    '24' => [
                        'arr_pacientes' => [],
                        'tot' => 0,
                    ],
                ],

            ],

            'arr_orgaos_temp_confirmacao_ate_12h' => [], // de orgaos captados com tempo  conf até 12h
            'media_orgaos_temp_confirmacao_ate_12h' => '0',

            'arr_orgaos_temp_confirmacao_13_ate_24h' => [],
            'media_orgaos_temp_confirmacao_13_ate_24h' => '0',

            'arr_orgaos_temp_confirmacao_25_ate_36h' => [],
            'media_orgaos_temp_confirmacao_25_ate_36h' => '0',

            'arr_orgaos_temp_confirmacao_37_ate_48h' => [],
            'media_orgaos_temp_confirmacao_37_ate_48h' => '0',

            'arr_orgaos_temp_confirmacao_49_ate_60h' => [],
            'media_orgaos_temp_confirmacao_49_ate_60h' => '0',

            'arr_orgaos_temp_confirmacao_61_ate_72h' => [],
            'media_orgaos_temp_confirmacao_61_ate_72h' => '0',

            'arr_orgaos_temp_captacao_ate_12h' => [], //total de orgaos captados com tempo  conf até 12h
            'media_orgaos_temp_captacao_ate_12h' => '0',

            'arr_orgaos_temp_captacao_13_ate_24h' => [],
            'media_orgaos_temp_captacao_13_ate_24h' => '0',

            'arr_orgaos_temp_captacao_25_ate_36h' => [],
            'media_orgaos_temp_captacao_25_ate_36h' => '0',

            'arr_orgaos_temp_captacao_37_ate_48h' => [],
            'media_orgaos_temp_captacao_37_ate_48h' => '0',

            'arr_orgaos_temp_captacao_49_ate_60h' => [],
            'media_orgaos_temp_captacao_49_ate_60h' => '0',

            'arr_orgaos_temp_captacao_61_ate_72h' => [],
            'media_orgaos_temp_captacao_61_ate_72h' => '0',

            'arr_orgaos_1_exam_comp' => [], // total de orgaos captados por exames complementares
            'media_orgaos_1_exam_comp' => '0',

            'arr_orgaos_2_exam_comp' => [],
            'media_orgaos_2_exam_comp' => '0',

            'arr_orgaos_3_exam_comp' => [],
            'media_orgaos_3_exam_comp' => '0',

            'arr_orgaos_4_exam_comp' => [],
            'media_orgaos_4_exam_comp' => '0',

            'arr_orgaos_5_exam_comp' => [],
            'media_orgaos_5_exam_comp' => '0',

            'arr_orgaos_6_exam_comp' => [],
            'media_orgaos_6_exam_comp' => '0',
        ];

        foreach ($hospitalizations as $hospitalization)
        {
            $data['tot_pacientes']++;
            $protocolo_aberto = true;
            $data_fechamento_protocolo = null;
            $data_confirmacao_me = null;
            $data_captacao_orgao = null;
            $nao_houve_captacao_de_orgaos = false;
            $tot_orgaos_doados = 0;
            $tempo_de_confirmacao = 0;
            $tot_exames_complementares = 0;

            foreach ($hospitalization["suspected_me_protocols"] as $key_1 => $protocol)
            {
                if (!in_array($hospitalization->id, $data['arr_pacientes_suspeita_me']))
                {
                    array_push($data['arr_pacientes_suspeita_me'], $hospitalization->id);
                    $data['tot_pacientes_suspeita_me']++;
                }

                //calc o tempo entre o primeiro e o segundo exame clínico
                if ($protocol['1_exame_data'] && $protocol['2_exame_data'])
                {
                    $data_exame_1 = new \DateTime($protocol['1_exame_data']->format('Y-m-d'));
                    $data_exame_2 = new \DateTime($protocol['2_exame_data']->format('Y-m-d'));
                    $days = $data_exame_1->diff($data_exame_2)->days;

                    array_push($data['arr_tempo_entre_exame_clinico'], $days);
                }

                //Tempo entre o 1º exame médico e o 1º exame complementar
                if ($protocol['1_exame_data'] &&
                    !empty($protocol['supplementary_examinations']) &&
                    $protocol['supplementary_examinations'][0]['data'])
                {
                    $data_exame_1 = new \DateTime($protocol['1_exame_data']->format('Y-m-d'));
                    $data_exame_2 = new \DateTime($protocol['supplementary_examinations'][0]['data']->format('Y-m-d'));
                    $days = $data_exame_1->diff($data_exame_2)->days;

                    array_push($data['arr_tempo_entre_exa_medico_clinico'], $days);
                }

                if ($protocol['me_confirmada'])
                {
                    $protocolo_aberto = false;
                    $data_fechamento_protocolo = $protocol['data_confirmacao'];
                    $data_confirmacao_me = $protocol['data_confirmacao'];
                }
                elseif ($protocol['nao_houve_captacao']) //verifica se o protocolo está fechado
                {
                    $protocolo_aberto = false;
                    $nao_houve_captacao_de_orgaos = true;
                    $data_fechamento_protocolo = $protocol['data_nao_houve_captacao'];

                    if ($protocol['data_nao_houve_captacao'] && $protocol['created'])
                    {
                        $data_suspeita_me = new \DateTime($protocol['created']->format('Y-m-d'));
                        $data_nao_captacao_orgao = new \DateTime($protocol['data_nao_houve_captacao']->format('Y-m-d'));
                        $days = $data_suspeita_me->diff($data_nao_captacao_orgao)->days;
                    }

                    array_push($data['arr_tempo_fechamento_protocolo'], $days);

                    if ($hospitalization['patient']['birthday'])
                    {
                        $this->calcCaptationTimeByAge($hospitalization['patient']['birthday'], $days, $data);
                    }

                    switch ($exam['tipo_exame'])
                    {
                        case 'Eletroencefalograma':
                            array_push($data['exame_complementar']['eletroencefalograma']['arr_tempo_fechamento_protocolo'], $days);
                            break;

                        case 'Doppler Transcraniano':
                            array_push($data['exame_complementar']['doppler']['arr_tempo_fechamento_protocolo'], $days);

                            break;

                        case 'Arteriografia Cerebral':
                            array_push($data['exame_complementar']['arteriografia']['arr_tempo_fechamento_protocolo'], $days);

                            break;

                        case 'Cintilografia Cerebral':
                            array_push($data['exame_complementar']['cintilografia']['arr_tempo_fechamento_protocolo'], $days);

                            break;

                        case 'SPECT':
                            array_push($data['exame_complementar']['spect']['arr_tempo_fechamento_protocolo'], $days);
                            break;

                        case 'Potenciais Evocados':
                            array_push($data['exame_complementar']['potenciais']['arr_tempo_fechamento_protocolo'], $days);
                            break;
                    }
                }
                elseif (!empty($protocol['organs']))
                {

                    if ($protocol['data_captcao_orgaos'] && $protocol['created'])
                    {
                        $data_captacao_orgao = $protocol['data_captcao_orgaos'];
                        $data_suspeita_me = new \DateTime($protocol['created']->format('Y-m-d'));
                        $data_captacao_orgao = new \DateTime($protocol['data_captcao_orgaos']->format('Y-m-d'));
                        $days = $data_suspeita_me->diff($data_captacao_orgao)->days;

                        array_push($data['arr_tempo_fechamento_protocolo'], $days);

                        switch ($exam['tipo_exame'])
                        {
                            case 'Eletroencefalograma':
                                array_push($data['exame_complementar']['eletroencefalograma']['arr_tempo_fechamento_protocolo'], $days);
                                break;

                            case 'Doppler Transcraniano':
                                array_push($data['exame_complementar']['doppler']['arr_tempo_fechamento_protocolo'], $days);

                                break;

                            case 'Arteriografia Cerebral':
                                array_push($data['exame_complementar']['arteriografia']['arr_tempo_fechamento_protocolo'], $days);

                                break;

                            case 'Cintilografia Cerebral':
                                array_push($data['exame_complementar']['cintilografia']['arr_tempo_fechamento_protocolo'], $days);

                                break;

                            case 'SPECT':
                                array_push($data['exame_complementar']['spect']['arr_tempo_fechamento_protocolo'], $days);
                                break;

                            case 'Potenciais Evocados':
                                array_push($data['exame_complementar']['potenciais']['arr_tempo_fechamento_protocolo'], $days);
                                break;
                        }

                        $tempo_de_captacao = $data_suspeita_me->diff($data_captacao_orgao);
                        $tempo_de_captacao = ($tempo_de_captacao->days * 24) + $tempo_de_captacao->h;
                        $tot_orgaos_doados = count($protocol['organs']);

                        if ($tempo_de_captacao <= 12)
                        {
                            array_push($data['arr_orgaos_temp_captacao_ate_12h'], $tot_orgaos_doados);
                        }
                        elseif ($tempo_de_captacao <= 24)
                        {
                            array_push($data['arr_orgaos_temp_captacao_13_ate_24h'], $tot_orgaos_doados);
                        }
                        elseif ($tempo_de_captacao <= 36)
                        {
                            array_push($data['arr_orgaos_temp_captacao_25_ate_36h'], $tot_orgaos_doados);
                        }
                        elseif ($tempo_de_captacao <= 48)
                        {
                            array_push($data['arr_orgaos_temp_captacao_37_ate_48h'], $tot_orgaos_doados);
                        }
                        elseif ($tempo_de_captacao <= 60)
                        {
                            array_push($data['arr_orgaos_temp_captacao_49_ate_60h'], $tot_orgaos_doados);
                        }
                        elseif ($tempo_de_captacao <= 72)
                        {
                            array_push($data['arr_orgaos_temp_captacao_61_ate_72h'], $tot_orgaos_doados);
                        }
                    }
                }

                foreach ($protocol['organs'] as $organ)
                {
                    $tot_orgaos_doados++;
                    $protocolo_aberto = false;
                    $data_fechamento_protocolo = $protocol['data_captcao_orgaos'];
                    $data['total_de_orgaos_captdados']++;

                    if ($hospitalization['patient']['birthday'])
                    {
                        $this->calcOrgansDonatedByAge($hospitalization['patient']['birthday'], 1, $data);
                    }

                    if (!in_array($hospitalization->id, $data['arr_pacientes_doadores']))
                    {
                        array_push($data['arr_pacientes_doadores'], $hospitalization->id);
                        $data['tot_pacientes_doadores']++;
                    }

                    switch ($organ['nome'])
                    {
                        case 'Córnea':
                            $data['orgaos']['cornea']['tot']++;
                            break;

                        case 'Coração':
                            $data['orgaos']['coracao']['tot']++;
                            break;

                        case 'Pulmão':
                            $data['orgaos']['pulmao']['tot']++;
                            break;

                        case 'Fígado':
                            $data['orgaos']['figado']['tot']++;
                            break;

                        case 'Rim':
                            $data['orgaos']['rim']['tot']++;
                            break;

                        case 'Pãncreas':
                            $data['orgaos']['pancreas']['tot']++;
                            break;

                        case 'Osso':
                            $data['orgaos']['osso']['tot']++;
                            break;
                    }
                }

                foreach ($protocol['supplementary_examinations'] as $exam)
                {
                    $data['tot_exames_complementares']++;
                    $tot_exames_complementares++;

                    if ($exam['me_confirmada'])
                    {
                        $protocolo_aberto = false;
                        $data_fechamento_protocolo = $exam['data_confirmacao'];
                        $data_confirmacao_me = $exam['data_confirmacao'];
                    }

                    if (!in_array($hospitalization->id, $data['arr_pacientes_usaram_exam_comple']))
                    {
                        array_push($data['arr_pacientes_usaram_exam_comple'], $hospitalization->id);
                        $data['tot_pacientes_usaram_exam_comple']++;
                    }

                    switch ($exam['tipo_exame'])
                    {
                        case 'Eletroencefalograma':
                            $data['exame_complementar']['eletroencefalograma']['tot']++;
                            break;

                        case 'Doppler Transcraniano':
                            $data['exame_complementar']['doppler']['tot']++;
                            break;

                        case 'Arteriografia Cerebral':
                            $data['exame_complementar']['arteriografia']['tot']++;
                            break;

                        case 'Cintilografia Cerebral':
                            $data['exame_complementar']['cintilografia']['tot']++;
                            break;

                        case 'SPECT':
                            $data['exame_complementar']['spect']['tot']++;
                            break;

                        case 'Potenciais Evocados':
                            $data['exame_complementar']['potenciais']['tot']++;
                            break;
                    }
                }

                if ($data_confirmacao_me)
                {
                    $data_confirmacao_me = new \DateTime($data_confirmacao_me->format('Y-m-d'));
                    $data_inicio_protocolo = new \DateTime($protocol['created']->format('Y-m-d'));
                    $interval = $data_inicio_protocolo->diff($data_confirmacao_me);
                    $interval = ($interval->days * 24) + $interval->h;

                    $tempo_de_confirmacao = $interval;
                    array_push($data['arr_tempo_de_confirmacao_da_me'], $interval);
                }

                if ($tempo_de_confirmacao <= 12)
                {
                    array_push($data['arr_orgaos_temp_confirmacao_ate_12h'], $tot_orgaos_doados);
                }
                elseif ($tempo_de_confirmacao <= 24)
                {
                    array_push($data['arr_orgaos_temp_confirmacao_13_ate_24h'], $tot_orgaos_doados);
                }
                elseif ($tempo_de_confirmacao <= 36)
                {
                    array_push($data['arr_orgaos_temp_confirmacao_25_ate_36h'], $tot_orgaos_doados);
                }
                elseif ($tempo_de_confirmacao <= 48)
                {
                    array_push($data['arr_orgaos_temp_confirmacao_37_ate_48h'], $tot_orgaos_doados);
                }
                elseif ($tempo_de_confirmacao <= 60)
                {
                    array_push($data['arr_orgaos_temp_confirmacao_49_ate_60h'], $tot_orgaos_doados);
                }
                elseif ($tempo_de_confirmacao <= 72)
                {
                    array_push($data['arr_orgaos_temp_confirmacao_61_ate_72h'], $tot_orgaos_doados);
                }

                if ($tot_orgaos_doados > 0 && $tot_exames_complementares > 0)
                {
                    if ($tot_orgaos_doados <= 6)
                    {
                        $index = 'arr_orgaos_' . $tot_orgaos_doados . '_exam_comp';
                        array_push($data[$index], $tot_orgaos_doados);
                    }
                }

                if ($nao_houve_captacao_de_orgaos)
                {
                    $tempo_de_confirmacao_index = null;

                    if ($tempo_de_confirmacao <= 12)
                    {
                        $tempo_de_confirmacao_index = 'tempo_confirmacao_ate_12h';
                    }
                    elseif ($tempo_de_confirmacao <= 24)
                    {
                        $tempo_de_confirmacao_index = 'tempo_confirmacao_12_a_24h';
                    }
                    elseif ($tempo_de_confirmacao <= 36)
                    {
                        $tempo_de_confirmacao_index = 'tempo_confirmacao_24_a_36h';
                    }
                    elseif ($tempo_de_confirmacao <= 48)
                    {
                        $tempo_de_confirmacao_index = 'tempo_confirmacao_36_a_48h';
                    }
                    elseif ($tempo_de_confirmacao <= 60)
                    {
                        $tempo_de_confirmacao_index = 'tempo_confirmacao_48_a_60h';
                    }
                    elseif ($tempo_de_confirmacao <= 72)
                    {
                        $tempo_de_confirmacao_index = 'tempo_confirmacao_60_a_72h';
                    }
                    elseif ($tempo_de_confirmacao > 72)
                    {
                        $tempo_de_confirmacao_index = 'tempo_confirmacao_maior_72h';
                    }

                    if ($tempo_de_confirmacao_index)
                    {
                        if (!in_array($hospitalization->id, $data['tempo_confirmacao'][$tempo_de_confirmacao_index]['arr_paciente_sem_captacao']))
                        {
                            array_push($data['tempo_confirmacao'][$tempo_de_confirmacao_index]['arr_paciente_sem_captacao'], $hospitalization->id);
                            $data['tempo_confirmacao'][$tempo_de_confirmacao_index]['tot_paciente_sem_captacao']++;
                        }
                    }
                }
            } //end foreach $hospitalization["suspected_me_protocols"]

            if ($protocolo_aberto && !empty($hospitalization["suspected_me_protocols"]))
            {
                if (!in_array($hospitalization->id, $data['arr_pacientes_com_protocolo_aberto']))
                {
                    array_push($data['arr_pacientes_com_protocolo_aberto'], $hospitalization->id);
                    $data['tot_pacientes_com_protocolo_aberto']++;
                }
            }
            elseif (!empty($hospitalization["suspected_me_protocols"]))
            {
                if (!in_array($hospitalization->id, $data['arr_pacientes_com_protocolo_fechado']))
                {
                    array_push($data['arr_pacientes_com_protocolo_fechado'], $hospitalization->id);
                    $data['tot_pacientes_com_protocolo_fechado']++;
                }

                $data['tot_causa_do_coma']++;

                if (count($protocol['supplementary_examinations']) == 1)
                {
                    if (!in_array($hospitalization->id, $data['arr_pacientes_usaram_unico_exam_comple']))
                    {
                        array_push($data['arr_pacientes_usaram_unico_exam_comple'], $hospitalization->id);
                        $data['tot_pacientes_usaram_unico_exam_comple']++;
                    }
                }

                if ($tot_orgaos_doados == 0)
                {
                    if (!in_array($hospitalization->id, $data['arr_paciente_proto_fechado_nao_doaram']))
                    {
                        array_push($data['arr_paciente_proto_fechado_nao_doaram'], $hospitalization->id);
                        $data['tot_paciente_proto_fechado_nao_doaram']++;
                    }
                }

                switch ($protocol['causa_do_coma'])
                {
                    case 'Traumatismo Craniano':
                        $data['causa_do_coma']['traumatismo']['tot']++;
                        array_push($data['causa_do_coma']['traumatismo']['arr_qtd_orgaos_doados'], $tot_orgaos_doados);
                        break;

                    case 'Hipoxemia':
                        $data['causa_do_coma']['hipoxemia']['tot']++;
                        array_push($data['causa_do_coma']['hipoxemia']['arr_qtd_orgaos_doados'], $tot_orgaos_doados);
                        break;

                    case 'Parada Cardiorrespiratória':
                        $data['causa_do_coma']['parada']['tot']++;
                        array_push($data['causa_do_coma']['parada']['arr_qtd_orgaos_doados'], $tot_orgaos_doados);
                        break;

                    case 'AVE Isquêmico':
                        $data['causa_do_coma']['ave_isquemico']['tot']++;
                        array_push($data['causa_do_coma']['ave_isquemico']['arr_qtd_orgaos_doados'], $tot_orgaos_doados);
                        break;

                    case 'AVE Hemorrágico':
                        $data['causa_do_coma']['ave_hemo']['tot']++;
                        array_push($data['causa_do_coma']['ave_hemo']['arr_qtd_orgaos_doados'], $tot_orgaos_doados);
                        break;

                    case 'Edema Cerebral':
                        $data['causa_do_coma']['edema']['tot']++;
                        array_push($data['causa_do_coma']['edema']['arr_qtd_orgaos_doados'], $tot_orgaos_doados);
                        break;

                    case 'Hipertensão Intracraniana':
                        $data['causa_do_coma']['hipertensao']['tot']++;
                        array_push($data['causa_do_coma']['overdose']['arr_qtd_orgaos_doados'], $tot_orgaos_doados);
                        break;

                    case 'Tumores Cerebrais':
                        $data['causa_do_coma']['tumores']['tot']++;
                        array_push($data['causa_do_coma']['tumores']['arr_qtd_orgaos_doados'], $tot_orgaos_doados);
                        break;

                    case 'Overdose':
                        $data['causa_do_coma']['overdose']['tot']++;
                        array_push($data['causa_do_coma']['overdose']['arr_qtd_orgaos_doados'], $tot_orgaos_doados);
                        break;

                    case 'Hipoglicemia':
                        $data['causa_do_coma']['hipoglicemia']['tot']++;
                        array_push($data['causa_do_coma']['hipoglicemia']['arr_qtd_orgaos_doados'], $tot_orgaos_doados);
                        break;
                }
            }            

            foreach ($hospitalization['saps_iii_scores'] as $saps)
            {
                $pontuation_index = null;
                $tempo_de_confirmacao_index = null;
                if ($saps['pontuation'] <= 10)
                {
                    $pontuation_index = '0_10';
                }
                elseif ($saps['pontuation'] <= 20)
                {
                    $pontuation_index = '11_20';
                }
                elseif ($saps['pontuation'] <= 30)
                {
                    $pontuation_index = '21_30';
                }
                elseif ($saps['pontuation'] <= 40)
                {
                    $pontuation_index = '31_40';
                }
                elseif ($saps['pontuation'] <= 50)
                {
                    $pontuation_index = '41_50';
                }
                elseif ($saps['pontuation'] <= 50)
                {
                    $pontuation_index = '41_50';
                }
                elseif ($saps['pontuation'] <= 60)
                {
                    $pontuation_index = '51_60';
                }
                elseif ($saps['pontuation'] <= 70)
                {
                    $pontuation_index = '61_70';
                }
                elseif ($saps['pontuation'] <= 80)
                {
                    $pontuation_index = '71_80';
                }
                elseif ($saps['pontuation'] <= 90)
                {
                    $pontuation_index = '81_90';
                }

                if ($tempo_de_confirmacao <= 12)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_ate_12h';
                }
                elseif ($tempo_de_confirmacao <= 24)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_12_a_24h';
                }
                elseif ($tempo_de_confirmacao <= 36)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_24_a_36h';
                }
                elseif ($tempo_de_confirmacao <= 48)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_36_a_48h';
                }
                elseif ($tempo_de_confirmacao <= 60)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_48_a_60h';
                }
                elseif ($tempo_de_confirmacao <= 72)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_60_a_72h';
                }
                elseif ($tempo_de_confirmacao > 72)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_maior_72h';
                }

                if ($pontuation_index && $tempo_de_confirmacao_index)
                {
                    if (!in_array($hospitalization->id, $data['saps'][$tempo_de_confirmacao_index][$pontuation_index]['arr_pacientes']))
                    {
                        array_push($data['saps'][$tempo_de_confirmacao_index][$pontuation_index]['arr_pacientes'], $hospitalization->id);
                        $data['saps'][$tempo_de_confirmacao_index][$pontuation_index]['tot']++;
                    }
                }
            }

            foreach ($hospitalization['curb_scores'] as $curb)
            {
                $tempo_de_captacao = null;
                $data_captacao_orgao = null;
                if ($data_captacao_orgao)
                {
                    $data_captacao_orgao = new \DateTime($data_captacao_orgao->format('Y-m-d'));
                    $data_inicio_protocolo = new \DateTime($protocol['created']->format('Y-m-d'));
                    $tempo_de_captacao = $data_inicio_protocolo->diff($data_captacao_orgao);
                    $tempo_de_captacao = ($tempo_de_captacao->days * 24) + $tempo_de_captacao->h;
                }
                
                $pontuation_index = null;
                $tempo_de_confirmacao_index = null;

                if ($curb['pontuation'] <= 0)
                {
                    $pontuation_index = '0';
                }
                elseif ($curb['pontuation'] <= 1)
                {
                    $pontuation_index = '1';
                }
                elseif ($curb['pontuation'] <= 2)
                {
                    $pontuation_index = '2';
                }
                elseif ($curb['pontuation'] <= 3)
                {
                    $pontuation_index = '3';
                }
                elseif ($curb['pontuation'] <= 4)
                {
                    $pontuation_index = '4';
                }
                elseif ($curb['pontuation'] <= 5)
                {
                    $pontuation_index = '5';
                }

                if ($tempo_de_confirmacao <= 12)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_ate_12h';
                }
                elseif ($tempo_de_confirmacao <= 24)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_12_a_24h';
                }
                elseif ($tempo_de_confirmacao <= 36)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_24_a_36h';
                }
                elseif ($tempo_de_confirmacao <= 48)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_36_a_48h';
                }
                elseif ($tempo_de_confirmacao <= 60)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_48_a_60h';
                }
                elseif ($tempo_de_confirmacao <= 72)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_60_a_72h';
                }
                elseif ($tempo_de_confirmacao > 72)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_maior_72h';
                }

                if ($tempo_de_captacao <= 12)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_ate_12h';
                }
                elseif ($tempo_de_captacao <= 24)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_12_a_24h';
                }
                elseif ($tempo_de_captacao <= 36)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_24_a_36h';
                }
                elseif ($tempo_de_captacao <= 48)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_36_a_48h';
                }
                elseif ($tempo_de_captacao <= 60)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_48_a_60h';
                }
                elseif ($tempo_de_captacao <= 72)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_60_a_72h';
                }
                elseif ($tempo_de_captacao > 72)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_maior_72h';
                }

                if ($pontuation_index && $tempo_de_confirmacao_index)
                {
                    if (!in_array($hospitalization->id, $data['curb'][$tempo_de_confirmacao_index][$pontuation_index]['arr_pacientes']))
                    {
                        array_push($data['curb'][$tempo_de_confirmacao_index][$pontuation_index]['arr_pacientes'], $hospitalization->id);
                        $data['curb'][$tempo_de_confirmacao_index][$pontuation_index]['tot']++;
                    }
                }
            }

            foreach ($hospitalization['sofa_escores'] as $sofa)
            {
                $tempo_de_captacao = null;
                $data_captacao_orgao = null;

                if ($data_captacao_orgao)
                {
                    $data_captacao_orgao = new \DateTime($data_captacao_orgao->format('Y-m-d'));
                    $data_inicio_protocolo = new \DateTime($protocol['created']->format('Y-m-d'));
                    $tempo_de_captacao = $data_inicio_protocolo->diff($data_captacao_orgao);
                    $tempo_de_captacao = ($tempo_de_captacao->days * 24) + $tempo_de_captacao->h;
                }

                if ($sofa['pontuation'] == 0)
                {
                    $pontuation_index = '0';
                }
                elseif ($sofa['pontuation'] <= 4)
                {
                    $pontuation_index = '4';
                }
                elseif ($sofa['pontuation'] <= 8)
                {
                    $pontuation_index = '8';
                }
                elseif ($sofa['pontuation'] <= 12)
                {
                    $pontuation_index = '12';
                }
                elseif ($sofa['pontuation'] <= 16)
                {
                    $pontuation_index = '16';
                }
                elseif ($sofa['pontuation'] <= 20)
                {
                    $pontuation_index = '20';
                }
                elseif ($sofa['pontuation'] <= 24)
                {
                    $pontuation_index = '24';
                }

                if ($tempo_de_confirmacao <= 12)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_ate_12h';
                }
                elseif ($tempo_de_confirmacao <= 24)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_12_a_24h';
                }
                elseif ($tempo_de_confirmacao <= 36)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_24_a_36h';
                }
                elseif ($tempo_de_confirmacao <= 48)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_36_a_48h';
                }
                elseif ($tempo_de_confirmacao <= 60)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_48_a_60h';
                }
                elseif ($tempo_de_confirmacao <= 72)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_60_a_72h';
                }
                elseif ($tempo_de_confirmacao > 72)
                {
                    $tempo_de_confirmacao_index = 'tempo_confirmacao_maior_72h';
                }

                if ($tempo_de_captacao <= 12)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_ate_12h';
                }
                elseif ($tempo_de_captacao <= 24)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_12_a_24h';
                }
                elseif ($tempo_de_captacao <= 36)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_24_a_36h';
                }
                elseif ($tempo_de_captacao <= 48)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_36_a_48h';
                }
                elseif ($tempo_de_captacao <= 60)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_48_a_60h';
                }
                elseif ($tempo_de_captacao <= 72)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_60_a_72h';
                }
                elseif ($tempo_de_captacao > 72)
                {
                    $tempo_de_captacao_index = 'tempo_captacao_maior_72h';
                }

                if ($pontuation_index && $tempo_de_confirmacao_index)
                {
                    if (!in_array($hospitalization->id, $data['sofa'][$tempo_de_confirmacao_index][$pontuation_index]['arr_pacientes']))
                    {
                        array_push($data['sofa'][$tempo_de_confirmacao_index][$pontuation_index]['arr_pacientes'], $hospitalization->id);
                        $data['sofa'][$tempo_de_confirmacao_index][$pontuation_index]['tot']++;
                    }
                }

                if ($pontuation_index && $tempo_de_captacao_index)
                {
                    if (!in_array($hospitalization->id, $data['sofa'][$tempo_de_captacao_index][$pontuation_index]['arr_pacientes']))
                    {
                        array_push($data['sofa'][$tempo_de_captacao_index][$pontuation_index]['arr_pacientes'], $hospitalization->id);
                        $data['sofa'][$tempo_de_captacao_index][$pontuation_index]['tot']++;
                    }
                }
            }
        }//end here


        if ($data['tot_pacientes_suspeita_me'] > 0
            && $data['tot_pacientes'] > 0)
        {
            $data['percen_pacientes_suspeita_me'] = ($data['tot_pacientes_suspeita_me'] * 100) / $data['tot_pacientes'];
            $data['percen_pacientes_suspeita_me'] = round($data['percen_pacientes_suspeita_me'], 2);
        }

        if ($data['tot_pacientes_com_protocolo_aberto'] > 0 && $data['tot_pacientes_suspeita_me'] > 0)
        {
            $data['percen_pacientes_iniciaram_protocolo'] = round(($data['tot_pacientes_com_protocolo_aberto'] / $data['tot_pacientes_suspeita_me']) * 100, 2);
        }

        if ($data['tot_pacientes_com_protocolo_fechado'] > 0 && $data['tot_pacientes_suspeita_me'] > 0)
        {
            $data['percen_pacientes_com_protocolo_fechado'] = ($data['tot_pacientes_com_protocolo_fechado'] * 100) / $data['tot_pacientes_suspeita_me'];
            $data['percen_pacientes_com_protocolo_fechado'] = round($data['percen_pacientes_com_protocolo_fechado'], 2);
        }

        if ($data['total_de_orgaos_captdados'] > 0 && $data['tot_pacientes_doadores'] > 0)
        {
            $data['percen_pacientes_doadores'] = round(($data['total_de_orgaos_captdados'] / $data['tot_pacientes_doadores']) * 100, 2);
        }

        if ($data['total_de_orgaos_captdados'] > 0 && $data['tot_pacientes'] > 0)
        {
            $data['percen_orgaos_por_todos_pacientes'] = ($data['total_de_orgaos_captdados'] * 100) / $data['tot_pacientes'];
            $data['percen_orgaos_por_todos_pacientes'] = round($data['percen_orgaos_por_todos_pacientes'], 2);
        }

        if ($data['total_de_orgaos_captdados'] > 0 && $data['tot_pacientes_doadores'] > 0)
        {
            $data['percen_orgaos_por_pacientes_doadores'] = ($data['total_de_orgaos_captdados'] * 100) / $data['tot_pacientes_doadores'];
            $data['percen_orgaos_por_pacientes_doadores'] = round($data['percen_orgaos_por_pacientes_doadores'], 2);
        }

        foreach ($data['orgaos'] as $key => $value)
        {
            if ($value['tot'] > 0)
            {
                $data['orgaos'][$key]['percen'] = round(($value['tot'] * 100) / $data['total_de_orgaos_captdados'], 2);
            }
        }

        if (count($data['arr_tempo_fechamento_protocolo']) > 0)
        {
            $data['tempo_min_fechamento_protocolo'] = min($data['arr_tempo_fechamento_protocolo']);
            $data['tempo_medio_fechamento_protocolo'] = $calc_obj->calc_average($data['arr_tempo_fechamento_protocolo']);
            $data['tempo_maximo_fechamento_protocolo'] = max($data['arr_tempo_fechamento_protocolo']);
        }

        if (count($data['arr_tempo_entre_exame_clinico']) > 0)
        {
            $data['tempo_min_entre_exame_clinico'] = min($data['arr_tempo_entre_exame_clinico']);
            $data['tempo_medio_entre_exame_clinico'] = $calc_obj->calc_average($data['arr_tempo_entre_exame_clinico']);
            $data['tempo_maximo_entre_exame_clinico'] = max($data['arr_tempo_entre_exame_clinico']);
        }

        if (count($data['arr_tempo_entre_exa_medico_clinico']) > 0)
        {
            $data['tempo_min_entre_exa_medico_clinico'] = min($data['arr_tempo_entre_exa_medico_clinico']);
            $data['tempo_medio_entre_exa_medico_clinico'] = $calc_obj->calc_average($data['arr_tempo_entre_exa_medico_clinico']);
            $data['tempo_maximo_entre_exa_medico_clinico'] = max($data['arr_tempo_entre_exa_medico_clinico']);
        }

        foreach ($data['exame_complementar'] as $key => $exam)
        {
            if ($value['tot'] > 0)
            {
                $data['exame_complementar'][$key]['percen'] = ($value['tot'] * 100) / $data['tot_exames_complementares'];
                $data['exame_complementar'][$key]['percen'] = round($data['exame_complementar'][$key]['percen'], 2);
            }
        }

        if ($data['tot_pacientes_usaram_unico_exam_comple'] > 0 && $data['tot_pacientes_usaram_exam_comple'] > 0)
        {
            $data['percen_pacientes_usaram_unico_exam_comple'] = ($data['tot_pacientes_usaram_unico_exam_comple'] * 100) / $data['tot_pacientes_usaram_exam_comple'];
            $data['percen_pacientes_usaram_unico_exam_comple'] = round($data['percen_pacientes_usaram_unico_exam_comple'], 2);
        }

        foreach ($data['causa_do_coma'] as $key => $causa)
        {
            if ($causa['tot'] > 0)
            {
                $data['causa_do_coma'][$key]['percen'] = ($causa['tot'] * 100) / $data['tot_causa_do_coma'];
                $data['causa_do_coma'][$key]['percen'] = round($data['causa_do_coma'][$key]['percen'], 2);
            }

            if (count($causa['arr_tempo_fechamento_protocolo']) > 0)
            {
                $data['causa_do_coma'][$key]['tempo_medio_fechamento_protocolo'] = $calc_obj->calc_average($causa['arr_tempo_fechamento_protocolo']);
            }

            if (count($causa['arr_qtd_orgaos_doados']) > 0)
            {
                $data['causa_do_coma'][$key]['media_orgaos_doados'] = $calc_obj->calc_average($causa['arr_qtd_orgaos_doados']);
            }
        }

        foreach ($data['idade_por_tempo_captacao'] as $key => $value)
        {
            if (count($value['arr_tempo_fechamento_protocolo']) > 0)
            {
                $data['idade_por_tempo_captacao'][$key]['tempo_medio_fechamento_protocolo'] = $calc_obj->calc_average($value['arr_tempo_fechamento_protocolo']);
            }
        }

        foreach ($data['idade_orgaos_doados'] as $key => $value)
        {
            if (count($value['arr_qtd_orgaos_doados']) > 0)
            {
                $data['idade_orgaos_doados'][$key]['media_orgaos_doados'] = $calc_obj->calc_average($value['arr_qtd_orgaos_doados']);
            }
        }

        if ($data['tot_paciente_proto_fechado_nao_doaram'] > 0 && $data['tot_pacientes_com_protocolo_fechado'] > 0)
        {
            $data['taxa_de_nao_captacao'] = ($data['tot_paciente_proto_fechado_nao_doaram'] * 100) / $data['tot_pacientes_com_protocolo_fechado'];
            $data['taxa_de_nao_captacao'] = round($data['taxa_de_nao_captacao'], 2);
        }

        if (count($data['arr_tempo_fechamento_protocolo_e_captacao']) > 0)
        {
            $data['medio_tempo_fechamento_protocolo_e_captacao'] = $calc_obj->calc_average($data['arr_tempo_fechamento_protocolo_e_captacao']);
            $data['min_tempo_fechamento_protocolo_e_captacao'] = min($data['arr_tempo_fechamento_protocolo_e_captacao']);
            $data['max_tempo_fechamento_protocolo_e_captacao'] = max($data['arr_tempo_fechamento_protocolo_e_captacao']);
        }

        if ($data['tot_pacientes_suspeita_me'] > 0 && $data['tot_pacientes_doadores'] > 0)
        {
            $data['media_pacientes_doaroes_pac_suspeita'] = round($data['tot_pacientes_doadores'] / $data['tot_pacientes_suspeita_me'], 2);

            $data['percen_pacientes_doaroes_pac_suspeita'] = ($data['tot_pacientes_doadores'] / $data['tot_pacientes_suspeita_me']) * 100;
            $data['percen_pacientes_doaroes_pac_suspeita'] = round($data['percen_pacientes_doaroes_pac_suspeita'], 2);
        }

        if ($data['tot_pacientes_com_protocolo_fechado'] > 0 && $data['tot_pacientes_doadores'] > 0)
        {
            $data['media_pacientes_doaroes_pac_prot_fechado'] = round($data['tot_pacientes_doadores'] / $data['tot_pacientes_com_protocolo_fechado'], 2);

            $data['percen_pacientes_doaroes_pac_prot_fechado'] = ($data['tot_pacientes_doadores'] / $data['tot_pacientes_com_protocolo_fechado']) * 100;
            $data['percen_pacientes_doaroes_pac_prot_fechado'] = round($data['percen_pacientes_doaroes_pac_prot_fechado'], 2);
        }

        $data['media_orgaos_temp_confirmacao_ate_12h'] = $calc_obj->calc_average($data['arr_orgaos_temp_confirmacao_ate_12h']);
        $data['media_orgaos_temp_confirmacao_13_ate_24h'] = $calc_obj->calc_average($data['arr_orgaos_temp_confirmacao_13_ate_24h']);
        $data['media_orgaos_temp_confirmacao_25_ate_36h'] = $calc_obj->calc_average($data['arr_orgaos_temp_confirmacao_25_ate_36h']);
        $data['media_orgaos_temp_confirmacao_37_ate_48h'] = $calc_obj->calc_average($data['arr_orgaos_temp_confirmacao_37_ate_48h']);
        $data['media_orgaos_temp_confirmacao_49_ate_60h'] = $calc_obj->calc_average($data['arr_orgaos_temp_confirmacao_49_ate_60h']);
        $data['media_orgaos_temp_confirmacao_61_ate_72h'] = $calc_obj->calc_average($data['arr_orgaos_temp_confirmacao_61_ate_72h']);

        $data['media_orgaos_temp_captacao_ate_12h'] = $calc_obj->calc_average($data['arr_orgaos_temp_captacao_ate_12h']);
        $data['media_orgaos_temp_captacao_13_ate_24h'] = $calc_obj->calc_average($data['arr_orgaos_temp_captacao_13_ate_24h']);
        $data['media_orgaos_temp_captacao_25_ate_36h'] = $calc_obj->calc_average($data['arr_orgaos_temp_captacao_25_ate_36h']);
        $data['media_orgaos_temp_captacao_37_ate_48h'] = $calc_obj->calc_average($data['arr_orgaos_temp_captacao_37_ate_48h']);
        $data['media_orgaos_temp_captacao_49_ate_60h'] = $calc_obj->calc_average($data['arr_orgaos_temp_captacao_49_ate_60h']);
        $data['media_orgaos_temp_captacao_61_ate_72h'] = $calc_obj->calc_average($data['arr_orgaos_temp_captacao_61_ate_72h']);

        $data['media_orgaos_1_exam_comp'] = $calc_obj->calc_average($data['arr_orgaos_1_exam_comp']);
        $data['media_orgaos_2_exam_comp'] = $calc_obj->calc_average($data['arr_orgaos_2_exam_comp']);
        $data['media_orgaos_3_exam_comp'] = $calc_obj->calc_average($data['arr_orgaos_3_exam_comp']);
        $data['media_orgaos_4_exam_comp'] = $calc_obj->calc_average($data['arr_orgaos_4_exam_comp']);
        $data['media_orgaos_5_exam_comp'] = $calc_obj->calc_average($data['arr_orgaos_5_exam_comp']);
        $data['media_orgaos_6_exam_comp'] = $calc_obj->calc_average($data['arr_orgaos_6_exam_comp']);

        return $data;
    }

    private function calcCaptationTimeByAge($birthday, $time, &$data_arr)
    {
        $birthday = new \Datetime($birthday);
        $age = $birthday->diff(new DateTime('now'))->y;

        if ($age < 11) //0-10
        {
            array_push($data_arr['idade_por_tempo_captacao']['0_10']['arr_tempo_fechamento_protocolo'], $days);
        }
        elseif ($age < 21) //11 - 20
        {
            array_push($data_arr['idade_por_tempo_captacao']['11_20']['arr_tempo_fechamento_protocolo'], $days);
        }
        elseif ($age < 31) //21 - 30
        {
            array_push($data_arr['idade_por_tempo_captacao']['21_30']['arr_tempo_fechamento_protocolo'], $days);
        }
        elseif ($age < 41) //31 - 40
        {
            array_push($data_arr['idade_por_tempo_captacao']['31_40']['arr_tempo_fechamento_protocolo'], $days);
        }
        elseif ($age < 51) //41 - 50
        {
            array_push($data_arr['idade_por_tempo_captacao']['41_50']['arr_tempo_fechamento_protocolo'], $days);
        }
        elseif ($age < 61) //51 - 60
        {
            array_push($data_arr['idade_por_tempo_captacao']['51_60']['arr_tempo_fechamento_protocolo'], $days);
        }
        elseif ($age < 71) //61 - 70
        {
            array_push($data_arr['idade_por_tempo_captacao']['61_70']['arr_tempo_fechamento_protocolo'], $days);
        }
        elseif ($age < 81) //71 - 80
        {
            array_push($data_arr['idade_por_tempo_captacao']['71_80']['arr_tempo_fechamento_protocolo'], $days);
        }
        elseif ($age < 91) //81 - 90
        {
            array_push($data_arr['idade_por_tempo_captacao']['81_90']['arr_tempo_fechamento_protocolo'], $days);
        }
        elseif ($age >= 91) // > 91
        {
            array_push($data_arr['idade_por_tempo_captacao']['maior_que_91']['arr_tempo_fechamento_protocolo'], $days);
        }
    }

    private function calcOrgansDonatedByAge($birthday, $sum_organs_donated, &$data_arr)
    {
        $birthday = new \Datetime($birthday);
        $age = $birthday->diff(new \DateTime('now'))->y;

        if ($age < 11) //0-10
        {
            array_push($data_arr['idade_orgaos_doados']['0_10']['arr_qtd_orgaos_doados'], $sum_organs_donated);
        }
        elseif ($age < 21) //11 - 20
        {
            array_push($data_arr['idade_orgaos_doados']['11_20']['arr_qtd_orgaos_doados'], $sum_organs_donated);
        }
        elseif ($age < 31) //21 - 30
        {
            array_push($data_arr['idade_orgaos_doados']['21_30']['arr_qtd_orgaos_doados'], $sum_organs_donated);
        }
        elseif ($age < 41) //31 - 40
        {
            array_push($data_arr['idade_orgaos_doados']['31_40']['arr_qtd_orgaos_doados'], $sum_organs_donated);
        }
        elseif ($age < 51) //41 - 50
        {
            array_push($data_arr['idade_orgaos_doados']['41_50']['arr_qtd_orgaos_doados'], $sum_organs_donated);
        }
        elseif ($age < 61) //51 - 60
        {
            array_push($data_arr['idade_orgaos_doados']['51_60']['arr_qtd_orgaos_doados'], $sum_organs_donated);
        }
        elseif ($age < 71) //61 - 70
        {
            array_push($data_arr['idade_orgaos_doados']['61_70']['arr_qtd_orgaos_doados'], $sum_organs_donated);
        }
        elseif ($age < 81) //71 - 80
        {
            array_push($data_arr['idade_orgaos_doados']['71_80']['arr_qtd_orgaos_doados'], $sum_organs_donated);
        }
        elseif ($age < 91) //81 - 90
        {
            array_push($data_arr['idade_orgaos_doados']['81_90']['arr_qtd_orgaos_doados'], $sum_organs_donated);
        }
        elseif ($age >= 91) // > 91
        {
            array_push($data_arr['idade_orgaos_doados']['maior_que_91']['arr_qtd_orgaos_doados'], $sum_organs_donated);
        }
    }

/**
 * Returns a rules checker object that will be used for validating
 * application integrity.
 *
 * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
 * @return \Cake\ORM\RulesChecker
 */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
