<?php    
    echo $this->element( 'internacao-menu' );
?>


<div class="hospitalizations view col-sm-9 col-md-9 columns content">
    <!-- <h3><?php //echo  h($hospitalization->Type) ?></h3> -->
    <table class="table table-striped table-hover">
        <tr>
            <th>Paciente</th>
            <td><?= $hospitalization->has('patient') ? $this->Html->link($hospitalization->patient['nome'], ['controller' => 'Patients', 'action' => 'view', $hospitalization->patient_id]) : '' ?></td>
        </tr>
        
        <tr>
            <th>Tipo de Internação</th>
            <td><?= h($hospitalization->type) ?></td>
        </tr>
        <tr>
            <th>Convênio</th>
            <td><?= h($hospitalization->complementary_health) ?></td>
        </tr>
        <tr>
            <th>Origem</th>
            <td><?= $hospitalization->has('origin') ? $this->Html->link($hospitalization->origin->name, ['controller' => 'Origins', 'action' => 'view', $hospitalization->origin->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Unidade</th>
            <td><?= $hospitalization->has('unit') ? $this->Html->link($hospitalization->unit->name, ['controller' => 'Units', 'action' => 'view', $hospitalization->unit->id]) : '' ?></td>
        </tr>
        
        <tr>
            <th>Diagnóstico Sistémico</th>
            <td><?= h($hospitalization->systemic_diagnosis) ?></td>
        </tr>
        <tr>
            <th>Comorbidades</th>
            <td><?= h($hospitalization->comorbidities) ?></td>
        </tr>
        <tr>
            <th>Peso (kg)</th>
            <td><?= $this->Number->format($hospitalization->weight) ?></td>
        </tr>
        <tr>
            <th>Altura (m)</th>
            <td><?= $this->Number->format($hospitalization->height) ?></td>
        </tr>
        <tr>
            <th>Data Prevista de Alta</th>
            <td><?= h($hospitalization->expected_discharge_day->format('d/m/Y')) ?></tr>
        </tr>
        <tr>
            <th>Data da Internação</th>
            <td><?= h($hospitalization->created->format('d/m/Y')) ?></tr>
        </tr>
        <tr>
            <th>Reinternação hospitalar < 30 dias</th>
            <td><?= $hospitalization->readmission_to_hospital_until_30_days ? __('Sim') : __('Não'); ?></td>
         </tr>
        <tr>
            <th>Reinternação < 24h em Relação à Última Alta da Unidade</th>
            <td><?= $hospitalization->rehospitalization_up_24 ? __('Sim') : __('Não'); ?></td>
         </tr>
    </table>
        <button class="btn btn-danger" onclick="goBack()">Voltar</button>

<script >
(function() {
   // your page initialization code here
   // the DOM will be available here
   var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)', 
    array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

   var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

   var link3 =' <?= $this->Html->link('Internação',['controller' => 'hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= link3;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Internação</a>';        
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>