<?php

    $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
    $to   = new DateTime('today');
    $age = null;
    $age = $from->diff($to)->y;

    if ($ituPreventionBundle['date_instalation']) {
        $ituPreventionBundle['date_instalation'] =  $ituPreventionBundle['date_instalation']->i18nFormat('d/m/Y');
    }

    if ($ituPreventionBundle['hour_instalation']) {
        $ituPreventionBundle['hour_instalation'] =  $ituPreventionBundle['hour_instalation']->i18nFormat('HH:mm');
    }

    if ($ituPreventionBundle['date_of_withdrawal']) {
        $ituPreventionBundle['date_of_withdrawal'] =  $ituPreventionBundle['date_of_withdrawal']->i18nFormat('d/m/Y');
    }

    if ($ituPreventionBundle['withdrawal_time']) {
        $ituPreventionBundle['withdrawal_time'] =  $ituPreventionBundle['withdrawal_time']->i18nFormat('HH:mm');
    }


?>

<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">

            <?=
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>
        <div class="col-sm-8">
            <h1>Bundle de Prevenção de ITU</h1>
        </div>

</div>

<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>

<div class="ituPreventionBundles form col-md-12 columns content">

        <?php

            $checked_img = $this->Html->image('checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

            $not_checked_img = $this->Html->image('not-checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);


            echo '<div class="col-sm-6 data-field">';
              echo '<b>Data de Instalação:</b>'.$ituPreventionBundle['date_instalation'];
            echo '</div>';


            echo '<div class="col-sm-6 data-field">';
              echo '<b>Hora de Instalação:</b>'.$ituPreventionBundle['hour_instalation'];
            echo '</div>';


            echo "<div class='col-md-12 no-padding'>";

              echo "<br><legend class='big-title'>Pré-procedimento</legend>";


                echo '<div class="col-sm-12 data-field">';
                   echo '<b>Tipo de Dispositivo:</b>'.$ituPreventionBundle['type_of_device'];
                echo '</div>';

              echo "<br><legend class='big-title'>Checklist pré-procedimento</legend>";

                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['emergency']){
                    echo $checked_img.'<b>Procedimento emergencial</b>';
                  }else{
                    echo $not_checked_img.'<b>Procedimento emergencial</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['is_risk_of_bleeding_verified']){
                    echo $checked_img.'<b>Risco de sangramento verificado</b>';
                  }else{
                    echo $not_checked_img.'<b>Risco de sangramento verificado</b>';
                  }
                echo '</div>';


                 echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['is_the_procedure_prescribed']){
                    echo $checked_img.'<b>Procedimento prescrito</b>';
                  }else{
                    echo $not_checked_img.'<b>Procedimento prescrito</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-12 data-field">';
                    echo '<b>Observação do dispositivo:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                   echo '<div class="textos">'.$ituPreventionBundle['device_observation'].'</div>';
                echo '</div>';

            echo '</div>';

            echo "<div class='col-md-12 no-padding'>";

                echo "<br><legend class='big-title'>Durante o procedimento</legend>";



                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['proper_handwashing']){
                    echo $checked_img.'<b>Higienização adequada das mãos com clorexidina ou gel alcoólico</b>';
                  }else{
                    echo $not_checked_img.'<b>Higienização adequada das mãos com clorexidina ou gel alcoólico</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['use_of_paramentation']){
                    echo $checked_img.'<b>Uso de paramentação: gorro, máscara e luvas estéreis</b>';
                  }else{
                    echo $not_checked_img.'<b>Uso de paramentação: gorro, máscara e luvas estéreis</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-12 no-padding">';
                  echo '<div class="col-sm-6 data-field">';
                    if($ituPreventionBundle['use_of_antisepsis']){
                      echo $checked_img.'<b>Uso de antissepsia</b>';
                    }else{
                      echo $not_checked_img.'<b>Uso de antissepsia</b>';
                    }
                  echo '</div>';


                  echo '<div class="col-sm-6 data-field">';
                    if($ituPreventionBundle['degermacao_da_genitalia']){
                      echo $checked_img.'<b>Uso de degermação da cavidade genitália com clorexidina aquosa</b>';
                    }else{
                      echo $not_checked_img.'<b>Uso de degermação da cavidade genitália com clorexidina aquosa</b>';
                    }
                  echo '</div>';
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['use_of_field_with_maxium_barrier']){
                    echo $checked_img.'<b>Uso de campo com barreira máxima</b>';
                  }else{
                    echo $not_checked_img.'<b>Uso de campo com barreira máxima</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['use_of_sterile_gel']){
                    echo $checked_img.'<b>Uso de gel estéril de xilocaína ou similar</b>';
                  }else{
                    echo $not_checked_img.'<b>Uso de gel estéril de xilocaína ou similar</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['suitable_catheter_progression']){
                    echo $checked_img.'<b>Progressão adequada do cateter</b>';
                  }else{
                    echo $not_checked_img.'<b>Progressão adequada do cateter</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['urine_output_cauterization']){
                    echo $checked_img.'<b>Saída de urina de imediato após cateterização</b>';
                  }else{
                    echo $not_checked_img.'<b>Saída de urina de imediato após cateterização</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['adequate_catheter_fixation']){
                    echo $checked_img.'<b>Fixação adequada do cateter</b>';
                  }else{
                    echo $not_checked_img.'<b>Fixação adequada do cateter</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['confirmation_of_position_with_us']){
                    echo $checked_img.'<b>Posição confimada com ultrassom</b>';
                  }else{
                    echo $not_checked_img.'<b>Posição confimada com ultrassom</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-12 data-field">';
                    echo '<b>Observação do Checklist:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                   echo '<div class="textos">'.$ituPreventionBundle['checklist_observation'].'</div>';
                echo '</div>';


            echo '</div>';



            echo "<div class='col-md-12 no-padding'>";

                echo "<br><legend class='big-title'>Descrição orientada</legend>";


                echo '<div class="col-sm-6 data-field">';
                  echo '<b>Número de tentativas:</b>'.$ituPreventionBundle['number_of_retries'];
                echo '</div>';

                echo '<div class="col-sm-6 data-field">';
                  echo '<b>Número de Profissionais insertadores:</b>'.$ituPreventionBundle['number_of_professionals'];
                echo '</div>';



                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['blood_on_catheter']){
                    echo $checked_img.'<b>Presença de sangue no sistema coletor</b>';
                  }else{
                    echo $not_checked_img.'<b>Presença de sangue no sistema coletor</b>';
                  }
                echo '</div>';

                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['successful_integration']){
                    echo $checked_img.'<b>Sucesso na inserção</b>';
                  }else{
                    echo $not_checked_img.'<b>Sucesso na inserção</b>';
                  }
                echo '</div>';


                $c='';

                foreach ($ituPreventionBundle['immediate_complications'] as $key => $complication) {
                       $c.= $complication['nome'].',';
                }

                $c = trim($c,",");

                echo '<div class="col-sm-12 data-field">';
                    echo '<b>Complicação Imediata:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                   echo '<div class="textos">'.$c.'</div>';
                echo '</div>';


            echo '</div>';




            echo "<div class='col-md-12 no-padding'>";

                echo "<br><legend class='big-title'>Retirada do CVD ou citostomia</legend>";


                echo '<div class="col-sm-6 data-field">';
                  echo '<b>Data de Retirada:</b>'.$ituPreventionBundle['date_of_withdrawal'];
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  echo '<b>Hora de Retirada:</b>'.$ituPreventionBundle['withdrawal_time'];
                echo '</div>';


                echo '<div class="col-sm-6 data-field">';
                  if($ituPreventionBundle['accidental_removal']){
                    echo $checked_img.'<b>Retirada acidental</b>';
                  }else{
                    echo $not_checked_img.'<b>Retirada acidental</b>';
                  }
                echo '</div>';


                echo '<div class="col-sm-12 data-field">';
                    echo '<b>Motivo da retirada acidental:</b>';
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                   echo '<div class="textos">'.$ituPreventionBundle['motive_accidental_removal'].'</div>';
                echo '</div>';


            echo "</div>";



        ?>
</div>

<script>
window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);

(function() {
    //url da listagem
    var urlIndex = '<?= $this->Html->linkUrl(['controller'=>'Bundles','action' => 'index']); ?>';

    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show");
          window.location.href=urlIndex;
        },950);
    }

    //chamando o spinner e a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },650);

  })();

</script>