
<?php
    echo $this->element( 'internacao-menu' );

    if (!isset($hospitalization->height)) {
        $hospitalization->height = 0;
    }

    if (!isset($hospitalization->weight)) {
        $hospitalization->weight = 0;
    }
?>
<div class="nutritionalAssessments form col-md-8 columns content">
    <?= $this->Form->create($nutritionalAssessment) ?>
    <fieldset>

        <?php

            $nutric_score = ["age", "score", "apache", "comorbidities"=>0, "days_from_hospital", "ll6"];
            $nutric_score["score"] = 0;

            //$from = new DateTime('1970-02-01');
            $to   = new DateTime('today');
            $nutric_score["age"] = $patient->birthday->diff($to)->y;
            $patient_sex = $patient->sexo;

            if ( $patient->sexo == null) {
                $patient_sex = "Masculino";
            }

            if ($nutric_score["age"] >= 50 && $nutric_score["age"] <= 75) {
                $nutric_score["score"] += 1;
            }
            else if ($nutric_score["age"] >= 75) {
                $nutric_score["score"] += 2;
            }

            foreach ($hospitalization["diagnostics"] as $key => $value) {
                foreach ($value["comorbidities"] as $key => $value) {
                    $nutric_score['comorbidities']++;
                }
            }

            if($nutric_score['comorbidities'] > 2){
                $nutric_score["score"] += 1;
            }
            
            // if (isset($hospitalization->comorbidities[2])){
            //     $nutric_score["score"] += 1;
            // }

            if (isset($hospitalization->apache_ii_scores[0])) {
                $last = end($hospitalization->apache_ii_scores);

                $nutric_score["apache"] = $last['pontuation'];

                if ($nutric_score["apache"] >= 15 && $nutric_score["apache"] < 20) {
                    $nutric_score["score"] += 1;
                }
                else if ($nutric_score["apache"] >= 20 && $nutric_score["apache"] < 28) {
                    $nutric_score["score"] += 2;
                }
                else if ($nutric_score["apache"] >= 28) {
                    $nutric_score["score"] += 3;
                }
            }

            if (isset($hospitalization->sofa_escores[0])) {
                $last = end($hospitalization->sofa_escores);
                $nutric_score["sofa"] = $last["pontuation"];

                if ($nutric_score["sofa"] >= 6 && $nutric_score["sofa"] < 10) {
                    $nutric_score["score"] += 1;
                }
                else if ($nutric_score["sofa"] >= 10) {
                    $nutric_score["score"] += 2;
                }
            }


            $geb_type_opt = ['Fórmula kcal por kg', ' Fórmula Harris-Benedict', 'Método Calolimetria Indireta', 'Método Calolimetria Indireta Circulatória'];
            $motivo_opt =['Exame de Imagem', 'Exame Laboratorial', 'Procedimento Cirúrgico', 'Descanso Gástrico Prolongado', ' Intervalo entre Dietas'];
             // $motivo_opt = [ 'Exame de Imagem', 'Procedimento Cirúrgico', 'Descanso Gástrico Prolongado', 'Intervalo de Dieta', 'Resíduo Gástrico Elevado', 'Vômitos', 'Broncoaspiração', 'Instabilidade Hemodinâmica', 'Distensão Abdominal', 'Pedido do Paciente', 'Recusa alimentar do Paciente', 'Outros'];
            $motivo_jejum_opt=['Banho', 'Exame de Imagem', 'Exame Laboratorial', 'Procedimento Cirúrgico', 'Descanso Gástrico', 'Intervalo entre Dietas', 'Resíduo Gástrico Elevado', 'Vômitos', 'Broncoaspiração', 'Instabilidade Hemodinâmica', 'Distensão Abdominal', 'Pedido do Paciente', 'Recusa do Paciente e Outros'];
        ?>


        <div class="tabbable-panel">
                <div class="tabbable-line">
                    <ul class="nav nav-tabs ">
                        <li class="active">
                            <a href="#tab_default_1" data-toggle="tab">
                            Avaliação Nutricional
                            </a>
                        </li>
                        <li>
                            <a href="#tab_default_2" data-toggle="tab">
                            GEB
                            </a>
                        </li>
                        <li>
                            <a href="#tab_default_3" data-toggle="tab">
                            VEPT
                            </a>
                        </li>
                        <li>
                            <a href="#tab_default_4" data-toggle="tab">
                            Jejum
                            </a>
                        </li>
                    </ul>

                    <div class="tab-content">
                    <br>
                        <div class="tab-pane active" id="tab_default_1">
                            <p style="font-style: italic;">Idade: <?= $nutric_score["age"] ?> &nbsp;&nbsp; Apache II: <?php if ( isset($nutric_score['apache']) ) echo $nutric_score['apache'] ?> &nbsp;&nbsp; Sofa: <?php if ( isset($nutric_score['sofa']) ) echo $nutric_score['sofa'] ?> &nbsp;&nbsp; Comorbidades: <?= $nutric_score['comorbidities'] ?> </p>
                            <br>

                            <?php
                                    echo $this->Form->input('assessment_date', ['default'=>date('d/m/Y'), 'required' => false,'type'=>'text', 'class'=>'date', 'label'=>['text'=>'Data da avaliação:', 'class'=>'form-input'] ]);

                                    echo '<div class="funkyradio">';
                                    echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('imc_e_menor_do_que_20_5', ['id'=>'imc_e_menor_do_que_20_5', 'class'=>'abc']);
                                    echo '<label for="imc_e_menor_do_que_20_5">IMC menor que 20,5 kg/m²</label>';
                                    echo "</div>";

                                    echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('paciente_perdeu_peso_nos_ultimos_3_meses', ['id'=>'paciente_perdeu_peso_nos_ultimos_3_meses', 'class'=>'abc']);
                                    echo '<label for="paciente_perdeu_peso_nos_ultimos_3_meses">Paciente perdeu peso nos últimos 3 meses</label>';
                                    echo "</div>";

                                     echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('paciente_e_gravemente_doente', ['id'=>'paciente_e_gravemente_doente', 'class'=>'abc']);
                                    echo '<label for="paciente_e_gravemente_doente">Paciente gravemente doente (Ex: em Terapia Intensiva)</label>';
                                    echo "</div>";

                                    echo"<div id='second-panel' style='display:none;'>";
                                    echo "<br><br>";
                                    echo '<legend class="big-title">Comunicação ativa com verificação obrigatória do checklist:</legend>';

                                    echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('estado_nutricional_normal',['id'=>'estado_nutricional_normal', 'class'=>'encore']);
                                    echo '<label for="estado_nutricional_normal">Estado nutricional normal </label>';
                                    echo "</div>";

                                    echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('perda_e_peso_maior_5_em_3_meses', ['id'=>'perda_e_peso_maior_5_em_3_meses', 'class'=>'encore1 encore']);
                                    echo '<label for="perda_e_peso_maior_5_em_3_meses">Perda de peso > 5%    em 3 meses ou ingestão alimentar na última semana entre 50-75% das necessidades nutricionais </label>';
                                    echo "</div>";

                                     echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('perda_e_peso_maior_5_em_2_meses', ['id'=>'perda_e_peso_maior_5_em_2_meses', 'class'=>'encore2 encore']);
                                    echo '<label for="perda_e_peso_maior_5_em_2_meses">Perda de peso > 5% em 2 meses + condição geral prejudicada (enfraquecida) ou ingestão alimentar na última semana entre 25%-60% das necessidades nutricionais </label>';
                                    echo "</div>";

                                    echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('perda_e_peso_maior_5_em_1_meses', ['id'=>'perda_e_peso_maior_5_em_1_meses', 'class'=>'encore3 encore']);
                                    echo '<label for="perda_e_peso_maior_5_em_1_meses">Perda de peso > 5% em 1 mês ou IMC < 18,5 + condição geral prejudicada (enfraquecida) ou ingestão alimentar na ultima semana entre 0-25% das necessidades nutricionais </label>';
                                    echo "</div>";

                                    echo"<br><br>";
                                    echo '<legend class="big-title">Gravidade da doença (aumento das necessidades):</legend>';

                                    echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('necessidades_nutricionais_normais', ['id'=>'necessidades_nutricionais_normais', 'class'=>'encore']);
                                    echo '<label for="necessidades_nutricionais_normais">Perda de peso > Necessidades nutricionais normais</label>';
                                    echo "</div>";

                                      echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('fratura_de_quadril', ['id'=>'fratura_de_quadril', 'class'=>'encore1 encore']);
                                    echo '<label for="fratura_de_quadril">Fratura de quadril, pacientes crônicos, em particular com complicações agudas: cirrose, DPOC, hemodiálise, diabetes, oncologia, paciente fraco, mas deambula </label>';
                                    echo "</div>";

                                    echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('cirurgia_abdominal', ['id'=>'cirurgia_abdominal', 'class'=>'encore2 encore']);
                                    echo '<label for="cirurgia_abdominal">Cirurgia abdominal de grande porte, AVC, pneumonia grave, doença hematológica maligna, (leucemia, linfoma), paciente confinado ao leito.</label>';
                                    echo "</div>";

                                    echo '<div class="funkyradio-primary">';
                                    echo $this->Form->checkbox('trauma', ['id'=>'trauma', 'class'=>'encore3 encore']);
                                    echo '<label for="trauma">Trauma, transplante de medula óssea, paciente em terapia intensiva (APACHE > 10). </label>';
                                    echo "</div>";

                                    echo"<h3 id='estado-nutricional'>Estado Nutricional: Eutrófico</h3>";
                                    echo "</div>";
                                    //echo $this->Form->input('hospitalization_id', ['value' => $hospitalization_id, 'class'=>"hide", 'label'=>false]);
                                    echo $this->Form->hidden('hospitalization_id', ['value' => $hospitalization_id]);
                                    echo "</div>";
                            ?>
                        </div>
                        <div class="tab-pane" id="tab_default_2">
                           <?php
                                echo '<legend class="big-title"></legend>';
                                echo '<legend class="big-title">Gasto Energético Basal</legend>';

                                echo $this->Form->input('geb_date', ['default'=>date('d/m/Y'), 'required' => false,'type'=>'text', 'class'=>'date', 'label'=>['text'=>'Data da avaliação:', 'class'=>'form-input'] ]);

                                echo $this->Form->input('geb_type', [ 'class'=>'item1', 'empty'=>true,'options'=>$geb_type_opt, 'label'=>['text'=>'Escolha de que forma deseja calcular o GEB:', 'class'=>'form-input'] ]);

                                echo "<div id='formula' style='display:none'></div><br>";

                                echo $this->Form->input('geb', ['type'=>'number', 'disabled'=>true, 'class'=>'item1', 'empty'=>true, 'label'=>['text'=>'Resultado GEB:', 'class'=>'form-input'] ]);
                           ?>
                        </div>
                        <div class="tab-pane" id="tab_default_3">
                            <?php
                                echo '<legend class="big-title">Volume Energético e Proteico Total</legend>';

                                echo $this->Form->input('volume_energetico_data', ['default'=>date('d/m/Y'), 'class'=>'date', 'type'=>'text','label'=>['text'=>'Data:', 'class'=>'form-input']]);

                                echo $this->Form->input('volume_energetico_programado', ['type'=>'number', 'placeholder'=>0,  'class'=>'item1', 'empty'=>true, 'label'=>['text'=>'Volume energético programado:', 'class'=>'form-input'] ]);

                                echo $this->Form->input('volume_energetico_atingido', ['type'=>'number', 'placeholder'=>0,  'class'=>'item1', 'empty'=>true, 'label'=>['text'=>'Volume energético atingido:', 'class'=>'form-input'] ]);

                                echo $this->Form->input('percentual_de_energia_programado_atingido_display', ['readonly'=>true, 'class'=>'item1 percentual_de_energia_programado_atingido', 'empty'=>true, 'label'=>['text'=>'Percentual de energia atingida e programada:', 'class'=>'form-input percentual_de_energia_programado_atingido'] ]);

                                echo $this->Form->input('percentual_de_energia_programado_atingido', ['class'=>'hide-element', 'label'=>false ]);

                                echo $this->Form->input('motivo_energia', ['options'=>$motivo_opt, 'class'=>'item1', 'empty'=>true, 'label'=>['text'=>'Motivo de ingestão energética baixa', 'class'=>'form-input'] ]);

                                echo $this->Form->input('volume_proteina_programado', ['type'=>'number', 'placeholder'=>0,  'class'=>'item1', 'empty'=>true, 'label'=>['text'=>'Volume proteína programado:', 'class'=>'form-input'] ]);

                                echo $this->Form->input('total_de_proteinas_ingeridas', ['type'=>'number', 'placeholder'=>0,  'class'=>'item1', 'empty'=>true, 'label'=>['text'=>'Total de proteínas ingeridas (%):', 'class'=>'form-input'] ]);

                                echo $this->Form->input('proteina_por_kg', ['disabled'=>true, 'class'=>'item1', 'empty'=>true, 'label'=>['text'=>'Proteína por kg:', 'class'=>'form-input'] ]);

                                echo $this->Form->input('percentual_de_proteina_programado_atingido', ['disabled'=>true, 'class'=>'item1 percentual_de_proteina_programado_atingido', 'empty'=>true, 'label'=>['text'=>'Percentual de proteína atingida e programada:', 'class'=>'form-input percentual_de_proteina_programado_atingido'] ]);

                                echo $this->Form->input('motivo_proteina', ['options'=>$motivo_opt, 'class'=>'item1', 'empty'=>true, 'label'=>['text'=>'Motivo de ingestão proteica baixa', 'class'=>'form-input'] ]);
                            ?>
                        </div>
                        <div class="tab-pane" id="tab_default_4">
                           <?php
                                echo '<legend class="big-title">Período de Jejum</legend>';

                                echo $this->Form->input('periodo_jejum_data', ['class'=>'date', 'type'=>'text','label'=>['text'=>'Data:', 'class'=>'form-input']]);

                                echo $this->Form->input('hora_inicio_jejum', ['class'=>'time', 'type'=>'text','label'=>['text'=>'Hora de início do jejum:', 'class'=>'form-input'],'empty' => true, 'default' => '']);

                                echo $this->Form->input('jejum_end_date', ['type'=>'text', 'class'=>'date', 'label'=>['text'=>'Data de término:', 'class'=>'form-input'] ]);

                                echo $this->Form->input('hora_termino_jejum', ['class'=>'time', 'type'=>'text','label'=>['text'=>'Hora de término do jejum:', 'class'=>'form-input'],'empty' => true, 'default' => '']);

                                echo $this->Form->input('motivo_jejum', ['options'=>$motivo_jejum_opt, 'class'=>'item1', 'empty'=>true, 'label'=>['text'=>'Motivo do jejum', 'class'=>'form-input'] ]);

                                echo $this->Form->hidden('peso', ['id'=>'peso', 'type'=>'text', 'empty' => true, 'default' => '', 'value'=>$hospitalization->weight]);
                                echo $this->Form->hidden('nutric_score', ['id'=>'nutric_score', 'type'=>'text', 'empty' => true, 'default' => $nutric_score["score"]]);

                                echo '<div class="funkyradio">';
                                echo '<div class="funkyradio-primary">';
                                echo $this->Form->checkbox('jejum_programado', ['id'=>'jejum_programado']);
                                echo '<label for="jejum_programado">O jejum foi programado</label>';
                                echo "</div></div><br><br>";
                           ?>
                        </div>
                    </div>
            </div>
        </div>
        <br>
        
        <h3>Estados Nutricionais:</h3>
        <p style="font-size: 1.3em;" id="nutric-score" style="display:block">Nutric score: <?= $nutric_score["score"] ?> </p>       
        <p style="font-size: 1.3em;"> Pontuação: <span id='pontuacao'> 0 </span>  </p>
        <p style="font-size: 1.3em;">   NRS 2002: <span id='estado-nutricional'> Eutrófico </span> </p>        
        <br><br>

        <input type="hidden" id="resultado" name="resultado" maxlength="45" >
      <button class="btn btn-danger" onclick="goBack()">Cancelar</button>
      <?= $this->Form->button(__('Salvar')) ?>
      <?= $this->Form->end() ?>

    </fieldset>

  <br><br><br><br>
</div>


<script>

    valor = $('#geb-type option:selected').val();
    switch (valor) {
        case '0':
            var texto = '<p>Paciente não crítico: 20 por kilo de peso.<br>Paciente crítico: 25 por kilo de peso.</p>';

            $("#formula").empty();
            $("#formula").append(texto);
            $("#formula").slideDown();
        break;

        case '1':
            var texto = '<p>Homens = 66,5 + 13,7(Peso,kg) + 5(Alt.,cm)   - 6,8 (Idade,anos).<br><br>Mulheres = 665 +'+ '9,6(Peso,kg) + 1,7(Alt.,cm) - 4,7 (Idade,anos).<p>';

            $("#formula").empty();
            $("#formula").append(texto);
            $("#formula").slideDown();
        break;

        case '2':
            var texto = '<p>Whatsssss<p>';

            $("#formula").empty();
            $("#formula").append(texto);
            $("#formula").slideDown();
        break;

        case '3':
            var texto = '<p>Débito cardíaco x Hemoglobina ( Saturação arterial de O2 - Satiração venosa de O2) x 95,8<p>';

            $("#formula").empty();
            $("#formula").append(texto);
            $("#formula").slideDown();
        break;

        default:
            $("#formula").slideUp();
        break;

    }


var patient ={};
patient.height = <?= $hospitalization->height ?>;
patient.age = <?= $nutric_score["age"] ?>;
patient.weight = <?= $hospitalization->weight ?>;
patient.estado = '<?= $estado_paciente ?>';
patient.sex = '<?= $patient_sex ?>';
console.log(patient);

$("#geb-type").change(function(){

    $("#formula").slideUp();

    var value = '';

    switch($(this).val()){

        case '0':
            var texto = '<p>Paciente não crítico: 20 por kilo de peso.<br>Paciente crítico: 25 por kilo de peso.</p>';

            $("#formula").empty();
            $("#formula").append(texto);
            $("#formula").slideDown();

            if (patient.estado == 'crítico') {
                value = 25*patient.weight;
            }
            else {
                value = 20*patient.weight;
            }

            $("#geb").prop('readonly', true);
        break;

        case '1':
            var texto = '<p>Homens = 66,5 + 13,7(Peso,kg) + 5(Alt.,cm)   - 6,8 (Idade,anos).<br><br>Mulheres = 66,5 +'+ '9,6(Peso,kg) + 1,7(Alt.,cm) - 4,7 (Idade,anos).<p>';

            $("#formula").empty();
            $("#formula").append(texto);
            $("#formula").slideDown();

            if (patient.sex =="Masculino"){
                value = 66.5 + (patient.weight*13.7) + (patient.height*100*5) - (patient.age*6.8);
            }else {
                value = 66.5 + (patient.weight*9.6) + (patient.height*100*1.7) - (patient.age*4.7);
            }

            value = Math.round(value * 100) / 100;

            $("#geb").prop('readonly', true);
        break;

        case '2':
            var texto = '<p>PE (kcal/dia) = 3,9 x VO2 (L/min) + 1,1 x VCO2 (L/min) x 1.440 <p>';

            $("#formula").empty();
            $("#formula").append(texto);
            $("#formula").slideDown();
            $("#geb").prop('readonly', false);
        break;

        case '3':
            var texto = '<p>Débito cardíaco x Hemoglobina ( Saturação arterial de O2 - Satiração venosa de O2) x 95,8<p>';

            $("#formula").empty();
            $("#formula").append(texto);
            $("#formula").slideDown();

            $("#geb").prop('readonly', false);
        break;
    }
    $("#geb").val(value);
});

// $( document ).ready(function() {
//     //$("#geb-type").trigger("change");
//     calcPercentual(); 
// });

// $("#geb-type").change(function(){

//     $("#formula").slideUp();

//     var value = '';

//     switch($(this).val()){
//         case '0':
//             value = 20;
//             $("#geb").prop('disabled', true);
//         break;

//         case '1':

//             if (patient.sex =="Masculino"){
//                 value = 66.5 + patient.weight + patient.height - patient.age;
//             }else {
//                 value = 66.5 + patient.weight + patient.height - patient.age;
//             }

//             $("#geb").prop('disabled', true);
//         break;

//         case '2':
//             $("#formula").slideDown();
//             $("#geb").prop('disabled', false);
//         break;

//         case '3':
//             $("#formula").slideDown();
//             $("#geb").prop('disabled', false);
//         break;
//     }
//     $("#geb").val(value);
// });

// function calculatePoints(){
//      var pontuacao = 0;

//         $( ".encore" ).each(function( index ) {

//         if($( this ).is(':checked')){
//            if ($(this).hasClass( "encore1" )){
//             pontuacao++;
//            }

//            if ($(this).hasClass( "encore2" )){
//             pontuacao+=2;
//            }

//            if ($(this).hasClass( "encore3" )){
//             pontuacao+=3;
//            }
//         }

//         });

//         $("#resultado").val(pontuacao);
//         switch (pontuacao) {
//              case 0:
//                 $("#estado-nutricional").text('Estado Nutricional: Eutrófico');
//              break;

//              case 1:
//                $("#estado-nutricional").text('Estado Nutricional: Desnutrido leve');
//              break;

//              case 2:
//                 $("#estado-nutricional").text('Estado Nutricional: Desnutrido moderado');
//              break;

//               case 3:
//                 $("#estado-nutricional").text('Estado Nutricional: Desnutrido grave');
//               break;
//               case 4:

//                 $("#estado-nutricional").text('Estado Nutricional: Desnutrido grave');
//               break;

//               case 5:
//                 $("#estado-nutricional").text('Estado Nutricional: Desnutrido grave');
//               break;

//               default:
//                 $("#estado-nutricional").text('Estado Nutricional: Desnutrido grave');
//               break;
//         }
// }

// function openSecondMenu(){
//     var isChecked = false;
//          $( ".abc" ).each(function( index ) {

//         if($( this ).is(':checked')){
//             isChecked = true;
//             return false;
//         }

//         });

//         if (isChecked){
//         $("#second-panel" ).fadeIn();
//         } else {
//                $( ".encore" ).each(function( index ) {
//                     $(this).prop('checked', false);
//                });
//                 $("#second-panel" ).fadeOut();
//         }
// }

(function() {
   //  openSecondMenu();
   //  calculatePoints();

   //  $('.encore').change(function () {
   //     calculatePoints();
   // });
        $('#volume-energetico-programado').change(function() {
            calcPercentual();
        });
        $('#volume-energetico-atingido').change(function() {
            calcPercentual();
        });
        $('#volume-proteina-programado').change(function() {
            calcPercentual();
        });
        $('#total-de-proteinas-ingeridas').change(function() {        
           var proteinas =  $('#total-de-proteinas-ingeridas').val();
           var peso = $('#peso').val();
           console.log("peso " + peso);
           console.log("proteinas " + proteinas);
           var total = 0;

           if (proteinas > 0 && peso > 0)
            {
                total = proteinas / peso * 100;
            }
            console.log('total = ' . total);
            $('#proteina-por-kg').val( total.toFixed(2) );

            calcPercentual();
        });

        calcPercentual();

        function calcPercentual() {
            var energetico_programado = $('#volume-energetico-programado').val();
            var energetico_atingido = $('#volume-energetico-atingido').val();
            console.log("energetico_programado ="+energetico_programado+" energetico_atingido="+energetico_atingido);
            var total_energetico =  Math.floor((energetico_atingido / energetico_programado) * 100);

            var proteina_programado = $('#volume-proteina-programado').val();
            var proteina_atingido = $('#total-de-proteinas-ingeridas').val();
            console.log("proteina_atingido ="+proteina_atingido+" proteina_programado="+proteina_programado);
            var total_proteina =  Math.floor((proteina_atingido / proteina_programado) * 100);

            console.log("total_proteina = "+total_proteina);
            console.log("total_energetico = "+total_energetico);

            if ( !isNaN(total_proteina) ) {
                $('#percentual-de-proteina-programado-atingido').val( total_proteina +'%' );
            }

            if ( !isNaN(total_energetico) ) {
                $('#percentual-de-energia-programado-atingido').val( total_energetico );
                $('#percentual-de-energia-programado-atingido-display').val( total_energetico +'%' );
            }
        }

        $('.abc').change(function () {
            var isChecked = false;

            $( ".abc" ).each(function( index ) {

            if($( this ).is(':checked')){
                isChecked = true;
                return false;
            }

            });

            if (isChecked)
            {
                $("#second-panel" ).fadeIn();
            }
            else {
                $( ".encore" ).each(function( index ) {
                    $(this).prop('checked', false);
                });

                $("#second-panel" ).fadeOut();
                $("#resultado").val(0);
                $("#estado-nutricional").text('Eutrófico');
                $("#pontuacao").text(pontuacao);
            }
        });

        $('.encore').change(function () {
            var pontuacao = 0;

            $( ".encore" ).each(function( index ) {
                if($( this ).is(':checked')) {

                   if ($(this).hasClass( "encore1" )) {
                        pontuacao++;
                   }

                   if ($(this).hasClass( "encore2" )) {
                        pontuacao+=2;
                   }

                   if ($(this).hasClass( "encore3" )) {
                        pontuacao+=3;
                   }
                }

            });

            $("#resultado").val(pontuacao);
            console.log("pontuacao = " + pontuacao);
            $("#pontuacao").text(pontuacao);

            switch (pontuacao) {
                 case 0:
                    $("#estado-nutricional").text('Eutrófico');
                 break;

                 case 1:                   
                   $("#estado-nutricional").text('Desnutrido leve');
                 break;

                 case 2:                    
                    $("#estado-nutricional").text('Desnutrido moderado');
                 break;

                  case 3:                    
                    $("#estado-nutricional").text('Desnutrido grave');
                  break;
                  case 4:                    
                    $("#estado-nutricional").text('Desnutrido grave');
                  break;

                  case 5:                    
                    $("#estado-nutricional").text('Desnutrido grave');
                  break;

                  default:
                    $("#estado-nutricional").text('Desnutrido grave');
                  break;
            }
        });

    $("#jejum").click( function() {
        if ( !$("#periodo-jejum-data").val().length > 0)
        {
            var today = moment().format('DD/MM/YYYY')
            $("#periodo-jejum-data").val(today.toString());
            $("#jejum-end-date").val(today.toString()); 
        }
    });

    $(".abc").trigger("change");
    $(".encore").trigger("change");

   var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

   var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

   var link3 =' <?= $this->Html->link('Internação',['controller' => 'hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var link4 =' <?= $this->Html->link('Avaliação Nutricional',['controller' => 'NutritionalAssessments', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= link3;
        html+= link4;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Editar</a>';
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>