<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <?=$this->Html->css('pdf', ['fullBase' => true]);?>
        <?=$this->fetch('css')?>
</head>

<body>
    <?=$this->element('header-logo', ['report_title' => 'Relatório CCIH']);?>
        <div class="container">
            <table class="aileron_thin limit-first-td" style="width:100%">
                <thead>

                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Valor</th>
                        <th class="title th-right">%</th>
                    </tr>
                </thead>

                <tbody>
                    <tr>
                        <td class="yolo" >Admissão com infecção</td>
                        <!-- falta pegar as infeccoes pelo numero/simbolo -->
                        <td><?=$data2['tot_internacoes_admisao_infeccao']?></td>
                        <td><?=$data2['percen_internacoes_admisao_infeccao']?>%</td>
                    </tr>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="3">Gravidade das infecções</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Sepse</td>
                        <td>
                            <?=$data['hospital']['gravidade_sepse']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gravidade_sepse']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Infecção</td>
                        <td>
                            <?=$data['hospital']['gravidade_infeccao']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gravidade_infeccao']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Choque</td>
                        <td>
                            <?=$data['hospital']['gravidade_choque']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gravidade_choque']?>% </td>
                    </tr>

                    <tr>
                        <td class="title" style="font-weight: bold" colspan="3">Tipo de infecções</td>
                    </tr>
                    '<tr class="tr-indent">
                        <td>&#8226; Nosocomial</td>
                        <td>
                            <?=$data['hospital']['classificacao_nosocomial']?>
                        </td>
                        <td>
                            <?=$data['hospital']['classificacao_nosocomial']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226;Nosocomial de outra unidade</td>
                        <td>
                            <?=$data['hospital']['classificacao_nosocomial_de']?>
                        </td>
                        <td>
                            <?=$data['hospital']['classificacao_nosocomial_de']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226;Comunitária</td>
                        <td>
                            <?=$data['hospital']['classificacao_comunitaria']?>
                        </td>
                        <td>
                            <?=$data['hospital']['comprovacao_microbiologica_percentual']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226;Sem identificação</td>
                        <td>
                            <?=$data['hospital']['sem_identificacao']?>
                        </td>
                        <td>
                            <?=$data['hospital']['sem_identificacao']?>% </td>
                    </tr>


                    <!-- <tr>
                    <td colspan="3">
                        <table class="aileron_thin limit-first-td" style="width:100%">
                            <thead>
                                <tr>
                                    <th colspan="2">Tabela comprovação microbiológica por sítio</th>
                                </tr>
                                <tr>
                                    <th>Item</th>
                                    <th>Valor</th>
                                </tr>
                            </thead>

                            <tbody>
                                <tr>
                                    <td>Meningite</td>
                                    <td><?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?></td>
                                </tr>

                            </tbody>
                        </table>
                    </td>
                </tr> -->
                    <tr>
                        <td>Comprovação microbiológica</td>
                        <td>-</td>
                        <td><?=$data2['percen_identificacao_agente_por_sepse']?>% </td>
                    </tr>

                    <tr>
                        <td>Germe gram positivo</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Sitio encontrado (gram positivo)</td>
                        <td>-</td>
                        <td>-</td>
                    </tr>

                    <tr>
                        <td>Resistente sim (gram positivo)</td>
                        <td>- </td>
                        <td>- </tr>

                    <tr>
                        <td>Germe gram negativo</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Sitio encontrado (gram negativo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Resistente sim (gram negativo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Multiresistente sim (gram negativo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Germe fungo</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Sitio encontrado (germe fungo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Resistente sim (germe fungo)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Vírus</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Sitio encontrado (vírus)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Tuberculose</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Sitio encontrado (tuberculose)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Resistente sim (tuberculose)</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>

                    <tr>
                        <td>Paciente com mais de um germe na internação</td>
                        <td>
                            <?=$data['hospital']['gram_positivo_total']?>
                        </td>
                        <td>
                            <?=$data['hospital']['gram_positivo_percentual']?>% </td>
                    </tr>


                </tbody>


            </table>

            <div style="page-break-after:always;"></div>

            <div style="page-break-after:auto;">
                <table class="aileron_thin limit-first-td" style="width:100%">
                    <thead>

                        <tr>
                            <th class="title th-left">Item</th>
                            <th class="title th-middle">Valor</th>
                            <th class="title th-right">%</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Comprovação microbiológica</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_total']?>
                            </td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_percentual']?>% </td>
                        </tr>
                    </tbody>
                </table>

                <br><br>

                <table class="aileron_thin limit-first-td" style="width:100%">
                    <thead>
                        <tr>
                            <th colspan="2">Tabela comprovação microbiológica por sítio/tipo</th>
                        </tr>
                        <tr>
                            <th class="title th-left">Item</th>
                            <th class="title th-right">Valor</th>
                        </tr>
                    </thead>

                    <tbody>
                        <tr>
                            <td>Meningite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Encefalite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['encefalite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Meningoencefalite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Sinusite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Mastoidite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Otite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Celulite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Amigdalite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Laringite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>TraqueÍte</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Pneumonia</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Endocardite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Infecção de Corrente sanguínea</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Gastroenterite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Hepatite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Pancreatite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Peritonite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Infecção urinária</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Infecção pélvica</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Piodermite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Foliculite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Fasciíte</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Úlcera Infectada</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Abcesso -> este solicitar o local</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Ostemielite</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Artrite séptica</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Tuberculose Pulmonar</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Herpes Zoster</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Outros</td>
                            <td>
                                <?=$data['hospital']['comprovacao_microbiologica_sitio']['meningite']?>
                            </td>
                        </tr>

                    </tbody>
                </table>
            </div>

            <table class="aileron_thin limit-first-td" style="width:100%">
                    <thead>
                        <tr>
                            <th colspan="2">Tabela entre  gram positivo e tipos de infecções</th>
                        </tr>
                        <tr>
                            <th class="title th-left">Item</th>
                            <th class="title th-right">Valor</th>
                        </tr>
                    </thead>

                    <tbody>
                        <tr>
                            <td>Meningite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Encefalite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['encefalite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Meningoencefalite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Sinusite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Mastoidite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Otite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Celulite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Amigdalite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Laringite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>TraqueÍte</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Pneumonia</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Endocardite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Infecção de Corrente sanguínea</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Gastroenterite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Hepatite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Pancreatite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Peritonite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Infecção urinária</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Infecção pélvica</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Piodermite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Foliculite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Fasciíte</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Úlcera Infectada</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Abcesso -> este solicitar o local</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Ostemielite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Artrite séptica</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Tuberculose Pulmonar</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Herpes Zoster</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Outros</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_gram_positivo']['meningite']?>
                            </td>
                        </tr>

                    </tbody>
                </table>

            <h3 class="title">Antibioticoterapia</h3>
            <table class="aileron_thin limit-first-td" style="width:100%">
                <thead>
                    <tr>
                        <th colspan="5">
                            Tipo de infecção e característica de uso de ATB 
                        </th>
                    </tr>
                    <tr>
                        <th class="title th-left">Tipo de Infecção</th>
                        <th class="title th-middle">Tratamento único</th>
                        <th class="title th-right">2 tratamentos</th>
                        <th class="title th-right">Tratamento em < 7 dias</th>
                        <th class="title th-right">Tratamento em < 30 dias</th>                        
                    </tr>
                </thead>
                <tbody>
                       <tr>
                            <td>Meningite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['meningite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['meningite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['meningite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['meningite']?>
                            </td>                           
                        </tr>
                        <tr>
                            <td>Encefalite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['encefalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['encefalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['encefalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['encefalite']?>
                            </td>
                        </tr>

                        <tr>
                            <td>Meningoencefalite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['meningoencefalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['meningoencefalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['meningoencefalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['meningoencefalite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Sinusite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['sinusite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['sinusite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['sinusite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['sinusite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Mastoidite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['mastoidite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['mastoidite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['mastoidite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['mastoidite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Otite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['otite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['otite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['otite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['otite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Celulite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['celulite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['celulite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['celulite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['celulite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Amigdalite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['amigdalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['amigdalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['amigdalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['amigdalite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Laringite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['laringite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['laringite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['laringite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['laringite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>TraqueÍte</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['traqueite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['traqueite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['traqueite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['traqueite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Pneumonia</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['pneumonia']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['pneumonia']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['pneumonia']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['pneumonia']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Endocardite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['endocardite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['endocardite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['endocardite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['endocardite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Infecção de Corrente sanguínea</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['infeccao_corrente']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['infeccao_corrente']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['infeccao_corrente']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['infeccao_corrente']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Gastroenterite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['gastroenterite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['gastroenterite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['gastroenterite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['gastroenterite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Hepatite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['hepatite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['hepatite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['hepatite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['hepatite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Pancreatite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['pancreatite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['pancreatite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['pancreatite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['pancreatite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Peritonite</td>
                            <td>
                                <?= $data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['peritsonite'] ?>
                            </td>
                            <td>
                                <?= $data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['peritsonite'] ?>
                            </td>
                            <td>
                                <?= $data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['peritsonite'] ?>
                            </td>
                            <td>
                                <?= $data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['peritsonite'] ?>
                            </td>
                        </tr>
                        <tr>
                            <td>Infecção urinária</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['infeccao_urinaria']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['infeccao_urinaria']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['infeccao_urinaria']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['infeccao_urinaria']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Infecção pélvica</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['infeccao_pelvica']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['infeccao_pelvica']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['infeccao_pelvica']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['infeccao_pelvica']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Piodermite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['piodermite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['piodermite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['piodermite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['piodermite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Foliculite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['foliculite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['foliculite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['foliculite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['foliculite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Fasciíte</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['fasciite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['fasciite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['fasciite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['fasciite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Úlcera Infectada</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['ulcera_infectada']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['ulcera_infectada']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['ulcera_infectada']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['ulcera_infectada']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Abcesso -> este solicitar o local</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['abcesso']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['abcesso']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['abcesso']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['abcesso']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Ostemielite</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['ostemielite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['ostemielite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['ostemielite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['ostemielite']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Artrite séptica</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['artrite_septica']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['artrite_septica']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['artrite_septica']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['artrite_septica']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Tuberculose Pulmonar</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['tuberculose_pulmonar']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['tuberculose_pulmonar']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['tuberculose_pulmonar']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['tuberculose_pulmonar']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Herpes Zoster</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['herpes_zoster']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['herpes_zoster']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['herpes_zoster']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['herpes_zoster']?>
                            </td>
                        </tr>
                        <tr>
                            <td>Outros</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['outros']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['outros']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['outros']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_30']['outros']?>
                            </td>
                        </tr>
                        
                </tbody>
            </table>


            <h3 class="title">IRAS e densidades de procedimentos</h3>
             <table class="aileron_thin limit-first-td" style="width:100%">
                <thead>
                    <tr>
                        <th colspan="5">
                            Tipo de infecção e característica de uso de ATB 
                        </th>
                    </tr>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-middle">Tempo médio</th>
                        <th class="title th-right">Densidade por dia</th>
                        <th class="title th-right">Percentual</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Densidade de Traqueostomia (TQT)</td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['unico']['encefalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['dois_tratamentos']['encefalite']?>
                            </td>
                            <td>
                                <?=$data['hospital']['tipo_infeccao_caracteristica_atb']['tratamento_<_7']['encefalite']?>
                            </td>
                        </tr>
                </tbody>
            </table>
        </div>
    </body>
</html>