<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
</head>
<body>
	<?= $this->element( 'header-logo', ['report_title'=>'Relatório de Checklist Cirúrgico'] ); ?>
	<div class="container">
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title  th-left">Item</th>
					 <th class="title th-middle">Valor</th>
					 <th class="title th-right">%</th>
			  </tr>
			</thead>		 
			<tbody>
				<tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=3>  Cirurgias na Unidade  Durante o Período </td>
                </tr>

				<tr>
					<td >Total de cirurgias na unidade no período</td>
					<td> <?=$data['total_de_registros']?> </td>
					<td>-</td>
			    </tr>

			    <tr class="yolo">
					 <td>Total de pacientes submetidos a cirurgia no período</td>
					 <td><?=$data['tot_pacientes_com_cirurgia']?></td>
					 <td>-</td>
			  	</tr>

				<tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=3> Avaliações do Checklist </td>
                </tr>

                <tr>
					<td >Total avaliações pelo checklist cirúrgico</td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['total']?> </td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Valor percentual de avaliações de checklist pelo total de cirurgias na unidade no período</td>
					<td>- </td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Avaliações de checklist por tipo de cirurgia (n, %)</td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['total']?> </td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['percentual']?>% </td>
			    </tr>

			  	<tr class="yolo">
                    <td class="line-separator title yolo" style="font-weight: bold" colspan=3>  Tipo de cirurgias </td>
                </tr>

                <?php foreach ($data['tipo_cirurgia'] as $key => $tipo_cirurgia) : ?>
                	<tr class="td-indent yolo">
						<td> <?=  $tipo_cirurgia['name']?> </td>
						<td> <?=  $tipo_cirurgia['total']?> </td>
						<td> <?=  $tipo_cirurgia['percentual']?> </td>
				  	</tr>
                <?php endforeach; ?>

			  	<tr class="yolo">
                    <td class="line-separator title yolo" style="font-weight: bold" colspan=3>  Pacientes com Avaliação Incompleta do Checklist </td>
                </tr>
                <tr>
					<td >Total de pacientes com checklists incompletos no período (n)</td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['total']?> </td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['percentual']?>% </td>
			    </tr>
			    <tr>
					<td >Valor percentual de avaliações de checklist incompleto pelo total de cirurgias na unidade no período (%)</td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['total']?> </td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['percentual']?>% </td>
			    </tr>
			    <tr>
					<td >Avaliações de checklist inconpletas por tipo de internação (n, %)</td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['total']?> </td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['percentual']?>% </td>
			    </tr>

			  	<tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=3>  Time in - entrada no centro cirúrgico </td>
                </tr>

                <tr>
					<td >Checado dois identificadores do paciente</td>
					<td> <?=$data['checado_dois_identificadores_do_paciente']['total']?> </td>
					<td> <?=$data['checado_dois_identificadores_do_paciente']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Checado paciente e cirurgia agendada</td>
					<td> <?=$data['checado_paciente_e_cirurgia_agendada']['total']?> </td>
					<td> <?=$data['checado_paciente_e_cirurgia_agendada']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Avaliação pré-anestésica realizada</td>
					<td> <?=$data['avaliacao_pre_anestesica_realizada']['total']?> </td>
					<td> <?=$data['avaliacao_pre_anestesica_realizada']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Termo de Consentimento Anestésico preenchido</td>
					<td> <?=$data['termo_de_consentimento_anestesico_preenchido']['total']?> </td>
					<td> <?=$data['termo_de_consentimento_anestesico_preenchido']['percentual']?></td>
			    </tr>

			    <tr>
					<td >Termo de Consentimento Cirúrgico preenchido</td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['total']?> </td>
					<td> <?=$data['checar_dois_identificadores_do_paciente']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Sítio Demarcado</td>
					<td> <?=$data['sitio_demarcado']['total']?> </td>
					<td> <?=$data['sitio_demarcado']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Conferência de Lateralidade</td>
					<td> <?=$data['conferencia_de_lateralidade']['total']?> </td>
					<td> <?=$data['conferencia_de_lateralidade']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Realizado anamnese e exame físico do paciente</td>
					<td> <?=$data['realizado_anamnese_e_exame_fisico_do_paciente']['total']?> </td>
					<td> <?=$data['realizado_anamnese_e_exame_fisico_do_paciente']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Se Transplante, anexaro impresso do cheklist de recepção do orgâo</td>
					<td> <?=$data['se_transplante_anexaro_impresso_do_cheklist_de_recepcao_do_orgao']['total']?> </td>
					<td> <?=$data['se_transplante_anexaro_impresso_do_cheklist_de_recepcao_do_orgao']['percentual']?>% </td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=3>Time out - antes da indução anestésica</td>
                </tr>

			    <tr>
					<td>As informações do paciente foram confirmadas</td>
					<td> <?=$data['informacoes_do_paciente_foram_confirmadas']['total']?> </td>
					<td> <?=$data['informacoes_do_paciente_foram_confirmadas']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >O antibiótico profilático foi adminsitrado 60 minutos antes da cirurgia</td>
					<td> <?=$data['realizado_antibiotico_profilatico_60_minutos_antes_da_cirurgia']['total']?> </td>
					<td> <?=$data['realizado_antibiotico_profilatico_60_minutos_antes_da_cirurgia']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Materiais / Implantes estão funcionantes e disponíveis</td>
					<td> <?=$data['materiais_implantes_estao_funcionantes_e_disponiveis']['total']?> </td>
					<td> <?=$data['materiais_implantes_estao_funcionantes_e_disponiveis']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Equipamentos cirúrgicos estão checados pela engenharia clínica</td>
					<td> <?=$data['equipamentos_cirurgicos_estao_checados_pela_engenharia_clinica']['total']?> </td>
					<td> <?=$data['equipamentos_cirurgicos_estao_checados_pela_engenharia_clinica']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Termo de Consentimento Anestésico preenchido</td>
					<td> <?=$data['termo_de_consentimento_anestesico_preenchido']['total']?> </td>
					<td> <?=$data['termo_de_consentimento_anestesico_preenchido']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Termo de Consentimento Cirúrgico preenchido</td>
					<td> <?=$data['termo_de_consentimento_cirurgico_preenchido_antes_inducao']['total']?> </td>
					<td> <?=$data['termo_de_consentimento_cirurgico_preenchido_antes_inducao']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Sítio Demarcado</td>
					<td> <?=$data['sitio_demarcado_antes_inducao']['total']?> </td>
					<td> <?=$data['sitio_demarcado_antes_inducao']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Conferência de lateralidade</td>
					<td> <?=$data['conferencia_de_lateralidade_antes_inducao']['total']?> </td>
					<td> <?=$data['conferencia_de_lateralidade_antes_inducao']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Laringoscópio adequado, testado e disponível</td>
					<td> <?=$data['laringoscopio_adequado_testado_disponivel']['total']?> </td>
					<td> <?=$data['laringoscopio_adequado_testado_disponivel']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Máscara de oxigenação e máscara de ventilação adequadas, testadas e disponíveis</td>
					<td> <?=$data['mascara_de_oxigenacao_e_mascara_de_ventilacao_adequadas']['total']?> </td>
					<td> <?=$data['mascara_de_oxigenacao_e_mascara_de_ventilacao_adequadas']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Aspirador adequado, testado e disponível</td>
					<td> <?=$data['aspirador_adequado']['total']?> </td>
					<td> <?=$data['aspirador_adequado']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Seringas estão identificadas?</td>
					<td> <?=$data['seringas_estao_identificadas']['total']?> </td>
					<td> <?=$data['seringas_estao_identificadas']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Monitorização do paciente está funcionando </td>
					<td> <?=$data['monitorizacao_do_paciente_esta_funcionando']['total']?> </td>
					<td> <?=$data['monitorizacao_do_paciente_esta_funcionando']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Paciente com via aérea difícil ou risco presumido </td>
					<td> <?=$data['paciente_com_via_aerea_dificil_ou_risco_presumido']['total']?> </td>
					<td> <?=$data['paciente_com_via_aerea_dificil_ou_risco_presumido']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Kit de via aérea difícil está disponível </td>
					<td> <?=$data['kit_de_via_aerea_dificil_esta_disponivel']['total']?> </td>
					<td> <?=$data['kit_de_via_aerea_dificil_esta_disponivel']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Paciente tem alergia ou suspeita </td>
					<td> <?=$data['paciente_tem_alergia_ou_suspeita']['total']?> </td>
					<td> <?=$data['paciente_tem_alergia_ou_suspeita']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Profilaxia para Tromboembolismo Venoso </td>
					<td> <?=$data['profilaxia_para_tromboembolismo_venoso']['total']?> </td>
					<td> <?=$data['profilaxia_para_tromboembolismo_venoso']['percentual']?>% </td>
			    </tr>

			    <tr class="yolo" style="font-weight: bold">
					<td colspan=3>Qual método de profilaxia utilizada </td>
			    </tr>

			    <?php foreach ($data['metodo_profilaxia'] as $key => $metodo_profilaxia): ?>
			    	<tr>
				    	<td ><?=$metodo_profilaxia['nome']?> </td>
						<td> <?=$metodo_profilaxia['tot']?> </td>
						<td> <?=$metodo_profilaxia['percen']?> </td>
					</tr>
			    <?php endforeach;?>

			    <tr>
					<td >Perda sanguínea estimada em até 500ml em adulto ou 7ml/kg de peso em crianças </td>
					<td> <?=$data['perda_sanguinea_estimada']['total']?> </td>
					<td> <?=$data['perda_sanguinea_estimada']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Solicitado reserva de sangue </td>
					<td> <?=$data['solicitado_reserva_de_sangue']['total']?> </td>
					<td> <?=$data['solicitado_reserva_de_sangue']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >A reserva de sangue está disponível </td>
					<td> <?=$data['a_reserva_de_sangue_esta_disponivel']['total']?> </td>
					<td> <?=$data['a_reserva_de_sangue_esta_disponivel']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Paciente está com acesso venoso central </td>
					<td> <?=$data['paciente_esta_com_acesso_venoso_central']['total']?> </td>
					<td> <?=$data['paciente_esta_com_acesso_venoso_central']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Há dois acessos venosos calibrosos disponíveis </td>
					<td> <?=$data['ha_dois_acessos_venosos_calibrosos_disponiveis']['total']?> </td>
					<td> <?=$data['ha_dois_acessos_venosos_calibrosos_disponiveis']['percentual']?>% </td>
			    </tr>

			     <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=3>Time out - antes da incisão cirúrgica</td>
                </tr>

			    <tr>
					<td >Checar paciente e cirurgia agendada </td>
					<td> <?=$data['checar_paciente_e_cirurgia_agendada']['total']?> </td>
					<td> <?=$data['checar_paciente_e_cirurgia_agendada']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Checagem da Equipe em sala operatória </td>
					<td> <?=$data['checagem_da_equipe_em_sala_operatoria']['total']?> </td>
					<td> <?=$data['checagem_da_equipe_em_sala_operatoria']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Todos os Materiais , Implantes e Equipamentos estão funcionantes e disponíveis </td>
					<td> <?=$data['todos_materiais_implantes_equipamentos_funcionantes_disponiveis']['total']?> </td>
					<td> <?=$data['todos_materiais_implantes_equipamentos_funcionantes_disponiveis']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Realizado antibiótico profilático  </td>
					<td> <?=$data['realizado_antibiotico_profilatico']['total']?> </td>
					<td> <?=$data['realizado_antibiotico_profilatico']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Equipe e material para exame de imagem e laboratoriais estão em sala </td>
					<td> <?=$data['equipe_material_exame_imagem_laboratoriais_estao_em_sala']['total']?> </td>
					<td> <?=$data['equipe_material_exame_imagem_laboratoriais_estao_em_sala']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Há necessidade de congelação / patologista </td>
					<td> <?=$data['ha_necessidade_de_congelacao_patologista']['total']?> </td>
					<td> <?=$data['ha_necessidade_de_congelacao_patologista']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Os frascos estão disponíveis </td>
					<td> <?=$data['os_frascos_estao_disponiveis']['total']?> </td>
					<td> <?=$data['os_frascos_estao_disponiveis']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Solicitado reserva de sangue </td>
					<td> <?=$data['solicitado_reserva_de_sangue_incisao_cirurgica']['total']?> </td>
					<td> <?=$data['solicitado_reserva_de_sangue_incisao_cirurgica']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >A reserva de sangue está disponível </td>
					<td> <?=$data['a_reserva_de_sangue_esta_disponivel_incisao_cirurgica']['total']?> </td>
					<td> <?=$data['a_reserva_de_sangue_esta_disponivel_incisao_cirurgica']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >A condição clinica do paciente está adequada para realizar a cirurgia </td>
					<td> <?=$data['condicao_clinica_paciente_adequada_para_realizar_cirurgia']['total']?> </td>
					<td> <?=$data['condicao_clinica_paciente_adequada_para_realizar_cirurgia']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Materiais de instrumentação cirúrgica estão estéreis e disponíveis </td>
					<td> <?=$data['materiais_instrumentacao_cirurgica_estao_estereis_disponiveis']['total']?> </td>
					<td> <?=$data['materiais_instrumentacao_cirurgica_estao_estereis_disponiveis']['percentual']?>% </td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=3>Check out</td>
                </tr>

			    <tr>
					<td >Contagem de Compressas </td>
					<td> <?=$data['contagem_de_compressas']['total']?> </td>
					<td> <?=$data['contagem_de_compressas']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Realizado congelação </td>
					<td> <?=$data['realizado_congelacao']['total']?> </td>
					<td> <?=$data['realizado_congelacao']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Peça cirúrgica encaminhada para anatomia patológica </td>
					<td> <?=$data['peca_cirurgica_encaminhada_para_anatomia_patologica']['total']?> </td>
					<td> <?=$data['peca_cirurgica_encaminhada_para_anatomia_patologica']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Identificado a peça com etiqueta ou dados do paciente </td>
					<td> <?=$data['identificado_a_peça_com_etiqueta_ou_dados_do_paciente']['total']?> </td>
					<td> <?=$data['identificado_a_peça_com_etiqueta_ou_dados_do_paciente']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Amostras biológicas / material para estudo compatível com etiqueta do paciente </td>
					<td> <?=$data['amostras_biologicas_material_estudo_compativel_etiqueta_paciente']['total']?> </td>
					<td> <?=$data['amostras_biologicas_material_estudo_compativel_etiqueta_paciente']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Soros, infusões, medicamentos e fluidos administrados ao paciente estão devidamente identificados?  (n, %) </td>
					<td> <?=$data['soros_infusoes_medicamentos_paciente_devidamente_identificados']['total']?> </td>
					<td> <?=$data['soros_infusoes_medicamentos_paciente_devidamente_identificados']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Pulseira de identificação devidamente instalada no paciente?  (n, %) </td>
					<td> <?=$data['pulseira_de_identificacao_devidamente_instalada_no_paciente']['total']?> </td>
					<td> <?=$data['pulseira_de_identificacao_devidamente_instalada_no_paciente']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Há algum evento previnido com o TME OUT?  (n, %) </td>
					<td> <?=$data['ha_algum_evento_previnido_com_o_tmeout']['total']?> </td>
					<td> <?=$data['ha_algum_evento_previnido_com_o_tmeout']['percentual']?>% </td>
			    </tr>

			    <tr >
					<td >Nível de Consciência?  (n, %) </td>
					<td> <?=$data['aspirador_adequado']['total']?> </td>
					<td> <?=$data['aspirador_adequado']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Sonda vesical de demora ?  (n, %) </td>
					<td> <?=$data['sonda_vesical_de_demora']['total']?> </td>
					<td> <?=$data['sonda_vesical_de_demora']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Sonda nasogástrica ?  (n, %) </td>
					<td> <?=$data['sonda_nasogastrica']['total']?> </td>
					<td> <?=$data['sonda_nasogastrica']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Houve instalação de Dreno? </td>
					<td> <?=$data['houve_instalacao_de_dreno']['total']?> </td>
					<td> <?=$data['houve_instalacao_de_dreno']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Cateter venoso periférico funcionante </td>
					<td> <?=$data['cateter_venoso_periferico_funcionante']['total']?> </td>
					<td> <?=$data['cateter_venoso_periferico_funcionante']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Cateter venoso central </td>
					<td> <?=$data['cateter_venoso_central']['total']?> </td>
					<td> <?=$data['cateter_venoso_central']['percentual']?>% </td>
			    </tr>
			    <tr>
					<td >Cateter arterial </td>
					<td> <?=$data['cateter_arterial']['total']?> </td>
					<td> <?=$data['cateter_arterial']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td >Envio do prontuário completo ( relatório de cirurgia, ficha anatomo patológica, ficha de recuperação anestésica, ficha de monitorização anestésica e integradores) </td>
					<td> <?=$data['anestesica_integradores']['total']?> </td>
					<td> <?=$data['anestesica_integradores']['percentual']?>% </td>
			    </tr>
			</tbody>
		</table>
	</div>
</body>
</html>