<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <?=  $this->Html->css('pdf', ['fullBase' => true]); ?>
        <?= $this->fetch('css') ?>
        <style type="text/css">
            table {
                border-collapse: collapse;
            }


            tbody tr td, .border th {
              border-right: solid 1px #ccc;
              border-left: solid 1px #ccc;
            }

             .border th {
              border-top: solid 1px #ccc;
            }

            tbody tr td {
                text-align: center;
            }

            tbody tr td:first-child {
                text-align: left;
            }
        </style>
    </head>
    <body>
        <?= $this->element( 'header-logo', ['report_title'=>'Relatório de Escores'] ); ?>
        <div class="container">
            <!-- tempo permanencia Fim -->
            <!-- Pre Deliric START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse; ">
                <thead>
                    <tr class="border">
                        <th rowspan="2" class="title  th-left">Item</th>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                        <?php endforeach;?>
                    </tr>
                </thead>

                <tbody class="yolo" >
                    <tr >
                        <td class="line-separator" style="font-weight: bold;"  colspan=<?= $count_mes ?> >  Pré Deliric  </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['pre_deliric']['total_pacientes'] ?> </td>
                            <td> <?= number_format($month['pre_deliric']['percentual_pacientes'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>
                    <tr>
                        <td >Média do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td><?= $month['pre_deliric']['escore']['media'] ?></td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td><?= $month['pre_deliric']['escore']['mediana'] ?></td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr>
                        <td >Desvio padrão do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td><?= $month['pre_deliric']['escore']['desvio_padrao'] ?></td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Pacientes com valor superior a 40%</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['pre_deliric']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                            <td> <?= number_format($month['pre_deliric']['probabilidade_de_obito_acima_40']['percentual'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>

                </tbody>
            </table>
            <!-- Pre Deliric END -->

            <!-- Sofa START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr class="border">
                        <th rowspan="2" class="title  th-left">Item</th>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                        <?php endforeach;?>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=<?= $count_mes ?> >  SOFA  </td>
                    </tr>
                    <tr >
                        <td >Total de pacientes com escore preenchido</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['sofa']['total_pacientes'] ?> </td>
                            <td> <?= number_format($month['sofa']['percentual_pacientes'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mínimo do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['sofa']['minimo_score'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Máximo do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['sofa']['maximo_score'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['sofa']['escore']['media'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['sofa']['escore']['mediana'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Desvio padrão do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['sofa']['escore']['desvio_padrao'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Pacientes com aumento maior/igual a dois pontos durante a internação</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td><?= $month['sofa']['pacientes_aumento']['total'] ?></td>
                            <td><?= $month['sofa']['pacientes_aumento']['percentual'] ?></td>
                        <?php endforeach;?>
                    </tr>
                </tbody>
            </table>
            <!-- Sofa END -->

            <!-- Curb START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse; page-break-after: always;">
                <thead>
                    <tr class="border">
                        <th rowspan="2" class="title  th-left">Item</th>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                        <?php endforeach;?>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=<?= $count_mes ?> >  Curb 65  </td>
                    </tr>
                    <tr >
                        <td >Total de pacientes com escore preenchido</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['curb']['total_pacientes'] ?> </td>
                            <td> <?= number_format($month['curb']['percentual_pacientes'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['curb']['escore']['media'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['curb']['escore']['mediana'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Desvio padrão do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['curb']['escore']['desvio_padrao'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Total de pacientes com valor superior a 2</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['curb']['total_superior_2'] ?> </td>
                            <td> <?= number_format($month['curb']['percentual_superior_2'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Total de pacientes com valor superior a 3</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['curb']['total_superior_3'] ?> </td>
                            <td> <?= number_format($month['curb']['percentual_superior_3'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Total de pacientes com valor superior a 4</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['curb']['total_superior_4'] ?> </td>
                            <td> <?= number_format($month['curb']['percentual_superior_4'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>
                </tbody>
            </table>
            <!-- Curb END -->


            <!-- Apache START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr class="border">
                        <th rowspan="2" class="title  th-left">Item</th>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                        <?php endforeach;?>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold" colspan=<?= $count_mes ?>>  APACHE II </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore preenchido</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['total_pacientes'] ?> </td>
                            <td> <?= number_format($month['apache']['percentual_pacientes'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mínimo do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['minimo_score'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Máximo do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['maximo_score'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['escore']['media'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['escore']['mediana'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['escore']['desvio_padrao'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Mínimo de previsão de óbito do escore e previsão para América Latina</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['taxa_letalidade_america_latina']['minimo'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Máximo de previsão de óbito do escore e previsão para América Latina</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['taxa_letalidade_america_latina']['maximo'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Média de previsão de óbito do escore e previsão para América Latina</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['taxa_letalidade_america_latina']['media'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana de previsão de óbito do escore e previsão para América Latina</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['taxa_letalidade_america_latina']['mediana'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Desvio padrão de previsão de óbito do escore e previsão para América Latina</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['taxa_letalidade_america_latina']['desvio_padrao'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Taxa de letalidade padronizada para América Latina</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> - </td>
                            <td> <?= $month['apache']['taxa_letalidade_america_latina']['taxa'] ?> </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Pacientes com valor superior a 40%</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['apache']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                            <td> <?= $month['apache']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                        <?php endforeach;?>
                    </tr>
                </tbody>
            </table>
            <!-- Apache II END -->
            <br><br><br><br><br>
            <!-- Saps START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr class="border">
                        <th rowspan="2" class="title  th-left">Item</th>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                        <?php endforeach;?>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold" colspan=<?= $count_mes ?>>  SAPS III </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore preenchido</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['saps']['total_pacientes'] ?> </td>
                            <td> <?= number_format($month['saps']['percentual_pacientes'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mínimo do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['saps']['minimo_score'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Máximo do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['saps']['maximo_score'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['saps']['escore']['media'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['saps']['escore']['mediana'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['saps']['escore']['desvio_padrao'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Pacientes com valor superior a 40%</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['saps']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                            <td> <?= $month['saps']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                        <?php endforeach;?>
                    </tr>
                </tbody>
            </table>
            <!-- Saps III END -->

            <!-- Nas START -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr class="border">
                        <th rowspan="2" class="title  th-left">Item</th>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                        <?php endforeach;?>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold" colspan=<?= $count_mes ?>>  NAS </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore preenchido</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['nas']['total_pacientes'] ?> </td>
                            <td> <?= number_format($month['nas']['percentual_pacientes'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['nas']['escore']['media'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['nas']['escore']['mediana'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['nas']['escore']['desvio_padrao'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Pacientes com valor superior a 25 pontos</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['nas']['pacientes_superior_25_pontos']['total'] ?> </td>
                            <td> <?= $month['nas']['pacientes_superior_25_pontos']['percentual'] ?> </td>
                        <?php endforeach;?>
                    </tr>
                </tbody>
            </table>
            <!-- Nas END -->

            <!-- Crib Start -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr class="border">
                        <th rowspan="2" class="title  th-left">Item</th>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                        <?php endforeach;?>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=<?= $count_mes ?> >  CRIB  </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore preenchido</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['crib']['total_pacientes'] ?> </td>
                            <td> <?= number_format($month['crib']['percentual_pacientes'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Média do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['crib']['escore']['media'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['crib']['escore']['mediana'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Desvio padrão do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['crib']['escore']['desvio_padrao'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Mínimo de previsão de obito do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['crib']['taxa_letalidade']['minimo'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Máximo de previsão de obito do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?=$month['crib']['taxa_letalidade']['maximo'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Média de previsão de obito do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['crib']['taxa_letalidade']['media'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana de previsão de obito do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['crib']['taxa_letalidade']['mediana'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Desvio padrão de previsão de obito do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['crib']['taxa_letalidade']['desvio_padrao'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Taxa de letalidade</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> - </td>
                            <td> <?= $month['crib']['taxa_letalidade']['taxa'] ?> </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Total de pacientes com valor superior a 40%</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['crib']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                            <td> <?= $month['crib']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                        <?php endforeach;?>
                    </tr>
                </tbody>
            </table>
            <!-- Crib END -->

            <!-- SNAP II Start -->
            <table class="aileron_thin relatorio_geral" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr class="border">
                        <th rowspan="2" class="title  th-left">Item</th>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                        <?php endforeach;?>
                    </tr>
                </thead>

                <tbody class="yolo">
                    <tr >
                        <td class="line-separator" style="font-weight: bold"  colspan=<?= $count_mes ?> >  SNAP II  </td>
                    </tr>
                    <tr >
                        <td >Pacientes com escore preenchido</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['snap']['total_pacientes'] ?> </td>
                            <td> <?= number_format($month['snap']['percentual_pacientes'], 2) ?> </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Média do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['snap']['escore']['media'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['snap']['escore']['mediana'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Desvio padrão do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['snap']['escore']['desvio_padrao'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Mínimo de previsão de obito do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['snap']['taxa_letalidade']['minimo'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Máximo de previsão de obito do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?=$month['snap']['taxa_letalidade']['maximo'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Média de previsão de obito do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['snap']['taxa_letalidade']['media'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Mediana de previsão de obito do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['snap']['taxa_letalidade']['mediana'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Desvio padrão de previsão de obito do escore</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['snap']['taxa_letalidade']['desvio_padrao'] ?> </td>
                            <td> - </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Taxa de letalidade</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> - </td>
                            <td> <?= $month['snap']['taxa_letalidade']['taxa'] ?> </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Total de pacientes com valor superior a 70 pontos ou previsão de óbito superior a 40%</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <td> <?= $month['snap']['probabilidade_de_obito_acima_40']['total'] ?> </td>
                            <td> <?= $month['snap']['probabilidade_de_obito_acima_40']['percentual'] ?> </td>
                        <?php endforeach;?>
                    </tr>
                </tbody>
            </table>
            <!-- SNAPII END -->
        </div>
    </body>
</html>