<style type="text/css">
table {
    border-collapse: collapse;
}


tbody tr td, .border th {
  border-right: solid 1px #ccc;
  border-left: solid 1px #ccc;
}

 .border th {
  border-top: solid 1px #ccc;
}

tbody tr td {
    text-align: center;
}

tbody tr td:first-child {
    text-align: left;
}
</style>

<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <?=$this->Html->css('pdf', ['fullBase' => true]);?>
    <?=$this->fetch('css')?>
</head>
<body>
<?=$this->element('header-logo', ['report_title' => 'Relatório de TEV Clinico']);?>
    <div class="container">
        <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr class="border">
                     <th rowspan="2" class="title  th-left">Item</th>
                     <?php foreach ($data['dates'] as $key => $month): ?>
                         <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                     <?php endforeach;?>
                </tr>
                <tr class="border">
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <th class="title  th-left">VA</th>
                        <th class="title  th-left">%</th>
                     <?php endforeach;?>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                      Detailed  Taxa de adesão ao protocolo de TEV
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td>-</td>
                        <td> <?= $month['taxa_adesao_protocolo_tev'] ?>% </td>
                     <?php endforeach;?>

                    
                </tr>

                <tr>
                    <td>
                        Pacientes com risco nos setores: unidade de internação
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['totalSetorUnidadeInternacao'] ?> </td>
                        <td> <?= $month['setorUnidadeInternacaoPercentual'] ?>% </td>
                     <?php endforeach;?>

                </tr>
                <tr>
                    <td>
                        Pacientes com risco nos setores: unidades intensivas
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['totalSetorUnidadeIntensiva'] ?> </td>
                        <td> <?= $month['setorUnidadeIntensivaPercentual'] ?>% </td>
                     <?php endforeach;?>
                </tr>

                <tr>
                    <td>
                        Pacientes com risco para tev
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['totalRiscoTev'] ?> </td>
                        <td> <?= $month['riscoTevPercentual'] ?>% </td>
                     <?php endforeach;?>
                </tr>

                <!--tr>
                    <td colspan="3" style="font-weight: bold; text-align: center;">% de contra indicação para profilaxia de TEV</td>
                </tr-->

                <tr>
                    <td>
                        Contra indicação para profilaxia de TEV
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['countContraIndicacaoParaProfilaxiaTev'] ?> </td>
                        <td> <?= $month['percentualContraIndicacaoParaProfilaxiaTev'] ?>% </td>
                     <?php endforeach;?>
                </tr>

                <tr>
                    <td>
                        Taxa de uso de profilaxia medicamentosa
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['paciente_profi_medi']['tot'] ?> </td>
                        <td> <?= $month['paciente_profi_medi']['percen'] ?>% </td>
                     <?php endforeach;?>
                </tr>

                <tr>
                    <td>
                        Taxa de uso de profilaxia mecânica
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['paciente_profi_meca']['tot'] ?> </td>
                        <td> <?= $month['paciente_profi_meca']['percen'] ?>% </td>
                     <?php endforeach;?>
                </tr>

                <tr>
                    <td>
                        Taxa de não uso de profilaxia em pacientes com risco
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['paciente_nao_usou_profilaxia']['tot'] ?> </td>
                        <td> <?= $month['paciente_nao_usou_profilaxia']['percen'] ?>% </td>
                     <?php endforeach;?>
                </tr>

                <tr>
                    <td>
                        Tempo médio de uso de profilaxia
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['temp_prof']['tot'] ?> </td>
                        <td>-</td>
                     <?php endforeach;?>                    
                </tr>

                <tr>
                    <td>
                        Tempo médio de uso de profilaxia medicamentosa
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['temp_prof_medi']['tot'] ?> </td>
                        <td>-</td>
                     <?php endforeach;?>         
                </tr>

                <tr>
                    <td>
                        Tempo médio de uso de profilaxia mecânica
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['temp_prof_meca']['tot'] ?> </td>
                        <td>-</td>
                     <?php endforeach;?>
                </tr>

                <tr>
                    <td>
                        Taxa de mortalidade nos pacientes que não receberam profilaxia
                    </td>
                    <?php foreach ($data['dates'] as $key => $month): ?>                        
                        <td> <?= $month['tot_paciente_risco_obito'] ?> </td>
                        <td> <?= $month['percen_paciente_risco_obito'] ?>% </td>
                     <?php endforeach;?>
                </tr>
            </tbody>
        </table>
    </div>
</body>
</html>