<style type="text/css">
table {
	border-collapse: collapse;
}


tbody tr td, .border th {
  border-right: solid 1px #ccc;
  border-left: solid 1px #ccc;
}

 .border th {
  border-top: solid 1px #ccc;
}

tbody tr td {
	text-align: center;
}

tbody tr td:first-child {
	text-align: left;
}
</style>

<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
</head>
<body>
	<?=$this->element('header-logo', ['report_title' => 'Relatório de Fisioterapia']);?>
	<div class="container">
		<h3  class="title t-center" style="font-weight: bold" >Barthel</h3>
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title  ">Item</th>
					 <th class="title ">Valor</th>
			  </tr>
			</thead>
			<tbody>
				<tr>
					<td >Média do índice de barthel na admissão</td>
					<td> <?=$data['barthel']['barthel']['media']?> </td>
			  	</tr>

			  	<tr>
					<td >Média do índice de barthel 24 horas após extubação</td>
					<td> <?=$data['barthel']['total_pontos_exturbacao']['media']?> </td>
			  	</tr>

			  	<tr>
					<td >Média do índice de barthel na alta</td>
					<td> <?=$data['barthel']['total_pontos_alta']['media']?> </td>
			  	</tr>

			  <tr>
					<td >Média de variação de indice de barthel na admissão</td>
					<td> <?=$data['barthel']['total_pontos_admissao']['variacao']?>% </td>
			  </tr>

			  <tr>
					<td >Média de variação de indice de barthel 24 horas após extubação </td>
					<td> <?=$data['barthel']['total_pontos_exturbacao']['variacao']?>% </td>
			  </tr>

			  <tr>
					<td >Média de variação de indice de barthel na alta</td>
					<td> <?=$data['barthel']['total_pontos_alta']['variacao']?>% </td>
			  </tr>

			    <tr>
					 <td colspan="2" class="title" style="font-weight: bold" >
					 	Média de distribuição do índice de barthel na admissão a cada dezena
					 </td>
			    </tr>

				<tr class="tr-indent">
					<td>&#8226; 0 - 10</td>
					<td> <?=$data['barthel']['total_pontos_admissao']['10']['tot']?> </td>
				</tr>

				<tr class="tr-indent">
						<td>&#8226; 11 - 20</td>
						<td> <?=$data['barthel']['total_pontos_admissao']['20']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 21 - 30</td>
						<td> <?=$data['barthel']['total_pontos_admissao']['30']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 31 - 40</td>
						<td> <?=$data['barthel']['total_pontos_admissao']['40']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 41 - 50</td>
						<td> <?=$data['barthel']['total_pontos_admissao']['50']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 51 - 60</td>
						<td> <?=$data['barthel']['total_pontos_admissao']['60']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 61 - 70</td>
						<td> <?=$data['barthel']['total_pontos_admissao']['70']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 71 - 80</td>
						<td> <?=$data['barthel']['total_pontos_admissao']['80']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 81 - 90</td>
						<td> <?=$data['barthel']['total_pontos_admissao']['90']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 91 - 100</td>
						<td> <?=$data['barthel']['total_pontos_admissao']['100']['tot']?> </td>

					</tr>

				<tr>
					 <td colspan="2" class="title" style="font-weight: bold" >
					 	Média de distribuição do índice de barthel na alta a cada dezena
					 </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; 0 - 10</td>
					<td> <?=$data['barthel']['total_pontos_alta']['10']['tot']?> </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 11 - 20</td>
					<td> <?=$data['barthel']['total_pontos_alta']['20']['tot']?> </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 21 - 30</td>
					<td> <?=$data['barthel']['total_pontos_alta']['30']['tot']?> </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 31 - 40</td>
					<td> <?=$data['barthel']['total_pontos_alta']['40']['tot']?> </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 41 - 50</td>
					<td> <?=$data['barthel']['total_pontos_alta']['50']['tot']?> </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 51 - 60</td>
					<td> <?=$data['barthel']['total_pontos_alta']['60']['tot']?> </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 61 - 70</td>
					<td> <?=$data['barthel']['total_pontos_alta']['70']['tot']?> </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 71 - 80</td>
					<td> <?=$data['barthel']['total_pontos_alta']['80']['tot']?> </td>

				</tr>

				<tr class="tr-indent">
					<td>&#8226; 81 - 90</td>
					<td> <?=$data['barthel']['total_pontos_alta']['90']['tot']?> </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 91 - 100</td>
					<td> <?=$data['barthel']['total_pontos_alta']['100']['tot']?> </td>

				</tr>



					<tr>
					 	<td colspan="2" class="title" style="font-weight: bold" >Média de distribuição do índice de barthel após extubação a cada dezena</td>
			    	</tr>

					<tr class="tr-indent">
						<td>&#8226; 0 - 10</td>
						<td> <?=$data['barthel']['total_pontos_exturbacao']['10']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 11 - 20</td>
						<td> <?=$data['barthel']['total_pontos_exturbacao']['20']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 21 - 30</td>
						<td> <?=$data['barthel']['total_pontos_exturbacao']['30']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 31 - 40</td>
						<td> <?=$data['barthel']['total_pontos_exturbacao']['40']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 41 - 50</td>
						<td> <?=$data['barthel']['total_pontos_exturbacao']['50']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 51 - 60</td>
						<td> <?=$data['barthel']['total_pontos_exturbacao']['60']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 61 - 70</td>
						<td> <?=$data['barthel']['total_pontos_exturbacao']['70']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 71 - 80</td>
						<td> <?=$data['barthel']['total_pontos_exturbacao']['80']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 81 - 90</td>
						<td> <?=$data['barthel']['total_pontos_exturbacao']['90']['tot']?> </td>

					</tr>

					<tr class="tr-indent">
						<td>&#8226; 91 - 100</td>
						<td> <?=$data['barthel']['total_pontos_exturbacao']['100']['tot']?> </td>

					</tr>


			    <tr>
					 <td class="title" style="font-weight: bold" colspan="2">Pacientes clínicos</td>
			    </tr>


				<tr>
					<td >Média do indice de barthel </td>
					<td> <?=$data['barthel']['clinica']['media']?> </td>

			  	</tr>

			  	<tr>
					<td >Média de variação de indice de barthel (admissão, 24 horas após extubação e alta)</td>
					<td> <?=$data['barthel']['clinica']['variacao']?>% </td>

			  </tr>

				<tr>
					 <td class="title" style="font-weight: bold" colspan="2">Pacientes cirúrgicos</td>
			    </tr>
				<tr>
					<td >Média do indice de barthel </td>
					<td> <?=$data['barthel']['cirurgica']['media']?> </td>

			  	</tr>

			  	<tr>
					<td >Média de variação de indice de barthel (admissão, 24 horas após extubação e alta)</td>
					<td> <?=$data['barthel']['cirurgica']['variacao']?>% </td>

			  </tr>

			</tbody>
		</table>


		<h3  class="title t-center" style="font-weight: bold" >MRC</h3>
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title  ">Item</th>
					 <th class="title ">Valor</th>
					 <th class="title ">%</th>
			    </tr>
			</thead>
			<tbody>
				<tr>
					<td>Média de indice de MRC</td>
					<td> <?=$data['escala']['media_indice_mrc']?> </td>
					<td> - </td>
			    </tr>
				<tr>
					<td>Média de variação de indice de MRC</td>
					<td> <?=$data['escala']['variacao_indice_mrc']?>% </td>
					<td> - </td>
			    </tr>

				<tr>
					<td colspan="3" class="title" style="font-weight: bold" >Média de distribuição do índice MRC a cada dezena</td>
			    </tr>

				<tr class="tr-indent">
					<td>&#8226; 0 - 10</td>
					<td> <?=$data['escala']['pontuation']['10']['tot']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 11 - 20</td>
					<td> <?=$data['escala']['pontuation']['20']['tot']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 21 - 30</td>
					<td> <?=$data['escala']['pontuation']['30']['tot']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 31 - 40</td>
					<td> <?=$data['escala']['pontuation']['40']['tot']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 41 - 50</td>
					<td> <?=$data['escala']['pontuation']['50']['tot']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 51 - 60</td>
					<td> <?=$data['escala']['pontuation']['60']['tot']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 61 - 70</td>
					<td> <?=$data['escala']['pontuation']['70']['tot']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 71 - 80</td>
					<td> <?=$data['escala']['pontuation']['80']['tot']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 81 - 90</td>
					<td> <?=$data['escala']['pontuation']['90']['tot']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 91 - 100</td>
					<td> <?=$data['escala']['pontuation']['100']['tot']?> </td>
					<td> - </td>
				</tr>
			</tbody>
		</table>


		<h3  class="title t-center" style="font-weight: bold" >MRC por setores</h3>
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title  ">Item</th>
					 <th class="title ">Valor</th>
					 <th class="title ">%</th>
			    </tr>
			</thead>
			<tbody>
				<tr>
					<td colspan="3" class="title" style="font-weight: bold" >Média de variação de indice de mrc por setor</td>
			    </tr>
				<?php foreach($data['escala']['setores'] as $sector) : ?>
					
				    <tr class="tr-indent">
						<td>&#8226; <?=$sector['name']?></td>
						<td> <?=$sector['variacao_mrc']?>% </td>
						<td> - </td>
				    </tr>
			    <?php endforeach; ?>

			    <tr>
					<td colspan="3" class="title" style="font-weight: bold" >Média do índice de mrc por setor</td>
			    </tr>
				<?php foreach($data['escala']['setores'] as $sector) : ?>
					
				    <tr class="tr-indent">
						<td>&#8226; <?=$sector['name']?></td>
						<td> <?=$sector['media_mrc']?> </td>
						<td> - </td>
				    </tr>
			    <?php endforeach; ?>
				
				<tr>
					<td colspan="3" class="title" style="font-weight: bold" >Média de distribuição do índice MRC a cada dezena por setor</td>
			    </tr>
			    <?php foreach($data['escala']['setores'] as $sector) : ?>			
				    <tr>
						<td colspan="3" class="title" style="font-weight: bold" ><?=$sector['name']?></td>
				    </tr>

				    <tr class="tr-indent">
						<td>&#8226; 0 - 10</td>
						<td> <?=$sector['pontuation']['10']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td>&#8226; 11 - 20</td>
						<td> <?=$sector['pontuation']['20']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td>&#8226; 21 - 30</td>
						<td> <?=$sector['pontuation']['30']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td>&#8226; 31 - 40</td>
						<td> <?=$sector['pontuation']['40']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td>&#8226; 41 - 50</td>
						<td> <?=$sector['pontuation']['50']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td>&#8226; 51 - 60</td>
						<td> <?=$sector['pontuation']['60']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td>&#8226; 61 - 70</td>
						<td> <?=$sector['pontuation']['70']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td>&#8226; 71 - 80</td>
						<td> <?=$sector['pontuation']['80']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td>&#8226; 81 - 90</td>
						<td> <?=$sector['pontuation']['90']['tot']?> </td>
						<td> - </td>
					</tr>

					<tr class="tr-indent">
						<td>&#8226; 91 - 100</td>
						<td> <?=$sector['pontuation']['100']['tot']?> </td>
						<td> - </td>
					</tr>
			    <?php endforeach; ?>
			  	
			</tbody>
		</table>

		<h3  class="title t-center" style="font-weight: bold" >MRC por pacientes clínicos e cirúrgicos</h3>
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr class="border">
					<th rowspan="2" class="title">Item</th>
					<th colspan="2" class="title ">Clínico</th>
					<th colspan="2" class="title ">Cirúrgico</th>
				</tr>
				<tr class="border">

					 <th class="title ">Valor</th>
					 <th class="title ">%</th>

					 <th class="title ">Valor</th>
					 <th class="title">%</th>
			  </tr>
			</thead>
			<tbody >
				<tr>
					<td >Média do índice de MRC</td>
					<td> <?=$data['escala']['clinica']['media_indice_mrc']?> </td>
					<td> - </td>
					<td> <?=$data['escala']['cirurgica']['media_indice_mrc']?> </td>
					<td> - </td>
			    </tr>

			    <tr>
					<td >Média de variação de indice de MRC</td>
					<td> <?=$data['escala']['clinica']['variacao_indice_mrc']?>% </td>
					<td> - </td>
					<td> <?=$data['escala']['cirurgica']['variacao_indice_mrc']?>% </td>
					<td> - </td>
			    </tr>			    

			    <tr>
					<td> Pacientes com MRC menor que 30 </td>
					<td> <?=$data['escala']['clinica']['tot_paciente_mrc_menor_30']?> </td>
					<td> <?=$data['escala']['clinica']['percen_paciente_mrc_menor_30']?>% </td>
					<td> <?=$data['escala']['cirurgica']['tot_paciente_mrc_menor_30']?> </td>
					<td> <?=$data['escala']['cirurgica']['percen_paciente_mrc_menor_30']?>% </td>
			    </tr>

			    <tr>
					<td>Queda de mrc durante a internação</td>
					<td> <?=$data['escala']['clinica']['media_queda_mrc']?> </td>
					<td> <?=$data['escala']['clinica']['percen_queda_mrc']?>% </td>
					<td> <?=$data['escala']['cirurgica']['media_queda_mrc']?> </td>
					<td> <?=$data['escala']['cirurgica']['percen_queda_mrc']?>% </td>
			    </tr>

			    <tr>
					<td>Pacientes com queda de mrc durante a internação</td>
					<td> <?=$data['escala']['clinica']['tot_paciente_queda_mrc']?> </td>
					<td> <?=$data['escala']['clinica']['percen_paciente_queda_mrc']?>% </td>
					<td> <?=$data['escala']['cirurgica']['tot_paciente_queda_mrc']?> </td>
					<td> <?=$data['escala']['cirurgica']['percen_paciente_queda_mrc']?>% </td>
			    </tr>

			    <tr>
					<td colspan="5" class="title" style="font-weight: bold" >Pacientes com queda de MRC relacionado com os 5 principais diagnósticos </td>
			    </tr>

				<?php foreach($data['escala']['clinica']['diagnosticos'] as $key => $diagnostico) : ?>
					<tr class="tr-indent">
						<td>&#8226; <?= $diagnostico['name'] ?> </td>
						<td> <?=$data['escala']['clinica']['diagnosticos'][$key]['tot_pacientes_queda_mrc']?> </td>
						<td> <?=$data['escala']['clinica']['diagnosticos'][$key]['percentual']?>% </td>
						<td> <?=$data['escala']['cirurgica']['diagnosticos'][$key]['tot_pacientes_queda_mrc']?> </td>
						<td> <?=$data['escala']['cirurgica']['diagnosticos'][$key]['percentual']?>% </td>
				    </tr>
				<?php endforeach; ?>
			</tbody>
		</table>



	</div>
</body>
</html>