<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
</head>
<body>
	<?=$this->element('header-logo', ['report_title' => 'Resumo da CIHDOTT']);?>

	 <!--Div that will hold the pie chart-->
    <div id="chart_div"></div>
	<div class="container">

	<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
                <tr>
                    <th class="title th-left">Item</th>
                    <th class="title th-middle">Total</th>
                  	<th class="title th-middle">%</th>
                </tr>
			</thead>

			<tbody >
				<tr>
					<td >Total de pacientes que houve suspeita de ME</td>
					<td> <?=$data2['tot_pacientes_suspeita_me']?> </td>
					<td> <?=$data2['percen_pacientes_suspeita_me']?>% </td>
			   </tr>

			   <tr>
					<td >Total de pacientes que iniciaram o protocolo de ME  </td>
					<td> <?=$data2['tot_pacientes_com_protocolo_aberto']?> </td>
					<td> <?=$data2['percen_pacientes_iniciaram_protocolo']?>% </td>
			   </tr>

			   <tr>
					<td >Total de pacientes que fecheram o protocolo de ME </td>
					<td> <?=$data2['tot_pacientes_com_protocolo_fechado']?> </td>
					<td> <?=$data2['percen_pacientes_com_protocolo_fechado']?>% </td>
			   </tr>

			   <!-- <tr>
					<td >Total de pacientes que notificou-se ME </td>
					<td> </td>
					<td>  </td>
			   </tr> -->

			   <tr>
					<td >Total de orgãos captados </td>
					<td> <?=$data2['total_de_orgaos_captdados']?> </td>
					<td> <?=$data2['percen_pacientes_doadores']?>% </td>
			   </tr>

			   <!-- <tr>
			   		<td>Orgãos captados individualmente</td>
			   		<td> <?=$data2['total_de_orgaos_captdados']?> </td>
			   		<td> - </td>
			   </tr> -->

			   <tr>
			   		<td>Percentual de orgãos captados individualmente por paciente</td>
			   		<td> - </td>
			   		<td> <?=$data2['percen_orgaos_por_todos_pacientes']?> </td>
			   </tr>

			   <tr>
			   		<td>Percentual de orgãos captados individualmente por pacientes doadores</td>
			   		<td> - </td>
			   		<td> <?=$data2['percen_orgaos_por_pacientes_doadores']?> </td>
			   </tr>

			   <tr>
					 <td class="title" style="font-weight: bold" colspan="3">Orgãos captados individualmente</td>

			    </tr>
				<?php foreach ($data2['orgaos'] as $orgaos): ?>
					<tr class="tr-indent">
						<td>&#8226; <?=$orgaos['name']?> </td>
						<td> <?=$orgaos['tot']?> </td>
						<td> <?=$orgaos['percen']?> </td>
					</tr>
				<?php endforeach;?>

			   <!-- <tr>
					<td >Total de pacientes que captou-se orgãos  </td>
					<td> <?=$data['tot_paciente_captou_orgao']?> </td>
					<td> <?=$data['percen_paciente_captou_orgao']?>% </td>
			   </tr> -->



			  <!--  <tr>
					<td class="yolo falta fazer esse carinha aqui" >Orgãos captados individualmente</td>
					<td> 0 </td>
					<td> <?=$data['percent_paciente_suspeita']?>% </td>
			   </tr> -->

			    <tr>
					 <td class="title" style="font-weight: bold" colspan="3">Tempo do protocolo - entre suspeita de ME e fechamento do protocolo</td>
			    </tr>

				<tr class="tr-indent">
					<td>&#8226; Mínimo</td>
					<td> <?=$data2['tempo_min_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Médio</td>
					<td> <?=$data2['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Máximo</td>
					<td> <?=$data2['tempo_maximo_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<!-- <tr>
					 <td class="title" style="font-weight: bold" colspan="3">Tempo de fechamento do protocolo</td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Mínimo</td>
					<td>0</td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Médio</td>
					<td>0</td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Máximo</td>
					<td>0</td>
					<td>-</td>
				</tr> -->

				<tr>
					 <td class="title" style="font-weight: bold" colspan="3">Tempo entre o 1º e 2º exame clinico</td>
					 <!-- <td ></td> -->
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Mínimo</td>
					<td> <?=$data2['tempo_min_entre_exame_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Médio</td>
					<td> <?=$data2['tempo_medio_entre_exame_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Máximo</td>
					<td> <?=$data2['tempo_maximo_entre_exame_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr>
					 <td class="title" style="font-weight: bold" colspan="3">Tempo entre o 1º exame médico e o 1º exame complementar</td>
					 <!-- <td ></td> -->
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Mínimo</td>
					<td> <?=$data2['tempo_min_entre_exa_medico_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Médio</td>
					<td> <?=$data2['tempo_medio_entre_exa_medico_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Máximo</td>
					<td> <?=$data2['tempo_maximo_entre_exa_medico_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr>
					 <td class="title" style="font-weight: bold" colspan="3"> Tempo de captação - entre fechamento de protocolo de me e captação de orgãos </td>
					 <!-- <td ></td> -->
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Mínimo</td>
					<td></td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Médio</td>
					<td></td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Máximo</td>
					<td></td>
					<td>-</td>
				</tr>

				<tr>
					 <td class="title" style="font-weight: bold" colspan="3"> Método complementar utilizado </td>
					 <!-- <td ></td> -->
			    </tr>

				<tr class="tr-indent">
					<td>&#8226; Eletroencefalograma</td>
					<td> <?=$data2['exame_complementar']['eletroencefalograma']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['eletroencefalograma']['percen']?>% </td>
				</tr>
				<tr class="tr-indent">
					<td>&#8226; Doppler Transcraniano</td>
					<td> <?=$data2['exame_complementar']['doppler']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['doppler']['percen']?>% </td>
				</tr>
				<tr class="tr-indent">
					<td>&#8226; Arteriografia Cerebral</td>
					<td> <?=$data2['exame_complementar']['arteriografia']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['arteriografia']['percen']?>% </td>
				</tr>
				<tr class="tr-indent">
					<td>&#8226; Cintilografia Cerebral</td>
					<td> <?=$data2['exame_complementar']['cintilografia']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['cintilografia']['percen']?>% </td>
				</tr>
				<tr class="tr-indent">
					<td>&#8226; SPECT</td>
					<td> <?=$data2['exame_complementar']['spect']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['spect']['percen']?>% </td>
				</tr>
				<tr class="tr-indent">
					<td>&#8226; Potenciais Evocados</td>
					<td> <?=$data2['exame_complementar']['potenciais']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['potenciais']['percen']?>% </td>
				</tr>

			   <tr>
					<td >Houve confirmação no 1º método utilizado</td>
					<td> <?=$data2['tot_pacientes_usaram_unico_exam_comple']?> </td>
					<td> <?=$data2['percen_pacientes_usaram_unico_exam_comple']?>% </td>
			   </tr>

			    <tr>
					 <td class="title" style="font-weight: bold" colspan="3">Diagnóstico da causa de coma irreversível </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Traumatismo Craniano</td>
					<td> <?=$data2['causa_do_coma']['traumatismo']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['traumatismo']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoxemia</td>
					<td> <?=$data2['causa_do_coma']['hipoxemia']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['hipoxemia']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Parada Cardiorrespiratória</td>
					<td> <?=$data2['causa_do_coma']['parada']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['parada']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Isquêmico</td>
					<td> <?=$data2['causa_do_coma']['ave_isquemico']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['ave_isquemico']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Hemorrágico</td>
					<td> <?=$data2['causa_do_coma']['ave_hemo']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['ave_hemo']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Edema Cerebral</td>
					<td> <?=$data2['causa_do_coma']['edema']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['edema']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipertensão Intracraniana</td>
					<td> <?=$data2['causa_do_coma']['hipertensao']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['hipertensao']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Tumores Cerebrais</td>
					<td> <?=$data2['causa_do_coma']['tumores']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['tumores']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Overdose</td>
					<td> <?=$data2['causa_do_coma']['overdose']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['overdose']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoglicemia</td>
					<td> <?=$data2['causa_do_coma']['hipoglicemia']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['hipoglicemia']['percen']?>% </td>
				</tr>


				<tr >
					 <td class="title" style="font-weight: bold" colspan="3">Diagnóstico por tempo médio de confirmação de ME </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Traumatismo Craniano</td>
					<td> <?=$data2['causa_do_coma']['traumatismo']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoxemia</td>
					<td> <?=$data2['causa_do_coma']['hipoxemia']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Parada Cardiorrespiratória</td>
					<td> <?=$data2['causa_do_coma']['parada']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Isquêmico</td>
					<td> <?=$data2['causa_do_coma']['ave_isquemico']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Hemorrágico</td>
					<td> <?=$data2['causa_do_coma']['ave_hemo']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Edema Cerebral</td>
					<td> <?=$data2['causa_do_coma']['edema']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipertensão Intracraniana</td>
					<td> <?=$data2['causa_do_coma']['hipertensao']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Tumores Cerebrais</td>
					<td> <?=$data2['causa_do_coma']['tumores']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Overdose</td>
					<td> <?=$data2['causa_do_coma']['overdose']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoglicemia</td>
					<td> <?=$data2['causa_do_coma']['hipoglicemia']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>


				<tr >
					 <td class="title" style="font-weight: bold" colspan="3"> Idade por tempo de captação </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; 0 - 10 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['0_10']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 11 - 20 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['11_20']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 21 - 30 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['21_30']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 31 - 40 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['31_40']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 41 - 50 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['41_50']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 51 - 60 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['51_60']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 61 - 70 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['61_70']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 71 - 80 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['71_80']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 81 - 90 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['81_90']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; > 91 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['maior_que_91']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr >
					 <td class="title" style="font-weight: bold" colspan="3"> Relação entre diagnóstico e captação de orgãos </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Traumatismo Craniano</td>
					<td> <?=$data2['causa_do_coma']['traumatismo']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoxemia</td>
					<td> <?=$data2['causa_do_coma']['hipoxemia']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Parada Cardiorrespiratória</td>
					<td> <?=$data2['causa_do_coma']['parada']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Isquêmico</td>
					<td> <?=$data2['causa_do_coma']['ave_isquemico']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Hemorrágico</td>
					<td> <?=$data2['causa_do_coma']['ave_hemo']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Edema Cerebral</td>
					<td> <?=$data2['causa_do_coma']['edema']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipertensão Intracraniana</td>
					<td> <?=$data2['causa_do_coma']['hipertensao']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Tumores Cerebrais</td>
					<td> <?=$data2['causa_do_coma']['tumores']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Overdose</td>
					<td> <?=$data2['causa_do_coma']['overdose']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoglicemia</td>
					<td> <?=$data2['causa_do_coma']['hipoglicemia']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>


				<tr >
					 <td class="title" style="font-weight: bold" colspan="3"> Relação entre idade e captação de orgãos </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; 0 - 10 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['0_10']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 11 - 20 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['11_20']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 21 - 30 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['21_30']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 31 - 40 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['31_40']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 41 - 50 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['41_50']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 51 - 60 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['51_60']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 61 - 70 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['61_70']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 71 - 80 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['71_80']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 81 - 90 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['81_90']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; > 91 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['maior_que_91']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr>
					<td> Taxa de não captação </td>
					<td> <?=$data2['tot_paciente_proto_fechado_nao_doaram']?> </td>
					<td>  <?=$data2['taxa_de_nao_captacao']?>  </td>
				</tr>

			</tbody>
		</table>
		<!-- <div id="piechart" style="width: 100%; height: 500px;"></div> -->
	</div>
</body>
</html>

<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
 <script type="text/javascript">
  google.charts.load('current', {'packages':['corechart']});
  google.charts.setOnLoadCallback(drawChart);

  function drawChart() {

    var data = google.visualization.arrayToDataTable([
      ['Task', 'Hours per Day'],
      ['Work',     11],
      ['Eat',      2],
      ['Commute',  2],
      ['Watch TV', 2],
      ['Sleep',    7]
    ]);

    var options = {
      title: 'Gráfico de tempo de confirmação da ME',
      sliceVisibilityThreshold: 0
    };

    var chart = new google.visualization.PieChart(document.getElementById('piechart'));

    chart.draw(data, options);
  }
</script>