<style type="text/css">
@media print and (color) { 
	* { 
		-webkit-print-color-adjust: exact; 
		print-color-adjust: exact; 
	} 
}

@media print { 
	* { 
		-webkit-print-color-adjust: exact; 
		print-color-adjust: exact; 
	} 
}

body {
  -webkit-print-color-adjust: exact;
   print-color-adjust: exact; 
}

table {
	border-collapse: collapse;
	-webkit-print-color-adjust: exact;
}


tbody tr td, .border th {
  border-right: solid 1px #ccc;
  border-left: solid 1px #ccc;
  -webkit-print-color-adjust: exact;
}

 .border th {
  border-top: solid 1px #ccc;
}

tbody tr td {
	text-align: center;
	-webkit-print-color-adjust: exact;
}

tbody tr td:first-child {
	text-align: left;
}

.sticky-wrap {
	overflow: hidden !important;
	margin: none;
}

.td-same-size td {
	width: 5%;
}

.container:before
{
	content: none;
}
.th-middle {
	text-align: center !important;
}
</style>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
</head>
<body>

<div class="logo">
	<div style="float: left" >			
		<?php 
			if ( isset($unit_logo) && !isset($default_logo) ) 
			{		
				echo $this->Html->image('uploads/'. $unit_logo, array('alt' => 'GH', 'border' => '0', 'style' => 'float: left; margin-left: 14%;'));
			}
			else 
			{
				echo $this->Html->image('uploads/default.png', array('alt' => 'GH', 'border' => '0', 'style' => 'float: left; margin-left: 14%;'));

			}
		?>
	</div>
	<div style="float: right; text-align: right">
		<span style="text-align: center" class='title-dark f-size-32 underline_text'> 
			Resumo da CIHDOTT
		</span>

		<p style="text-align: right; font-size: 0.8em; line-height: 20px;" class='title f-size-32 underline_text'> 
			Período de análise: <?= $date_before->format("d/m/Y") ?>  a <?= $date_after->format("d/m/Y") ?> 
		</p>
	</div>
</div>
	
<div class="container">
	<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
                <tr>
                    <th class="title th-left">Item</th>
                    <th class="title th-middle">Total</th>
                  	<th class="title th-middle">%</th>
                </tr>
			</thead>

			<tbody >
				<tr>
					<td >Total de pacientes que houve suspeita de ME</td>
					<td> <?=$data2['tot_pacientes_suspeita_me']?> </td>
					<td> <?=$data2['percen_pacientes_suspeita_me']?>% </td>
			   </tr>

			   <tr>
					<td >Total de pacientes que iniciaram o protocolo de ME  </td>
					<td> <?=$data2['tot_pacientes_com_protocolo_aberto']?> </td>
					<td> <?=$data2['percen_pacientes_iniciaram_protocolo']?>% </td>
			   </tr>

			   <tr>
					<td >Total de pacientes que fecharam o protocolo de ME </td>
					<td> <?=$data2['tot_pacientes_com_protocolo_fechado']?> </td>
					<td> <?=$data2['percen_pacientes_com_protocolo_fechado']?>% </td>
			   </tr>

			   <!-- <tr>
					<td >Total de pacientes que notificou-se ME </td>
					<td> </td>
					<td>  </td>
			   </tr> -->

			   <tr>
					<td >Total de orgãos captados </td>
					<td> <?=$data2['total_de_orgaos_captdados']?> </td>
					<td> <?=$data2['percen_pacientes_doadores']?>% </td>
			   </tr>

			   <!-- <tr>
			   		<td>Orgãos captados individualmente</td>
			   		<td> <?=$data2['total_de_orgaos_captdados']?> </td>
			   		<td> - </td>
			   </tr> -->

			   <tr>
			   		<td>Percentual de orgãos captados individualmente por paciente</td>
			   		<td> - </td>
			   		<td> <?=$data2['percen_orgaos_por_todos_pacientes']?>% </td>
			   </tr>

			   <tr>
			   		<td>Percentual de orgãos captados individualmente por pacientes doadores</td>
			   		<td> - </td>
			   		<td> <?=$data2['percen_orgaos_por_pacientes_doadores']?>% </td>
			   </tr>

			   <tr>
					 <td class="title" style="font-weight: bold" colspan="3">Orgãos captados individualmente</td>

			    </tr>
				<?php foreach ($data2['orgaos'] as $orgaos): ?>
					<tr class="tr-indent">
						<td>&#8226; <?=$orgaos['name']?> </td>
						<td> <?=$orgaos['tot']?> </td>
						<td> <?=$orgaos['percen']?>% </td>
					</tr>
				<?php endforeach;?>

				<tr>
					<td >Total de pacientes que captou-se orgãos  por pacientes com suspeita de ME</td>
					<td> <?=$data2['media_pacientes_doaroes_pac_suspeita']?> </td>
					<td> <?=$data2['percen_pacientes_doaroes_pac_suspeita']?>% </td>
			   </tr>

			   <tr>
					<td >Total de pacientes que captou-se orgãos  por pacientes com protocolo fechado</td>
					<td> <?=$data2['media_pacientes_doaroes_pac_prot_fechado']?> </td>
					<td> <?=$data2['percen_pacientes_doaroes_pac_prot_fechado']?>% </td>
			   </tr> 



			  <!--  <tr>
					<td class="yolo falta fazer esse carinha aqui" >Orgãos captados individualmente</td>
					<td> 0 </td>
					<td> <?=$data['percent_paciente_suspeita']?>% </td>
			   </tr> -->

			    <tr>
					 <td class="title" style="font-weight: bold" colspan="3">Tempo do protocolo - entre suspeita de ME e fechamento do protocolo</td>
			    </tr>

				<tr class="tr-indent">
					<td>&#8226; Mínimo</td>
					<td> <?=$data2['tempo_min_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Médio</td>
					<td> <?=$data2['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Máximo</td>
					<td> <?=$data2['tempo_maximo_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<!-- <tr>
					 <td class="title" style="font-weight: bold" colspan="3">Tempo de fechamento do protocolo</td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Mínimo</td>
					<td>0</td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Médio</td>
					<td>0</td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Máximo</td>
					<td>0</td>
					<td>-</td>
				</tr> -->

				<tr>
					 <td class="title" style="font-weight: bold" colspan="3">Tempo entre o 1º e 2º exame clinico</td>
					 <!-- <td ></td> -->
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Mínimo</td>
					<td> <?=$data2['tempo_min_entre_exame_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Médio</td>
					<td> <?=$data2['tempo_medio_entre_exame_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Máximo</td>
					<td> <?=$data2['tempo_maximo_entre_exame_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr>
					 <td class="title" style="font-weight: bold" colspan="3">Tempo entre o 1º exame médico e o 1º exame complementar</td>
					 <!-- <td ></td> -->
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Mínimo</td>
					<td> <?=$data2['tempo_min_entre_exa_medico_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Médio</td>
					<td> <?=$data2['tempo_medio_entre_exa_medico_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Máximo</td>
					<td> <?=$data2['tempo_maximo_entre_exa_medico_clinico']?> </td>
					<td>-</td>
				</tr>

				<tr>
					 <td class="title" style="font-weight: bold" colspan="3"> Tempo de captação - entre fechamento de protocolo de ME e captação de orgãos </td>
					 <!-- <td ></td> -->
			    </tr>
				<tr class="tr-indent">	
					<td>&#8226; Mínimo</td>
					<td> <?=$data2['min_tempo_fechamento_protocolo_e_captacao']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Médio</td>
					<td> <?=$data2['medio_tempo_fechamento_protocolo_e_captacao']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Máximo</td>
					<td> <?=$data2['max_tempo_fechamento_protocolo_e_captacao']?> </td>
					<td>-</td>
				</tr>

				<tr>
					 <td class="title" style="font-weight: bold" colspan="3"> Método complementar utilizado </td>
			    </tr>

				<tr class="tr-indent">
					<td>&#8226; Eletroencefalograma</td>
					<td> <?=$data2['exame_complementar']['eletroencefalograma']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['eletroencefalograma']['percen']?>% </td>
				</tr>
				<tr class="tr-indent">
					<td>&#8226; Doppler Transcraniano</td>
					<td> <?=$data2['exame_complementar']['doppler']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['doppler']['percen']?>% </td>
				</tr>
				<tr class="tr-indent">
					<td>&#8226; Arteriografia Cerebral</td>
					<td> <?=$data2['exame_complementar']['arteriografia']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['arteriografia']['percen']?>% </td>
				</tr>
				<tr class="tr-indent">
					<td>&#8226; Cintilografia Cerebral</td>
					<td> <?=$data2['exame_complementar']['cintilografia']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['cintilografia']['percen']?>% </td>
				</tr>
				<tr class="tr-indent">
					<td>&#8226; SPECT</td>
					<td> <?=$data2['exame_complementar']['spect']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['spect']['percen']?>% </td>
				</tr>
				<tr class="tr-indent">
					<td>&#8226; Potenciais Evocados</td>
					<td> <?=$data2['exame_complementar']['potenciais']['tot']?> </td>
					<td> <?=$data2['exame_complementar']['potenciais']['percen']?>% </td>
				</tr>

			   <tr>
					<td >Houve confirmação no 1º método utilizado</td>
					<td> <?=$data2['tot_pacientes_usaram_unico_exam_comple']?> </td>
					<td> <?=$data2['percen_pacientes_usaram_unico_exam_comple']?>% </td>
			   </tr>

			    <tr>
					 <td class="title" style="font-weight: bold" colspan="3">Diagnóstico da causa de coma irreversível </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Traumatismo Craniano</td>
					<td> <?=$data2['causa_do_coma']['traumatismo']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['traumatismo']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoxemia</td>
					<td> <?=$data2['causa_do_coma']['hipoxemia']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['hipoxemia']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Parada Cardiorrespiratória</td>
					<td> <?=$data2['causa_do_coma']['parada']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['parada']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Isquêmico</td>
					<td> <?=$data2['causa_do_coma']['ave_isquemico']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['ave_isquemico']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Hemorrágico</td>
					<td> <?=$data2['causa_do_coma']['ave_hemo']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['ave_hemo']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Edema Cerebral</td>
					<td> <?=$data2['causa_do_coma']['edema']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['edema']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipertensão Intracraniana</td>
					<td> <?=$data2['causa_do_coma']['hipertensao']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['hipertensao']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Tumores Cerebrais</td>
					<td> <?=$data2['causa_do_coma']['tumores']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['tumores']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Overdose</td>
					<td> <?=$data2['causa_do_coma']['overdose']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['overdose']['percen']?>% </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoglicemia</td>
					<td> <?=$data2['causa_do_coma']['hipoglicemia']['tot']?> </td>
					<td> <?=$data2['causa_do_coma']['hipoglicemia']['percen']?>% </td>
				</tr>


				<tr >
					 <td class="title" style="font-weight: bold" colspan="3">Diagnóstico por tempo médio de confirmação de ME </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Traumatismo Craniano</td>
					<td> <?=$data2['causa_do_coma']['traumatismo']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoxemia</td>
					<td> <?=$data2['causa_do_coma']['hipoxemia']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Parada Cardiorrespiratória</td>
					<td> <?=$data2['causa_do_coma']['parada']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Isquêmico</td>
					<td> <?=$data2['causa_do_coma']['ave_isquemico']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Hemorrágico</td>
					<td> <?=$data2['causa_do_coma']['ave_hemo']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Edema Cerebral</td>
					<td> <?=$data2['causa_do_coma']['edema']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipertensão Intracraniana</td>
					<td> <?=$data2['causa_do_coma']['hipertensao']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Tumores Cerebrais</td>
					<td> <?=$data2['causa_do_coma']['tumores']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Overdose</td>
					<td> <?=$data2['causa_do_coma']['overdose']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoglicemia</td>
					<td> <?=$data2['causa_do_coma']['hipoglicemia']['tempo_medio_fechamento_protocolo']?> </td>
					<td> - </td>
				</tr>


				<tr >
					 <td class="title" style="font-weight: bold" colspan="3"> Idade por tempo de captação </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; 0 - 10 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['0_10']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 11 - 20 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['11_20']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 21 - 30 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['21_30']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 31 - 40 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['31_40']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 41 - 50 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['41_50']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 51 - 60 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['51_60']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 61 - 70 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['61_70']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 71 - 80 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['71_80']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 81 - 90 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['81_90']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; > 91 anos</td>
					<td> <?=$data2['idade_por_tempo_captacao']['maior_que_91']['tempo_medio_fechamento_protocolo']?> </td>
					<td>-</td>
				</tr>

				<tr >
					 <td class="title" style="font-weight: bold" colspan="3"> Relação entre diagnóstico e tempo de captação de orgãos </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; Traumatismo Craniano</td>
					<td> <?=$data2['causa_do_coma']['traumatismo']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoxemia</td>
					<td> <?=$data2['causa_do_coma']['hipoxemia']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Parada Cardiorrespiratória</td>
					<td> <?=$data2['causa_do_coma']['parada']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Isquêmico</td>
					<td> <?=$data2['causa_do_coma']['ave_isquemico']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; AVE Hemorrágico</td>
					<td> <?=$data2['causa_do_coma']['ave_hemo']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Edema Cerebral</td>
					<td> <?=$data2['causa_do_coma']['edema']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipertensão Intracraniana</td>
					<td> <?=$data2['causa_do_coma']['hipertensao']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Tumores Cerebrais</td>
					<td> <?=$data2['causa_do_coma']['tumores']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Overdose</td>
					<td> <?=$data2['causa_do_coma']['overdose']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Hipoglicemia</td>
					<td> <?=$data2['causa_do_coma']['hipoglicemia']['media_orgaos_doados']?> </td>
					<td> - </td>
				</tr>


				<tr >
					 <td class="title" style="font-weight: bold" colspan="3"> Relação entre idade e captação de orgãos </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; 0 - 10 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['0_10']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 11 - 20 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['11_20']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 21 - 30 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['21_30']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 31 - 40 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['31_40']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 41 - 50 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['41_50']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 51 - 60 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['51_60']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 61 - 70 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['61_70']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 71 - 80 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['71_80']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 81 - 90 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['81_90']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; > 91 anos</td>
					<td> <?=$data2['idade_orgaos_doados']['maior_que_91']['media_orgaos_doados']?> </td>
					<td>-</td>
				</tr>

				<tr>
					<td> Taxa de não captação </td>
					<td> <?=$data2['tot_paciente_proto_fechado_nao_doaram']?> </td>
					<td>  <?=$data2['taxa_de_nao_captacao']?>  </td>
				</tr>

				<tr >
					 <td class="title" style="font-weight: bold" colspan="3"> Tabela de uso de exame complementar e média de captação de orgãos </td>
			    </tr>
				<tr class="tr-indent">
					<td>&#8226; 1 exame</td>
					<td> <?=$data2['media_orgaos_1_exam_comp']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 2 exames</td>
					<td> <?=$data2['media_orgaos_2_exam_comp']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 3 exames</td>
					<td> <?=$data2['media_orgaos_3_exam_comp']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 4 exames</td>
					<td> <?=$data2['media_orgaos_4_exam_comp']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 5 exames </td>
					<td> <?=$data2['media_orgaos_5_exam_comp']?> </td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; 6 exames</td>
					<td> <?=$data2['media_orgaos_6_exam_comp']?> </td>
					<td>-</td>
				</tr>
			</tbody>
		</table>


		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr >
					 <th class="title" style="font-weight: bold" colspan="10">Tabela de gravidade do SAPS e tempo de confirmação </th>
			    </tr>
                
			</thead>

			<tbody >
				<tr class="title f-bold">
                    <td >Tempo</td>
                    <td > 0 - 10 </td>
                  	<td > 11 - 20</td>
                  	<td > 21 - 30</td>
                  	<td > 31 - 40</td>
                  	<td > 41 - 50</td>
                  	<td > 51 - 60</td>
                  	<td > 61 - 70</td>
                  	<td > 71 - 80</td>
                  	<td > 81 - 90</td>
                </tr>				
					<tr >
						<td>Até 12h</td>
						<?php foreach ($data2['saps']['tempo_confirmacao_ate_12h'] as $saps) : ?>							
							<td> <?=$saps['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 13h à 24h</td>
						<?php foreach ($data2['saps']['tempo_confirmacao_12_a_24h'] as $saps) : ?>							
							<td> <?=$saps['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 25h à 36h</td>
						<?php foreach ($data2['saps']['tempo_confirmacao_24_a_36h'] as $saps) : ?>							
							<td> <?=$saps['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 37h à 48h</td>
						<?php foreach ($data2['saps']['tempo_confirmacao_36_a_48h'] as $saps) : ?>							
							<td> <?=$saps['tot']?> </td>
						<?php endforeach; ?>
					</tr>		

					<tr >
						<td>De 49h à 60h</td>
						<?php foreach ($data2['saps']['tempo_confirmacao_48_a_60h'] as $saps) : ?>							
							<td> <?=$saps['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 61h à 72h</td>
						<?php foreach ($data2['saps']['tempo_confirmacao_60_a_72h'] as $saps) : ?>							
							<td> <?=$saps['tot']?> </td>
						<?php endforeach; ?>
					</tr>		

					<tr >
						<td>Maior que 72h</td>
						<?php foreach ($data2['saps']['tempo_confirmacao_maior_72h'] as $saps) : ?>							
							<td> <?=$saps['tot']?> </td>
						<?php endforeach; ?>
					</tr>												
			</tbody>
		</table>

		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr >
					 <th class="title" style="font-weight: bold" colspan="10">Tabela de gravidade do CURB 65 e tempo de confirmação </th>
			    </tr>
                
			</thead>

			<tbody >
				<tr class="title f-bold">
                    <td >Tempo</td>
                    <td > 0 </td>
                  	<td > 1 </td>
                  	<td > 2 </td>
                  	<td > 3 </td>
                  	<td > 4 </td>
                  	<td > 5 </td>

                </tr>				
					<tr >
						<td>Até 12h</td>
						<?php foreach ($data2['curb']['tempo_confirmacao_ate_12h'] as $curb) : ?>							
							<td> <?=$curb['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 13h à 24h</td>
						<?php foreach ($data2['curb']['tempo_confirmacao_12_a_24h'] as $curb) : ?>							
							<td> <?=$curb['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 25h à 36h</td>
						<?php foreach ($data2['curb']['tempo_confirmacao_24_a_36h'] as $curb) : ?>							
							<td> <?=$curb['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 37h à 48h</td>
						<?php foreach ($data2['curb']['tempo_confirmacao_36_a_48h'] as $curb) : ?>							
							<td> <?=$curb['tot']?> </td>
						<?php endforeach; ?>
					</tr>		

					<tr >
						<td>De 49h à 60h</td>
						<?php foreach ($data2['curb']['tempo_confirmacao_48_a_60h'] as $curb) : ?>							
							<td> <?=$curb['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 61h à 72h</td>
						<?php foreach ($data2['curb']['tempo_confirmacao_60_a_72h'] as $curb) : ?>							
							<td> <?=$curb['tot']?> </td>
						<?php endforeach; ?>
					</tr>		

					<tr >
						<td>Maior que 72h</td>
						<?php foreach ($data2['curb']['tempo_confirmacao_maior_72h'] as $curb) : ?>							
							<td> <?=$curb['tot']?> </td>
						<?php endforeach; ?>
					</tr>												
			</tbody>
		</table>

		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr >
					 <th class="title" style="font-weight: bold" colspan="10">Tabela de gravidade do SOFA e tempo de confirmação </th>
			    </tr>
                
			</thead>

			<tbody >
				<tr class="title f-bold td-same-size">
                    <td >Tempo</td>
                    <td > 0 </td>
                  	<td > 1 - 4 </td>
                  	<td > 5 - 8 </td>
                  	<td > 9 - 12 </td>
                  	<td > 13 - 16 </td>
                  	<td > 17 - 20 </td>
                  	<td > 21 - 24 </td>

                </tr>				
					<tr >
						<td>Até 12h</td>
						<?php foreach ($data2['sofa']['tempo_confirmacao_ate_12h'] as $sofa) : ?>							
							<td> <?=$sofa['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 13h à 24h</td>
						<?php foreach ($data2['sofa']['tempo_confirmacao_12_a_24h'] as $sofa) : ?>							
							<td> <?=$sofa['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 25h à 36h</td>
						<?php foreach ($data2['sofa']['tempo_confirmacao_24_a_36h'] as $sofa) : ?>							
							<td> <?=$sofa['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 37h à 48h</td>
						<?php foreach ($data2['sofa']['tempo_confirmacao_36_a_48h'] as $sofa) : ?>							
							<td> <?=$sofa['tot']?> </td>
						<?php endforeach; ?>
					</tr>		

					<tr >
						<td>De 49h à 60h</td>
						<?php foreach ($data2['sofa']['tempo_confirmacao_48_a_60h'] as $sofa) : ?>							
							<td> <?=$sofa['tot']?> </td>
						<?php endforeach; ?>
					</tr>

					<tr >
						<td>De 61h à 72h</td>
						<?php foreach ($data2['sofa']['tempo_confirmacao_60_a_72h'] as $sofa) : ?>							
							<td> <?=$sofa['tot']?> </td>
						<?php endforeach; ?>
					</tr>		

					<tr >
						<td>Maior que 72h</td>
						<?php foreach ($data2['sofa']['tempo_confirmacao_maior_72h'] as $sofa) : ?>							
							<td> <?=$sofa['tot']?> </td>
						<?php endforeach; ?>
					</tr>												
			</tbody>
		</table>


		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr >
                     <th class="title" style="font-weight: bold" colspan="10">Tabela de gravidade do SAPS e tempo de captação </th>
                </tr>
                
            </thead>

            <tbody >
                <tr class="title f-bold">
                    <td >Tempo</td>
                    <td > 0 - 10 </td>
                    <td > 11 - 20</td>
                    <td > 21 - 30</td>
                    <td > 31 - 40</td>
                    <td > 41 - 50</td>
                    <td > 51 - 60</td>
                    <td > 61 - 70</td>
                    <td > 71 - 80</td>
                    <td > 81 - 90</td>
                </tr>               
                    <tr >
                        <td>Até 12h</td>
                        <?php foreach ($data2['saps']['tempo_captacao_ate_12h'] as $saps) : ?>                           
                            <td> <?=$saps['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 13h à 24h</td>
                        <?php foreach ($data2['saps']['tempo_captacao_12_a_24h'] as $saps) : ?>                          
                            <td> <?=$saps['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 25h à 36h</td>
                        <?php foreach ($data2['saps']['tempo_captacao_24_a_36h'] as $saps) : ?>                          
                            <td> <?=$saps['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 37h à 48h</td>
                        <?php foreach ($data2['saps']['tempo_captacao_36_a_48h'] as $saps) : ?>                          
                            <td> <?=$saps['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>       

                    <tr >
                        <td>De 49h à 60h</td>
                        <?php foreach ($data2['saps']['tempo_captacao_48_a_60h'] as $saps) : ?>                          
                            <td> <?=$saps['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 61h à 72h</td>
                        <?php foreach ($data2['saps']['tempo_captacao_60_a_72h'] as $saps) : ?>                          
                            <td> <?=$saps['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>       

                    <tr >
                        <td>Maior que 72h</td>
                        <?php foreach ($data2['saps']['tempo_captacao_maior_72h'] as $saps) : ?>                         
                            <td> <?=$saps['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>                                               
            </tbody>
        </table>

        <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr >
                     <th class="title" style="font-weight: bold" colspan="10">Tabela de gravidade do CURB 65 e tempo de captação </th>
                </tr>
                
            </thead>

            <tbody >
                <tr class="title f-bold">
                    <td >Tempo</td>
                    <td > 0 </td>
                    <td > 1 </td>
                    <td > 2 </td>
                    <td > 3 </td>
                    <td > 4 </td>
                    <td > 5 </td>

                </tr>               
                    <tr >
                        <td>Até 12h</td>
                        <?php foreach ($data2['curb']['tempo_captacao_ate_12h'] as $curb) : ?>                           
                            <td> <?=$curb['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 13h à 24h</td>
                        <?php foreach ($data2['curb']['tempo_captacao_12_a_24h'] as $curb) : ?>                          
                            <td> <?=$curb['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 25h à 36h</td>
                        <?php foreach ($data2['curb']['tempo_captacao_24_a_36h'] as $curb) : ?>                          
                            <td> <?=$curb['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 37h à 48h</td>
                        <?php foreach ($data2['curb']['tempo_captacao_36_a_48h'] as $curb) : ?>                          
                            <td> <?=$curb['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>       

                    <tr >
                        <td>De 49h à 60h</td>
                        <?php foreach ($data2['curb']['tempo_captacao_48_a_60h'] as $curb) : ?>                          
                            <td> <?=$curb['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 61h à 72h</td>
                        <?php foreach ($data2['curb']['tempo_captacao_60_a_72h'] as $curb) : ?>                          
                            <td> <?=$curb['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>       

                    <tr >
                        <td>Maior que 72h</td>
                        <?php foreach ($data2['curb']['tempo_captacao_maior_72h'] as $curb) : ?>                         
                            <td> <?=$curb['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>                                               
            </tbody>
        </table>        

        <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr >
                     <th class="title" style="font-weight: bold" colspan="10">Tabela de gravidade do SOFA e tempo de captação </th>
                </tr>
                
            </thead>

            <tbody >
                <tr class="title f-bold td-same-size">
                    <td >Tempo</td>
                    <td > 0 </td>
                    <td > 1 - 4 </td>
                    <td > 5 - 8 </td>
                    <td > 9 - 12 </td>
                    <td > 13 - 16 </td>
                    <td > 17 - 20 </td>
                    <td > 21 - 24 </td>

                </tr>               
                    <tr >
                        <td>Até 12h</td>
                        <?php foreach ($data2['sofa']['tempo_captacao_ate_12h'] as $sofa) : ?>                           
                            <td> <?=$sofa['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 13h à 24h</td>
                        <?php foreach ($data2['sofa']['tempo_captacao_12_a_24h'] as $sofa) : ?>                          
                            <td> <?=$sofa['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 25h à 36h</td>
                        <?php foreach ($data2['sofa']['tempo_captacao_24_a_36h'] as $sofa) : ?>                          
                            <td> <?=$sofa['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 37h à 48h</td>
                        <?php foreach ($data2['sofa']['tempo_captacao_36_a_48h'] as $sofa) : ?>                          
                            <td> <?=$sofa['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>       

                    <tr >
                        <td>De 49h à 60h</td>
                        <?php foreach ($data2['sofa']['tempo_captacao_48_a_60h'] as $sofa) : ?>                          
                            <td> <?=$sofa['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>

                    <tr >
                        <td>De 61h à 72h</td>
                        <?php foreach ($data2['sofa']['tempo_captacao_60_a_72h'] as $sofa) : ?>                          
                            <td> <?=$sofa['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>       

                    <tr >
                        <td>Maior que 72h</td>
                        <?php foreach ($data2['sofa']['tempo_captacao_maior_72h'] as $sofa) : ?>                         
                            <td> <?=$sofa['tot']?> </td>
                        <?php endforeach; ?>
                    </tr>                                               
            </tbody>
        </table>

        <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr >
                     <th class="title" style="font-weight: bold" colspan="10"> Tempo de confirmação de ME e pacientes sem doação de orgãos </th>
                </tr>                
            </thead>

            <tbody >
                <tr class="title f-bold">
                    <td >Tempo</td>
                    <td > Valor </td>

                </tr>               
                    <tr >
                        <td>Até 12h</td>
                       	<td> <?= $data2['tempo_confirmacao']['tempo_confirmacao_ate_12h']['tot_paciente_sem_captacao'] ?> </td>
                    </tr>

                    <tr >
                        <td>De 13h à 24h</td>
                        <td> <?= $data2['tempo_confirmacao']['tempo_confirmacao_12_a_24h']['tot_paciente_sem_captacao'] ?> </td>
                    </tr>

                    <tr >
                        <td>De 25h à 36h</td>
                        <td> <?= $data2['tempo_confirmacao']['tempo_confirmacao_24_a_36h']['tot_paciente_sem_captacao'] ?> </td>
                    </tr>

                    <tr >
                        <td>De 37h à 48h</td>
                        <td> <?= $data2['tempo_confirmacao']['tempo_confirmacao_36_a_48h']['tot_paciente_sem_captacao'] ?> </td>
                    </tr>       

                    <tr >
                        <td>De 49h à 60h</td>
                        <td> <?= $data2['tempo_confirmacao']['tempo_confirmacao_48_a_60h']['tot_paciente_sem_captacao'] ?> </td>
                    </tr>

                    <tr >
                        <td>De 61h à 72h</td>
                        <td> <?= $data2['tempo_confirmacao']['tempo_confirmacao_60_a_72h']['tot_paciente_sem_captacao'] ?> </td>
                    </tr>       

                    <tr >
                        <td>Maior que 72h</td>
                        <td> <?= $data2['tempo_confirmacao']['tempo_confirmacao_maior_72h']['tot_paciente_sem_captacao'] ?> </td>
                    </tr>                                               
            </tbody>
        </table>

		 <!--Div that will hold the pie chart-->
    	<div id="chart_div_confirmation_time"></div>
    	<br><br>

    	<div id="chart_div_organs_reception_time"></div>
    	<br><br>
	</div>
</body>
</html>

<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
 <script type="text/javascript">
 	$('*[media="screen"]').attr('media', '');$('*[media="print"]').remove();

  	google.charts.load('current', {packages: ['corechart', 'line']});
	google.charts.setOnLoadCallback(drawBasic);
	google.charts.setOnLoadCallback(drawBasicOrgans);
	
	function drawBasic() 
	{
	  var data = new google.visualization.DataTable();
	  data.addColumn('number', 'X');
	  data.addColumn('number', 'Orgãos');

	  data.addRows([
	    	[12, <?= $data2['media_orgaos_temp_confirmacao_ate_12h'] ?>],
	    	[24, <?= $data2['media_orgaos_temp_confirmacao_13_ate_24h'] ?>],
	    	[36, <?= $data2['media_orgaos_temp_confirmacao_25_ate_36h'] ?>],
	    	[48, <?= $data2['media_orgaos_temp_confirmacao_37_ate_48h'] ?>],
	    	[60, <?= $data2['media_orgaos_temp_confirmacao_49_ate_60h'] ?>],
	    	[72, <?= $data2['media_orgaos_temp_confirmacao_61_ate_72h'] ?>],

	  ]);

	  var options = 
	  {
	    hAxis: 
	    {
	      title: 'Tempo de confirmação (em horas)'
	    },
	    vAxis: 
	    {
	    	title: 'Orgãos captados'	      
	    }
	  };

	  var chart = new google.visualization.LineChart(document.getElementById('chart_div_confirmation_time'));

	  chart.draw(data, options);
    }

    function drawBasicOrgans() 
	{
	  var data = new google.visualization.DataTable();
	  data.addColumn('number', 'X');
	  data.addColumn('number', 'Orgãos');

	  data.addRows([
	    	[12, <?= $data2['media_orgaos_temp_captacao_ate_12h'] ?>],
	    	[24, <?= $data2['media_orgaos_temp_captacao_13_ate_24h'] ?>],
	    	[36, <?= $data2['media_orgaos_temp_captacao_25_ate_36h'] ?>],
	    	[48, <?= $data2['media_orgaos_temp_captacao_37_ate_48h'] ?>],
	    	[60, <?= $data2['media_orgaos_temp_captacao_49_ate_60h'] ?>],
	    	[72, <?= $data2['media_orgaos_temp_captacao_61_ate_72h'] ?>],

	  ]);

	  var options = 
	  {
	    hAxis: 
	    {
	      title: 'Tempo de captação (em horas)'
	    },
	    vAxis: 
	    {
	    	title: 'Orgãos captados'	      
	    }
	  };

	  var chart = new google.visualization.LineChart(document.getElementById('chart_div_organs_reception_time'));

	  chart.draw(data, options);
    }

    window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);

	(function() {
	    //url da listagem
	    var urlIndex = '<?= $this->Html->linkUrl(['controller'=>'Relatorios','action' => 'dashboard']); ?>';

	    $("form :input").prop('readonly', true);
	    $("form :input").css('readonly', true);
	    $('nav').css('display','none');

	    // definindo a função de Print
	    function PrintPage() {
	        window.print();
	        setTimeout(function () {
	          $.LoadingOverlay("show");
	          window.location.href=urlIndex;
	        },1200);
	    }

	    //chamando o spinner e a função de imprimir
	    setTimeout(function(){ 
	      PrintPage();
	    },1000);

	  })();
</script>