<?php
    echo $this->element( 'screening-menu' );

    if(isset($screening->date_of_hospitalization)){
    	$screening->date_of_hospitalization = $screening->date_of_hospitalization->format('d/m/Y');
    }
    if(isset($screening->time_of_hospitalization)){
    	$screening->time_of_hospitalization = $screening->time_of_hospitalization->format('H:i');
    }

//echo $this->element( 'screening-menu' );
//$from = new DateTime( $patient['birthday'] );
$from = $patient['birthday'];
//print_r($from);
$to = new DateTime('today');
//echo "<br>";
//print_r($from);
$age = $from->diff($to)->y;
$months = $from->diff(new DateTime())->format('%m') + 12 * $from->diff(new DateTime())->format('%y');
//echo "<br>age = " . $age;

$nivel_da_dor         = ["Forte (7 a 10)", "Moderada (4 a 6)", "Leve (1 a 3)", "Sem dor (0)"];
$retorno              = ["1 retorno em &lt;24 horas", "2 retornos em &lt;72 horas"];
$nivel_consciencia    = ["Inconsciente (coma)", 'Alterado (sonolência ou torpor)'];
$via_aerea_respiracao = ["Cianose de lábios", "Dispneia", "Taquipneia", "Coriza e/ou espirros"];
$cardiovascular       = ["Pulsos ausentes", "Cianose de extremidades", "Enchimento capilar > 2s", "Pulsos finos"];

$admissao_emergencial     = ['Convulsões', 'Nível de consciência comprometido', 'Apneia', ' Cianose', 'Outros'];
$classificacao_risco      = ['azul' => 'Azul', 'verde' => 'Verde', 'amarelo' => 'Amarelo', 'vermelho' => 'Vermelho'];
$neurologico              = ["Convulsão no momento do atendimento", "Déficit focal agudo", "Estado pós-ictal", "Glicemia capilar: < 40(<= 1 ano) ou <60 (1> ano)", "Convulsão nas últimas 12h", "Glicemia capilar: 40~60 (< 1 ano) ou 60~80 (>1 ano)"];
$gastrintestinal          = ["Sinais de desidratação", "Retenção urinária", "Palpável", "Dor testiclar", "Vômitos no momento ou relato devômitos incoercíveis", "> 5 Evacuações/dia com globo vesical ou evacuações com sangue", "Dor abdominal atual e persistente", "Dor abdominal intermitente em <2 anos"];
$trauma                   = ["Politraumatizado", "TCE com relato de perda da consciência e/ou vômitos", "Fratura exposta ou com deformidade", "Mecanismo de alta energia", "TCE com < 12h e sem relato de perda da consciência ou de vômitos", "Suspeita de fratura ou luxação de membros", "TCE com > 12h sem perda de consciência e sem vômitos"];
$sangramento_ou_ferimento = ["Hemorragia sem controle", "Sangramento abundante", "Ferimento extenso", "Sangramento moderado", "Pequeno ferimento com sangramento leve", "Ferimento moderado", "Sangramento pequeno", "Pequeno ferimento, sem sangramento"];
$queimadura               = ["De face e/ou inalação", "Moderada >20%", "Queimadura elétrica ou circunferencial ou química", "Leve < 10%"];
$intoxicacao_exogena      = ["Presente (relato de)"];
$pele                     = ["Urticária com estridor e dificuldade respiratória importante", "Púrpura", "	Edema + PA >140×90", "Urticárial com edema de face", "Edema sem hipertensão", "Sinais de celulite", "Urticárial extensa", "Urticária localizada", "Exantema sem petéquias", "Impetigo ou abcesso localizado"];

$locomotor          = ["Claudicação + febre", "Alteração aguda da marcha"];
$corpo_estranho     = ["Presente"];
$inespecificos      = ["Alteração de comportamento", "Não consegue ficar de pé", "Irritabilidade", "Choro incessante"];
$comorbidades       = ["Diabetes com hipoglicemia grave (glicemia capilar <20)", "Imunossupressão com febre", "Diabetes com hipo ou hiperglicemia: glicemia capilar <60 ou >400", "Febre",	"Doenças neuromusculares", "Imunossupressão sem febre", "Diabetes com glicemia capilar entre 250-400"];
$suspeita_de_dengue = ["Sinais de choque", "Presença de sinais de alarme", "Ausência de sinais de alarme"];

$pain_intensity = [
    'Leve'     => [
        0, 1, 2,
    ],
    'Moderada' => [
        3, 4, 5, 6, 7,
    ],
    'Intensa'  => [
        8, 9, 10,
    ],
];

$fraquesa_muscular = ['Generalizada' => 'Generalizada', 'Membros' => 'Membros', 'Face' => 'Face'];

$alteracao_consciencia = ['Inquieto' => 'Inquieto', 'Agitado' => 'Agitado', 'Agressivo' => 'Agressivo', 'Obnubilado' => 'Obnubilado', 'Torporoso' => 'Torporoso', 'Comatoso' => 'Comatoso'];

$fraquesa_muscular_tipo = ['aguda_menor_48h' => 'Aguda < 48h', 'cronica' => 'Crônica'];

$queixa_principal = ['alteracao_estado_mental' => 'Alteração de estado mental', 'dispneia' => 'Dispneia', 'hiperglicemia' => 'Hiperglicemia', 'alt_sinais_vitais' => 'Alteração de sinais vitais isolados', 'tosse' => 'Tosse', 'lesoes_de_pele' => 'Lesões de pele', 'dor' => 'Dor', 'febre' => 'Febre', 'hipoglicemia' => 'Hipoglicemia', 'diarreia' => 'Diarreia', 'casos_especiais' => 'Casos especiais', 'procura_da_unidade' => 'Procura da unidade para procedimentos', 'hemorragia' => 'Hemorragia', 'alteracao_de_pressao' => 'Alteração de pressão', 'parada_cardiorrespiratoria' => 'Parada cardiorrespiratória', 'hemorragia_digestiva' => 'Hemorragia digestiva', 'queixas_cronicas' => 'Queixas crônicas', "deficit_motor"=>'Déficit motor (fraqueza muscular face ou membros uni ou bilateral)'];

$localizacao_da_dor = ['abdominal' => 'Abdominal', 'cefaleia' => 'Cefaleia', 'ceruical' => 'Ceruical', 'lombar' => 'Lombar', 'toracica' => 'Torácica', 'outras' => 'Outras'];

$intensidade_da_dor = ['Forte' => 'Forte', 'Moderada' => 'Moderada', 'Leve' => 'Leve'];

$aparecimento_da_dor = ['Nas últimas horas' => 'Nas últimas horas', 'Inferior a 48h' => 'Inferior a 48h', 'Superior a 48h' => 'Superior a 48h'];

$dor             = ["Forte (7 a 10)", "Moderada (4 a 6)", "Leve (1 a 3)", "Sem dor (0)"];
$retorno         = ["1 retorno em < 24h", "2 retornos em < 72h"];
$relato_de_febre = ["Relato de febre Relato de febre ≥38,5◦C em 3 meses", "Relato de febre ≥37,5◦C em 3 meses de idade", "Relato de febre ≥38,5◦C em 3 anos de idade"];
$estado_geral    = ["Agonizando", "Parece muito doente", "Parece doente", "Parece pouco", "Muito bom"];

$cefaleia_deficit_motor = ["Déficit motor agudo <48h"=>"Déficit motor agudo <48h", "Ausência de déficits motores"=>"Ausência de déficits motores"];
?>


<div class="bundles form col-md-9 columns content">
    <?php echo $this->Html->link(__('Impressão'), ['action' => 'printView', $screening->id], ['class'=>'btn btn-primary pull-right','target'=>'blank','style'=>'margin-right:2%;margin-bottom:2%;']);
    ?>
</div>

<div class="screenings form col-md-9 columns content">
	<?=$this->Form->create($screening)?>
	<fieldset>
	<?php if ($age > 13): ?>


		<div class="tabbable-panel">
			<div class="tabbable-line">
				<ul class="nav nav-tabs ">
					<li class="active">
						<a href="#tab_default_1" data-toggle="tab" class="calc-screening" id="gambiarra">
						Triagem
						</a>
					</li>
					<li >
						<a id="menu_2" href="#tab_default_2" data-toggle="tab">
						Classificação de Risco
						</a>
					</li>
				</ul>
				<div class="tab-content">
					<div class="tab-pane active" id="tab_default_1">
						<?php
							echo "<div class='row'>";
				                echo "<div class='col-md-6'>";
				                    echo $this->Form->input('date_of_hospitalization', ['type' => 'text', 'default'=>date('d/m/Y'), 'label'=>['text'=>'Data de internação:', 'class'=>'form-input mandatory'], 'class' => 'date'  ]);

				                echo "</div>";

				                echo "<div class='col-md-6'>";
				                    echo $this->Form->input('time_of_hospitalization', ['type' => 'text','label'=>['text'=>'Hora da internação:', 'class'=>'form-input'], 'class' => 'time' ]);

				                echo "</div>";
				            echo "</div>";
//Sinais alt_sinais_vitais
echo $this->Form->input('ocular', ['id' => 'ocular', 'class' => 'hide-element', 'label' => false]);
echo $this->Form->input('verbal', ['id' => 'verbal', 'class' => 'hide-element', 'label' => false]);
echo $this->Form->input('motora', ['id' => 'motora', 'class' => 'hide-element', 'label' => false]);

echo "<br><br><div class='row div-pading'>";
echo "<legend class='big-title'>Sinais Vitais</legend>";
echo "<div class='col-md-3'>";
echo $this->Form->input('pas', ['class' => 'int-limit-3 calc-screening', 'label' => ['text' => 'PAS (mmHg):', 'class' => 'form-input']]);
echo "</div>";

echo "<div class='col-md-3'>";
echo $this->Form->input('pad', ['class' => 'int-limit-3 calc-screening', 'label' => ['text' => 'PAD (mmHg):', 'class' => 'form-input']]);
echo "</div>";

echo "<div class='col-md-3'>";
echo $this->Form->input('temp', ['class' => 'temp calc-screening', 'label' => ['text' => 'Temp (ºC):', 'class' => 'form-input']]);
echo "</div>";

echo "<div class='col-md-3'>";
echo $this->Form->input('sato2', ['type' => 'text', 'class' => 'int-limit-3 calc-screening', 'label' => ['text' => 'SatO2 (%):', 'class' => 'form-input']]);
echo "</div>";
echo "</div>";

echo "<div class='row div-pading'>";
echo "<div class='col-md-4'>";
echo $this->Form->input('fc', ['class' => 'int-limit-3 calc-screening', 'type' => 'number', 'label' => ['text' => 'FC (bpm):', 'class' => 'form-input']]);
echo "</div>";

echo "<div class='col-md-4'>";
echo $this->Form->input('fr', ['type' => 'text', 'class' => 'calc-screening int-limit-3', 'label' => ['text' => 'FR (irm):', 'class' => 'form-input']]);
echo "</div>";

echo "<div class='col-md-4'>";
echo $this->Form->input('glicemia', ['type' => 'text', 'class' => 'calc-screening', 'label' => ['text' => 'Glicemia (mg/dl):', 'class' => 'form-input']]);
echo "</div>";
echo "</div>";

echo '<div class="funkyradio">';
	echo '<div class="funkyradio-primary">';
	echo $this->Form->checkbox('portador_necessidas_especiais', ['id' => 'portador_necessidas_especiais']);
	echo '<label for="portador_necessidas_especiais">Portador de necessidades especiais</label>';
	echo "</div>";

	echo '<div class="funkyradio-primary">';
	echo $this->Form->checkbox('esta_gestente_ou_suspeita', ['id' => 'esta_gestente_ou_suspeita' , 'class' => 'active_checked']);
	echo '<label for="esta_gestente_ou_suspeita">Esta gestante ou há suspeita</label>';
	echo "</div>";

	echo '<div class="funkyradio-primary esta_gestente_ou_suspeita hide-element">';
	echo $this->Form->checkbox('classificacao_obstetrica', ['id' => 'classificacao_obstetrica']);
	echo '<label for="classificacao_obstetrica">Deseja realizar a Classificação de Risco de Obstetrícia?</label>';
	echo "</div>";


	echo '<div class="funkyradio-primary">';
	echo $this->Form->checkbox('parada_cardiaca_ou_suspeita', ['id' => 'parada_cardiaca_ou_suspeita', 'class'=>'calc-screening calc-pediatria']);
	echo '<label for="parada_cardiaca_ou_suspeita">Parada cardiorrespiratória ou suspeita</label>';
	echo "</div>";
echo "</div><br>";


//Nível de consciência e déficit motor-sensorial
echo "<br><br><div class='row div-pading'>";
echo "<legend class='big-title'>Nível de consciência e déficit motor-sensorial</legend>";
echo $this->Form->input('fraquesa_muscular', ['empty' => true, 'options' => $fraquesa_muscular, 'label' => ['text' => 'Fraqueza muscular:', 'class' => 'form-input']]);

echo $this->Form->input('fraquesa_muscular_tipo', ['empty' => true, 'options' => $fraquesa_muscular_tipo, 'label' => ['text' => 'Tipo de fraqueza:', 'class' => 'form-input']]);

echo $this->Form->input('perda_sensorial', ['empty' => true, 'options' => $fraquesa_muscular, 'label' => ['text' => 'Perda sensorial:', 'class' => 'form-input']]);

echo $this->Form->input('perda_sensorial_tipo', ['empty' => true, 'options' => $fraquesa_muscular_tipo, 'label' => ['text' => 'Tipo de perda:', 'class' => 'form-input']]);

echo $this->Form->input('alteracao_consciencia', ['class' => 'calc-screening', 'empty' => true, 'options' => $alteracao_consciencia, 'label' => ['text' => 'Alteração de consciência:', 'class' => 'form-input']]);
echo "</div><br>";

?>
<br><br>
  <!-- Glasgow -->
  <table class="table table-striped table-striped-gray table-hover">
	  <?='<legend class="big-title">Escala de Coma de Glasgow (selecionar)</legend>';?>
	<thead>
	  <tr>
		<th>#</th>
		<th>1</th>
		<th>2</th>
		<th>3</th>
		<th>4</th>
		<th>5</th>
		<th>6</th>
		<th></th>
	  </tr>
	</thead>
	<tbody id="glasgow_tbody">
	  <tr id='tr-ocular' >
		<th scope="row">Ocular</th>
		<td id="nao_abre_os_olhos" onclick="selectGlasgow('ocular', this, 'nao_abre_os_olhos')">Não abre os olhos</td>
		<td id="abre_os_olhos_a_dor" onclick="selectGlasgow('ocular', this, 'abre_os_olhos_a_dor')">Abre os olhos em resposta à dor</td>
		<td id="abre_os_olhos_a_resposta" onclick="selectGlasgow('ocular', this, 'abre_os_olhos_a_resposta')">Abre os olhos em resposta à um chamado</td>
		<td id="abre_os_olhos_espontaneamente" onclick="selectGlasgow('ocular', this, 'abre_os_olhos_espontaneamente')">Abre os olhos espontaneamente</td>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
		<!-- <td>&nbsp;</td> -->
	  </tr>
	  <tr id ='tr-verbal'>
		<th  scope="row">Verbal</th>
		<td id="sem_resposta" onclick="selectGlasgow('verbal', this, 'sem_resposta')">Sem resposta</td>
		<td id='emite_sons' onclick="selectGlasgow('verbal', this, 'emite_sons')">Emite sons incompreensíveis</td>
		<td id="pronuncia_palavras" onclick="selectGlasgow('verbal', this, 'pronuncia_palavras')">Pronuncia palavras inapropriadas</td>
		<td id="confuso_desorientado" onclick="selectGlasgow('verbal', this, 'confuso_desorientado')">Confuso/Desorientado</td>
		<td id="orientado" onclick="selectGlasgow('verbal', this, 'orientado')">Orientado</td>
		<td>&nbsp;</td>
		<!-- <td>&nbsp;</td> -->
	  </tr>
	  <tr id ='tr-motora'>
		<th  scope="row">Motora</th>
		<td id="nao_se_movimenta" onclick="selectGlasgow('motora', this, 'nao_se_movimenta')">Não se movimenta</td>
		<td id="extensao_a_estimulos" onclick="selectGlasgow('motora', this, 'extensao_a_estimulos')">Extensão ao estímulo doloroso</td>
		<td id="flexao_ao_estimulo" onclick="selectGlasgow('motora', this, 'flexao_ao_estimulo')">Flexão ao estímulo doloroso</td>
		<td id="retirada_ao_estimulo" onclick="selectGlasgow('motora', this, 'retirada_ao_estimulo')">Retirada ao estímulo doloroso</td>
		<td id="localiza_a_dor" onclick="selectGlasgow('motora', this, 'localiza_a_dor')">Localiza a dor (retirada ao toque)</td>
		<td id="movimentacao_espontanea" onclick="selectGlasgow('motora', this, 'movimentacao_espontanea')">Movimentação espontânea</td>
		<!-- <td>&nbsp;</td> -->
	  </tr>
	</tbody>
  </table>

  <h3 id="glasgow-pontuation">Pontuação Glasgow: 0</h3>

<?php
//Queixa
echo "<br><br><div class='row div-pading'>";
echo "<legend class='big-title'>Queixa </legend>";
echo $this->Form->input('queixa_principal', ['class' => 'calc-screening', 'empty' => true, 'options' => $queixa_principal, 'label' => ['text' => 'Queixa principal:', 'class' => 'form-input']]);

echo '<div class="funkyradio">';
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tem_alergiatem_alergia', ['id' => 'tem_alergia']);
echo '<label for="tem_alergia">Possui alergia</label>';
echo "</div>";
echo "</div><br>";

echo "<div class='tem_alergia' style='display:none'>";
echo $this->Form->input('alergias', ['type' => 'textarea', 'label' => ['text' => 'Alergias:', 'class' => 'form-input']]);
echo "</div>";

echo '<div class="funkyradio">';
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('uso_medicacao_regular', ['id' => 'uso_medicacao_regular']);
echo '<label for="uso_medicacao_regular">Uso de medicação regular</label>';
echo "</div>";
echo "</div><br>";

echo "<div class='uso_medicacao_regular' style='display:none'>";
echo $this->Form->input('medicacao_regular', ['type' => 'textarea', 'label' => ['text' => 'Medicação regular:', 'class' => 'form-input']]);
echo "</div>";

echo $this->Form->input('resumo_da_queixa', ['type' => 'textarea', 'label' => ['text' => 'Resumo da queixa do paciente:', 'class' => 'form-input']]);
echo "</div>";

echo '<br><button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>&nbsp;&nbsp;';
echo "<button disabled class='btn btn-success' type='button' id='proximo'>Próximo</button>";
?>

					</div>
					<div class="tab-pane" id="tab_default_2">
					   <?php
echo "<br><br><div class='row div-pading'>";
echo "<div class='dor tipo-de-dor-queixa hide-element'>";
echo "<legend class='big-title'>Dor</legend>";
echo $this->Form->input('localizacao_da_dor', ['class' => 'calc-screening', 'empty' => true, 'options' => $localizacao_da_dor, 'label' => ['text' => 'Localização:', 'class' => 'form-input']]);

echo $this->Form->input('intensidade_da_dor', ['class' => 'calc-screening', 'empty' => true, 'options' => $intensidade_da_dor, 'label' => ['text' => 'Intensidade:', 'class' => 'form-input']]);

echo $this->Form->input('aparecimento_da_dor', ['class' => 'calc-screening', 'empty' => true, 'options' => $aparecimento_da_dor, 'label' => ['text' => 'Aparecimento:', 'class' => 'form-input ']]);

echo $this->Form->input('cefaleia_deficit_motor', ['class' => 'calc-screening', 'empty' => true, 'options' => $cefaleia_deficit_motor, 'label' => ['text' => 'Déficit motor:', 'class' => 'form-input ']]);


echo $this->Form->input('pain_characteristics._ids', ['class' => 'calc-screening', 'options' => $pain_characteristics, 'empty' => true, 'label' => ['text' => 'Característica da dor:', 'class' => 'form-input']]);

echo "<div class='cefaleia tipo-de-dor hide-element'>";
echo '<div class="funkyradio">';

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('cefaleia_episodio_de_crise_convulsiva', ['id' => 'cefaleia_episodio_de_crise_convulsiva', 'class' => 'calc-screening']);
echo '<label for="cefaleia_episodio_de_crise_convulsiva">Início há vários dias</label>';
echo "</div>";


echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('cefaleia_inicio_a_varios_dias', ['id' => 'cefaleia_inicio_a_varios_dias', 'class' => 'calc-screening']);
echo '<label for="cefaleia_inicio_a_varios_dias">Ausência de déficits motores</label>';
echo "</div>";



echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('cefaleia_rigidez_da_nuca', ['id' => 'cefaleia_rigidez_da_nuca', 'class' => 'calc-screening']);
echo '<label for="cefaleia_rigidez_da_nuca">Rigidez da nuca</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('cefaleia_vomitos', ['id' => 'cefaleia_vomitos', 'class' => 'calc-screening']);
echo '<label for="cefaleia_vomitos">Vomitos</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";
echo "</div>";

echo "<div class='abdominal tipo-de-dor hide-element'>";
echo '<div class="funkyradio">';

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_abdominal_historico_de_trauma', ['id' => 'dor_abdominal_historico_de_trauma', 'class'=>'calc-screening']);
echo '<label for="dor_abdominal_historico_de_trauma">Histórico abdominal</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_abdominal_diarreia', ['id' => 'dor_abdominal_diarreia', 'class'=>'calc-screening']);
echo '<label for="dor_abdominal_diarreia">Diarreia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_abdominal_nausea', ['id' => 'dor_abdominal_nausea', 'class'=>'calc-screening']);
echo '<label for="dor_abdominal_nausea">Nausea</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_abdominal_vomitos', ['id' => 'dor_abdominal_vomitos', 'class'=>'calc-screening']);
echo '<label for="dor_abdominal_vomitos">Vomito</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='ceruical tipo-de-dor hide-element'>";
echo '<div class="funkyradio">';

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('ceruicalgia_historico_progresso_calculo_renal', ['id' => 'ceruicalgia_historico_progresso_calculo_renal', 'class'=>'calc-screening']);
echo '<label for="ceruicalgia_historico_progresso_calculo_renal">Histórico de progressão do cálculo renal, hu, omose, hepatia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('ceruicalgia_transplatandos_e_em_quimioterapia', ['id' => 'ceruicalgia_transplatandos_e_em_quimioterapia', 'class'=>'calc-screening']);
echo '<label for="ceruicalgia_transplatandos_e_em_quimioterapia">Transplantados e em quimioterapia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('ceruicalgia_alteracao_de_esfincter', ['id' => 'ceruicalgia_alteracao_de_esfincter', 'class'=>'calc-screening']);
echo '<label for="ceruicalgia_alteracao_de_esfincter">Alteração de esfincter</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='toracica tipo-de-dor' style='display:none'>";
	echo '<div class="funkyradio">';
		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dor_toracica_dispineia', ['id' => 'dor_toracica_dispineia', 'class'=>'calc-screening']);
		echo '<label for="dor_toracica_dispineia">Dispneia</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dor_toracica_assimetria_dos_pulsos', ['id' => 'dor_toracica_assimetria_dos_pulsos', 'class'=>'calc-screening']);
		echo '<label for="dor_toracica_assimetria_dos_pulsos">Assimetria dos pulsos</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dor_toracica_irradiacao', ['id' => 'dor_toracica_irradiacao', 'class'=>'calc-screening']);
		echo '<label for="dor_toracica_irradiacao">Irradiação da dor para MSE</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dor_toracica_historico_de_coronariopatia', ['id' => 'dor_toracica_historico_de_coronariopatia', 'class'=>'calc-screening']);
		echo '<label for="dor_toracica_historico_de_coronariopatia">Histórico de coronariopatia</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dor_toracica_historico_de_avc', ['id' => 'dor_toracica_historico_de_avc', 'class'=>'calc-screening']);
		echo '<label for="dor_toracica_historico_de_avc">Histórico de familar com AVC ou TAI</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dor_toracica_trauma_toracico_antecedente', ['id' => 'dor_toracica_trauma_toracico_antecedente', 'class'=>'calc-screening']);
		echo '<label for="dor_toracica_trauma_toracico_antecedente">Antecedente de trauma torácico</label>';
		echo "</div>";
	echo "</div><br>";
echo "</div>";

echo "<div class='dispneia tipo-de-queixa  hide-element'>";
	echo '<div class="funkyradio">';
		echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Dispneia</legend>";
		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dispneia_desconforto', ['class' => 'calc-screening', 'id' => 'dispneia_desconforto']);
		echo '<label for="dispneia_desconforto">Desconforto respiratório moderado a intenso</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dispneia_cianose', ['class' => 'calc-screening', 'id' => 'dispneia_cianose']);
		echo '<label for="dispneia_cianose">Cianose</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dispneia_utilizacao_da_musculatura', ['class' => 'calc-screening', 'id' => 'dispneia_utilizacao_da_musculatura']);
		echo '<label for="dispneia_utilizacao_da_musculatura">Utilização de musculatura acessora</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dispneia_dificuldade_para_falar', ['class' => 'calc-screening', 'id' => 'dispneia_dificuldade_para_falar']);
		echo '<label for="dispneia_dificuldade_para_falar">Dificuldade para falar</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dispneia_historico_de_asma', ['class' => 'calc-screening', 'id' => 'dispneia_historico_de_asma']);
		echo '<label for="dispneia_historico_de_asma">Histórico de asma ou DPOC</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('dispneia_alteracao_na_ausculta', ['class' => 'calc-screening', 'id' => 'dispneia_alteracao_na_ausculta']);
		echo '<label for="dispneia_alteracao_na_ausculta">Alteração na ausulta pulmonar</label>';
		echo "</div>";
	echo "</div><br>";
echo "</div>";

echo "<div class='diarreia tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Diarreia</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('diarreia_sinais_de_desidratacao', ['id' => 'diarreia_sinais_de_desidratacao']);
echo '<label for="diarreia_sinais_de_desidratacao">Sinais de desidratação</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('diarreia_dor_abdominal', ['id' => 'diarreia_dor_abdominal']);
echo '<label for="diarreia_dor_abdominal">Dor abdominal leve e monerada</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('diarreia_nausea_e_vomito', ['id' => 'diarreia_nausea_e_vomito']);
echo '<label for="diarreia_nausea_e_vomito">Nausea e vomito</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('diarreia_sinais_vitais_normais', ['id' => 'diarreia_sinais_vitais_normais']);
echo '<label for="diarreia_sinais_vitais_normais">Sinais vitais dentro da normalidade</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='tosse tipo-de-queixa  hide-element'>";
	echo '<div class="funkyradio">';

		echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Tosse</legend>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('tosse_dispneia', [ 'id' => 'tosse_dispneia', 'class'=>'calc-screening']);
		echo '<label for="tosse_dispneia">Dispneia</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('tosse_historico_de_hemoptise', [ 'id' => 'tosse_historico_de_hemoptise', 'class'=>'calc-screening']);
		echo '<label for="tosse_historico_de_hemoptise">Histórico de hemoptise</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('tosse_dor_toracica_ausente', ['id' => 'tosse_dor_toracica_ausente', 'class'=>'calc-screening']);
		echo '<label for="tosse_dor_toracica_ausente">Dor torácica ausente ou leve</label>';
		echo "</div>";

	echo "</div><br>";
echo "</div>";

echo "<div class='casos_especiais tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Casos especiais</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_dispneia_yo', [ 'id' => 'tosse_dispneia_yo']);
echo '<label for="tosse_dispneia_yo">Idade >60 anos</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_historico_de_hemoptise_yo', [ 'id' => 'tosse_historico_de_hemoptise_yo']);
echo '<label for="tosse_historico_de_hemoptise_yo">Pacientes portadores de necessidades especiais</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('tosse_dor_toracica_ausente_yo', ['id' => 'tosse_dor_toracica_ausente_yo']);
echo '<label for="tosse_dor_toracica_ausente_yo">Gestantes</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='alteracao_de_pressao tipo-de-queixa  hide-element'>";
	echo '<div class="funkyradio">';

		echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Alteração de pressão</legend>";
		//echo '<div class="funkyradio-primary">';
		// echo $this->Form->checkbox('tosse_dispneia_hh', [ 'id' => 'tosse_dispneia_hh', 'class'=>'calc-screening']);
		// echo '<label for="tosse_dispneia_hh">PA >150/100mmHg ou PA <100/60mmHg </label>';
		// echo "</div>";

		// echo '<div class="funkyradio-primary">';
		// echo $this->Form->checkbox('tosse_historico_de_hemoptise_hhh', [ 'id' => 'tosse_historico_de_hemoptise_hhh', 'class'=>'calc-screening']);
		// echo '<label for="tosse_historico_de_hemoptise_hhh">FC >100bpm ou FC <60bpm</label>';
		// echo "</div>";

		// echo '<div class="funkyradio-primary">';
		// echo $this->Form->checkbox('tosse_dor_toracica_ausente_ggg', ['id' => 'tosse_dor_toracica_ausente_ggg', 'class'=>'calc-screening']);
		// echo '<label for="tosse_dor_toracica_ausente_ggg">FR >20rpm</label>';
		// echo "</div>";

		// echo '<div class="funkyradio-primary">';
		// echo $this->Form->checkbox('tosse_dor_toracica_ausente_gggh', ['id' => 'tosse_dor_toracica_ausente_gggh', 'class'=>'calc-screening']);
		// echo '<label for="tosse_dor_toracica_ausente_gggh">Tº >37,8oC no momento da consulta</label>';
		// echo "</div>";
	echo "</div><br>";
echo "</div>";

echo "<div class='parada_cardiorrespiratoria tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Parada cardiorrespiratória</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('parada_ausecia_pulso', ['id' => 'parada_ausecia_pulso', 'class'=>'calc-screening']);
echo '<label for="parada_ausecia_pulso">Ausência de pulso carotídeo (5 a 10 segundos)</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('parada_ausecia_movimentos', ['id' => 'parada_ausecia_movimentos', 'class'=>'calc-screening']);
echo '<label for="parada_ausecia_movimentos">Ausência de movimentos respiratórios</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('parada_inconsciencia', ['id' => 'parada_inconsciencia', 'class'=>'calc-screening']);
echo '<label for="parada_inconsciencia">Inconsciência</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='hemorragia_digestiva tipo-de-queixa  hide-element'>";
	echo '<div class="funkyradio">';

	echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Hemorragia</legend>";
		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('hemorragia_historico_de_enterorragia', ['id' => 'hemorragia_historico_de_enterorragia', 'class'=>'calc-screening']);
		echo '<label for="hemorragia_historico_de_enterorragia">História de enterorragia, melena ou hematêmese</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('hemorragia_antecedente_de_cirrose', ['id' => 'hemorragia_antecedente_de_cirrose', 'class'=>'calc-screening']);
		echo '<label for="hemorragia_antecedente_de_cirrose">Antecedente de cirrose ou neoplasia hepática ou de cólon, uso de anti-inflamatório não esteroidal</label>';
		echo "</div>";

	echo "</div><br>";
echo "</div>";

echo "<div class='queixa_cronica tipo-de-queixa  hide-element'>";
echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Queixa crônica</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('queixa_cronica_nao_agudizada', ['id' => 'queixa_cronica_nao_agudizada', 'class'=>'calc-screening']);
echo '<label for="queixa_cronica_nao_agudizada">Queixa crõnica não agudizadas</label>';
echo "</div>";

echo "</div>";

echo "<div class='demaio_mal_estar tipo-de-queixa hide-element'>";
echo '<div class="funkyradio">';
echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Demaio / mal estar geral</legend>";

// echo "<div id='desmaio_vermelho'> ";
$desmaio_saturacao = ['Saturação ≤ 89% em ar ambiente', 'Saturação de O² ≥ 90% e ≤ 94% (ar ambiente)', 'Saturação ≥ 95% (ar ambiente)'];
$desmaio_pas       = ["PAS ≥ 160 e/ou PAD ≥ 110 mmHg", "PAS de 140-159 e/ou PAD 90-109 mmHg, sem sintomas", 'PAS ≤ 139 e PAD ≤ 89 mmHg'];

$abdominal_dor = ["Dor intensa ≥ 7-10", 'Dor lombar moderada 4-6/10', 'Dor leve intensidade (&lt;3/10)'];

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_nao_responsivo', ['id' => 'desmaio_nao_responsivo', 'class' => 'red']);
echo '<label for="desmaio_nao_responsivo">Não responsiva</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_choque', ['id' => 'desmaio_choque', 'class' => 'red']);
echo '<label for="desmaio_choque">Choque</label>';
echo "</div><br>";

echo $this->Form->input('desmaio_saturacao', ['empty' => true, 'options' => $desmaio_saturacao, 'label' => ['text' => 'Saturação:', 'class' => 'form-input ']]);

echo $this->Form->input('desmaio_pas', ['empty' => true, 'options' => $desmaio_pas, 'label' => ['text' => 'PAS:', 'class' => 'form-input ']]);

//     echo '<div class="funkyradio-primary">';
//     echo $this->Form->checkbox('desmaio_nao_vermelho', ['id' => 'desmaio_nao_vermelho']);
//     echo '<label for="desmaio_nao_vermelho">Não</label>';
//     echo "</div>";
// echo "</div>";

// echo "<div id='desmaio_laranja' style='display:none'> ";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_alteracao_consciencia', ['id' => 'desmaio_alteracao_consciencia', 'class' => 'laranja']);
echo '<label for="desmaio_alteracao_consciencia">Alteração de consciência ou estado mental</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_padrao_respiratorio', ['id' => 'desmaio_padrao_respiratorio', 'class' => 'laranja']);
echo '<label for="desmaio_padrao_respiratorio">Padrão respiratório ineficaz*²</label>';
echo "</div>";

//echo '<div class="funkyradio-primary">';
// echo $this->Form->checkbox('desmaio_saturacao_o2', ['id' => 'desmaio_saturacao_o2', 'class'=>'laranja']);
// echo '<label for="desmaio_saturacao_o2">Saturação de O² ≥ 90% e ≤ 94% (ar ambiente)</label>';

//echo '<div class="funkyradio-primary">';
// echo $this->Form->checkbox('desmaio_pas', ['id' => 'desmaio_pas', 'class'=>'laranja']);
// echo '<label for="desmaio_pas">PAS ≥ 160 e/ou PAD ≥ 110 mmHg</label>';

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_pa', ['id' => 'desmaio_pa', 'class' => 'laranja']);
echo '<label for="desmaio_pa">PA ≥ 140/90 mmHg com dor de cabeça, de estômago ou alterações visuais</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_relatorio_diabetes', ['id' => 'desmaio_relatorio_diabetes', 'class' => 'calc-screening']);
echo '<label for="desmaio_relatorio_diabetes">Relato de Diabetes (glicemia ≤ 50 mg/dl)</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_hipertermia', ['id' => 'desmaio_hipertermia', 'class' => 'calc-screening']);
echo '<label for="desmaio_hipertermia">Hipertermia ≥ 40ºC</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_febre', ['id' => 'desmaio_febre', 'class' => 'calc-screening']);
echo '<label for="desmaio_febre">Febre: TAx 38,0oC a 39,9oC</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_pacientes_imunodeprimidas', ['id' => 'desmaio_pacientes_imunodeprimidas', 'class' => 'calc-screening']);
echo '<label for="desmaio_pacientes_imunodeprimidas">Pacientes imunodeprimidas (HIV)</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_encaminhamento_centro', ['id' => 'desmaio_encaminhamento_centro', 'class' => 'calc-screening']);
echo '<label for="desmaio_encaminhamento_centro">Encaminhamento do Centro de Saúde não enquadradas nas situações de urgência</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('desmaio_atendimento_nao_prioritario', ['id' => 'desmaio_atendimento_nao_prioritario', 'class' => 'calc-screening']);
echo '<label for="desmaio_atendimento_nao_prioritario">Atendimento não prioritário ou encaminhamento ao Centro de Saúde</label>';
echo "</div>";

// echo '<div class="funkyradio-primary">';
// echo $this->Form->checkbox('desmaio_nao_laranja', ['id' => 'desmaio_nao_laranja']);
// echo '<label for="desmaio_nao_laranja">Não</label>';
// echo "</div>";
//echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='dor_abdominal_lombar tipo-de-queixa hide-element'>";
	echo '<div class="funkyradio">';

		echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Dor abdominal/lombar/contrações uterinas</legend>";
		echo '<div class="funkyradio-primary">';
			echo $this->Form->checkbox('abdominal_periodo_expulsivo', ['id' => 'abdominal_periodo_expulsivo', 'class' => 'red']);
			echo '<label for="abdominal_periodo_expulsivo">Período expulsivo</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_prolapso', ['id' => 'abdominal_prolapso', 'class' => 'red']);
		echo '<label for="abdominal_prolapso">Prolapso de cordão umbilical</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_exteriorizacao', ['id' => 'abdominal_exteriorizacao', 'class' => 'red']);
		echo '<label for="abdominal_exteriorizacao">Exteriorização de partes fetais</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_sinais_choque', ['id' => 'abdominal_sinais_choque', 'class' => 'red']);
		echo '<label for="abdominal_sinais_choque">Sinais de choque</label>';
		echo "</div><br>";

		echo $this->Form->input('abdominal_dor', ['empty' => true, 'options' => $abdominal_dor, 'label' => ['text' => 'Dor:', 'class' => 'form-input ']]);

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_contracoes', ['id' => 'abdominal_contracoes', 'class' => 'laranja']);
		echo '<label for="abdominal_contracoes">Contrações intensas a cada 2 minutos</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_hipertonia', ['id' => 'abdominal_hipertonia', 'class' => 'laranja']);
		echo '<label for="abdominal_hipertonia">Hipertonia uterina / Sangramento genital intenso**</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_pa', ['id' => 'abdominal_pa', 'class' => 'laranja']);
		echo '<label for="abdominal_pa">PA ≥ 140/90 mmHg com dor de cabeça, de estômago ou alterações visuais</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_perda_liquido', ['id' => 'abdominal_perda_liquido', 'class' => 'calc-screening']);
		echo '<label for="abdominal_perda_liquido">Perda de líquido espesso esverdeado</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_portadora', ['id' => 'abdominal_portadora', 'class' => 'calc-screening']);
		echo '<label for="abdominal_portadora">Portadora de doença falciforme</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_portadora_hiv', ['id' => 'abdominal_portadora_hiv', 'class' => 'calc-screening']);
		echo '<label for="abdominal_portadora_hiv">Portadora de HIV em TP (qualquer frequência ou dor)</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_pos_parto', ['id' => 'abdominal_pos_parto', 'class' => 'calc-screening']);
		echo '<label for="abdominal_pos_parto">Pós-parto imediato</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_dor_lombar', ['id' => 'abdominal_dor_lombar', 'class' => 'calc-screening']);
		echo '<label for="abdominal_dor_lombar">Dor lombar moderada 4-6/10</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_sangramento_moderado', ['id' => 'abdominal_sangramento_moderado', 'class' => 'calc-screening']);
		echo '<label for="abdominal_sangramento_moderado">Sangramento moderado**</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_ausencia', ['id' => 'abdominal_ausencia', 'class' => 'calc-screening']);
		echo '<label for="abdominal_ausencia">Ausência de MF em gravidez ≥ 22 semanas</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_vitima', ['id' => 'abdominal_vitima', 'class' => 'calc-screening']);
		echo '<label for="abdominal_vitima">Vítimas de Violência física e sexual</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_febril', ['id' => 'abdominal_febril', 'class' => 'calc-screening']);
		echo '<label for="abdominal_febril">Febril ≤ 37,9oC</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_perda_liquido_pequena', ['id' => 'abdominal_perda_liquido_pequena', 'class' => 'calc-screening']);
		echo '<label for="abdominal_perda_liquido_pequena">Perda de liquido em pequena quantidade</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_encaminhamento', ['id' => 'abdominal_encaminhamento', 'class' => 'calc-screening']);
		echo '<label for="abdominal_encaminhamento">Encaminhamento de outras unidades de saúde não enquadradas nas situações de urgência</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('abdominal_atendimento_prioritario', ['id' => 'abdominal_atendimento_prioritario', 'class' => 'calc-screening']);
		echo '<label for="abdominal_atendimento_prioritario">Atendimento não prioritário ou Encaminhamento ao Centro de Saúde</label>';
		echo "</div>";

	echo "</div><br>";
echo "</div>";

echo "<div class='new dor_de_cabeca tipo-de-queixa hide-element'>";
echo '<div class="funkyradio">';
echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Dor de cabeça, tontura, vertigem</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_apneia', ['id' => 'dor_cabeca_apneia', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_apneia">Apnéia ou Padrão Respiratório ineficaz*²</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_choque', ['id' => 'dor_cabeca_choque', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_choque">Sinais de Choque</label>';
echo "</div><br>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_alteracao_consciencia', ['id' => 'dor_cabeca_alteracao_consciencia', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_alteracao_consciencia">Alteração de consciência ou estado mental</label>';
echo "</div><br>";

echo $this->Form->input('dor_cabeca_pas', ['empty' => true, 'options' => $desmaio_pas, 'label' => ['text' => 'PAS:', 'class' => 'form-input ']]);

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_pa_maior_140', ['id' => 'dor_cabeca_pa_maior_140', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_pa_maior_140">PA ≥ 140/90 mmHg com dor de cabeça, de estômago ou alterações visuais</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_dor_intensa', ['id' => 'dor_cabeca_dor_intensa', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_dor_intensa">Dor intensa (7-10/10) de início abrupto ou progressiva</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_disturbios', ['id' => 'dor_cabeca_disturbios', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_disturbios">Distúrbios de equilíbrio, zumbidos, perda da visão, Sinais de meningismo*6</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_hipertermia', ['id' => 'dor_cabeca_hipertermia', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_hipertermia">Hipertermia: &gt; 40ºC</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_dor_forte', ['id' => 'dor_cabeca_dor_forte', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_dor_forte">Dor forte moderada (5-7/10) </label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_nausea', ['id' => 'dor_cabeca_nausea', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_nausea">Náuseas e vômitos de início agudo ou persistentes</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_febre', ['id' => 'dor_cabeca_febre', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_febre">Febre: TAx 38,0oC a 39,9oC</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_dor_leve', ['id' => 'dor_cabeca_dor_leve', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_dor_leve">Dor leve 1-4/10</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_dor_relato', ['id' => 'dor_cabeca_dor_relato', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_dor_relato">Relato de náuseas e vômitos</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_febril', ['id' => 'dor_cabeca_febril', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_febril">Febril: 37,5oC a 37,9oC</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_atendimento', ['id' => 'dor_cabeca_atendimento', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_atendimento">Atendimento não prioritário ou Encaminhamento ao Centro de Saúde</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='new falta_de_ar tipo-de-queixa hide-element'>";
echo '<div class="funkyradio">';
echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Falta de ar/sintomas respiratórios</legend>";

echo $this->Form->input('falta_ar_saturacao', ['empty' => true, 'options' => $desmaio_saturacao, 'label' => ['text' => 'Saturação:', 'class' => 'form-input ']]);

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('falta_ar_estridor', ['id' => 'falta_ar_estridor', 'class' => 'calc-screening']);
echo '<label for="falta_ar_estridor">Estridor</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('falta_ar_choque', ['id' => 'falta_ar_choque', 'class' => 'calc-screening']);
echo '<label for="falta_ar_choque">Sinais de Choque</label>';
echo "</div><br>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('falta_ar_padrao', ['id' => 'falta_ar_padrao', 'class' => 'calc-screening']);
echo '<label for="falta_ar_padrao">Padrão respiratório ineficaz*²</label>';
echo "</div><br>";

echo $this->Form->input('falta_ar_pas', ['empty' => true, 'options' => $desmaio_pas, 'label' => ['text' => 'PAS:', 'class' => 'form-input ']]);

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_pa_maior_140', ['id' => 'dor_cabeca_pa_maior_140', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_pa_maior_140">PA ≥ 140/90 mmHg com dor de cabeça, de estômago ou alterações visuais</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_dor_intensa', ['id' => 'dor_cabeca_dor_intensa', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_dor_intensa">Dor intensa (7-10/10) de início abrupto ou progressiva</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_disturbios', ['id' => 'dor_cabeca_disturbios', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_disturbios">Distúrbios de equilíbrio, zumbidos, perda da visão, Sinais de meningismo*6</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_hipertermia', ['id' => 'dor_cabeca_hipertermia', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_hipertermia">Hipertermia: &gt; 40ºC</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_dor_forte', ['id' => 'dor_cabeca_dor_forte', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_dor_forte">Dor forte moderada (5-7/10) </label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_nausea', ['id' => 'dor_cabeca_nausea', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_nausea">Náuseas e vômitos de início agudo ou persistentes</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_febre', ['id' => 'dor_cabeca_febre', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_febre">Febre: TAx 38,0oC a 39,9oC</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_dor_leve', ['id' => 'dor_cabeca_dor_leve', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_dor_leve">Dor leve 1-4/10</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_dor_relato', ['id' => 'dor_cabeca_dor_relato', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_dor_relato">Relato de náuseas e vômitos</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_febril', ['id' => 'dor_cabeca_febril', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_febril">Febril: 37,5oC a 37,9oC</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('dor_cabeca_atendimento', ['id' => 'dor_cabeca_atendimento', 'class' => 'calc-screening']);
echo '<label for="dor_cabeca_atendimento">Atendimento não prioritário ou Encaminhamento ao Centro de Saúde</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='lesoes_de_pele tipo-de-queixa  hide-element'>";
	echo '<div class="funkyradio">';

		echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Lesões de pele</legend>";
		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('lesoes_de_pele_escabiose', ['id' => 'lesoes_de_pele_escabiose', 'class'=>'calc-screening']);
		echo '<label for="lesoes_de_pele_escabiose">Escabiose</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('lesoes_de_pele_eczema', ['id' => 'lesoes_de_pele_eczema', 'class'=>'calc-screening']);
		echo '<label for="lesoes_de_pele_eczema">Eczema</label>';
		echo "</div>";

		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('lesoes_de_pele_outras_lesoes', ['id' => 'lesoes_de_pele_outras_lesoes', 'class'=>'calc-screening']);
		echo '<label for="lesoes_de_pele_outras_lesoes">Outras lesões de pele</label>';
		echo "</div>";

	echo "</div><br>";
echo "</div>";

echo "<div class='alteracao_estado_mental tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Alteração do estado mental</legend>";
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('alt_estado_mental_ausencia_de_resposta', [ 'id' => 'alt_estado_mental_ausencia_de_resposta', 'class' => 'calc-screening']);
echo '<label for="alt_estado_mental_ausencia_de_resposta">Ausência de resposta a estímulos (verbal, doloroso, tátil) </label>';
echo "</div>";

// echo '<div class="funkyradio-primary">';
// echo $this->Form->checkbox('alt_estado_mental_alteracao_consciencia', [ 'id' => 'alt_estado_mental_alteracao_consciencia', 'class'=>'calc-screening']);
// echo '<label for="alt_estado_mental_alteracao_consciencia">Alteração do nível de consciência</label>';
// echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='deficit_motor tipo-de-queixa  hide-element'>";
	echo '<div class="funkyradio">';

		echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Déficit Motor</legend>";
		echo '<div class="funkyradio-primary">';
		echo $this->Form->checkbox('deficit_motor_inicio_subito', ['id' => 'deficit_motor_inicio_subito', 'class'=>'calc-screening']);
		echo '<label for="deficit_motor_inicio_subito">Início súbito (<48h)</label>';
		echo "</div>";

	echo "</div><br>";
echo "</div>";

echo "<div class='febre tipo-de-queixa  hide-element'>";
echo '<div class="funkyradio">';

echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Febre</legend>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('febre_alteracao_nivel_consciencia', ['id' => 'febre_alteracao_nivel_consciencia']);
echo '<label for="febre_alteracao_nivel_consciencia">Alteração do nível de consciência</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('febre_dispneia', ['id' => 'febre_dispneia']);
echo '<label for="febre_dispneia">Dispneia</label>';
echo "</div>";

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('febre_imunossupressao', ['id' => 'febre_imunossupressao']);
echo '<label for="febre_imunossupressao">Imunossupressão</label>';
echo "</div>";

echo "</div><br>";
echo "</div>";

echo "<div class='hiperglicemia tipo-de-queixa  hide-element'>";
	//echo '<div class="funkyradio">';

		echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Hiperglicemia</legend>";

	//echo "</div><br>";
echo "</div>";

echo "<div class='alt_sinais_vitais tipo-de-queixa  hide-element'>";
	echo '<div class="funkyradio">';

		 echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Alteração de sinais vitais</legend>";

		// echo '<div class="funkyradio-primary">';
		// echo $this->Form->checkbox('hip', [ 'id' => 'hip']);
		// echo '<label for="hip">FC >100bpm ou FC <60bpm</label>';
		// echo "</div>";

		// echo '<div class="funkyradio-primary">';
		// echo $this->Form->checkbox('hipp', [ 'id' => 'hipp']);
		// echo '<label for="hipp">FR >20rpm</label>';
		// echo "</div>";

		// echo '<div class="funkyradio-primary">';
		// echo $this->Form->checkbox('hipap', [ 'id' => 'hipap']);
		// echo '<label for="hipap">Tº >37,8oC no momento da consulta</label>';
		// echo "</div>";

	echo "</div><br>";
echo "</div>";

echo "<div class='hipoglicemia tipo-de-queixa  hide-element'>";
	// echo '<div class="funkyradio">';
	 	echo "<legend class='no-bottom big-title'>&nbsp;&nbsp;&nbsp;Hipoglicemia</legend>";

	// 	echo '<div class="funkyradio-primary">';
	// 	echo $this->Form->checkbox('hipoglicemia_glicemia_capilar', ['id' => 'hipoglicemia_glicemia_capilar', 'class'=>'calc-screening']);
	// 	echo '<label for="hipoglicemia_glicemia_capilar">Glicemia capilar < ou = 60mg/dl</label>';
	// 	echo "</div>";

	// echo "</div><br>";
echo "</div>";

echo "<br><br><br>";
echo "<p id='classificacao-sugerida'>Classificação sugerida: Azul</p>";
echo "<figure class='circle classficiacao_sugerida'></figure>";

echo "<div class='hide-element' style='display:none'>";
echo "<input class='classificacao-fields' name='classificacao_sugerida' default='Azul'>";
echo "</div>";

// echo $this->Form->input('classificacao_sugerida', ['empty'=>true, 'options'=>$classificacao_risco, 'label'=>['text'=>'Classificação sugerida:', 'class'=>'form-input']]);

echo '<div class="funkyradio">';

echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('sel', ['id' => 'sel']);
echo '<label for="sel">Deseja alterar a seleção?</label>';
echo "</div>";
echo "</div>";

echo "<br>";
echo "<div class='alterar-sel' style='display:none'>";
echo $this->Form->input('classificacao_selecionada', ['empty' => true, 'options' => $classificacao_risco, 'label' => ['text' => 'Classificação corrigida:', 'class' => 'form-input classificacao_selecionada_l']]);
//echo "";
echo "<br>";
echo "</div>";
?>
	<button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>&nbsp;&nbsp;
	<?=$this->Form->button(__('Salvar'));?>
</div>
</div>

				</div>
			</div>
		</div>
			<div class="hide-element">
				<input type="text" name="glasgow_ocular"  id="glasgow-ocular">
				<input type="text" name="glasgow_verbal"  id="glasgow-verbal">
				<input type="text" name="glasgow_motora"  id="glasgow-motora">
			</div>
			<br><br>

		</div>
		<?php elseif ($age <= 13): ?>

			<?=$this->Form->input('pediatric_screenings.0.id', ['type' => 'hidden']);?>
		    <input type="hidden"  name="pediatric_screenings[0][glasgow_ocular]"     id="glasgow-ocular">
			<input type="hidden" name="pediatric_screenings[0][glasgow_verbal]"      id="glasgow-verbal">
			<input type="hidden" name="pediatric_screenings[0][glasgow_motora]"      id="glasgow-motora">
			<input type="hidden" name="pediatric_screenings[0][pontuation_glasgow]"  id="pontuation_glasgow">

			<legend class='big-title'>Triagem pediátrica</legend>
			<?=$this->Form->input('pediatric_screenings.0.motivo_da_consulta', ['empty' => true, 'label' => ['text' => 'Motivo da consulta:', 'class' => 'form-input ']]);?>
			<div class="funkyradio">
				 <div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.alergia_a_medicacoes', ['id' => 'alergia_a_medicacoes', 'class' => 'active_checked'])?>
				<label for="alergia_a_medicacoes">Alergia a medicamentos</label>
				</div>

				<br>
				<div class="hide-element alergia_a_medicacoes">
					<?=$this->Form->input('pediatric_screenings.0.alergia_a_medicacoes_texto', ['placeholder' => 'Quais?', 'label' => ['text' => '', 'class' => 'form-input ']])?>
				</div>

				 <div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.usa_assistencia', ['id' => 'usa_assistencia', 'class' => 'active_checked'])?>
				<label for="usa_assistencia">Usa assistência pediátrica regular</label>
				</div>

				<br>
		        <!-- <div class="hide-element usa_assistencia">
					<?=$this->Form->input('pediatric_screenings.0.usa_assistencia_texto', ['placeholder' => 'Quais?', 'label' => ['text' => '', 'class' => 'form-input ']])?>
				</div> -->

				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.comorbidades_associadas', ['id' => 'comorbidades_associadas', 'class' => 'active_checked'])?>
				<label for="comorbidades_associadas">Comorbidades associadas </label>
				</div>

				<br>
				<div class="hide-element comorbidades_associadas">
					<?=$this->Form->input('pediatric_screenings.0.comorbidades_texto', ['placeholder' => 'Quais?', 'label' => ['text' => '', 'class' => 'form-input ']])?>
				</div>

				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.ma_formacoes_congenitas', ['id' => 'ma_formacoes_congenitas', 'class' => 'active_checked'])?>
				<label for="ma_formacoes_congenitas">Má formações congênitas</label>
				</div>

				<br>
				<div class="hide-element ma_formacoes_congenitas">
					<?=$this->Form->input('pediatric_screenings.0.ma_formacoes_congenitas_texto', ['placeholder' => 'Quais?', 'label' => ['text' => '', 'class' => 'form-input ']])?>
				</div>

				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.medicacoes_em_uso', ['id' => 'medicacoes_em_uso', 'class' => 'active_checked'])?>
				<label for="medicacoes_em_uso">Medicações em uso</label>
				</div>

				<br>
				<div class="hide-element medicacoes_em_uso">
					<?=$this->Form->input('pediatric_screenings.0.medicacoes_em_uso_texto', ['placeholder' => 'Quais?', 'label' => ['text' => '', 'class' => 'form-input ']])?>
				</div>

				<?=$this->Form->input('pediatric_screenings.0.ultimo_peso_aferido', ['class' => '', 'type' => 'text', 'placeholder' => '', 'label' => ['text' => 'Último peso aferido:', 'class' => 'form-input ']])?>

				<div class="funkyradio-primary">
					<?=$this->Form->checkbox('pediatric_screenings.0.admissao_emergencial', ['id' => 'admissao_emergencial', 'class' => 'active_checked'])?>
				<label for="admissao_emergencial">Admissão emergencial sem classificação</label>
				</div>
				<br>

				<div class="hide-element admissao_emergencial">
					<?=$this->Form->input('pediatric_screenings.0.admissao_emergencial_texto', ['empty' => true, 'options' => $admissao_emergencial, 'placeholder' => '', 'label' => ['text' => 'Admissão emergencial sem classificação:', 'class' => 'form-input ']])?>
				</div>
			</div>

			<br><br><br>
			<legend class='big-title'>Sinais Vitais</legend>
			<div class="row ">
				<div class='col-md-3'>
					<?=$this->Form->input('pediatric_screenings.0.temp', ['default' => '00,0', 'class' => 'temp calc-vipe', 'label' => ['text' => 'Temp (ºC):', 'class' => 'form-input']])?>
				</div>

				<div class='col-md-3'>
				<?=$this->Form->input('pediatric_screenings.0.sato2', ['default' => 0, 'type' => 'text', 'class' => 'int-limit-3 calc-vipe', 'label' => ['text' => 'SpO2 (%):', 'class' => 'form-input']]);?>
				</div>

				<div class='col-md-3'>
				<?=$this->Form->input('pediatric_screenings.0.fc', ['default' => 0, 'type' => 'number', 'class' => 'int-limit-3 calc-vipe', 'label' => ['text' => 'FC (bpm):', 'class' => 'form-input']]);?>
				</div>

				<div class='col-md-3'>
				<?=$this->Form->input('pediatric_screenings.0.fr', ['default' => 0, 'type' => 'text', 'class' => 'int-limit-3 calc-vipe', 'label' => ['text' => 'FR (irm):', 'class' => 'form-input']]);?>
				</div>
			</div>




			<div class="funkyradio">
				 <div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.recem_nascido', ['id' => 'recem_nascido', 'class' => ''])?>
				<label for="recem_nascido">Recém-nascido (≤28dias)</label>
				</div>
			</div>
			<br>



			<div class="funkyradio">
				<div class="funkyradio-primary">
					<?=$this->Form->checkbox('pediatric_screenings.0.glasgow_pediatrica_preenchida', ['id' => 'glasgow_pediatrica_preenchida', 'class' => 'active_checked'])?>
					<label for="glasgow_pediatrica_preenchida">Escala de Coma de Glasglow Pediátrica</label>
				</div>
			</div>
			<div class="glasgow_pediatrica_preenchida hide-element">
				<table class="table table-striped table-striped-gray table-hover  " id="glasgow_pediatrica">
				<!-- <legend class="big-title">Escala de coma de Glasgow pediátrica</legend> -->
				<thead>
				  <tr>
					<th>#</th>
					<th>1</th>
					<th>2</th>
					<th>3</th>
					<th>4</th>
					<th>5</th>
					<th>6</th>
					<th></th>
				  </tr>
				</thead>
				<tbody >
					<?php if ($age > 1): ?>
					  	<tr id='tr-ocular' >
							<th scope="row">Abertura dos olhos</th>
							<td id="espontaneamente">Espontaneamente</td>
							<td id="ao_comando">Ao comando</td>
							<td id="a_dor">À dor</td>
							<td id="nenhuma_resposta">Nenhuma resposta</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
					  	</tr>
					  	<tr id ='tr-verbal'>
							<th  scope="row">Orientada</th>
							<td id="desorientada">Desorientada</td>
							<td id='palavra_inapropriada'>Palavra inapropriada</td>
							<td id="sons_incompreensiveis">Sons incompreensíveis</td>
							<td id="nenhuma_resposta_2">Nenhuma resposta</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
					  	</tr>
					  	<tr id ='tr-motora'>
							<th  scope="row">Resposta motora</th>
							<td id="obedece_a_comandos">Obedece a comandos</td>
							<td id="localiza_a_dor">Localiza a dor</td>
							<td id="flexao_a_dor">Flexão à dor</td>
							<td id="flexao_anormal_dor">Flexão anormal à dor</td>
							<td id="extensao_anormal_dor">Extensão anormal à dor</td>
							<td id="nenhuma_resposta_3">Nenhuma resposta</td>
					  	</tr>
					<?php elseif ($age <= 1): ?>
						<tr id='resposta-ocular' >
							<th scope="row">Abertura dos olhos</th>
							<td id="espontaneamente_2">Espontaneamente</td>
							<td id="a_fala">À fala</td>
							<td id="a_dor">À dor</td>
							<td id="nenhuma_resposta">Nenhuma resposta</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
						</tr>
						<tr id='resposta-verbal'>
							<th  scope="row">Orientada</th>
							<td id="sorri_orientada">Sorri, orientada</td>
							<td id='choro_consolavel'>Choro, consolável</td>
							<td id="choro_persistente">Choro persistente, gemente.</td>
							<td id="agitada_e_inquietacao" >Agitada e inquietação</td>
							<td id="nenhuma_resposta_4">Nenhuma resposta</td>
							<td>&nbsp;</td>
					  	</tr>
					  	<tr id='resposta-motora'>
							<th  scope="row">Resposta motora</th>
							<td id="nao_se_movimenta">Não se movimenta</td>
							<td id="localiza_a_dor">Localiza a dor</td>
							<td id="flexao_a_dor">Flexão à dor</td>
							<td id="flexao_anormal_dor">Flexão anormal à dor</td>
							<td id="extensao_anormal_dor">Extensão anormal à dor</td>
							<td id="nenhuma_resposta_3">Nenhuma resposta</td>
					  	</tr>
					<?php endif;?>
				</tbody>
		  	</table>
			  <h3 id="glasgow-pontuation">Pontuação Glasgow: 0</h3>
	  	</div>
		  	<br><br>
  			<legend class="big-title">Discriminadores obrigatórios</legend>
		  	<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.estado_geral_check', ['id' => 'estado_geral_check', 'class' => 'active_checked calc-pediatria'])?>
				<label for="estado_geral_check">Estado geral</label>
				</div>
			</div>
			<br>
			<div class="estado_geral_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.estado_geral', ["class" => "calc-pediatria", 'empty' => 'Selecione um item', 'options' => $estado_geral, 'placeholder' => 'Estado geral', 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.tempo_maximo_espera_check', ['id' => 'tempo_maximo_espera_check', 'class' => 'active_checked calc-pediatria'])?>
				<label for="tempo_maximo_espera_check">Tempo máximo de espera</label>
				</div>
			</div>
			<br>
			<div class="tempo_maximo_espera_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.tempo_maximo_espera', ['class' => 'calc-pediatria time','type'=>'text', 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.nivel_da_dor_check', ['id' => 'nivel_da_dor_check', 'class' => 'active_checked calc-pediatria'])?>
				<label for="nivel_da_dor_check">Dor</label>
				</div>
			</div>
			<br>
			<div class="nivel_da_dor_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.nivel_da_dor', ['class'=>'calc-pediatria', 'empty' => 'Selecione o nível da dor', 'options' => $nivel_da_dor, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.retorno_check', ['id' => 'retorno_check', 'class' => 'active_checked calc-pediatria'])?>
				<label for="retorno_check">Retorno</label>
				</div>
			</div>
			<br>
			<div class="retorno_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.retorno', ['class'=>'calc-pediatria', 'empty' => 'Selecione o retorno', 'options' => $retorno, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<br><br>
			<legend class="big-title">Discriminadores secundários</legend>
			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.nivel_consciencia_check', ['class'=>'calc-pediatria', 'id' => 'nivel_consciencia_check', 'class' => 'active_checked'])?>
				<label for="nivel_consciencia_check">Nível de consciência</label>
				</div>
			</div>
			<br>
			<div class="nivel_consciencia_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.nivel_consciencia', ['class'=>'calc-pediatria', 'empty' => 'Selecione o nível de consciência', 'options' => $nivel_consciencia, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>


			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.via_aerea_respiracao_check', ['class'=>'calc-pediatria', 'id' => 'via_aerea_respiracao_check', 'class' => 'active_checked'])?>
				<label for="via_aerea_respiracao_check">Vias aéreas/respiração</label>
				</div>
			</div>
			<br>
			<div class="via_aerea_respiracao_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.via_aerea_respiracao', ['class'=>'calc-pediatria', 'empty' => 'Selecione uma via aérea', 'options' => $via_aerea_respiracao, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.cardiovascular_check', ['class'=>'calc-pediatria', 'id' => 'cardiovascular_check', 'class' => 'active_checked'])?>
				<label for="cardiovascular_check">Cardiovascular</label>
				</div>
			</div>
			<br>
			<div class="cardiovascular_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.cardiovascular', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $cardiovascular, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.neurologico_check', ['class'=>'calc-pediatria', 'id' => 'neurologico_check', 'class' => 'active_checked'])?>
				<label for="neurologico_check">Neurológico</label>
				</div>
			</div>
			<br>
			<div class="neurologico_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.neurologico', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $neurologico, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.gastrintestinal_check', ['class'=>'calc-pediatria', 'id' => 'gastrintestinal_check', 'class' => 'active_checked'])?>
				<label for="gastrintestinal_check">Gastrintestinal e genito-urinário</label>
				</div>
			</div>
			<br>
			<div class="gastrintestinal_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.gastrintestinal', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $gastrintestinal, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.trauma_check', ['class'=>'calc-pediatria', 'id' => 'trauma_check', 'class' => 'active_checked'])?>
				<label for="trauma_check">Trauma</label>
				</div>
			</div>
			<br>
			<div class="trauma_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.trauma', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $trauma, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.sangramento_ou_ferimento_check', ['class'=>'calc-pediatria', 'id' => 'sangramento_ou_ferimento_check', 'class' => 'active_checked'])?>
				<label for="sangramento_ou_ferimento_check">Sangramento ou ferimento</label>
				</div>
			</div>
			<br>
			<div class="sangramento_ou_ferimento_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.sangramento_ou_ferimento', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $sangramento_ou_ferimento, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.queimadura_check', ['class'=>'calc-pediatria', 'id' => 'queimadura_check', 'class' => 'active_checked'])?>
				<label for="queimadura_check">Queimadura</label>
				</div>
			</div>
			<br>
			<div class="queimadura_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.queimadura', ['class' => 'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $queimadura, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.intoxicacao_exogena_check', ['id' => 'intoxicacao_exogena_check', 'class' => 'active_checked calc-pediatria'])?>
				<label for="intoxicacao_exogena_check">Intoxicação exógena presente</label>
				</div>
			</div>
			<br>
			<!-- <div class="intoxicacao_exogena_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.intoxicacao_exogena', ['empty' => 'Selecione um item', 'options' => $intoxicacao_exogena, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div> -->


			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.pele_check', ['class'=>'calc-pediatria', 'id' => 'pele_check', 'class' => 'active_checked'])?>
				<label for="pele_check">Pele</label>
				</div>
			</div>
			<br>
			<div class="pele_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.pele', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $pele, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.locomotor_check', ['class'=>'calc-pediatria', 'id' => 'locomotor_check', 'class' => 'active_checked'])?>
				<label for="locomotor_check">Locomotor</label>
				</div>
			</div>
			<br>
			<div class="locomotor_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.locomotor', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $locomotor, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.corpo_estranho_check', ['class'=>'calc-pediatria', 'id' => 'corpo_estranho_check'])?>
				<label for="corpo_estranho_check">Corpo estranho presente</label>
				</div>
			</div>
			<br>
		<!-- 	<div class="corpo_estranho_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.corpo_estranho', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $corpo_estranho, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div> -->

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.inespecificos_check', ['class'=>'calc-pediatria', 'id' => 'inespecificos_check', 'class' => 'active_checked'])?>
				<label for="inespecificos_check">Inespecíficos</label>
				</div>
			</div>
			<br>
			<div class="inespecificos_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.inespecificos', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $inespecificos, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.comorbidades_check', ['class'=>'calc-pediatria', 'id' => 'comorbidades_check', 'class' => 'active_checked'])?>
				<label for="comorbidades_check">Comorbidades</label>
				</div>
			</div>
			<br>
			<div class="comorbidades_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.comorbidades', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $comorbidades, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>

			<div class="funkyradio">
				<div class="funkyradio-primary">
				<?=$this->Form->checkbox('pediatric_screenings.0.suspeita_de_dengue_check', ['class'=>'calc-pediatria', 'id' => 'suspeita_de_dengue_check', 'class' => 'active_checked'])?>
				<label for="suspeita_de_dengue_check">Suspeita de dengue</label>
				</div>
			</div>
			<br>
			<div class="suspeita_de_dengue_check hide-element">
				<?=$this->Form->input('pediatric_screenings.0.suspeita_de_dengue', ['class'=>'calc-pediatria', 'empty' => 'Selecione um item', 'options' => $suspeita_de_dengue, 'label' => ['text' => '', 'class' => 'form-input ']])?>
			</div>



		  	<br><br><br>
			<p id='classificacao-sugerida'>Classificação da urgência: Azul</p>
			<figure class='circle classficiacao_sugerida bg-blue'></figure>
			<input type="hidden" id="classificacao-urgencia" name='pediatric_screenings[0][classificacao_urgencia]' value='Azul'>
			<div class='hide-element' style='display:none'>
				<input class='classificacao-fields' name='classificacao_sugerida' default='Azul'>
			</div>
			<br><br><br>

			<button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>&nbsp;&nbsp;
			<?=$this->Form->button(__('Salvar'));?>
			<br><br><br>

		<?php endif;?>

		<?=$this->Form->hidden('pontuation_glasgow', ['id' =>'pontuation_glasgow']);?>
		<?=$this->Form->hidden('patient_id', ['value' => $pacient_id]);?>
		<?=$this->Form->hidden('unit_id', ['value' => $unit_id]);?>
		<?=$this->Form->end()?>
	</fieldset>
</div>



<script>

     var queixa_principal_current = '';

	<?php if (isset($screening['queixa_principal'])) :?>
			queixa_principal_current = '<?= $screening['queixa_principal']; ?>';
	<?php endif;?>

	$('#queixa-principal').change(function(){
			$('#queixa-principal option').each(function(){
				if($(this).val() == queixa_principal_current){
					$(this).attr('selected','selected');
				}
			});
	});




	if($('#sel').is(':checked')){
		$('.alterar-sel').show();
	}






	var age_in_months = <?=$months?>;
	var escore_vipe = 0;
	var current_color = 'verde';

	console.log("months = " + age_in_months);

// pediatria START
	var glasgow = {
		'nao_abre_os_olhos':1,
		'abre_os_olhos_a_dor':2,
		'abre_os_olhos_a_resposta':3,
		'abre_os_olhos_espontaneamente':4,
		'sem_resposta':1,
		'emite_sons':2,
		'pronuncia_palavras':3,
		'confuso_desorientado':4,
		'orientado':5,
		'nao_se_movimenta':1,
		'extensao_a_estimulos':2,
		'flexao_ao_estimulo':3,
		'retirada_ao_estimulo':4,
		'localiza_a_dor':5,
		'movimentacao_espontanea':6,
		'nenhuma_resposta_3':1
	};

	var glasgow_pediatrica = {
		'espontaneamente':1,
		'espontaneamente_2':1,
		'ao_comando':2,
		'a_fala':2,
		'a_dor':3,
		'nenhuma_resposta':4,
		'nenhuma_resposta_4':5,
		'nenhuma_resposta_2':4,
		'orientada':5,
		'sorri_orientada':1,
		'desorientada':1,
		'choro_consolavel':2,
		'palavra_inapropriada':2,
		'sons_incompreensiveis':3,
		'choro_persistente':3,
		'agitada_e_inquietacao':4,
		'obedece_a_comandos':1,
		'localiza_a_dor':2,
		'flexao_a_dor':3,
		'flexao_anormal_dor':4,
		'extensao_anormal_dor':5,
		'nenhuma_resposta_3':6,
		'nao_se_movimenta':1,
	};

	//calcula a escala de glasgow pediátrica
	$("#glasgow_pediatrica tbody tr td").click(function() {

		var total = 0;
		var tr_id = $(this).closest('tr').attr("id");
		var td_id = $(this).attr("id");
		var texto = '';

		if (typeof td_id == 'undefined') {
			return;
		}

		$(this).siblings().removeClass("selected");
		$(this).addClass("selected");

		$(".selected").each(function(index, value) {
			var id = $(value).attr("id");
			if (id.length > 1) {
				total += glasgow_pediatrica[id];
			}
		});

		if (tr_id == 'tr-ocular') {
		   texto = $("#"+td_id).text();
		   $("#glasgow-ocular").val(texto);
		}

		else if (tr_id == 'tr-verbal') {
		  texto = $("#"+td_id).text();
		  $("#glasgow-verbal").val(texto);
		}

		else if (tr_id == 'tr-motora') {
		  texto = $("#"+td_id).text();
		  $("#glasgow-motora").val(texto);
		}

		$("#glasgow-pontuation").text("Pontuação Glasgow: "+ (total));

		$("#pontuation_glasgow").val(total);

	});

	//calcular escore vipe
	$(".calc-vipe").change(function() {
		var spo2 = 0;
		var fc = 0;
		var fr = 0;
		var temp = null;
		escore_vipe = 0;

		if ( $("#pediatric-screenings-0-temp").val().length > 0 ) {
			// temp = parseFloat( $("#pediatric-screenings-0-temp").val() );
			temp = parseFloat($("#pediatric-screenings-0-temp").val().replace(',','.').replace(' ',''));
		}

		//if ( $("#pediatric-screenings-0-sato2").val().length > 0 ) {
			spo2 = parseInt( $("#pediatric-screenings-0-sato2").val() );
		//}

		//if ( $("#pediatric-screenings-0-fc").val().length > 0 ) {
			fc = parseInt( $("#pediatric-screenings-0-fc").val() );
		//}

		//if ( $("#pediatric-screenings-0-fr").val().length > 0 ) {
			fr = parseInt( $("#pediatric-screenings-0-fr").val() );
		//}

		console.log("spo2 = " + spo2);
		console.log("fc = " + fc);

		if (temp > 37.5 && temp <= 38.5) {
			escore_vipe - 1;
		}
		else if (temp > 38.5) {
			escore_vipe - 2;
		}

		if (age_in_months <= 2) {
			if (fr < 16) {
				escore_vipe += 4;
			}
			else if (fr <= 19) {
				escore_vipe += 2;
			}
			else if (fr <= 29) {
				escore_vipe += 1;
			}
			else if (fr <= 60) {
			}
			else if (fr <= 80) {
				escore_vipe += 2;
			}
			else if (fr <= 90) {
				escore_vipe += 3;
			}
			else if (fr > 90) {
				escore_vipe += 4;
			}

			if (fc < 81) {
				escore_vipe += 4;
			}
			else if (fc <= 90) {
				escore_vipe += 2;
			}
			else if (fc <= 110) {
				escore_vipe += 1;
			}
			else if (fc <= 149) {
			}
			else if (fc <= 179) {
				escore_vipe += 2;
			}
			else if (fc <= 189) {
				escore_vipe += 3;
			}
			else if (fc > 189) {
				escore_vipe += 4;
			}

			if (spo2 < 90) {
				console.log("you1");
				escore_vipe += 4;
			}
			else if (spo2 <= 92) {
				console.log("you2");
				escore_vipe += 2;
			}
			else if (spo2 <= 94) {
				escore_vipe += 1;
			}
			else if (spo2 <= 100) {
			}

		}
		else if (age_in_months <= 11) {
			if (fr < 16) {
				escore_vipe += 4;
			}
			else if (fr <= 19) {
				escore_vipe += 2;
			}
			else if (fr <= 29) {
				escore_vipe += 1;
			}
			else if (fr <= 60) {
			}
			else if (fr <= 80) {
				escore_vipe += 2;
			}
			else if (fr <= 90) {
				escore_vipe += 3;
			}
			else if (fr > 90) {
				escore_vipe += 4;
			}

			if (fc < 81) {
				escore_vipe += 4;
			}
			else if (fc <= 90) {
				escore_vipe += 2;
			}
			else if (fc <= 110) {
				escore_vipe += 1;
			}
			else if (fc <= 149) {
			}
			else if (fc <= 179) {
				escore_vipe += 2;
			}
			else if (fc <= 189) {
				escore_vipe += 3;
			}
			else if (fc > 189) {
				escore_vipe += 4;
			}

			if (spo2 < 90) {
				console.log("you1");
				escore_vipe += 4;
			}
			else if (spo2 <= 92) {
				console.log("you2");
				escore_vipe += 2;
			}
			else if (spo2 <= 94) {
				escore_vipe += 1;
			}
			else if (spo2 <= 100) {
			}
		}
		else if (age_in_months <= 48) {

			if (fr < 16) {
				escore_vipe += 4;
			}
			else if (fr <= 19) {
				escore_vipe += 2;
			}
			else if (fr <= 29) {
				escore_vipe += 1;
			}
			else if (fr <= 60) {
			}
			else if (fr <= 80) {
				escore_vipe += 2;
			}
			else if (fr <= 90) {
				escore_vipe += 3;
			}
			else if (fr > 90) {
				escore_vipe += 4;
			}

			if (fc < 81) {
				escore_vipe += 4;
			}
			else if (fc <= 90) {
				escore_vipe += 2;
			}
			else if (fc <= 110) {
				escore_vipe += 1;
			}
			else if (fc <= 149) {
			}
			else if (fc <= 179) {
				escore_vipe += 2;
			}
			else if (fc <= 189) {
				escore_vipe += 3;
			}
			else if (fc > 189) {
				escore_vipe += 4;
			}

			if (spo2 < 90) {
				console.log("you1");
				escore_vipe += 4;
			}
			else if (spo2 <= 92) {
				console.log("you2");
				escore_vipe += 2;
			}
			else if (spo2 <= 94) {
				escore_vipe += 1;
			}
			else if (spo2 <= 100) {
			}
		}
		else if (age_in_months <= 144) {
			if (fr < 16) {
				escore_vipe += 4;
			}
			else if (fr <= 19) {
				escore_vipe += 2;
			}
			else if (fr <= 29) {
				escore_vipe += 1;
			}
			else if (fr <= 60) {
			}
			else if (fr <= 80) {
				escore_vipe += 2;
			}
			else if (fr <= 90) {
				escore_vipe += 3;
			}
			else if (fr > 90) {
				escore_vipe += 4;
			}

			if (fc < 81) {
				escore_vipe += 4;
			}
			else if (fc <= 90) {
				escore_vipe += 2;
			}
			else if (fc <= 110) {
				escore_vipe += 1;
			}
			else if (fc <= 149) {
			}
			else if (fc <= 179) {
				escore_vipe += 2;
			}
			else if (fc <= 189) {
				escore_vipe += 3;
			}
			else if (fc > 189) {
				escore_vipe += 4;
			}

			if (spo2 < 90) {
				console.log("you1");
				escore_vipe += 4;
			}
			else if (spo2 <= 92) {
				console.log("you2");
				escore_vipe += 2;
			}
			else if (spo2 <= 94) {
				escore_vipe += 1;
			}
			else if (spo2 <= 100) {
			}
		}
		else {
			if (fr < 16) {
				escore_vipe += 4;
			}
			else if (fr <= 19) {
				escore_vipe += 2;
			}
			else if (fr <= 29) {
				escore_vipe += 1;
			}
			else if (fr <= 60) {
			}
			else if (fr <= 80) {
				escore_vipe += 2;
			}
			else if (fr <= 90) {
				escore_vipe += 3;
			}
			else if (fr > 90) {
				escore_vipe += 4;
			}

			//fc
			if (fc < 81) {
				escore_vipe += 4;
			}
			else if (fc <= 90) {
				escore_vipe += 2;
			}
			else if (fc <= 110) {
				escore_vipe += 1;
			}
			else if (fc <= 149) {
			}
			else if (fc <= 179) {
				escore_vipe += 2;
			}
			else if (fc <= 189) {
				escore_vipe += 3;
			}
			else if (fc > 189) {
				escore_vipe += 4;
			}

			//spo
			if (spo2 < 90) {
				console.log("you1");
				escore_vipe += 4;
			}
			else if (spo2 <= 92) {
				console.log("you2");
				escore_vipe += 2;
			}
			else if (spo2 <= 94) {
				escore_vipe += 1;
			}
			else if (spo2 <= 100) {
			}

		}

		console.log("escore_vipe = " + escore_vipe);
		if (escore_vipe == 1) {
			current_color = null;
			ajustar_classificacao('azul');
		}
		else if (escore_vipe <= 2) {
			ajustar_classificacao("verde");
		}
		else if (escore_vipe <= 5) {
			ajustar_classificacao("amarelo");
		}
		else if (escore_vipe<= 9 ) {
			ajustar_classificacao("laranja");
		}
		else if (escore_vipe >= 10) {
			ajustar_classificacao("vermelho");
		}


	});

 $(".calc-pediatria").change(function() {
 		current_color = null;
 		ajustar_classificacao('azul');
 	//if ( $("#pediatric-screenings-0-estado-geral").val() ) {
 		console.log("calc pediatria");
 		console.log("calc pediatria eg = " +$("#pediatric-screenings-0-estado-geral option:selected").val());


		switch( $("#pediatric-screenings-0-suspeita-de-dengue option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
            case '2':
		        ajustar_classificacao('amarelo');
		        break;

		}

 		switch( $("#pediatric-screenings-0-nivel-consciencia option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;

		}

		switch( $("#pediatric-screenings-0-via-aerea-respiracao option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
	         case '2':
		        ajustar_classificacao('amarelo');
		        break;
		    case '3':
		        ajustar_classificacao('verde');
		        break;
		}


 		switch( $("#pediatric-screenings-0-estado-geral option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
	  	 	case '2':
		        ajustar_classificacao('amarelo');
		        break;
	        case '3':
		        ajustar_classificacao('verde');
		        break;
	        case '4':
		        ajustar_classificacao('azul');
		        break;
		}

		switch( $("pediatric-screenings-0-nivel-da-dor option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('laranja');
		        break;
		    case '1':
		        ajustar_classificacao('amarelo');
		        break;
	  	 	case '2':
		        ajustar_classificacao('verde');
		        break;
	        case '3':
		        ajustar_classificacao('azul');
		        break;
		}

		switch( $("pediatric-screenings-0-retorno option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('amarelo');
		        break;
		    case '1':
		        ajustar_classificacao('amarelo');
		        break;

		}

		switch( $("#pediatric-screenings-0-estado-geral option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
		}

		switch( $("pediatric-screenings-0-via-aerea-respiracao option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
	  	 	case '2':
		        ajustar_classificacao('amarelo');
		        break;
	        case '3':
		        ajustar_classificacao('verde');
		        break;
		}

		switch( $("#pediatric-screenings-0-cardiovascular option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
		}

		switch( $("#pediatric-screenings-0-neurologico option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
		    case '1':
		        ajustar_classificacao('amarelo');
		        break;
		}

		switch( $("#pediatric-screenings-0-gastrintestinal option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('laranja');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
	  	 	case '2':
		        ajustar_classificacao('laranja');
		        break;
	        case '3':
		        ajustar_classificacao('laranja');
		        break;

		    case '4':
		        ajustar_classificacao('amarelo');
		        break;
	        case '5':
		        ajustar_classificacao('amarelo');
		        break;

		    case '6':
		        ajustar_classificacao('amarelo');
		        break;

		    case '7':
		        ajustar_classificacao('verde');
		        break;
		}

		switch( $("#pediatric-screenings-0-trauma option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
	  	 	case '2':
		        ajustar_classificacao('laranja');
		        break;
	        case '3':
		        ajustar_classificacao('laranja');
		        break;

		    case '4':
		        ajustar_classificacao('amarelo');
		        break;
	        case '5':
		        ajustar_classificacao('amarelo');
		        break;

		    case '6':
		        ajustar_classificacao('verde');
		        break;
		}

		switch( $("#pediatric-screenings-0-sangramento-ou-ferimento option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
	  	 	case '2':
		        ajustar_classificacao('vermelho');
		        break;
	        case '3':
		        ajustar_classificacao('amarelo');
		        break;

		    case '4':
		        ajustar_classificacao('amarelo');
		        break;
	        case '5':
		        ajustar_classificacao('laranja');
		        break;
		    case '6':
		        ajustar_classificacao('verde');
		        break;
		    case '7':
		        ajustar_classificacao('laranja');
		        break;
		}
		switch( $("#pediatric-screenings-0-queimadura option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
	  	 	case '2':
		        ajustar_classificacao('vermelho');
		        break;
	        case '3':
		        ajustar_classificacao('amarelo');
		        break;
		}

		if ( $("#intoxicacao_exogena_check").is(':checked') ) {
			 ajustar_classificacao('laranja');
		}

		switch( $("#pediatric-screenings-0-pele option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('vermelho');
		        break;
	  	 	case '2':
		        ajustar_classificacao('vermelho');
		        break;
	        case '3':
		        ajustar_classificacao('laranja');
		        break;

		    case '4':
		        ajustar_classificacao('laranja');
		        break;
	        case '5':
		        ajustar_classificacao('laranja');
		        break;
		    case '6':
		        ajustar_classificacao('amarelo');
		        break;
		    case '7':
		        ajustar_classificacao('amarelo');
		        break;
		    case '8':
		        ajustar_classificacao('verde');
		        break;
		    case '9':
		        ajustar_classificacao('azul');
		        break;
		}

		switch( $("#pediatric-screenings-0-locomotor option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('amarelo');
		        break;
		    case '1':
		        ajustar_classificacao('amarelo');
		        break;
		}

		if ( $("#corpo_estranho_check").is(':checked') ) {
			 ajustar_classificacao('amarelo');
		}

		switch( $("#pediatric-screenings-0-inespecificos option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('laranja');
		        break;
	  	 	case '2':
		        ajustar_classificacao('laranja');
		        break;
	        case '3':
		        ajustar_classificacao('amarelo');
		        break;
		}

		switch( $("#pediatric-screenings-0-comorbidades option:selected").val() ) {
		    case '0':
		        ajustar_classificacao('vermelho');
		        break;
		    case '1':
		        ajustar_classificacao('vermelho');
		        break;
	  	 	case '2':
		        ajustar_classificacao('laranja');
		        break;
	        case '3':
		        ajustar_classificacao('amarelo');
		        break;
		}

 	//}
 });

 // pediatria END

var verbal =0;
var ocular = 0;
var motora = 0;
var classificacao = null;

var select_opt_1 = '<option value=""></option><option value="alteracao_estado_mental">Alteração de estado mental</option><option value="dispneia">Dispneia</option><option value="hiperglicemia">Hiperglicemia</option><option value="alt_sinais_vitais">Alteração de sinais vitais isolados</option><option value="tosse">Tosse</option><option value="lesoes_de_pele">Lesões de pele</option><option value="dor">Dor</option><option value="febre">Febre</option><option value="hipoglicemia">Hipoglicemia</option><option value="diarreia">Diarreia</option><option value="casos_especiais">Casos especiais</option><option value="procura_da_unidade">Procura da unidade para procedimentos</option><option value="hemorragia">Hemorragia</option><option value="alteracao_de_pressao">Alteração de pressão</option><option value="parada_cardiorrespiratoria">Parada cardiorrespiratória</option><option value="hemorragia_digestiva">Hemorragia digestiva</option><option value="queixas_cronicas">Queixas crônicas</option>';

var select_opt_2 = '<option value=""></option>';
	select_opt_2 += '<option value="demaio_mal_estar">Desmaio / mal estar geral</option>';
	select_opt_2 += '<option value="dor_abdominal_lombar">Dor abdominal / lombar / contrações uterinas</option>';
	select_opt_2 += '<option value="dor_de_cabeca">Dor de cabeça, tontura, vertigem</option>';
	select_opt_2 += '<option value="falta_de_ar">Falta de ar</option>';
	select_opt_2 += '<option value="febre_sinais_infeccao">Febre / sinais de infecção</option>';
	select_opt_2 += '<option value="nausea_e_vomito">Náuseas e vômitos</option>';
	select_opt_2 += '<option value="perda_liquido_vaginal">Perda de líquido vaginal / secreções</option>';
	select_opt_2 += '<option value="perda_de_sangue_vaginal">Perda de sangue via vaginal</option>';
	select_opt_2 += '<option value="queixas_urinarias">Queixas urinárias</option>';
	select_opt_2 += '<option value="parada_reducao_movimentos">Parada / redução de movimentos fetais</option>';
	select_opt_2 += '<option value="relato_convulsao">Relato de convulsão</option>';
	select_opt_2 += '<option value="outras_queixaas_pacientes">Outras queixas / pacientes encaminhadas de outras unidades sem referenciamento</option>';



	$(".calc-screening").change(function() {
		console.log("calc-screening");
		current_color = null;
		ajustar_classificacao("azul");

		console.log('$("#pontuation_glasgow").val() ' + $("#pontuation_glasgow").val());

		if ( $("#pontuation_glasgow").val() == "3") {
			ajustar_classificacao("vermelho");
		}
			//ajustar_classificacao("verde");

			//$(".calc-screening").each(function(index, value) {

			//sinais vitais
			if ($("#parada_cardiaca_ou_suspeita").is(":checked")) {
				ajustar_classificacao("vermelho");
			}

			if ($("#fc").val() !== '' || $("#fc").val() > 0) {
				if ( $("#fc").val() > 100 || $("#fc").val() < 60 ) {
					ajustar_classificacao("amarelo");
				}
			}

			if ($("#fr").val() !== '' || $("#fr").val() > 0) {
				if ( $("#fr").val() > 20 ) {
					ajustar_classificacao("amarelo");
				}
			}

			if ($("#temp").val() !== '') {
				if ( $("#temp").val() > 37.8 || $("#temp").val() < 35 ) {
					ajustar_classificacao("amarelo");
				}
			}

			if ($("#glicemia").val() !== '' || $("#glicemia").val() > 0) {
				if ( $("#glicemia").val() <= 60 ) {
					ajustar_classificacao("amarelo");
				}
			}

			if ($("#sato2").val() !== '' || $("#sato2").val() > 0) {

				if ( $("#sato2").val() < 95 ) {
					ajustar_classificacao("vermelho");
				}
				else {
					ajustar_classificacao("verde");
				}
			}

			if ($("#pas").val() !== '' || $("#pas").val() > 0) {
				if ( $("#pas").val() > 140 ) {
					console.log("cefaleia pas > 140 ");
					ajustar_classificacao("vermelho");
				}
			}

			if ($("#pad").val() !== '' || $("#pad").val() > 0) {
				if ( $("#pad").val() > 90 ) {
					console.log("cefaleia pading > 140 ");
					ajustar_classificacao("vermelho");
				}
			}

			if ($("#alteracao-consciencia").val().length > 1) {
				ajustar_classificacao("amarelo");
			}



			switch( $("#queixa-principal").val() ) {

				case "deficit_motor":
					if ($("#deficit_motor_inicio_subito").is(":checked")) {
						ajustar_classificacao("vermelho");
					}
				break;

				case "parada_cardiorrespiratoria":
					if ($("#parada_ausecia_pulso").is(":checked")) {
						ajustar_classificacao("vermelho");
					}

					if ($("#parada_ausecia_movimentos").is(":checked")) {
						ajustar_classificacao("vermelho");
					}

					if ($("#parada_inconsciencia").is(":checked")) {
						ajustar_classificacao("vermelho");
					}
				break;

				case "lesoes_de_pele":
					if ($("#lesoes_de_pele_escabiose").is(":checked")) {
						ajustar_classificacao("azul");
					}

					if ($("#lesoes_de_pele_eczema").is(":checked")) {
						ajustar_classificacao("azul");
					}

					if ($("#lesoes_de_pele_eczema").is(":checked")) {
						ajustar_classificacao("azul");
					}
				break;

				case "alt_sinais_vitais":
					// if ( $("#fc").val() > 100 || $("#fc").val() < 60 ) {
					// 	ajustar_classificacao("amarelo");
					// }

					// if ( $("#fr").val() > 20 ) {
					// 	ajustar_classificacao("amarelo");
					// }

					// if ( $("#temp").val() > 37.8 ) {
					// 	ajustar_classificacao("amarelo");
					// }
				break;


				case "alteracao_estado_mental":
					if ($("#alt_estado_mental_ausencia_de_resposta").is(":checked")) {
						ajustar_classificacao("vermelho");
					}

					// if ($("#alteracao-consciencia").val().length > 1) {
					// 	ajustar_classificacao("amarelo");
					// }
				break;

				case "hiperglicemia":
					if ($("#alteracao-consciencia").val().length > 1) {
						ajustar_classificacao("vermelho");
					}
				break;

				case "hipoglicemia":
					if ($("#alteracao-consciencia").val().length > 1) {
						ajustar_classificacao("vermelho");
					}

					// if ( $("#glicemia").val() <= 60 ) {
					// 	ajustar_classificacao("amarelo");
					// }
				break;

				case "parada_cardiorrespiratoria":
					if ($("#parada_ausecia_pulso").is(":checked")) {
						ajustar_classificacao("vermelho");
					}

					if ($("#parada_ausecia_movimentos").is(":checked")) {
						ajustar_classificacao("vermelho");
					}

					if ($("#parada_inconsciencia").is(":checked")) {
						ajustar_classificacao("vermelho");
					}

				break;


				case "diarreia":
					//resolver corrigir pa
					if ($("#diarreia_sinais_de_desidratacao").is(":checked")) {
						ajustar_classificacao("amarelo");
					}

					// if ( $("#fc").val() > 100 ) {
					// 	ajustar_classificacao("amarelo");
					// }

					// if ( $("#temp").val() > 37.8 ) {
					// 	ajustar_classificacao("amarelo");
					// }

				break;

				case "hemorragia_digestiva":
					//resolver corrigir pa
					if ($("#hemorragia_historico_de_enterorragia").is(":checked")) {
						ajustar_classificacao("amarelo");
					}

					// if ( $("#fc").val() > 100 ) {
					// 	ajustar_classificacao("amarelo");
					// }

					// if ($("#alteracao-consciencia").val().length > 1) {
					// 	ajustar_classificacao("amarelo");
					// }

					if ($("#hemorragia_antecedente_de_cirrose").is(":checked")) {
						ajustar_classificacao("amarelo");
					}

				break;

				case "tosse":
					//resolver corrigir pa
					if ($("#tosse_dispneia").is(":checked")) {
						ajustar_classificacao("amarelo");
					}

					if ($("#tosse_historico_de_hemoptise").is(":checked")) {
						ajustar_classificacao("amarelo");
					}

					// if ( $("#fr").val() > 20 ) {
					// 	ajustar_classificacao("amarelo");
					// }

					// if ( $("#temp").val() > 37.8 ) {
					// 	ajustar_classificacao("amarelo");
					// }

					if ( $("#sato2").val() > 95 ) {
						ajustar_classificacao("amarelo");
					}



				break;

				case "febre":
					//resolver corrigir pa

					if ($("#alt_estado_mental_ausencia_de_resposta").is(":checked")) {
						ajustar_classificacao("vermelho");
					}

					if ($("#febre_dispneia").is(":checked")) {
						ajustar_classificacao("vermelho");
					}

					if ($("#febre_imunossupressao").is(":checked")) {
						ajustar_classificacao("vermelho");
					}

					// if ( $("#fc").val() > 100 ) {
					// 	ajustar_classificacao("vermelho");
					// }

					// if ( $("#fr").val() > 25 ) {
					// 	ajustar_classificacao("vermelho");
					// }
				break;

				case "dispneia":
					if ( $("#dispneia_desconforto").is(":checked") ) {
						ajustar_classificacao("vermelho");
					}

					if ( $("#dispneia_cianose").is(":checked") ) {
						ajustar_classificacao("vermelho");
					}

					if ( $("#dispneia_utilizacao_da_musculatura").is(":checked") ) {
						ajustar_classificacao("vermelho");
					}

					// if ( $("#fr").val() > 20 ) {
					// 	ajustar_classificacao("vermelho");
					// }

					if ( $("#dispneia_dificuldade_para_falar").is(":checked") ) {
						ajustar_classificacao("vermelho");
					}

					// if ( $("#temp").val() > 37.8 || $("#temp").val() < 35 ) {
					// 	ajustar_classificacao("vermelho");
					// }

					if ( $("#alteracao-consciencia").val().length > 1 ) {
						ajustar_classificacao("vermelho");
					}

					// if ( $("#sato2").val() < 95 ) {
					// 	ajustar_classificacao("vermelho");
					// }
					// else {
					// 	ajustar_classificacao("verde");
					// }

					// if ( $("#fc").val() > 100 ) {
					// 	ajustar_classificacao("vermelho");
					// }

					if ( $("#dispneia_historico_de_asma").is(":checked") ) {
						ajustar_classificacao("amarelo");
					}

					if ( $("#dispneia_alteracao_na_ausculta").is(":checked") ) {
						ajustar_classificacao("amarelo");
					}
				break;

				case "dor":
					if ( $('#localizacao-da-dor').val().length > 1 ) {
						switch( $("#localizacao-da-dor option:selected").val() ) {
							case "cefaleia" :
								if ( $("#cefaleia_inicio_subito").is(":checked") ) {
									console.log("cefaleia_inicio_subito");
									ajustar_classificacao("vermelho");
								}

								if ( $("#cefaleia_episodio_de_crise_convulsiva").is(":checked") ) {
									console.log("cefaleia_episodio_de_crise_convulsiva");
									ajustar_classificacao("vermelho");
								}

								if ( $("#cefaleia-deficit-motor option:selected").val() == 0) {
									console.log( $("#cefaleia-deficit-motor option:selected").text() );
									ajustar_classificacao("vermelho");
								}
								else if ( $("#cefaleia-deficit-motor option:selected").val() == 1) {
									console.log( $("#cefaleia-deficit-motor	option:selected").text() );
									ajustar_classificacao("verde");
								}

								if ( $("#alteracao-consciencia").val().length > 0 ) {
									ajustar_classificacao("vermelho");
								}
								else {
									ajustar_classificacao("verde");
								}

								// if ( $("#pas").val() > 140 ) {
								// 	console.log("cefaleia pas > 140 ");
								// 	ajustar_classificacao("vermelho");
								// }

								// if ( $("#pad").val() > 90 ) {
								// 	console.log("cefaleia pading > 140 ");
								// 	ajustar_classificacao("vermelho");
								// }

								// if ( $("#fc").val() < 60 ) {
								// 	console.log("cefaleia fc < 60");
								// 	ajustar_classificacao("vermelho");
								// }

								if ( $("#cefaleia_rigidez_da_nuca").is(":checked") ) {
									ajustar_classificacao("vermelho");
									console.log("cefaleia_rigidez_da_nuca");
								}

								if ( $("#cefaleia_vomitos").is(":checked") ) {
									ajustar_classificacao("vermelho");
									console.log("cefaleia_vomitos");

								}

								if ( $("#intensidade-da-dor").val() == "Forte" ) {
									ajustar_classificacao("amarelo");
									console.log("intensidade-da-dor");
								}
								else  {
									ajustar_classificacao("verde");
									console.log("intensidade-da-dor");
								}

								if ( $("#cefaleia_inicio_a_varios_dias").is(":checked") ) {
									console.log("cefaleia_inicio_a_varios_dias");
									ajustar_classificacao("verde");
								}

							break;

							case "abdominal":
								//resolver corrigir pa
								// if ( $("#fc").val() > 100 ) {
								// 	ajustar_classificacao("vermelho");
								// }

								// if ( $("#temp").val() > 37.8) {
								// 	ajustar_classificacao("vermelho");
								// }

								if ( $("#dor_abdominal_historico_de_trauma").is(":checked") ) {
									ajustar_classificacao("vermelho");
								}

								if ( $("#intensidade-da-dor option:selected").val() == "Moderada" ||  $("#intensidade-da-dor option:selected").val() == "Forte" ) {
									console.log('yoyoy');
									ajustar_classificacao("amarelo");
								}
							break;

							case "toracica":
								//resolver corrigir pa
								if ( $("#dor_toracica_dor_precordial").is(":checked") ) {
									ajustar_classificacao("vermelho");
								}

								if ( $("#dor_toracica_dispineia").is(":checked") ) {
									ajustar_classificacao("vermelho");
								}

								if ( $("#dor_toracica_assimetria_dos_pulsos").is(":checked") ) {
									ajustar_classificacao("vermelho");
								}

								if ( $("#dor_toracica_historico_de_coronariopatia").is(":checked") ) {
									ajustar_classificacao("vermelho");
								}

								if ( $("#dor_toracica_irradiacao").is(":checked") ) {
									ajustar_classificacao("vermelho");
								}

								// if ( $("#fc").val() > 90 || $("#fc").val() < 60 ) {
								// 	ajustar_classificacao("vermelho");
								// }

								// if ( $("#fr").val() > 20 ) {
								// 	ajustar_classificacao("vermelho");
								// }

								if ( $("#dor_toracica_historico_de_avc").is(":checked") ) {
									ajustar_classificacao("amarelo");
								}

							break;
						}
					}
				break;

				default:
					classificacao = "verde";
				break;
			}

			if ( $(this).is("#pas") ) {
				 //console.log("queixa-principal = " + $("#queixa-principal").val() );
				// console.log("value = " + $(value).val());
				//if ( $(value).val() > 140)
			}
		// });
	});

	function ajustar_classificacao(cor) {
		console.log("ajustar_classificacao INIT");
		console.log("current_color = " + current_color);
		console.log("cor = " + cor);
		console.log("ajustar_classificacao END");
		console.log($(".classificacao-fields"));

		switch(cor) {
			case 'azul':
				if (current_color != "verde" && current_color != "laranja" && current_color != "amarelo" && current_color != 'vermelho' ) {
					current_color = 'azul';
					$("#classificacao-sugerida").text("Classificação da urgência: Azul");
					$(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #235DFF, #676767)');
					$("#classificacao-urgencia").val('Azul');
					$(".classificacao-fields").val('Azul');
				}
				break;

			case 'verde':
				if (current_color != "laranja" && current_color != "amarelo" && current_color != 'vermelho' ) {
					current_color = 'verde';
					$("#classificacao-sugerida").text("Classificação da urgência: Verde");
					$(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #21FF07, #676767)');
					$("#classificacao-urgencia").val('Verde');
					$(".classificacao-fields").val('Verde');
				}
				break;

			case 'amarelo':
				if (current_color != "laranja" && current_color != "vermelho" ) {
					current_color = 'amarelo';
					$("#classificacao-sugerida").text("Classificação da urgência: Amarelo");
					$(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #fff700, #676767)');
					$("#classificacao-urgencia").val('Amarelo');
					$(".classificacao-fields").val('Amarelo');
				}
				break;

			case 'laranja':
				if (current_color != "vermelho") {
					current_color = 'laranja';
					$("#classificacao-sugerida").text("Classificação da urgência: Laranja");
					$(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #ff8d00, #b7b2b2)');
					$("#classificacao-urgencia").val('Laranja');
					$(".classificacao-fields").val('Laranja');
				}
				break;

			case 'vermelho':
					current_color = 'vermelho';
					$("#classificacao-sugerida").text("Classificação da urgência: Vermelho");
					$(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #ff0000, #676767)');
					$("#classificacao-urgencia").val('Vermelho');
					$(".classificacao-fields").val('Vermelho');

				break;
			default:
				current_color = 'verde';
				$("#classificacao-sugerida").text("Classificação da urgência: Verde");
				$(".classficiacao_sugerida").css('background','radial-gradient(circle at 13px 14px, #21FF07, #676767)');
				$("#classificacao-urgencia").val('Verde');
				$(".classificacao-fields").val('Verde');
		}
	}

	$("#classificacao_obstetrica").change(function() {
		$("#queixa-principal option").remove();

		if ($(this).is(":checked")) {
			$("#queixa-principal").append(select_opt_2);
		}
		else {
			$("#queixa-principal").append(select_opt_1);
		}
	});

	$("#desmaio_nao_vermelho").change(function() {
		$("#desmaio_vermelho").hide();

		if ($(this).is(":checked")) {
			$("#desmaio_laranja").fadeIn();
		}
		else {
			$("#desmaio_laranja").fadeOut();
		}
	});

$("#localizacao-da-dor").change(function(){
   var localizacao = $(this).val();

   $('.tipo-de-dor select').val('');
   $('.tipo-de-dor').hide();

   $('.'+localizacao).slideDown();
   console.log($(this).val());
});


$("#queixa-principal").change(function(){

   var localizacao = $(this).val();
   console.log(localizacao);

   if (localizacao) {
   		if (localizacao.length > 2){
		  $("#proximo").removeAttr("disabled");
		  // $("#menu_2").attr("href", "#tab_default_2");
		  // $("#menu_2").attr("data-toggle", "#tab");

		}
	   else
	   {
		  $("#proximo").attr("disabled");
		  //$("#proximo").removeAttr("href");
		  //$("#proximo").removeAttr("data-toggle");
	   }

	   $('.tipo-de-dor-queixa select').val('');
	   $('.tipo-de-queixa select').val('');
	   $('.tipo-de-dor select').val('');

	   $('.tipo-de-dor').hide();
	   $('.tipo-de-dor-queixa').hide();
	   $('.tipo-de-queixa').hide();

	   $('.'+localizacao).toggle();
   }


});

$("#proximo").click(function(){
	$("#menu_2").click();
});

// $("#parada_cardiaca_ou_suspeita").change(function() {
//     if ($(this).is(":checked")) {
//         $(".parada_cardiaca_ou_suspeita").slideDown();
//     }
//     else {
//         $(".parada_cardiaca_ou_suspeita").slideUp();
//     }
// });

$("#tem_alergia").change(function() {
	console.log("yo");
	console.log(this.checked );

	if (this.checked ) {
		$(".tem_alergia").show();
	}
	else {
		$(".tem_alergia").hide();
	}
});

$("#uso_medicacao_regular").change(function() {

	console.log(this.checked);

	if (this.checked ) {
		$(".uso_medicacao_regular").show();
	}
	else {
		$(".uso_medicacao_regular").hide();
	}
});

$("#classificacao-selecionada").change(function(){
	console.log($(this).val());
	if(!$( ".classificacao_selecionada_l figure" ).hasClass( "circle_selecionada" )) {
		$(".classificacao_selecionada_l").append("<figure class='circle circle_selecionada'></figure>");
	}

	color = $(this).val();
	switch(color) {
		case 'amarelo':
			$(".circle_selecionada").css('background','radial-gradient(circle at 13px 14px, #fff700, #676767)');
			break;
		case 'azul':
			$(".circle_selecionada").css('background','radial-gradient(circle at 13px 14px, #00a1ff, #676767)');
			break;
		case 'vermelho':
			$(".circle_selecionada").css('background','radial-gradient(circle at 13px 14px, #ff0000, #676767)');
			break;
		default:
			$(".circle_selecionada").css('background','radial-gradient(circle at 13px 14px, #1BFF00, #676767)');
	}
});

(function() {
   // your page initialization code here
   // the DOM will be available here
   var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    array('controller' => 'Users', 'action' => 'login'), array('class' => 'btn btn-default ', 'escape' => false))?> ';

   var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';
   var link3 =' <?=$this->Html->link('Triagens', ['controller' => 'Screenings', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

	var html = '';
		html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
		html+= link1;
		html+= link2;
		html+= link3;
		html+= '<a href="#" class="breadcumb-active btn btn-default">Novo</a>';
		html+= '</div>';
			document.getElementById("breadcumb").innerHTML =html;
})();


function selectGlasgow(type, elem,  param, val) {

	// console.log("param = " + param);
	// console.log('type = '+type);
	// console.log( $(elem).html() );

	if (type == 'ocular') {
	   ocular = glasgow[param];

	   $("#tr-ocular td").removeClass("selected");
	   $("#glasgow-ocular").val( $(elem).html() );
	}
	else if (type == 'verbal') {
	  verbal = glasgow[param];

	  $("#tr-verbal td").removeClass("selected");
	  $("#glasgow-verbal").val( $(elem).html() );

	}
	else if (type == 'motora') {
	  motora = glasgow[param];

	  $("#tr-motora td").removeClass("selected");
	  $("#glasgow-motora").val( $(elem).html() );
	}

	$("#glasgow-pontuation").text("Pontuação Glasgow: "+ (ocular + verbal + motora));
	$("#pontuation_glasgow").val(ocular + verbal + motora);

	$(elem).addClass("selected");

	$("#gambiarra").trigger("change");
}


$("#sel").change(function() {
	   if (this.checked ) {
		$(".alterar-sel").show();
	}
	else {
		$(".alterar-sel").hide();
	}
});




$( document ).ready(function() {


	$("#classificacao_obstetrica").trigger("change");

	ajustar_classificacao('azul');
	$('.calc-pediatria').trigger("change");

	setTimeout(function() {

	 	 $("#gambiarra").trigger("change");
	 	 $("#queixa-principal").trigger("change");

 	<?php
 		//pega o valor que foi salvo no banco e preenche a tabela

 		if ($age > 13){

			if (isset($screening['glasgow_motora'])) {
				echo '$( "td:contains(\''.$screening['glasgow_motora'].'\')" ).click();';
			}

			if (isset($screening['glasgow_verbal'])) {
				echo '$( "td:contains(\''.$screening['glasgow_verbal'].'\')" ).click();';
			}

			if (isset($screening['glasgow_ocular'])) {
				echo '$( "td:contains(\''.$screening['glasgow_ocular'].'\')" ).click();';
			}

	    }elseif ($age <= 13){

	    	if (isset($screening['pediatric_screenings'][0]['glasgow_motora'])) {
			echo '$( "td:contains(\''.$screening['pediatric_screenings'][0]['glasgow_motora'].'\')" ).click();';
			}

			if (isset($screening['pediatric_screenings'][0]['glasgow_verbal'])) {
				echo '$( "td:contains(\''.$screening['pediatric_screenings'][0]['glasgow_verbal'].'\')" ).click();';
			}

			if (isset($screening['pediatric_screenings'][0]['glasgow_ocular'])) {
				echo '$( "td:contains(\''.$screening['pediatric_screenings'][0]['glasgow_ocular'].'\')" ).click();';
			}

	    }




	?>

	}, 1000);

});

// $('select').each(function(){
// 	$(this).find('option:selected').prependTo($(this));
// });

</script>

<style type="text/css">
	table tbody tr:hover, table tbody tr:hover th {
		color: #666 !important;
		background-color: #fff !important;
	}

	#glasgow_pediatrica tbody tr:hover, #glasgow_pediatrica tbody tr:hover th{
		color: #666;
		background-color: #fff;

	}
	.sticky-wrap {
		overflow-y: hidden;
		overflow-x: hidden;
	}
</style>
