<?php
  
  $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
  $to   = new DateTime('today');
  $age  = null;
  $age  = $from->diff($to)->y;

  $nivelcons_ciencia = [''=> '', 'Acordado'=> 'Acordado', 'Adormecido'=>'Adormecido', 'Sonolento'=>'Sonolento', 'Coma'=>'Coma'];

  $suplementacao_oxigenio = [''=> '', 'Não'=> 'Não', 'Cateter de O2'=>'Cateter de O2', 'Macronebulizador'=>'Macronebulizador', 'Máscara Laríngea'=>'Máscara Laríngea', 'Tubo Orotraqueal'=>'Tubo Orotraqueal', 'Cânula de Traqueostomia'=>'Cânula de Traqueostomia'];

  $qual_metodo_de_profilaxia_utilizada = ['Farmacológica', 'Compressor Intermitente', 'Meias Elásticas', 'Outro'];

  $checked_img = $this->Html->image('checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

  $not_checked_img = $this->Html->image('not-checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

?>

<style type="text/css">
	.data-field{
		min-height:30px;
	}
</style>

<div class="container unit-header">
    <div class="bundles form col-sm-4 columns content">

        <?=
         $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
        ?>
        <br><br>
        <p class="unit-data"><b><?= $unit->name ?></b></p>
        <p class="unit-data"><b><?= $unit->telephone ?></b></p>
        <p class="unit-data"><b><?= $unit->street ?></b></p>
        <p class="unit-data"><b><?= $unit->city ?></b></p>
        <br>
    </div>
    <div class="col-sm-8">
        <h1>Checklist Cirúrgico</h1>
    </div>

</div>

<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>

<div class="surgicalChecklists form col-md-9 columns content">

<div class="page"> <!-- inicio da página 1  -->

    <div class="col-sm-12 no-padding">
       
        <legend class="big-title">Comunicação ativa com verificação obrigatória do checklist:</legend>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['confirmacao_paciente_cirurgia_a_ser_realizado']){
              echo $checked_img.'<b>Confirmação o paciente/cirurgia a ser realizado e lateralidade/sítio cirúrgico</b>';
             }else{
              echo $not_checked_img.'<b>Confirmação o paciente/cirurgia a ser realizado e lateralidade/sítio cirúrgico</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['checagem_da_equipe_que_esta_em_saia']){
              echo $checked_img.'<b>Checagem da equipe que está em saia</b>';
             }else{
              echo $not_checked_img.'<b>Checagem da equipe que está em saia</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['todos_os_materais_uncionando_e_disponiveis']){
              echo $checked_img.'<b>Todos os materais, implantes e equipamentos estão funcionando e disponíveis</b>';
             }else{
              echo $not_checked_img.'<b>Todos os materais, implantes e equipamentos estão funcionando e disponíveis</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['atb_profilático_realizado']){
              echo $checked_img.'<b>ATB profilático realizado</b>';
             }else{
              echo $not_checked_img.'<b>ATB profilático realizado</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['exames_de_imagens_e_laboratoriais_essenciais_em_saia']){
              echo $checked_img.'<b>Exames de imagens e laboratoriais essenciais em saia</b>';
             }else{
              echo $not_checked_img.'<b>Exames de imagens e laboratoriais essenciais em saia</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['necessidades_de_congelacao_patologista']){
              echo $checked_img.'<b>Há necessidades de congelação/patologista</b>';
             }else{
              echo $not_checked_img.'<b>Há necessidades de congelação/patologista</b>';
             }
          ?>
        </div>
              
    </div>



    <div class="col-sm-12 no-padding">
      
       
       <legend class="big-title">Antes da Indução</legend>
       
       <div class="col-sm-12 no-padding">
         <legend class="sub-title-sections">Antes da indução anestésica:</legend>
       </div>

       <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['informacoes_do_paciente_foram_confirmadas']){
            echo $checked_img.'<b>As informações do paciente (identidade, local da cirurgia e procedimento cirúrgico) foram confirmadas</b>';
           }else{
            echo $not_checked_img.'<b>As informações do paciente (identidade, local da cirurgia e procedimento cirúrgico) foram confirmadas</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['consentimentos_cirurgico_anestesico_foi_assinado']){
            echo $checked_img.'<b>O consentimentos cirúrgico/anestésico foi assinado</b>';
           }else{
            echo $not_checked_img.'<b>O consentimentos cirúrgico/anestésico foi assinado</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['visualizacao_o_local_da_cirurgica_marcado_nao_aplicavel']){
            echo $checked_img.'<b>Visualização do local da cirurgica marcado não aplicavel</b>';
           }else{
            echo $not_checked_img.'<b>Visualização do local da cirurgica marcado não aplicavel</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['checklist_da_anestesia_foi_executado']){
            echo $checked_img.'<b>O checklist da anestesia foi executado</b>';
           }else{
            echo $not_checked_img.'<b>O checklist da anestesia foi executado</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['ficha_anestesica_esta_completa']){
            echo $checked_img.'<b>A ficha anestésica está completa</b>';
           }else{
            echo $not_checked_img.'<b>A ficha anestésica está completa</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['recursos_humanos_estao_disponiveis']){
            echo $checked_img.'<b>Os recursos humanos estão disponíveis</b>';
           }else{
            echo $not_checked_img.'<b>Os recursos humanos estão disponíveis</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['equipamentos_foram_verificados']){
            echo $checked_img.'<b>Os equipamentos foram verificados</b>';
           }else{
            echo $not_checked_img.'<b>Os equipamentos foram verificados</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['monitorizacao_standard_colocada_e_funcionante']){
            echo $checked_img.'<b>Monitorização standard colocada e funcionante</b>';
           }else{
            echo $not_checked_img.'<b>Monitorização standard colocada e funcionante</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['acesso_venoso_adequado']){
            echo $checked_img.'<b>Acesso venoso adequado</b>';
           }else{
            echo $not_checked_img.'<b>Acesso venoso adequado</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['alguma_alergia_conhecida']){
            echo $checked_img.'<b>Alguma alergia conhecida</b>';
           }else{
            echo $not_checked_img.'<b>Alguma alergia conhecida</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['via_aerea_difícil_risco_de_aspiracao']){
            echo $checked_img.'<b>Via aérea difícil / risco de aspiração</b>';
           }else{
            echo $not_checked_img.'<b>Via aérea difícil / risco de aspiração</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo']){
            echo $checked_img.'<b>Fluidoterapia/sangue disponível de acordo com o protocolo</b>';
           }else{
            echo $not_checked_img.'<b>Fluidoterapia/sangue disponível de acordo com o protocolo</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['checado_dois_identificadores_do_paciente_antes_inducao']){
            echo $checked_img.'<b>Checado dois identificadores do paciente</b>';
           }else{
            echo $not_checked_img.'<b>Checado dois identificadores do paciente</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['realizado_antibiotico_profilatico_60_minutos_antes_da_cirurgia']){
            echo $checked_img.'<b>Realizado antibiótico profilático 60 minutos antes da cirurgia</b>';
           }else{
            echo $not_checked_img.'<b>Realizado antibiótico profilático 60 minutos antes da cirurgia</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['paciente_esta_sob_uso_de_antibiotico_terapia']){
            echo $checked_img.'<b>Paciente está sob uso de antibiotico terapia</b>';
           }else{
            echo $not_checked_img.'<b>Paciente está sob uso de antibiotico terapia</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['materiais_implantes_estao_funcionantes_e_disponiveis']){
            echo $checked_img.'<b>Materiais / Implantes estão funcionantes e disponíveis</b>';
           }else{
            echo $not_checked_img.'<b>Materiais / Implantes estão funcionantes e disponíveis</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['equipamentos_cirurgicos_estao_checados_pela_engenharia_clinica']){
            echo $checked_img.'<b>Equipamentos cirúrgicos estão checados pela engenharia clínica</b>';
           }else{
            echo $not_checked_img.'<b>Equipamentos cirúrgicos estão checados pela engenharia clínica</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['termo_de_consentimento_anestesico_preenchido']){
            echo $checked_img.'<b>Termo de Consentimento Anestésico preenchido</b>';
           }else{
            echo $not_checked_img.'<b>Termo de Consentimento Anestésico preenchido</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['termo_de_consentimento_cirurgico_preenchido_antes_inducao']){
            echo $checked_img.'<b>Termo de Consentimento Cirúrgico preenchido</b>';
           }else{
            echo $not_checked_img.'<b>Termo de Consentimento Cirúrgico preenchido</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['sitio_demarcado_antes_inducao']){
            echo $checked_img.'<b>Sítio Demarcado</b>';
           }else{
            echo $not_checked_img.'<b>Sítio Demarcado</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['conferencia_de_lateralidade_antes_inducao']){
            echo $checked_img.'<b>Conferência de lateralidade</b>';
           }else{
            echo $not_checked_img.'<b>Conferência de lateralidade</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['laringoscopio_adequado_testado_disponivel']){
            echo $checked_img.'<b>Laringoscópio adequado, testado e disponível</b>';
           }else{
            echo $not_checked_img.'<b>Laringoscópio adequado, testado e disponível</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['mascara_de_oxigenacao_e_mascara_de_ventilacao_adequadas']){
            echo $checked_img.'<b>Máscara de oxigenação e máscara de ventilação adequadas, testadas e disponíveis</b>';
           }else{
            echo $not_checked_img.'<b>Máscara de oxigenação e máscara de ventilação adequadas, testadas e disponíveis</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['aspirador_adequado']){
            echo $checked_img.'<b>Aspirador adequado, testado e disponível</b>';
           }else{
            echo $not_checked_img.'<b>Aspirador adequado, testado e disponível</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['seringas_estao_identificadas']){
            echo $checked_img.'<b>Seringas estão identificadas</b>';
           }else{
            echo $not_checked_img.'<b>Seringas estão identificadas</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['monitorizacao_do_paciente_esta_funcionando']){
            echo $checked_img.'<b>Monitorização do paciente está funcionando</b>';
           }else{
            echo $not_checked_img.'<b>Monitorização do paciente está funcionando</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['paciente_com_via_aerea_dificil_ou_risco_presumido']){
            echo $checked_img.'<b>Paciente com via aérea difícil ou risco presumido</b>';
           }else{
            echo $not_checked_img.'<b>Paciente com via aérea difícil ou risco presumido</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['kit_de_via_aerea_dificil_esta_disponivel']){
            echo $checked_img.'<b>Kit de via aérea difícil está disponível</b>';
           }else{
            echo $not_checked_img.'<b>Kit de via aérea difícil está disponível</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['paciente_tem_alergia_ou_suspeita']){
            echo $checked_img.'<b>Paciente tem alergia ou suspeita</b>';
           }else{
            echo $not_checked_img.'<b>Paciente tem alergia ou suspeita</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['profilaxia_para_tromboembolismo_venoso']){
            echo $checked_img.'<b>Profilaxia para tromboembolismo venoso</b>';
           }else{
            echo $not_checked_img.'<b>Profilaxia para tromboembolismo venoso</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['qual_metodo_de_profilaxia_utilizada']){
            echo $checked_img.'<b>Qual método de profilaxia utilizada</b>';
           }else{
            echo $not_checked_img.'<b>Qual método de profilaxia utilizada</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['perda_sanguinea_estimada']){
            echo $checked_img.'<b>Perda sanguínea estimada em até 500ml em adulto ou 7ml/kg de peso em crianças</b>';
           }else{
            echo $not_checked_img.'<b>Perda sanguínea estimada em até 500ml em adulto ou 7ml/kg de peso em crianças</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['solicitado_reserva_de_sangue']){
            echo $checked_img.'<b>Solicitado reserva de sangue</b>';
           }else{
            echo $not_checked_img.'<b>Solicitado reserva de sangue</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['a_reserva_de_sangue_esta_disponivel']){
            echo $checked_img.'<b>A reserva de sangue está disponível</b>';
           }else{
            echo $not_checked_img.'<b>A reserva de sangue está disponível</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['paciente_esta_com_acesso_venoso_central']){
            echo $checked_img.'<b>Paciente está com acesso venoso central</b>';
           }else{
            echo $not_checked_img.'<b>Paciente está com acesso venoso central</b>';
           }
        ?>
      </div>

      <div class="col-sm-6 data-field">
        <?php  
          if($surgicalChecklist['ha_dois_acessos_venosos_calibrosos_disponiveis']){
            echo $checked_img.'<b>Há dois acessos venosos calibrosos disponíveis</b>';
           }else{
            echo $not_checked_img.'<b>Há dois acessos venosos calibrosos disponíveis</b>';
           }
        ?>
      </div>

    </div>


    <div class="col-sm-12 no-padding">
        
        
        <legend class="big-title">Antes da Incisão</legend>
        

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado']){
              echo $checked_img.'<b>O nome e função de pessoas não habituais na sala foi confirmado</b>';
             }else{
              echo $not_checked_img.'<b>O nome e função de pessoas não habituais na sala foi confirmado</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['cirurgiao_anestesista_e_enfermeiro_confirmaram_verbalmente']){
              echo $checked_img.'<b>Cirurgião, anestesista e enfermeiro confirmaram verbalmente</b>';
             }else{
              echo $not_checked_img.'<b>Cirurgião, anestesista e enfermeiro confirmaram verbalmente</b>';
             }
          ?>
        </div>
      
    </div>

</div> <!-- fim da página 1  -->
    <div class="col-sm-12 no-padding">
       
        <legend class="big-title">Antes do Doente Sair</legend>
        
        <div class="col-sm-12 no-padding">
          <legend class="sub-title-sections">Antes do doente sair da sala de operações:</legend>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['procedimento_cirurgico_realizado']){
              echo $checked_img.'<b>Procedimento cirúrgico realizado</b>';
             }else{
              echo $not_checked_img.'<b>Procedimento cirúrgico realizado</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['contagem_correta_de_instrumentos']){
              echo $checked_img.'<b>Contagem correta de compressas, instrumentos e corto perfurantes (ou não aplicável)</b>';
             }else{
              echo $not_checked_img.'<b>Contagem correta de compressas, instrumentos e corto perfurantes (ou não aplicável)</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['pecas_anatomicas_produtos_para_analie_corretamente_identificados']){
              echo $checked_img.'<b>Peças anatômicas e produtos para a análie corretamente identificads ( incluindo o nome do paciente)</b>';
             }else{
              echo $not_checked_img.'<b>Peças anatômicas e produtos para a análie corretamente identificads ( incluindo o nome do paciente)</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['todos_revem_necessidades_pos_operatorias']){
              echo $checked_img.'<b>Cirurgião, anestesista e enfermeiro revêm as necessidades pós-operatórias</b>';
             }else{
              echo $not_checked_img.'<b>Cirurgião, anestesista e enfermeiro revêm as necessidades pós-operatórias</b>';
             }
          ?>
        </div>
      
    </div>
    <div class="col-sm-12 no-padding">
        
        <legend class="big-title">Entrada no centro</legend>
      

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['checado_dois_identificadores_do_paciente']){
              echo $checked_img.'<b>Checado dois identificadores do paciente</b>';
             }else{
              echo $not_checked_img.'<b>Checado dois identificadores do paciente</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['checado_paciente_e_cirurgia_agendada']){
              echo $checked_img.'<b>Checado paciente e cirurgia agendada</b>';
             }else{
              echo $not_checked_img.'<b>Checado paciente e cirurgia agendada</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['avaliacao_pre_anestesica_realizada']){
              echo $checked_img.'<b>Avaliação pré-anestésica realizada</b>';
             }else{
              echo $not_checked_img.'<b>Avaliação pré-anestésica realizada</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['termo_de_consentimento_cirurgico_preenchido']){
              echo $checked_img.'<b>Termo de consentimento cirúrgico preenchido</b>';
             }else{
              echo $not_checked_img.'<b>Termo de consentimento cirúrgico preenchido</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['sitio_demarcado']){
              echo $checked_img.'<b>Sítio Demarcado</b>';
             }else{
              echo $not_checked_img.'<b>Sítio Demarcado</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['conferencia_de_lateralidade']){
              echo $checked_img.'<b>Conferência de lateralidade</b>';
             }else{
              echo $not_checked_img.'<b>Conferência de lateralidade</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['realizado_anamnese_e_exame_fisico_do_paciente']){
              echo $checked_img.'<b>Realizado anamnese e exame físico do paciente</b>';
             }else{
              echo $not_checked_img.'<b>Realizado anamnese e exame físico do paciente</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['se_transplante_anexaro_impresso_do_cheklist_de_recepcao_do_orgao']){
              echo $checked_img.'<b>Se Transplante, anexar o impresso do cheklist de recepção do orgão</b>';
             }else{
              echo $not_checked_img.'<b>Se Transplante, anexar o impresso do cheklist de recepção do orgão</b>';
             }
          ?>
        </div>

    </div>


    <div class="col-sm-12 no-padding">
           
        <legend class="big-title">Antes da incisão cirúrgica</legend>


        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['checar_paciente_e_cirurgia_agendada']){
              echo $checked_img.'<b>Checar paciente e cirurgia agendada</b>';
             }else{
              echo $not_checked_img.'<b>Checar paciente e cirurgia agendada</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['checagem_da_equipe_em_sala_operatoria']){
              echo $checked_img.'<b>Checagem da equipe em sala operatória</b>';
             }else{
              echo $not_checked_img.'<b>Checagem da equipe em sala operatória</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['todos_materiais_implantes_equipamentos_funcionantes_disponiveis']){
              echo $checked_img.'<b>Todos os Materiais , Implantes e Equipamentos estão funcionantes e disponíveis</b>';
             }else{
              echo $not_checked_img.'<b>Todos os Materiais , Implantes e Equipamentos estão funcionantes e disponíveis</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['realizado_antibiotico_profilatico']){
              echo $checked_img.'<b>Realizado antibiótico profilático</b>';
             }else{
              echo $not_checked_img.'<b>Realizado antibiótico profilático</b>';
             }
          ?>
        </div>


        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['equipe_material_exame_imagem_laboratoriais_estao_em_sala']){
              echo $checked_img.'<b>Equipe e material para exame de imagem e laboratoriais estão em sala</b>';
             }else{
              echo $not_checked_img.'<b>Equipe e material para exame de imagem e laboratoriais estão em sala</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['equipe_material_exame_imagem_laboratoriais_estao_em_sala']){
              echo $checked_img.'<b>Equipe e material para exame de imagem e laboratoriais estão em sala</b>';
             }else{
              echo $not_checked_img.'<b>Equipe e material para exame de imagem e laboratoriais estão em sala</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['ha_necessidade_de_congelacao_patologista']){
              echo $checked_img.'<b>Há necessidade de congelação / patologista</b>';
             }else{
              echo $not_checked_img.'<b>Há necessidade de congelação / patologista</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['os_frascos_estao_disponiveis']){
              echo $checked_img.'<b>Os frascos estão disponíveis</b>';
             }else{
              echo $not_checked_img.'<b>Os frascos estão disponíveis</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['solicitado_reserva_de_sangue_incisao_cirurgica']){
              echo $checked_img.'<b>Solicitado reserva de sangue</b>';
             }else{
              echo $not_checked_img.'<b>Solicitado reserva de sangue</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['a_reserva_de_sangue_esta_disponivel_incisao_cirurgica']){
              echo $checked_img.'<b>A reserva de sangue está disponível</b>';
             }else{
              echo $not_checked_img.'<b>A reserva de sangue está disponível</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['condicao_clinica_paciente_adequada_para_realizar_cirurgia']){
              echo $checked_img.'<b>A condição clinica do paciente está adequada para realizar a cirurgia</b>';
             }else{
              echo $not_checked_img.'<b>A condição clinica do paciente está adequada para realizar a cirurgia</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['materiais_instrumentacao_cirurgica_estao_estereis_disponiveis']){
              echo $checked_img.'<b>Materiais de instrumentação cirúrgica estão estéreis e disponíveis</b>';
             }else{
              echo $not_checked_img.'<b>Materiais de instrumentação cirúrgica estão estéreis e disponíveis</b>';
             }
          ?>
        </div>
                
    </div>


    <div class="col-sm-12 no-padding">

        <legend class="big-title">Check out</legend>
  
        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['contagem_de_compressas']){
              echo $checked_img.'<b>Contagem de Compressas</b>';
             }else{
              echo $not_checked_img.'<b>Contagem de Compressas</b>';
             }
          ?>
        </div>

        <?php 
          if($surgicalChecklist['contagem_de_compressas']):
        ?> 
            <div class="col-sm-6 data-field">
              <b>Total de compressas entregues:</b><?= $surgicalChecklist['tot_compressas_entregues'] ?>
            </div>

            <div class="col-sm-6 data-field">
              <b>Total de compressas devolvidas:</b><?= $surgicalChecklist['tot_compressas_devolvidas'] ?>
            </div>
        <?php 
          endif;
        ?>  

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['realizado_congelacao']){
              echo $checked_img.'<b>Realizado congelação</b>';
             }else{
              echo $not_checked_img.'<b>Realizado congelação</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['peca_cirurgica_encaminhada_para_anatomia_patologica']){
              echo $checked_img.'<b>Peça cirúrgica encaminhada para anatomia patológica</b>';
             }else{
              echo $not_checked_img.'<b>Peça cirúrgica encaminhada para anatomia patológica</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['identificado_a_peça_com_etiqueta_ou_dados_do_paciente']){
              echo $checked_img.'<b>Identificado a peça com etiqueta ou dados do paciente</b>';
             }else{
              echo $not_checked_img.'<b>Identificado a peça com etiqueta ou dados do paciente</b>';
             }
          ?>
        </div>


        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['amostras_biologicas_material_estudo_compativel_etiqueta_paciente']){
              echo $checked_img.'<b>Amostras biológicas / material para estudo compatível com etiqueta do paciente</b>';
             }else{
              echo $not_checked_img.'<b>Amostras biológicas / material para estudo compatível com etiqueta do paciente</b>';
             }
          ?>
        </div>

       
        <?php  
          if($surgicalChecklist['amostras_biologicas_material_estudo_compativel_etiqueta_paciente']){  
        ?>  

          <div class="col-sm-6 data-field">
            <b>Total de amostras biológicas:</b><?= $surgicalChecklist['tot_amostra_material_enviada'] ?>
          </div>

        <?php  
         }
        ?>  


        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['soros_infusoes_medicamentos_paciente_devidamente_identificados']){
              echo $checked_img.'<b>Soros, infusões, medicamentos e fluidos administrados ao paciente estão devidamente identificados</b>';
             }else{
              echo $not_checked_img.'<b>Soros, infusões, medicamentos e fluidos administrados ao paciente estão devidamente identificados</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['pulseira_de_identificacao_devidamente_instalada_no_paciente']){
              echo $checked_img.'<b>Pulseira de identificação devidamente instalada no paciente</b>';
             }else{
              echo $not_checked_img.'<b>Pulseira de identificação devidamente instalada no paciente</b>';
             }
          ?>
        </div>

        <div class="col-sm-6 data-field">
          <?php  
            if($surgicalChecklist['ha_algum_evento_previnido_com_o_tmeout']){
              echo $checked_img.'<b>Há algum evento previnido com o TME OUT</b>';
             }else{
              echo $not_checked_img.'<b>Há algum evento previnido com o TME OUT</b>';
             }
          ?>
        </div>

    </div>


    <div class="col-sm-12 no-padding">

            <div class="col-sm-12 no-padding">
              <legend class="big-title">Condições de encaminhamento do paciente</legend>
            </div>


             <div class="col-sm-6 data-field">
              <b>Nível de Consciência:</b><?= $nivelcons_ciencia[$surgicalChecklist['nivel_de_consciencia']] ?>
             </div>

             <div class="col-sm-6 data-field">
              <b>Suplementação de Oxigênio:</b><?= $suplementacao_oxigenio[$surgicalChecklist['suplementacao_oxigenio']] ?>
             </div>

            <div class="col-sm-6 data-field">
              <?php  
                if($surgicalChecklist['sonda_vesical_de_demora']){
                  echo $checked_img.'<b>Sonda vesical de demora</b>';
                 }else{
                  echo $not_checked_img.'<b>Sonda vesical de demora</b>';
                 }
              ?>
            </div>

            <?php 
               if($surgicalChecklist['sonda_vesical_de_demora']):
            ?>  
              <div class="col-sm-6 data-field">
                <b>Volume coletado do paciente(sonda vesical):</b><?= $surgicalChecklist['sonda_vesical_volume_coletado'] ?>
              </div>
            <?php 
              endif;
            ?> 

            <div class="col-sm-6 data-field">
              <?php  
                if($surgicalChecklist['sonda_nasogastrica']){
                  echo $checked_img.'<b>Sonda nasogástrica</b>';
                 }else{
                  echo $not_checked_img.'<b>Sonda nasogástrica</b>';
                 }
              ?>
            </div>

            <?php 
               if($surgicalChecklist['sonda_nasogastrica']):
            ?>  
              <div class="col-sm-6 data-field">
                <b>Volume coletado do paciente(sonda nasogástrica):</b><?= $surgicalChecklist['sonda_nasogastrica_volume_coletado'] ?>
              </div>
            <?php 
              endif;
            ?> 

            <div class="col-sm-6 data-field">
              <?php  
                if($surgicalChecklist['houve_instalacao_de_dreno']){
                  echo $checked_img.'<b>Houve instalação de Dreno</b>';
                 }else{
                  echo $not_checked_img.'<b>Houve instalação de Dreno</b>';
                 }
              ?>
            </div>

            <?php 
               if($surgicalChecklist['houve_instalacao_de_dreno']):
            ?>  
              <div class="col-sm-6 data-field">
                <b>Volume coletado do paciente(drenos):</b><?= $surgicalChecklist['tot_drenos_inseridos'] ?>
              </div>
            <?php 
              endif;
            ?> 


            <div class="col-sm-6 data-field">
              <?php  
                if($surgicalChecklist['cateter_venoso_periferico_funcionante']){
                  echo $checked_img.'<b>Cateter venoso periférico funcionante</b>';
                 }else{
                  echo $not_checked_img.'<b>Cateter venoso periférico funcionante</b>';
                 }
              ?>
            </div>

            <div class="col-sm-6 data-field">
              <?php  
                if($surgicalChecklist['cateter_venoso_central']){
                  echo $checked_img.'<b>Cateter venoso central</b>';
                 }else{
                  echo $not_checked_img.'<b>Cateter venoso central</b>';
                 }
              ?>
            </div>

            <div class="col-sm-6 data-field">
              <?php  
                if($surgicalChecklist['cateter_arterial']){
                  echo $checked_img.'<b>Cateter arterial</b>';
                 }else{
                  echo $not_checked_img.'<b>Cateter arterial</b>';
                 }
              ?>
            </div>

            <div class="col-sm-6 data-field">
              <?php  
                if($surgicalChecklist['anestesica_integradores']){
                  echo $checked_img.'<b>Anestésica e integradores</b>';
                 }else{
                  echo $not_checked_img.'<b>Anestésica e integradores</b>';
                 }
              ?>
            </div>

    </div>

</div>


<script>

window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);
  
  (function(){
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    // chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();

</script>
