<?php

    $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
    $to   = new DateTime('today');
    $age = null;
    $age = $from->diff($to)->y;
    // echo "<pre>";
    //   print_r($patient);
    // echo "</pre>";

    if(isset($suspectedMeProtocol['data_nao_houve_captacao'])){
        $suspectedMeProtocol['data_nao_houve_captacao'] =$suspectedMeProtocol['data_nao_houve_captacao']->format('d/m/Y');
    }

    if(isset($suspectedMeProtocol['2_exame_hora'])){$suspectedMeProtocol['2_exame_hora']=$suspectedMeProtocol['2_exame_hora']->i18nFormat('HH:mm');}
    
    if(isset($suspectedMeProtocol['1_exame_hora'])){$suspectedMeProtocol['1_exame_hora']=$suspectedMeProtocol['1_exame_hora']->i18nFormat('HH:mm');}
    
    if(isset($suspectedMeProtocol['hora_captcao_orgaos'])){$suspectedMeProtocol['hora_captcao_orgaos']=$suspectedMeProtocol['hora_captcao_orgaos']->i18nFormat('HH:mm');}
    
    if(isset($suspectedMeProtocol['data_captcao_orgaos'])){$suspectedMeProtocol['data_captcao_orgaos']=$suspectedMeProtocol['data_captcao_orgaos']->format('d/m/Y');}

    if(isset($suspectedMeProtocol['hora_nao_houve_captacao'])){$suspectedMeProtocol['hora_nao_houve_captacao']=$suspectedMeProtocol['hora_nao_houve_captacao']->i18nFormat('HH:mm');}

    if(isset($suspectedMeProtocol['fechamento_obito_hora'])){$suspectedMeProtocol['fechamento_obito_hora']=$suspectedMeProtocol['fechamento_obito_hora']->i18nFormat('HH:mm');}
    
    if(isset($suspectedMeProtocol['fechamento_obito_data'])){$suspectedMeProtocol['fechamento_obito_data']=$suspectedMeProtocol['fechamento_obito_data']->format('d/m/Y');}

     $causa_do_coma=['Traumatismo Craniano'=>'Traumatismo Craniano', 'Hipoxemia'=>'Hipoxemia', 'Parada Cardiorrespiratória'=>'Parada Cardiorrespiratória', 'AVE Isquêmico'=>'AVE Isquêmico', 'AVE Hemorrágico'=>'AVE Hemorrágico', 'Edema Cerebral'=>'Edema Cerebral', 'Hipertensão Intracraniana'=>'Hipertensão Intracraniana', 'Tumores Cerebrais'=>'Tumores Cerebrais', 'Overdose'=>'Overdose', 'Hipoglicemia'=>'Hipoglicemia'];

    $exame_tipo=[""=>"","Eletroencefalograma"=>'Eletroencefalograma', 'Doppler Transcraniano'=>'Doppler Transcraniano', 'Arteriografia Cerebral'=>'Arteriografia Cerebral', 'Cintilografia Cerebral'=>'Cintilografia Cerebral', 'SPECT'=>'SPECT', 'Potenciais Evocados'=>'Potenciais Evocados'];

     $orgaos=['Córnea', 'Coração', 'Pulmão', 'Rim', 'Fígado', 'Pãncreas', 'Osso'];

    $orgaos_cadaver=["orgaos_doar_cadaver_cornea"=>'Córnea', "orgaos_doar_cadaver_rin"=>'Rim', "orgaos_doar_cadaver_ossos"=>'Osso'];

    $orgaos_potenciais=[
     'potencial_orgao_cornea'=>'Córnea',
     'potencial_orgao_pulmao'=>'Pulmão',
     'potencial_orgao_coracao'=>'Coração',
     'potencial_orgao_rin'=>'Rim',
     'potencial_orgao_figado'=>'Fígado',
     'potencial_orgao_pancreas'=>'Pâncreas',
     'potencial_orgao_ossos'=>'Osso'
    ];

?>

<style>
    
    html,body{
      font-size:10px;
    }
    
    .form-group {
      margin-bottom:5px!important;
    }

    .row .form-group  {
      width:100%!important;
    }

    label{
      width:auto;
    }

    input {
      height: 13px;
      width: 100%;
      border: 0!important;
      outline: 0!important;
      background: transparent!important;
      border-bottom: 1px solid black!important;
      border-radius: none!important;
      margin-bottom: 0px!important;
    }

    .bordered-div{
      padding-top: 20px;
      font-size:12px;
      margin-bottom:15px;
      border:1px solid #000!important;
      /*min-height: 130px;
      max-height: 130px;*/
    }

    .top-divs{
      font-size:11px;
      max-width: 49%;
      /*min-height: 110px;
      max-height: 110px;*/
    }

    .aling-inline-items{
      display:flex;
      flex-direction:row;
      justify-content:center;
    }

    #justificativa-title{
      font-size:24px;
      text-transform: uppercase;
      line-height: 2.8;
      margin-right: 48px;
    }

    .prefeitura{
      padding-top:10px;
      height:auto!important;
    }

    .prefeitura p {
       line-height: 0.6;
       font-size:20px;
    }

    .page{
      margin-bottom:0px;
    }

    .flex-inputs{
      display: flex;
      flex-direction:row;
      justify-content:flex-start;
    }

    .flex-tables{
      display: flex;
      flex-direction:row;
      justify-content: center;
      align-content: center;
      align-items:flex-end;
    }

    .flex-tables > table{
      text-align:left;
      width:auto;
      margin-bottom:0px;
      margin-right: 20px;
    }

    .flex-tables > table td{
      text-align:left;
      padding: 0px;
      padding-left:8px;
      padding-right:8px;
    }
    
    .bottom-cont{
      margin-top: 23px;
    }

    .main-box-title{
      padding:10px;
      font-size:12px;
      margin-bottom:15px;
      border:1px solid #000!important;
      text-align:center;
      width:70%;
    }

    .center-item{
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .small-inputs{
      max-width:70px;
    }

    .medium-inputs{
      max-width:100px;
    }


    .padded-label{
      padding-left:8px;
      padding-right:8px;
    }

    .parentesis{
      padding-left:3px;
      padding-right:3px;
    }

    .term-sheet-text p{
      line-height: 1.2;
    }

    
    @page {
      size:portrait;
      margin: 3mm 10mm 3mm 10mm;  
    }

</style>



<div class="page">

<div class="col-sm-12 center-item">
  <div class="main-box-title">
    <h5><center><b>TERMO DE DECLARAÇÃO DE MORTE ENCEFÁLICA</b></center></h5>
  </div>
</div>

<div class="row"><h4 style="text-align: center;">(Res. CFM no 1.480 de 08/08/97)</h4></div>


    <div class="row">

      <div class="col-sm-12 no-padding">

        <div class="flex-inputs">
          <label style="width:210px!important;" for="example-search-input">IDENTIFICAÇÃO DO HOSPITAL:</label>
          <input value="" type="text">
        </div>

        <div class="flex-inputs">
          <label for="example-search-input">NOME:</label>
          <input value="<?= $patient['nome']?>" type="text">
        </div>

        <div class="flex-inputs">
          <label for="example-search-input">PAI:</label>
          <input value="<?= $patient['father_name']?>" type="text">
        </div>

        <div class="flex-inputs">
          <label for="example-search-input">MÃE:</label>
          <input value="<?= $patient['mother_name']?>" type="text">
        </div>

        <div class="flex-inputs">

          <label for="example-email-input">IDADE:&nbsp;</label>
          <input class="small-inputs" value="<?= $age?>" type="text">

          <label class="padded-label" for="example-email-input">ANOS:&nbsp;</label>
          <input class="small-inputs" type="text">

          <label class="padded-label" for="example-email-input">MESES:&nbsp;</label>
          <input class="small-inputs" type="text">

          <label class="padded-label" for="example-email-input">DIAS:&nbsp;</label>
          <input class="small-inputs" type="text">

          
          <label class="padded-label" for="example-email-input">DATA NASC:&nbsp;</label>
          <span class="date-filler">_____/_____/_____</span>
         
        </div>


        <div class="flex-inputs">

          <label for="example-email-input">SEXO:&nbsp;</label>
          <span class="parentesis">M(&nbsp;&nbsp;)</span>
          <span class="parentesis">F(&nbsp;&nbsp;)</span>

          <label class="padded-label" for="example-email-input">RAÇA:</label>
          <span class="parentesis">A(&nbsp;&nbsp;)</span>
          <span class="parentesis">B(&nbsp;&nbsp;)</span>
          <span class="parentesis">N(&nbsp;&nbsp;)</span>

          <label style="min-width:145px!important;" class="padded-label"  for="example-email-input">REGISTRO HOSPITALAR:&nbsp;</label>
          <input class="" type="text">
          
        </div>


        <div class="col-sm-12 no-padding">
          <br>
          <span><strong>A. CAUSA DO COMA</strong></span>

          <div class="flex-inputs">
            <label style="min-width:109px!important;" for="example-email-input">A.1 - Causa do Coma:&nbsp;</label>
            <input type="text">
          </div>

          <span>A.2. Causas do coma que devem ser excluídas durante o exame</span>

          <div class="flex-tables">
            
            <table class="table-bordered">
              <tr>
                <td>
                  a) Hipotermia
                </td>
              </tr>
              <tr>
                <td>
                  b) Uso de drogas depressoras do sistema nervoso central
                </td>
              </tr>
            </table>

            <table class="table-bordered">
              <tr>
                <td>
                  <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                </td>
              </tr>
              <tr>
                <td>
                  <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                </td>
              </tr>
            </table>

            <table class="table-bordered">
              <tr>
                <td>
                  <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                </td>
              </tr>
              <tr>
                <td>
                  <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                </td>
              </tr>
            </table>

          </div>

          <span>Se a resposta for <b><u>SIM</u></b> a qualquer um dos itens, interrompe-se o protocolo.</span>
    
        </div>


        <div class="col-sm-12 no-padding"><!-- col-sm-12-inicio -->
          <br>

          <span><strong>B. EXAME NEUROLÓGICO </strong> - Atenção: verificar o intervalo mínimo exigível entre
          as avaliações clínicas, constantes da tabela abaixo</span>

          <div class="flex-tables"><!-- flex-inicio -->
            
            <table class="table-bordered">
              <tr>
                <td>
                  <center><b>IDADE</b></center>
                </td>
                <td>
                  <center><b>INTERVALO</b></center>
                </td>
              </tr>
              
              <tr>
                <td>
                 7 dias a 2 meses incompletos
                </td>

                <td>
                 2 meses a 1 ano incompleto
                </td>
              </tr>

              <tr>
                <td>
                 24 horas
                </td>

                <td>
                 1 ano a 2 anos incompletos
                </td>
              </tr>

              <tr>
                <td>
                 Acima de 2 anos
                </td>

                <td>
                 6 horas
                </td>
              </tr>  
            </table>

          </div><!-- flex-fim -->
          <br>
          <span>(Ao efetuar o exame, assinalar uma das duas opções SIM/NÃO obrigatoriamente, para todos os itens abaixo.)</span>
          <br>
          <span>Elementos do exame neurológico</span>
          


          <div class="flex-tables"><!-- flex-inicio -->
            
            <table class="table-bordered">
              <tr>
                <td>
                  Coma aperceptivo
                </td>
              </tr>
              
              <tr>
                <td>
                  Pupilas fixas e arreativas
                </td>
              </tr>
              
              <tr>
                <td>
                  Ausência de reflexo córneo-palpebral
                </td>
              </tr>
              
              <tr>
                <td>
                  Ausência de reflexos oculocefálicos
                </td>
              </tr>
              
              <tr>
                <td>
                  Ausência de respostas às provas calóricas
                </td>
              </tr>
              
              <tr>
                <td>
                  Ausência de reflexo de tosse
                </td>
              </tr>
              
              <tr>
                <td>
                  Apnéia
                </td>
              </tr>

            </table>
            

            <table class="">

              <tr>
                <td>
                  <center><b><span style="margin-right: 15px">Resultado</span></b></center>
                </td>
              </tr> 

              <tr>
                <td> <!-- Guarda as duas tabelas -->

                  <div class="flex-tables">
                    <table class="table-bordered">
                      <tr>
                        <td colspan="2">
                          <center><b>EXAME 1</b></center>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>
                    </table>


                    <table class="table-bordered">
                      <tr>
                        <td colspan="2">
                          <center><b>EXAME 2</b></center>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>

                      <tr>
                        <td>
                          <span class="parentesis">SIM(&nbsp;&nbsp;)</span>
                        </td>
                        <td>
                          <span class="parentesis">NÃO(&nbsp;&nbsp;)</span>
                        </td>
                      </tr>
                    </table>
                  </div>

                </td>
              </tr>

            </table>   
            
          </div><!-- flex-fim -->
          <br>
          <span><strong>C. ASSINATURAS DOS EXAMES CLÍNICOS</strong> - (Os exames devem ser realizados por profissionais diferentes, que não</span>
          <br>
          <span>poderão ser integrantes da equipe de remoção e transplante.)</span>

          <div class="col-sm-12 no-padding ">

            <div class="col-sm-6 bordered-div pull-left top-divs">

              <span><strong>1 - PRIMEIRO EXAME</strong></span>
              

              <div class="flex-inputs">
                <label for="example-email-input">DATA NASC:&nbsp;</label>
                <span class="date-filler">_____/_____/_____</span>

                <label class="padded-label" for="example-email-input">HORA:&nbsp;</label>
                <span class="date-filler">_____:_____</span>
              </div>  

              <div class="flex-inputs">
                <label style="min-width:109px" for="example-text-input">NOME DO MÉDICO:&nbsp;</label>
                <input type="text">
              </div>

              <div class="flex-inputs">
                <label for="example-email-input">CRM:&nbsp;</label>
                <input type="text">

                <label style="padding-left:15px;padding-right:15px;" for="example-url-input">FONE:</label>
                <input value="" type="text">
              </div>

              <div class="flex-inputs">
                <label for="example-text-input">END:&nbsp;</label>
                <input type="text">
              </div>

              <span class="date-filler"><b>Assinatura</b></span>
               <div class="flex-inputs">
                <label style="min-width:118px" for="example-text-input">e carimbo do médico:&nbsp;</label>
                <input type="text">
              </div>


            </div>
            
            <div class="col-sm-6 bordered-div pull-right top-divs">

              <span><strong>2 - PRIMEIRO EXAME</strong></span>
              

              <div class="flex-inputs">
                <label for="example-email-input">DATA NASC:&nbsp;</label>
                <span class="date-filler">_____/_____/_____</span>

                <label class="padded-label" for="example-email-input">HORA:&nbsp;</label>
                <span class="date-filler">_____:_____</span>
              </div>  

              <div class="flex-inputs">
                <label style="min-width:109px" for="example-text-input">NOME DO MÉDICO:&nbsp;</label>
                <input type="text">
              </div>

              <div class="flex-inputs">
                <label for="example-email-input">CRM:&nbsp;</label>
                <input type="text">

                <label style="padding-left:15px;padding-right:15px;" for="example-url-input">FONE:</label>
                <input value="" type="text">
              </div>

              <div class="flex-inputs">
                <label for="example-text-input">END:&nbsp;</label>
                <input type="text">
              </div>

              <span class="date-filler"><b>Assinatura</b></span>
               <div class="flex-inputs">
                <label style="min-width:118px" for="example-text-input">e carimbo do médico:&nbsp;</label>
                <input type="text">
              </div>


            </div>

          </div> 

          
          <p style="margin-bottom:1px;">D. EXAME COMPLEMENTAR - Indicar o exame realizado e anexar laudo com identificação do médico responsável.
          <strong><u>1. Angiografia Cerebral</u></strong> <strong><u>2. Cintilografia Radioisotópica</u></strong> <strong><u>3. Doppler Transcraniano</u></strong> 4. Monitorização da pressão intra-
          craniana 5. Tomografia computadorizada com xenônio 6. Tomografia por emissão de foton único <strong><u>7. EEG</u></strong> 8. Tomografia
          por emissão de positróns 9. Extração Cerebral de oxigênio 10. outros (citar):</p>
            
          <div class="flex-inputs">
            <input type="text">
          </div>

          <div class="flex-inputs">
            <input type="text">
          </div>

          <div class="flex-inputs">
            <input type="text">
          </div>
          
          <div style="margin-top:3px;" class="flex-inputs">
            <label style="min-width:227px" for="example-text-input">Data/Hora/Assinatura e carimbo do médico (a):&nbsp;</label>
            <input type="text">
          </div>

          <div class="flex-inputs">
            <input type="text">
          </div>  
          




    
        </div><!-- col-sm-12-fim -->


      </div>
    

    </div><!-- row end -->

</div>


<div class="page">

  <div class="term-sheet-text">
    <br><br><br>
    <p><strong>E. OBSERVAÇÕES</strong></p>
    <p>1 - Interessa, para o diagnóstico de morte encefálica, exclusivamente a arreatividade supraespinal. Consequentemente, não</p>
    <p>afasta este diagnóstico a presença de sinais de reatividade infraespinal (atividade reflexa medular) tais como: reflexos</p>
    <p>osteotendinosos ("reflexos profundos"), cutâneo-abdominais, cutâneo-plantar em flexão ou extensão, cremastérico superficial</p>
    <p>ou profundo, ereção peniana reflexa, arrepio, reflexos flexores de retirada dos membros inferiores ou superiores, reflexo tônico</p>
    <p>cervical.</p>

    <br>

    <p><strong><u>2 - PROVA CALÓRICA</u></strong></p>
    <p>2.1 - Certificar-se de que não há obstrução do canal auditivo por cerumem ou qualquer outra condição que dificulte ou impeça</p>
    <p>a correta realização do exame.</p>
    <p>2.2 - Usar 50 ml de líquido (soro fisiológico, água, etc) próximo de 0 grau Celsius em cada ouvido.</p>
    <p>2.3 - Manter a cabeça elevada em 30 (trinta) graus durante a prova.</p>
    <p>2.4 - Constatar a ausência de movimentos oculares.</p>
    
    <br>

    <p><strong><u>3 - TESTE DA APNÉIA</u></strong></p>
    <p>No doente em coma, o nível sensorial de estímulo para desencadear a respiração é alto, necessitando-se da pCO2 de até 55</p>
    <p>mmHg, fenômeno que pode determinar um tempo de vários minutos entre a desconexão do respirador e o aparecimento dos</p>
    <p>movimentos respiratórios, caso a região ponto-bulbar ainda esteja íntegra. A prova da apnéia é realizada de acordo com o</p>
    <p>seguinte protocolo:</p>
    <p>3.1 - Ventilar o paciente com 02 de 100% por 10 minutos.</p>
    <p>3.2 - Desconectar o ventilador.</p>
    <p>3.3 - Instalar catéter traqueal de oxigênio com fluxo de 6 litros por minuto.</p>
    <p>3.4 - Observar se aparecem movimentos respiratórios por 10 minutos ou até quando o pCO2 atingir 55 mmHg.</p>
    
    <br>

    <p><strong><u>4 – EXAME COMPLEMENTAR.</u></strong> Este exame clínico deve estar acompanhado de um exame complementar que demonstre</p>
    <p>inequivocadamente a ausência de circulação sangüínea intracraniana ou atividade elétrica cerebral, ou atividade metabólica</p>
    <p>cerebral. Observar o disposto abaixo (itens 5 e 6) com relação ao tipo de exame e faixa etária.</p>
    
    <br>

    <p>5 - Em pacientes com dois anos ou mais - 1 exame complementar entre os abaixo mencionados:</p>
    <p>5.1 - Atividade circulatória cerebral: angiografia, cintilografia radioisotópica, doppler transcraniano, monitorização da pressão</p>
    <p>intracraniana, tomografia computadorizada com xenônio, SPECT.</p>
    <p>5.2 - Atividade elétrica: eletroencefalograma.</p>
    <p>5.3 - Atividade metabólica: PET, extração cerebral de oxigênio.</p>
    
    <br>

    <p>6 - Para pacientes abaixo de 02 anos:</p>
    <p>6.1 - De 1 ano a 2 anos incompletos: o tipo de exame é facultativo. No caso de eletroencefalograma são necessários 2 registros</p>
    <p>com intervalo mínimo de 12 horas.</p>
    <p>6.2 - De 2 meses a 1 ano incompleto: dois eletroencefalogramas com intervalo de 24 horas.</p>
    <p>6.3 - De 7 dias a 2 meses de idade (incompletos): dois eletroencefalogramas com intervalo de 48 h.</p>
    
    <br>

    <strong><p>7 - Uma vez constatada a morte encefálica, cópia deste termo de declaração deve obrigatoriamente ser enviada ao órgão</p>
    <p>controlador estadual (Lei 9.434/97, Art. 13).</p></strong>
  </div>
    
</div>



<script>

  window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);

  
  (function(){
    $(".pad-top-20").removeClass('container');
    $(".pad-top-20").addClass('container-fluid');
    $(".pad-top-20").css('padding-top','0px');
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    // chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();


</script>
