<?php
namespace App\Test\Fixture;

use Cake\TestSuite\Fixture\TestFixture;

/**
 * GoalsSectorsFixture
 *
 */
class GoalsSectorsFixture extends TestFixture
{

    /**
     * Fields
     *
     * @var array
     */
    // @codingStandardsIgnoreStart
    public $fields = [
        'idgoals_sectors' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'autoIncrement' => true, 'precision' => null],
        'sector_id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        'goal_id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        '_indexes' => [
            'fk_goals_sectors_sectors1_idx' => ['type' => 'index', 'columns' => ['sector_id'], 'length' => []],
            'fk_goals_sectors_goals1_idx' => ['type' => 'index', 'columns' => ['goal_id'], 'length' => []],
        ],
        '_constraints' => [
            'primary' => ['type' => 'primary', 'columns' => ['idgoals_sectors'], 'length' => []],
            'fk_goals_sectors_goals1' => ['type' => 'foreign', 'columns' => ['goal_id'], 'references' => ['goals', 'id'], 'update' => 'noAction', 'delete' => 'noAction', 'length' => []],
            'fk_goals_sectors_sectors1' => ['type' => 'foreign', 'columns' => ['sector_id'], 'references' => ['sectors', 'id'], 'update' => 'noAction', 'delete' => 'noAction', 'length' => []],
        ],
        '_options' => [
            'engine' => 'InnoDB',
            'collation' => 'utf8_general_ci'
        ],
    ];
    // @codingStandardsIgnoreEnd

    /**
     * Records
     *
     * @var array
     */
    public $records = [
        [
            'idgoals_sectors' => 1,
            'sector_id' => 1,
            'goal_id' => 1
        ],
    ];
}
